/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.core.Campaign;
import pcgen.core.CustomData;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.Race;
import pcgen.core.Skill;
import pcgen.core.spell.Spell;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.editor.EditorMainForm;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public final class LstEditorMain
extends JFrame {
    static final long serialVersionUID = 9007333328425546533L;
    private static final String s_EDITTYPE_CLASS = "Class";
    private static final String s_EDITTYPE_DEITY = "Deity";
    private static final String s_EDITTYPE_DOMAIN = "Domain";
    private static final String s_EDITTYPE_FEAT = "Feat";
    private static final String s_EDITTYPE_LANGUAGE = "Language";
    private static final String s_EDITTYPE_RACE = "Race";
    private static final String s_EDITTYPE_SKILL = "Skill";
    private static final String s_EDITTYPE_SPELL = "Spell";
    private static final String s_EDITTYPE_TEMPLATE = "Template";
    private static final String s_EDITTYPE_SOURCE = "Source";
    private static final String[] supportedLsts = new String[]{"Class", "Deity", "Domain", "Feat", "Language", "Race", "Skill", "Spell", "Template", "Source"};
    private JButton btnCopy;
    private JButton btnDelete;
    private JButton btnDone;
    private JButton btnEdit;
    private JButton btnNew;
    private JLabel lblLstFileContent;
    private JLabel lblLstFileTypes;
    private JList lstLstFileContent;
    private JList lstLstFileTypes;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel pnlButtons;
    private JPanel pnlLstEditorMain;
    private JPanel pnlLstFileContent;
    private JPanel pnlLstFileTypes;
    private JPanel pnllstLstFileContent;
    private JPanel pnllstLstFileTypes;
    private JScrollPane scpLstFileContent;
    private JScrollPane scpLstFileTypes;
    private int editType = -1;

    public LstEditorMain() {
        this.initComponents();
        IconUtilitities.maybeSetIcon(this, "PcgenIcon.gif");
        Utility.centerFrame(this, false);
    }

    public void editIt(PObject editItem, int argEditType) {
        this.editType = argEditType;
        this.editIt(editItem);
    }

    private void addObject(PObject editObject) {
        switch (this.editType) {
            case 0: {
                Globals.getClassList().add(editObject);
                Globals.sortPObjectList(Globals.getClassList());
                break;
            }
            case 1: {
                Globals.getDeityList().add(editObject);
                Globals.sortPObjectList(Globals.getDeityList());
                break;
            }
            case 2: {
                Globals.addDomain((Domain)editObject);
                Globals.sortPObjectList(Globals.getDomainList());
                break;
            }
            case 3: {
                Globals.getFeatList().add(editObject);
                Globals.sortPObjectList(Globals.getFeatList());
                break;
            }
            case 4: {
                Globals.getLanguageList().add(editObject);
                Globals.sortPObjectList(Globals.getLanguageList());
                break;
            }
            case 5: {
                Globals.getRaceMap().put(editObject.getKeyName(), editObject);
                break;
            }
            case 6: {
                Globals.getSkillList().add(editObject);
                Globals.sortPObjectList(Globals.getSkillList());
                Iterator i = Globals.getClassList().iterator();
                while (i.hasNext()) {
                    PCClass aClass = (PCClass)i.next();
                    aClass.refreshCSkillList();
                }
                i = Globals.getDomainList().iterator();
                while (i.hasNext()) {
                    Domain aDomain = (Domain)i.next();
                    aDomain.refreshCSkillList();
                }
                break;
            }
            case 7: {
                Globals.getSpellMap().put(editObject.getName(), editObject);
                break;
            }
            case 8: {
                Globals.getTemplateList().add(editObject);
                Globals.sortPObjectList(Globals.getTemplateList());
                break;
            }
            case 9: {
                Globals.getCampaignList().add(editObject);
                Globals.sortPObjectList(Globals.getCampaignList());
                break;
            }
        }
        CustomData.writeCustomFiles(Globals.getCurrentPC());
    }

    private void btnCopyActionPerformed() {
        PObject lstItem = (PObject)this.lstLstFileContent.getSelectedValue();
        if (lstItem != null) {
            try {
                PObject newItem = (PObject)lstItem.clone();
                String nameEnding = " of " + lstItem.getName();
                int idx = 1;
                while (true) {
                    String newName;
                    if (this.findObject(newName = "Copy" + (idx > 1 ? Integer.toString(idx) : "") + nameEnding) == null) {
                        newItem.setName(newName);
                        if (lstItem instanceof Race) {
                            String region = lstItem.getRegionString();
                            if (region == null) {
                                region = "None";
                            }
                            Globals.getBioSet().copyRaceTags(region, lstItem.getName(), region, newItem.getName());
                        }
                        this.editIt(newItem);
                        break;
                    }
                    ++idx;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void btnDeleteActionPerformed() {
        PObject lstItem;
        if (JOptionPane.showConfirmDialog(null, "Are you sure?", "PCGen", 0, 3) != 1 && this.removeObject(lstItem = (PObject)this.lstLstFileContent.getSelectedValue())) {
            this.lstLstFileTypesValueChanged();
        }
    }

    private void btnDoneActionPerformed() {
        this.setVisible(false);
        this.dispose();
    }

    private void btnEditActionPerformed() {
        PObject lstItem = (PObject)this.lstLstFileContent.getSelectedValue();
        if (lstItem != null) {
            this.editIt(lstItem);
        }
    }

    private void btnNewActionPerformed() {
        this.editIt(null);
    }

    private void editIt(PObject editItem) {
        try {
            PObject oldObject;
            if (editItem == null) {
                oldObject = null;
                editItem = this.newObject();
            } else {
                oldObject = this.findObject(editItem.getName());
                if (oldObject != null) {
                    this.removeObject(oldObject);
                    editItem = (PObject)oldObject.clone();
                }
            }
            EditorMainForm emf = new EditorMainForm(this, editItem, this.editType);
            while (true) {
                emf.setVisible(true);
                if (emf.wasCancelled()) {
                    if (oldObject != null) {
                        this.addObject(oldObject);
                    }
                    return;
                }
                if (this.findObject(editItem.getName()) == null) break;
                ShowMessageDelegate.showMessageDialog("Cannot save; already exists.", "PCGen", MessageType.ERROR);
            }
            this.addObject(editItem);
            this.lstLstFileTypesValueChanged();
        }
        catch (Exception ignored) {
            Logging.errorPrint("Error", ignored);
        }
    }

    private PObject findObject(String aName) {
        switch (this.editType) {
            case 0: {
                return Globals.getClassNamed(aName);
            }
            case 1: {
                return Globals.getDeityNamed(aName);
            }
            case 2: {
                return Globals.getDomainNamed(aName);
            }
            case 3: {
                return Globals.getFeatNamed(aName);
            }
            case 4: {
                return Globals.getLanguageNamed(aName);
            }
            case 5: {
                return Globals.getRaceNamed(aName);
            }
            case 6: {
                return Globals.getSkillNamed(aName);
            }
            case 7: {
                return Globals.getSpellNamed(aName);
            }
            case 8: {
                return Globals.getTemplateNamed(aName);
            }
            case 9: {
                return Globals.getCampaignNamed(aName);
            }
        }
        return null;
    }

    private void initComponents() {
        this.pnlLstEditorMain = new JPanel();
        this.pnlLstFileTypes = new JPanel();
        this.lblLstFileTypes = new JLabel();
        this.pnllstLstFileTypes = new JPanel();
        this.scpLstFileTypes = new JScrollPane();
        this.lstLstFileTypes = new JList<String>(supportedLsts);
        this.pnlLstFileContent = new JPanel();
        this.lblLstFileContent = new JLabel();
        this.pnllstLstFileContent = new JPanel();
        this.scpLstFileContent = new JScrollPane();
        this.lstLstFileContent = new JList();
        this.pnlButtons = new JPanel();
        this.btnNew = new JButton();
        this.btnEdit = new JButton();
        this.btnDelete = new JButton();
        this.btnCopy = new JButton();
        this.btnDone = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.setTitle("LST Editors");
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LstEditorMain.this.btnDoneActionPerformed();
            }
        });
        this.pnlLstEditorMain.setLayout(new GridBagLayout());
        this.pnlLstFileTypes.setLayout(new GridBagLayout());
        this.lblLstFileTypes.setText("File Types");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.pnlLstFileTypes.add((Component)this.lblLstFileTypes, gridBagConstraints);
        this.pnllstLstFileTypes.setLayout(new BorderLayout());
        this.lstLstFileTypes.setSelectionMode(0);
        this.lstLstFileTypes.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                LstEditorMain.this.lstLstFileTypesValueChanged();
            }
        });
        this.scpLstFileTypes.setPreferredSize(new Dimension(90, 20));
        this.scpLstFileTypes.setViewportView(this.lstLstFileTypes);
        this.pnllstLstFileTypes.add((Component)this.scpLstFileTypes, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlLstFileTypes.add((Component)this.pnllstLstFileTypes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 1.0;
        this.pnlLstEditorMain.add((Component)this.pnlLstFileTypes, gridBagConstraints);
        this.pnlLstFileContent.setLayout(new GridBagLayout());
        this.lblLstFileContent.setText("Content");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.pnlLstFileContent.add((Component)this.lblLstFileContent, gridBagConstraints);
        this.pnllstLstFileContent.setLayout(new BorderLayout());
        this.lstLstFileContent.setSelectionMode(0);
        this.lstLstFileContent.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                LstEditorMain.this.lstLstFileContentValueChanged();
            }
        });
        this.lstLstFileContent.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LstEditorMain.this.lstLstFileContentMouseClicked(evt);
            }
        });
        this.scpLstFileContent.setPreferredSize(new Dimension(90, 20));
        this.scpLstFileContent.setViewportView(this.lstLstFileContent);
        this.pnllstLstFileContent.add((Component)this.scpLstFileContent, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlLstFileContent.add((Component)this.pnllstLstFileContent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.weighty = 1.0;
        this.pnlLstEditorMain.add((Component)this.pnlLstFileContent, gridBagConstraints);
        this.pnlButtons.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.1;
        this.pnlButtons.add((Component)this.jPanel2, gridBagConstraints);
        this.btnNew.setText(PropertyFactory.getString("in_new"));
        this.btnNew.setMnemonic(PropertyFactory.getMnemonic("in_mn_new"));
        this.btnNew.setEnabled(false);
        this.btnNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LstEditorMain.this.btnNewActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.pnlButtons.add((Component)this.btnNew, gridBagConstraints);
        this.btnEdit.setText(PropertyFactory.getString("in_edit"));
        this.btnEdit.setMnemonic(PropertyFactory.getMnemonic("in_mn_edit"));
        this.btnEdit.setEnabled(false);
        this.btnEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LstEditorMain.this.btnEditActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.pnlButtons.add((Component)this.btnEdit, gridBagConstraints);
        this.btnDelete.setText(PropertyFactory.getString("in_delete"));
        this.btnDelete.setMnemonic(PropertyFactory.getMnemonic("in_mn_delete"));
        this.btnDelete.setEnabled(false);
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LstEditorMain.this.btnDeleteActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.pnlButtons.add((Component)this.btnDelete, gridBagConstraints);
        this.btnCopy.setText(PropertyFactory.getString("in_copy"));
        this.btnCopy.setMnemonic(PropertyFactory.getMnemonic("in_mn_copy"));
        this.btnCopy.setEnabled(false);
        this.btnCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LstEditorMain.this.btnCopyActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.pnlButtons.add((Component)this.btnCopy, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.9;
        this.pnlButtons.add((Component)this.jPanel1, gridBagConstraints);
        this.btnDone.setText(PropertyFactory.getString("in_close"));
        this.btnDone.setMnemonic(PropertyFactory.getMnemonic("in_mn_close"));
        this.btnDone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LstEditorMain.this.btnDoneActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.anchor = 15;
        this.pnlButtons.add((Component)this.btnDone, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        this.pnlLstEditorMain.add((Component)this.pnlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pnlLstEditorMain, gridBagConstraints);
        this.setSize(new Dimension(640, 470));
    }

    private void lstLstFileContentMouseClicked(MouseEvent evt) {
        if (this.btnEdit.isEnabled() && evt.getClickCount() == 2) {
            this.btnEditActionPerformed();
        }
    }

    private void lstLstFileContentValueChanged() {
        PObject lstItem = (PObject)this.lstLstFileContent.getSelectedValue();
        if (lstItem != null) {
            boolean canEdit = lstItem.isType("CUSTOM");
            String lstType = (String)this.lstLstFileTypes.getSelectedValue();
            if (lstType.equalsIgnoreCase(s_EDITTYPE_SOURCE)) {
                canEdit = true;
            }
            this.btnDelete.setEnabled(canEdit);
            this.btnEdit.setEnabled(canEdit);
            this.btnCopy.setEnabled(true);
            return;
        }
        this.btnEdit.setEnabled(false);
        this.btnCopy.setEnabled(false);
        this.btnDelete.setEnabled(false);
    }

    private void lstLstFileTypesValueChanged() {
        String lstType = (String)this.lstLstFileTypes.getSelectedValue();
        List possibleSelections = null;
        if (lstType != null) {
            if (lstType.equalsIgnoreCase(s_EDITTYPE_CLASS)) {
                possibleSelections = Globals.getClassList();
                this.editType = 0;
            } else if (lstType.equalsIgnoreCase(s_EDITTYPE_DEITY)) {
                possibleSelections = Globals.getDeityList();
                this.editType = 1;
            } else if (lstType.equalsIgnoreCase(s_EDITTYPE_DOMAIN)) {
                possibleSelections = Globals.getDomainList();
                this.editType = 2;
            } else if (lstType.equalsIgnoreCase(s_EDITTYPE_FEAT)) {
                possibleSelections = Globals.getFeatList();
                this.editType = 3;
            } else if (lstType.equalsIgnoreCase(s_EDITTYPE_LANGUAGE)) {
                possibleSelections = Globals.getLanguageList();
                this.editType = 4;
            } else if (lstType.equalsIgnoreCase(s_EDITTYPE_RACE)) {
                possibleSelections = new ArrayList(Globals.getRaceMap().values());
                this.editType = 5;
            } else if (lstType.equalsIgnoreCase(s_EDITTYPE_SKILL)) {
                possibleSelections = Globals.getSkillList();
                this.editType = 6;
            } else if (lstType.equalsIgnoreCase(s_EDITTYPE_SPELL)) {
                possibleSelections = new ArrayList(Globals.getSpellMap().values().size());
                Iterator e = Globals.getSpellMap().values().iterator();
                while (e.hasNext()) {
                    Object obj = e.next();
                    if (obj instanceof Spell) {
                        possibleSelections.add(obj);
                        continue;
                    }
                    possibleSelections.addAll((ArrayList)obj);
                }
                Globals.sortPObjectList(possibleSelections);
                this.editType = 7;
            } else if (lstType.equalsIgnoreCase(s_EDITTYPE_TEMPLATE)) {
                possibleSelections = Globals.getTemplateList();
                this.editType = 8;
            } else if (lstType.equalsIgnoreCase(s_EDITTYPE_SOURCE)) {
                possibleSelections = Globals.getCampaignList();
                this.editType = 9;
            }
        }
        if (possibleSelections == null) {
            possibleSelections = new ArrayList();
            this.editType = -1;
        }
        this.lstLstFileContent.setListData(possibleSelections.toArray());
        this.btnNew.setEnabled(possibleSelections.size() != 0);
        this.btnEdit.setEnabled(false);
        this.btnCopy.setEnabled(false);
        this.btnDelete.setEnabled(false);
    }

    private PObject newObject() {
        switch (this.editType) {
            case 0: {
                return new PCClass();
            }
            case 1: {
                return new Deity();
            }
            case 2: {
                return new Domain();
            }
            case 3: {
                return new Feat();
            }
            case 4: {
                return new Language();
            }
            case 5: {
                return new Race();
            }
            case 6: {
                return new Skill();
            }
            case 7: {
                return new Spell();
            }
            case 8: {
                return new PCTemplate();
            }
            case 9: {
                return new Campaign();
            }
        }
        return null;
    }

    private boolean removeObject(PObject editObject) {
        boolean removed = false;
        if (editObject != null) {
            switch (this.editType) {
                case 0: {
                    removed = Globals.getClassList().remove(editObject);
                    break;
                }
                case 1: {
                    removed = Globals.getDeityList().remove(editObject);
                    break;
                }
                case 2: {
                    if (Globals.getDomainMap().remove(editObject.getKeyName()) == null) break;
                    removed = Globals.getDomainList().remove(editObject);
                    break;
                }
                case 3: {
                    removed = Globals.getFeatList().remove(editObject);
                    break;
                }
                case 4: {
                    removed = Globals.getLanguageList().remove(editObject);
                    break;
                }
                case 5: {
                    removed = Globals.getRaceMap().remove(editObject.getKeyName()) != null;
                    break;
                }
                case 6: {
                    removed = Globals.getSkillList().remove(editObject);
                    break;
                }
                case 7: {
                    Object obj = Globals.getSpellMap().get(editObject.getName());
                    if (obj instanceof ArrayList) {
                        removed = ((ArrayList)obj).remove(editObject);
                        break;
                    }
                    removed = Globals.getSpellMap().remove(editObject.getName()) != null;
                    break;
                }
                case 8: {
                    removed = Globals.getTemplateList().remove(editObject);
                    break;
                }
                case 9: {
                    removed = Globals.getCampaignList().remove(editObject);
                    break;
                }
            }
        }
        if (removed) {
            CustomData.writeCustomFiles(Globals.getCurrentPC());
        }
        return removed;
    }
}

