/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import pcgen.gui.PCGenProp;
import pcgen.gui.utils.BrowserLauncher;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

final class MainAbout
extends JPanel {
    static final long serialVersionUID = -423796320641536943L;
    private JButton mailingList;
    private JButton wwwSite;
    private JLabel dateLabel;
    private JLabel emailLabel;
    private JLabel helperLabel;
    private JLabel leaderLabel;
    private JLabel licenseLabel;
    private JLabel versionLabel;
    private JLabel wwwLink;
    private JScrollPane license;
    private JTabbedPane mainPane;
    private JTabbedPane monkeyTabPane;
    private JTextArea LGPLArea;
    private JTextArea otherLibrariesField;
    private JTextField projectLead;
    private JTextField releaseDate;
    private JTextField version;
    private JPanel creditsPanel;
    private JPanel licensePanel;

    MainAbout() {
        this.initComponents();
    }

    private void initComponents() {
        this.mainPane = new JTabbedPane();
        this.mainPane.add(PropertyFactory.getString("in_abt_credits"), this.buildCreditsPanel());
        this.mainPane.add(PropertyFactory.getString("in_abt_libraries"), this.buildIncludesPanel());
        this.mainPane.add(PropertyFactory.getString("in_abt_license"), this.buildLicensePanel());
        this.setLayout(new BorderLayout());
        this.add("Center", this.mainPane);
        this.mainPane.setPreferredSize(new Dimension(640, 480));
    }

    private JPanel buildCreditsPanel() {
        JPanel creditsPanel = new JPanel();
        this.versionLabel = new JLabel();
        this.dateLabel = new JLabel();
        this.leaderLabel = new JLabel();
        this.helperLabel = new JLabel();
        this.wwwLink = new JLabel();
        this.emailLabel = new JLabel();
        this.version = new JTextField();
        this.releaseDate = new JTextField();
        this.projectLead = new JTextField();
        this.wwwSite = new JButton();
        this.mailingList = new JButton();
        this.monkeyTabPane = new JTabbedPane();
        creditsPanel = new JPanel();
        creditsPanel.setLayout(new GridBagLayout());
        this.versionLabel.setText(PropertyFactory.getString("in_abt_version"));
        GridBagConstraints gridBagConstraints1 = this.buildConstraints(0, 0, 17);
        gridBagConstraints1.weightx = 0.2;
        creditsPanel.add((Component)this.versionLabel, gridBagConstraints1);
        this.dateLabel.setText(PropertyFactory.getString("in_abt_release_date"));
        gridBagConstraints1 = this.buildConstraints(0, 1, 17);
        creditsPanel.add((Component)this.dateLabel, gridBagConstraints1);
        this.leaderLabel.setText(PropertyFactory.getString("in_abt_BD"));
        gridBagConstraints1 = this.buildConstraints(0, 2, 17);
        creditsPanel.add((Component)this.leaderLabel, gridBagConstraints1);
        this.wwwLink.setText(PropertyFactory.getString("in_abt_web"));
        gridBagConstraints1 = this.buildConstraints(0, 3, 17);
        creditsPanel.add((Component)this.wwwLink, gridBagConstraints1);
        this.emailLabel.setText(PropertyFactory.getString("in_abt_email"));
        gridBagConstraints1 = this.buildConstraints(0, 4, 17);
        creditsPanel.add((Component)this.emailLabel, gridBagConstraints1);
        this.helperLabel.setText(PropertyFactory.getString("in_abt_monkeys"));
        gridBagConstraints1 = this.buildConstraints(0, 5, 18);
        creditsPanel.add((Component)this.helperLabel, gridBagConstraints1);
        this.version.setEditable(false);
        this.version.setText(PCGenProp.getVersionNumber());
        this.version.setBorder(null);
        this.version.setOpaque(false);
        gridBagConstraints1 = this.buildConstraints(1, 0, 17);
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        creditsPanel.add((Component)this.version, gridBagConstraints1);
        this.releaseDate.setEditable(false);
        this.releaseDate.setText(PCGenProp.getReleaseDate());
        this.releaseDate.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.releaseDate.setOpaque(false);
        gridBagConstraints1 = this.buildConstraints(1, 1, 17);
        gridBagConstraints1.fill = 2;
        creditsPanel.add((Component)this.releaseDate, gridBagConstraints1);
        this.projectLead.setEditable(false);
        this.projectLead.setText(PCGenProp.getHeadCodeMonkey());
        this.projectLead.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.projectLead.setOpaque(false);
        gridBagConstraints1 = this.buildConstraints(1, 2, 17);
        gridBagConstraints1.fill = 2;
        creditsPanel.add((Component)this.projectLead, gridBagConstraints1);
        this.wwwSite.setText(PCGenProp.getWWWHome());
        this.wwwSite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BrowserLauncher.openURL(MainAbout.this.wwwSite.getText());
                }
                catch (IOException ioe) {
                    Logging.errorPrint(PropertyFactory.getString("in_abt_browser_err"), ioe);
                }
            }
        });
        gridBagConstraints1 = this.buildConstraints(1, 3, 17);
        creditsPanel.add((Component)this.wwwSite, gridBagConstraints1);
        this.mailingList.setText(PCGenProp.getMailingList());
        this.mailingList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BrowserLauncher.openURL(MainAbout.this.mailingList.getText());
                }
                catch (IOException ioe) {
                    Logging.errorPrint(PropertyFactory.getString("in_abt_browser_err"), ioe);
                }
            }
        });
        gridBagConstraints1 = this.buildConstraints(1, 4, 17);
        creditsPanel.add((Component)this.mailingList, gridBagConstraints1);
        gridBagConstraints1 = this.buildConstraints(1, 5, 17);
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.fill = 1;
        creditsPanel.add((Component)this.monkeyTabPane, gridBagConstraints1);
        this.monkeyTabPane.add(PropertyFactory.getString("in_abt_code_mky"), this.buildMonkeyList(PCGenProp.getCodeMonkeys()));
        this.monkeyTabPane.add(PropertyFactory.getString("in_abt_list_mky"), this.buildMonkeyList(PCGenProp.getListMonkeys()));
        this.monkeyTabPane.add(PropertyFactory.getString("in_abt_test_mky"), this.buildMonkeyList(PCGenProp.getTestMonkeys()));
        this.monkeyTabPane.add(PropertyFactory.getString("in_abt_eng_mky"), this.buildMonkeyList(PCGenProp.getEngineeringMonkeys()));
        this.monkeyTabPane.setToolTipTextAt(2, PropertyFactory.getString("in_abt_easter_egg"));
        return creditsPanel;
    }

    private JScrollPane buildMonkeyList(String monkeys) {
        JTextArea textArea = new JTextArea();
        JScrollPane scroller = new JScrollPane();
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setEditable(false);
        textArea.setText(monkeys);
        scroller.setViewportView(textArea);
        textArea.setCaretPosition(0);
        return scroller;
    }

    private GridBagConstraints buildConstraints(int xPos, int yPos, int anchor) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = xPos;
        constraints.gridy = yPos;
        constraints.fill = 0;
        constraints.anchor = anchor;
        constraints.insets = new Insets(5, 0, 5, 10);
        return constraints;
    }

    private JPanel buildIncludesPanel() {
        JPanel iPanel = new JPanel();
        this.otherLibrariesField = new JTextArea();
        iPanel.setLayout(new BorderLayout());
        String s = PropertyFactory.getString("in_abt_lib_apache");
        s = s + PropertyFactory.getString("in_abt_lib_jdom");
        s = s + PropertyFactory.getString("in_abt_lib_l2f");
        this.otherLibrariesField.setText(s);
        this.otherLibrariesField.setWrapStyleWord(true);
        this.otherLibrariesField.setLineWrap(true);
        this.otherLibrariesField.setEditable(false);
        this.otherLibrariesField.setBorder(BorderFactory.createBevelBorder(1));
        iPanel.add("Center", this.otherLibrariesField);
        return iPanel;
    }

    private JPanel buildLicensePanel() {
        JPanel lPanel = new JPanel();
        this.licenseLabel = new JLabel();
        this.license = new JScrollPane();
        this.LGPLArea = new JTextArea();
        lPanel.setLayout(new BorderLayout());
        this.LGPLArea.setEditable(false);
        InputStream lgpl = ClassLoader.getSystemResourceAsStream("LICENSE");
        if (lgpl != null) {
            try {
                this.LGPLArea.read(new InputStreamReader(lgpl), "LICENSE");
            }
            catch (IOException ioe) {
                this.LGPLArea.setText(PropertyFactory.getString("in_abt_license_read_err1"));
            }
        } else {
            this.LGPLArea.setText(PropertyFactory.getString("in_abt_license_read_err2"));
        }
        this.license.setViewportView(this.LGPLArea);
        lPanel.add("Center", this.license);
        return lPanel;
    }
}

