/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Logging;

final class MainDebug
extends JPanel {
    static final long serialVersionUID = 6997794954514089648L;
    private static final JTextArea txtAreaDebug = new JTextArea();
    private BorderLayout borderLayout4 = new BorderLayout();
    private FlowLayout flowLayout3 = new FlowLayout();
    private JButton btnDebugClear = new JButton();
    private JButton btnDebugGo = new JButton();
    private JLabel lblDebugSouth = new JLabel();
    private JPanel debugSouth = new JPanel();
    private JScrollPane debugCenter = new JScrollPane();
    private JTextField txtDebugField = new JTextField();

    MainDebug() {
        this.initComponents();
        System.setOut(new DebugStream(System.out));
        System.setErr(System.out);
        try {
            System.getProperties().list(System.out);
            String javaVersion = System.getProperty("java.vm.version");
            if (javaVersion.indexOf("1.4") == -1) {
                if (javaVersion.indexOf("1.5") == -1) {
                    ShowMessageDelegate.showMessageDialog("You do not have java 1.4.x installed. Go to http://www.java.com to get the latest java.", "PCGen", MessageType.ERROR);
                } else {
                    ShowMessageDelegate.showMessageDialog("Pcgen does not yet work correctly with java 1.5. Please install java 1.4.", "PCGen", MessageType.ERROR);
                }
            }
            try {
                ResourceBundle d_properties = ResourceBundle.getBundle("pcgen/gui/prop/PCGenProp");
                Logging.debugPrint("PCGen version:", d_properties.getString("VersionNumber"));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (!new File("options.ini").exists()) {
                ShowMessageDelegate.showMessageDialog("If you experience any difficulties, look in the Debug tab and post its contents at http://groups.yahoo.com/group/pcgen", "PCGen", MessageType.INFORMATION);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void btnDebugClear_actionPerformed() {
        txtAreaDebug.setText("");
    }

    private void btnDebugGo_actionPerformed() {
        String keyWord = this.txtDebugField.getText();
        PlayerCharacter aPC = Globals.getCurrentPC();
        if (aPC != null) {
            txtAreaDebug.append(aPC.getDisplayName() + ":" + keyWord + " = " + aPC.getVariable(keyWord, true, true, "", ""));
        } else {
            txtAreaDebug.append("No character currently selected.");
        }
        txtAreaDebug.append("\n");
    }

    private void initComponents() {
        this.setLayout(this.borderLayout4);
        txtAreaDebug.setLineWrap(true);
        txtAreaDebug.setWrapStyleWord(true);
        txtAreaDebug.setDoubleBuffered(true);
        txtAreaDebug.setMinimumSize(new Dimension(426, 17));
        txtAreaDebug.setEditable(false);
        this.debugCenter.setHorizontalScrollBarPolicy(32);
        this.debugCenter.setVerticalScrollBarPolicy(22);
        this.debugCenter.setDoubleBuffered(true);
        this.debugCenter.setPreferredSize(new Dimension(446, 37));
        this.txtDebugField.setPreferredSize(new Dimension(200, 21));
        this.debugSouth.setLayout(this.flowLayout3);
        this.debugSouth.setPreferredSize(new Dimension(200, 40));
        this.flowLayout3.setAlignment(0);
        this.lblDebugSouth.setText("Variable : ");
        this.btnDebugGo.setText("Get");
        this.btnDebugGo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainDebug.this.btnDebugGo_actionPerformed();
            }
        });
        this.btnDebugClear.setText("Clear");
        this.btnDebugClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainDebug.btnDebugClear_actionPerformed();
            }
        });
        this.add((Component)this.debugCenter, "Center");
        this.debugCenter.getViewport().add((Component)txtAreaDebug, null);
        this.add((Component)this.debugSouth, "South");
        this.debugSouth.add((Component)this.lblDebugSouth, null);
        this.debugSouth.add((Component)this.txtDebugField, null);
        this.debugSouth.add((Component)this.btnDebugGo, null);
        this.debugSouth.add((Component)this.btnDebugClear, null);
        this.btnDebugGo.setMnemonic('g');
        this.btnDebugClear.setMnemonic('l');
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                MainDebug.this.requestFocus();
            }
        });
    }

    private final class DebugStream
    extends PrintStream {
        private char[] newline = new char[]{'\n'};

        private DebugStream(OutputStream os) {
            super(os);
        }

        public void println(String x) {
            txtAreaDebug.append(x + new String(this.newline));
        }

        public void println(Object x) {
            txtAreaDebug.append(x.toString() + new String(this.newline));
        }

        public void write(int x) {
            txtAreaDebug.append(Integer.toString(x));
        }
    }
}

