/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CsheetFilter;
import pcgen.gui.PFileChooser;
import pcgen.gui.TemplateListModel;
import pcgen.io.ExportHandler;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

final class MainExport
extends JPanel {
    static final long serialVersionUID = 6401354046356862511L;
    private static final CsheetFilter csheetFilter = new CsheetFilter();
    private static final CsheetFilter psheetFilter = new CsheetFilter(1);
    private JButton closeButton = new JButton();
    private JButton exportButton = new JButton();
    private JButton templatePathButton = new JButton();
    private JCheckBox cboxParty = new JCheckBox();
    private JLabel lblPCs = new JLabel();
    private JLabel lblTemplates = new JLabel();
    private JList pcList;
    private JList templateList;
    private JPanel buttonPanel = new JPanel();
    private JScrollPane pcScroll;
    private JScrollPane templateScroll;
    private TemplateListModel templateModel;
    private boolean partyMode = false;

    public MainExport() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Logging.errorPrint("Error while initing form", e);
        }
    }

    public void setCurrentPCSelection(int curSel) {
        this.pcList.updateUI();
        if (curSel > 0 && curSel - 1 < this.pcList.getModel().getSize()) {
            this.setPartyMode(false);
            this.pcList.setSelectedIndex(curSel - 1);
        } else {
            this.setPartyMode(true);
            this.pcList.setSelectedIndex(this.pcList.getModel().getSize() - 1);
        }
        this.setDefaultTemplateSelection();
    }

    void refreshTemplates() {
        ((TemplateListModel)this.templateList.getModel()).updateTemplateList();
    }

    private void setDefaultTemplateSelection() {
        int templatePathEnd;
        String tempSel = this.partyMode ? SettingsHandler.getSelectedPartyHTMLOutputSheet() : SettingsHandler.getSelectedCharacterHTMLOutputSheet(Globals.getCurrentPC());
        File templateDir = SettingsHandler.getPcgenOutputSheetDir();
        if (templateDir != null && (templatePathEnd = templateDir.getAbsolutePath().length() + 1) > 1 && templatePathEnd < tempSel.length()) {
            tempSel = tempSel.substring(templatePathEnd);
        }
        this.templateList.setSelectedIndex(Math.max(0, this.templateModel.indexOf(tempSel)));
    }

    private void setPartyMode(boolean party) {
        if (this.partyMode != party) {
            this.partyMode = party;
            TemplateListModel tlModel = (TemplateListModel)this.templateList.getModel();
            tlModel.setPartyMode(party);
            tlModel.updateTemplateList();
            this.templateList.revalidate();
            this.templateList.updateUI();
            this.cboxParty.setSelected(party);
        }
    }

    private void getTemplatePath() {
        JFileChooser fcTemplates = new JFileChooser();
        fcTemplates.setCurrentDirectory(new File(SettingsHandler.getHTMLOutputSheetPath()));
        if (fcTemplates.showOpenDialog(this) == 0) {
            File newTemplatePath = fcTemplates.getSelectedFile();
            if (!newTemplatePath.isDirectory()) {
                newTemplatePath = newTemplatePath.getParentFile();
            }
            SettingsHandler.setPcgenOutputSheetDir(newTemplatePath.getParentFile());
            TemplateListModel tlModel = (TemplateListModel)this.templateList.getModel();
            tlModel.updateTemplateList();
            this.templateList.revalidate();
            this.setDefaultTemplateSelection();
        }
    }

    private void export() {
        String templateName = (String)this.templateList.getSelectedValue();
        int idx = templateName.lastIndexOf(46);
        String extension = "";
        if (idx >= 0) {
            extension = templateName.substring(idx + 1);
        }
        PFileChooser fcExport = new PFileChooser();
        fcExport.setFileSelectionMode(0);
        fcExport.setCurrentDirectory(new File(SettingsHandler.getHTMLOutputSheetPath()));
        fcExport.addChoosableFileFilter(null, "All Files (*.*)");
        String desc = "htm".equalsIgnoreCase(extension) ? "HTML Documents" : ("xml".equalsIgnoreCase(extension) ? "XML Documents" : extension + " Files");
        fcExport.addChoosableFileFilter(extension, desc + " (*." + extension + ")");
        int[] pcExports = !this.partyMode ? this.pcList.getSelectedIndices() : new int[]{-2};
        for (int loop = 0; loop < pcExports.length; ++loop) {
            String pcName = this.partyMode ? "Entire Party" : (String)this.pcList.getModel().getElementAt(pcExports[loop]);
            fcExport.setSelectedFile(new File(SettingsHandler.getPcgPath().toString() + File.separator + pcName + "." + extension));
            fcExport.setDialogTitle("Export " + pcName);
            if (fcExport.showSaveDialog(this) != 0) continue;
            String aFileName = fcExport.getSelectedFile().getAbsolutePath();
            if (aFileName.length() < 1) {
                ShowMessageDelegate.showMessageDialog("You must set a filename.", "PCGen", MessageType.ERROR);
                continue;
            }
            try {
                int reallyClose;
                File outFile = new File(aFileName);
                if (outFile.isDirectory()) {
                    ShowMessageDelegate.showMessageDialog("You cannot overwrite a directory with a file.", "PCGen", MessageType.ERROR);
                    continue;
                }
                if (outFile.exists() && (reallyClose = JOptionPane.showConfirmDialog(this, "The file " + outFile.getName() + " already exists, are you sure you want to overwrite it?", "Confirm overwriting " + outFile.getName(), 0)) != 0) continue;
                this.printToFile(outFile, pcExports[loop]);
                Globals.executePostExportCommand(aFileName);
                continue;
            }
            catch (IOException ex) {
                ShowMessageDelegate.showMessageDialog("Could not export " + pcName + ". Try another filename.", "PCGen", MessageType.ERROR);
                Logging.errorPrint("Could not export " + pcName, ex);
            }
        }
    }

    private void jbInit() throws Exception {
        this.lblPCs.setText("Select a Character:");
        this.pcList = new JList(new PCListModel());
        this.pcList.setSelectionMode(2);
        this.pcScroll = new JScrollPane();
        this.pcScroll.getViewport().setView(this.pcList);
        this.lblTemplates.setText("Select a Template:");
        this.templateModel = new TemplateListModel(csheetFilter, psheetFilter, this.partyMode, "htmlxml");
        this.templateList = new JList(this.templateModel);
        this.templateList.setSelectionMode(0);
        this.templateScroll = new JScrollPane();
        this.templateScroll.getViewport().setView(this.templateList);
        this.templatePathButton.setText("Find Templates...");
        this.templatePathButton.setMnemonic(70);
        this.templatePathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainExport.this.getTemplatePath();
            }
        });
        this.exportButton.setText("Export");
        this.exportButton.setMnemonic(69);
        this.exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MainExport.this.templateList.getSelectedValue() == null) {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_exportNoTemplate"), "PCGen", MessageType.ERROR);
                } else {
                    MainExport.this.export();
                }
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.setMnemonic(67);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrame parentFrame = (JFrame)MainExport.this.getParent().getParent().getParent().getParent();
                parentFrame.dispose();
            }
        });
        this.buttonPanel.add(this.exportButton);
        this.buttonPanel.add(this.closeButton);
        this.cboxParty.setText("Entire Party");
        this.cboxParty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainExport.this.setPartyMode(MainExport.this.cboxParty.isSelected());
                MainExport.this.pcList.setEnabled(!MainExport.this.cboxParty.isSelected());
                MainExport.this.templateList.updateUI();
                MainExport.this.setDefaultTemplateSelection();
            }
        });
        this.setLayout(new BorderLayout());
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BorderLayout());
        aPanel.add((Component)this.lblPCs, "North");
        aPanel.add((Component)this.pcScroll, "Center");
        aPanel.add((Component)this.cboxParty, "South");
        aPanel.setMinimumSize(new Dimension(200, 200));
        this.add((Component)aPanel, "West");
        JPanel bPanel = new JPanel();
        bPanel.setLayout(new BorderLayout());
        JPanel cPanel = new JPanel();
        cPanel.add(this.lblTemplates);
        bPanel.add((Component)cPanel, "North");
        bPanel.add((Component)this.templateScroll, "Center");
        bPanel.add((Component)this.buttonPanel, "South");
        this.add((Component)bPanel, "Center");
        this.setSize(new Dimension(500, 400));
    }

    private void printToFile(File outFile, int pcIndex) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
        File template = new File(SettingsHandler.getPcgenOutputSheetDir() + File.separator + (String)this.templateList.getSelectedValue());
        if (this.partyMode) {
            SettingsHandler.setSelectedPartyHTMLOutputSheet(template.getAbsolutePath());
            new ExportHandler(template).write(Globals.getPCList(), bw);
            bw.close();
        } else {
            SettingsHandler.setSelectedCharacterHTMLOutputSheet(template.getAbsolutePath(), Globals.getCurrentPC());
            PlayerCharacter aPC = (PlayerCharacter)Globals.getPCList().get(pcIndex);
            PlayerCharacter oldPC = Globals.getCurrentPC();
            Globals.setCurrentPC(aPC);
            new ExportHandler(template).write(aPC, bw);
            Globals.setCurrentPC(oldPC);
        }
        bw.close();
    }

    private static class PCListModel
    extends AbstractListModel {
        private PCListModel() {
        }

        public Object getElementAt(int index) {
            if (index < Globals.getPCList().size()) {
                PlayerCharacter aPC = (PlayerCharacter)Globals.getPCList().get(index);
                return aPC.getDisplayName();
            }
            return null;
        }

        public int getSize() {
            return Globals.getPCList().size();
        }
    }
}

