/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

final class MainHP
extends JPanel {
    static final long serialVersionUID = 8762071234494775757L;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private JButton okButton = new JButton();
    private JPanel buttonPanel = new JPanel();
    private JScrollPane currentHpPane;
    private JTableEx currentHpTable;
    private PCHitPointsTableModel currentHpTableModel = new PCHitPointsTableModel();
    private RendererEditor plusMinusRenderer = new RendererEditor();
    private PlayerCharacter aPC;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public MainHP() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Logging.errorPrint("Error while initing form", e);
        }
    }

    public void setCharacter(PlayerCharacter aPC) {
        this.aPC = aPC;
    }

    public void setPSize() {
        Dimension preferredSize = this.currentHpPane.getPreferredSize();
        preferredSize.height = (this.currentHpTable.getRowCount() + 2) * (this.currentHpTable.getRowHeight() + this.currentHpTable.getRowMargin());
        this.currentHpPane.setPreferredSize(preferredSize);
    }

    /*
     * WARNING - void declaration
     */
    private void hpTableMouseClicked(MouseEvent evt) {
        void var3_2;
        switch (this.currentHpTable.columnAtPoint(evt.getPoint())) {
            case 5: {
                int increment = 1;
                break;
            }
            case 6: {
                int increment = -1;
                break;
            }
            default: {
                return;
            }
        }
        int iRow = this.currentHpTable.getSelectedRow();
        this.incrementForRow(iRow, (int)var3_2);
    }

    private void incrementForRow(int iRow, int increment) {
        if (iRow >= this.currentHpTableModel.getRowCount() - 2) {
            return;
        }
        int iMax = (Integer)this.currentHpTableModel.getValueAt(iRow, 1);
        int iRoll = (Integer)this.currentHpTableModel.getValueAt(iRow, 2);
        if (iRoll > iMax) {
            iRoll = iMax;
            ShowMessageDelegate.showMessageDialog("Setting roll to maximum (" + iMax + ')', "PCGen", MessageType.ERROR);
            increment = 0;
        }
        if (iRoll + increment < 1) {
            ShowMessageDelegate.showMessageDialog("Roll must be at least the minimum (1)", "PCGen", MessageType.ERROR);
        } else if (iRoll + increment > iMax) {
            ShowMessageDelegate.showMessageDialog("Roll cannot exceed the maximum (" + iMax + ')', "PCGen", MessageType.ERROR);
        } else {
            iRoll += increment;
            PCClass aClass = null;
            Race aRace = null;
            if (this.aPC != null) {
                aRace = this.aPC.getRace();
                if (aRace != null) {
                    if (iRow < aRace.hitDice(this.aPC)) {
                        aRace.setHitPoint(iRow, new Integer(iRoll));
                    }
                    iRow -= aRace.hitDice(this.aPC);
                }
                if (iRow >= 0 && iRow < this.aPC.getLevelInfoSize() && (aClass = this.aPC.getClassKeyed(this.aPC.getLevelInfoClassKeyName(iRow))) != null) {
                    int lvl = this.aPC.getLevelInfoClassLevel(iRow) - 1;
                    aClass.setHitPoint(lvl, new Integer(iRoll));
                }
                this.aPC.setDirty(true);
                this.currentHpTableModel.fireTableDataChanged();
            }
        }
    }

    private void jbInit() throws Exception {
        this.currentHpPane = new JScrollPane();
        this.currentHpTable = new JTableEx();
        this.setLayout(this.gridBagLayout);
        this.currentHpTable.setModel(this.currentHpTableModel);
        this.currentHpTable.setSelectionMode(0);
        this.currentHpTable.setDoubleBuffered(false);
        this.currentHpPane.setViewportView(this.currentHpTable);
        this.add((Component)this.currentHpPane, new GridBagConstraints(0, 0, 1, 7, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        TableColumn col = this.currentHpTable.getColumnModel().getColumn(5);
        col.setCellRenderer(this.plusMinusRenderer);
        col.setMaxWidth(30);
        col.setWidth(30);
        col.setMinWidth(30);
        col = this.currentHpTable.getColumnModel().getColumn(6);
        col.setCellRenderer(this.plusMinusRenderer);
        col.setMaxWidth(30);
        col.setWidth(30);
        col.setMinWidth(30);
        this.currentHpTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainHP.this.hpTableMouseClicked(evt);
            }
        });
        this.okButton.setText(PropertyFactory.getString("in_ok"));
        this.okButton.setMnemonic(PropertyFactory.getMnemonic("in_mn_ok"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PCGen_Frame1.getInst().hpTotal_Changed();
                JFrame parentFrame = (JFrame)Utility.getParentNamed(MainHP.this.getParent(), "pcgen.gui.HPFrame");
                if (parentFrame != null) {
                    parentFrame.dispose();
                }
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 11;
        this.buttonPanel.add((Component)this.okButton, c);
        this.add((Component)this.buttonPanel, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class RendererEditor
    implements TableCellRenderer {
        DefaultTableCellRenderer def = new DefaultTableCellRenderer();
        JButton minusButton = new JButton("-");
        JButton plusButton = new JButton("+");

        public RendererEditor() {
            this.def.setBackground(MainHP.this.getBackground());
            this.def.setAlignmentX(0.5f);
            this.def.setHorizontalAlignment(0);
            this.plusButton.setPreferredSize(new Dimension(30, 24));
            this.plusButton.setMinimumSize(new Dimension(30, 24));
            this.plusButton.setMaximumSize(new Dimension(30, 24));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            switch (column) {
                case 5: {
                    this.def.setText("+");
                    return this.def;
                }
                case 6: {
                    this.def.setText("-");
                    return this.def;
                }
            }
            return null;
        }
    }

    final class PCHitPointsTableModel
    extends AbstractTableModel {
        PCHitPointsTableModel() {
        }

        public boolean isCellEditable(int rowIndex, int colIndex) {
            return colIndex == 2;
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 5: 
                case 6: {
                    return class$java$lang$String == null ? (class$java$lang$String = MainHP.class$("java.lang.String")) : class$java$lang$String;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = MainHP.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
            }
            return null;
        }

        public int getColumnCount() {
            return 7;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Class";
                }
                case 1: {
                    return "Sides";
                }
                case 2: {
                    return "Roll";
                }
                case 3: {
                    return "Stat Adj";
                }
                case 4: {
                    return "Total";
                }
                case 5: {
                    return "+";
                }
                case 6: {
                    return "-";
                }
            }
            return "Out Of Bounds";
        }

        public int getRowCount() {
            int iRows = 2;
            if (MainHP.this.aPC != null) {
                if (MainHP.this.aPC.getRace() != null) {
                    iRows += MainHP.this.aPC.getRace().hitDice(MainHP.this.aPC);
                }
                if (MainHP.this.aPC.getClassList() != null) {
                    Iterator e = MainHP.this.aPC.getClassList().iterator();
                    while (e.hasNext()) {
                        PCClass aClass = (PCClass)e.next();
                        iRows += aClass.getLevel();
                    }
                }
            }
            return iRows;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 2) {
                int increment = Integer.parseInt(aValue.toString()) - Integer.parseInt(this.getValueAt(rowIndex, columnIndex).toString());
                MainHP.this.incrementForRow(rowIndex, increment);
            }
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            int askedRowIndex = rowIndex;
            int iHp = 0;
            int iSides = 0;
            if (MainHP.this.aPC != null) {
                Race aRace = MainHP.this.aPC.getRace();
                if (aRace != null) {
                    if (rowIndex < aRace.hitDice(MainHP.this.aPC) && (iHp = aRace.getHitPoint(rowIndex).intValue()) > (iSides = aRace.getHitDiceSize(MainHP.this.aPC))) {
                        aRace.setHitPoint(rowIndex, new Integer(iSides));
                        iHp = iSides;
                    }
                    rowIndex -= aRace.hitDice(MainHP.this.aPC);
                }
                PCClass aClass = null;
                Object aTempList = null;
                if (rowIndex >= 0 && rowIndex < MainHP.this.aPC.getLevelInfoSize()) {
                    String classKeyName = MainHP.this.aPC.getLevelInfoClassKeyName(rowIndex);
                    aClass = MainHP.this.aPC.getClassKeyed(classKeyName);
                    if (aClass != null) {
                        int lvl = MainHP.this.aPC.getLevelInfoClassLevel(rowIndex);
                        int baseSides = aClass.getLevelHitDie(MainHP.this.aPC, lvl);
                        iHp = aClass.getHitPoint(lvl - 1);
                        if (iHp > (iSides = baseSides + (int)aClass.getBonusTo("HD", "MAX", lvl, MainHP.this.aPC))) {
                            aClass.setHitPoint(lvl - 1, new Integer(iSides));
                            iHp = iSides;
                        }
                    }
                }
                if ((rowIndex -= MainHP.this.aPC.getLevelInfoSize()) == 0) {
                    switch (columnIndex) {
                        case 0: {
                            return "Feats";
                        }
                        case 2: 
                        case 4: {
                            Integer iBonus = new Integer((int)MainHP.this.aPC.getTotalBonusTo("HP", "CURRENTMAX"));
                            return iBonus;
                        }
                    }
                    return null;
                }
                if (rowIndex == 1) {
                    switch (columnIndex) {
                        case 0: {
                            return "Total";
                        }
                        case 4: {
                            int iRows = this.getRowCount() - 1;
                            iHp = 0;
                            for (int i = 0; i < iRows && i != askedRowIndex; ++i) {
                                iHp += ((Integer)this.getValueAt(i, 4)).intValue();
                            }
                            return new Integer(iHp);
                        }
                    }
                    return null;
                }
                switch (columnIndex) {
                    case 0: {
                        if (aClass == null) {
                            return aRace == null ? "<none selected>" : aRace.getName();
                        }
                        return aClass.getName();
                    }
                    case 1: {
                        return new Integer(iSides);
                    }
                    case 2: {
                        return new Integer(iHp);
                    }
                    case 3: {
                        int iConMod = (int)MainHP.this.aPC.getStatBonusTo("HP", "BONUS");
                        return new Integer(iConMod);
                    }
                    case 4: {
                        if ((iHp += (int)MainHP.this.aPC.getStatBonusTo("HP", "BONUS")) < 1) {
                            iHp = 1;
                        }
                        return new Integer(iHp);
                    }
                    case 5: {
                        return "+";
                    }
                    case 6: {
                        return "-";
                    }
                }
            }
            return null;
        }
    }
}

