/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.fop.apps.Version;
import org.apache.fop.render.awt.AWTRenderer;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CsheetFilter;
import pcgen.gui.PFileChooser;
import pcgen.gui.TemplateListModel;
import pcgen.io.ExportHandler;
import pcgen.util.FOPHandler;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

final class MainPrint
extends JPanel {
    public static final int EXPORT_MODE = 0;
    public static final int PRINT_MODE = 1;
    static final long serialVersionUID = 2322087772130893998L;
    private static final String MSG = "Please standby while rendering ...";
    private static final CsheetFilter csheetFilter = new CsheetFilter();
    private static final CsheetFilter psheetFilter = new CsheetFilter(1);
    private ButtonListener bl = new ButtonListener();
    private FOPHandler fh = new FOPHandler();
    private JButton closeButton = new JButton();
    private JButton exportButton = new JButton();
    private JButton printButton = new JButton();
    private JButton templatePathButton = new JButton();
    private JCheckBox cboxParty = new JCheckBox();
    private JFrame parentFrame;
    private JLabel lblPCs = new JLabel();
    private JLabel lblTemplates = new JLabel();
    private JList pcList;
    private JList templateList;
    private JPanel buttonPanel = new JPanel();
    private JProgressBar progressBar = new JProgressBar();
    private JScrollPane pcScroll;
    private JScrollPane templateScroll;
    private JTextField progressField = new JTextField();
    private TemplateListModel templateModel;
    private Timer timer;
    private boolean partyMode = false;
    private int mode;

    public MainPrint(JFrame pf, int mode) {
        this.mode = mode;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Logging.errorPrint("Error while initing form", e);
        }
        this.parentFrame = pf;
        this.timer = new Timer(5, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int value = MainPrint.this.progressBar.getValue();
                if (value == MainPrint.this.progressBar.getMaximum()) {
                    value = -1;
                }
                MainPrint.this.progressBar.setValue(value + 1);
            }
        });
    }

    public void setCurrentPCSelection(int curSel) {
        this.pcList.updateUI();
        if (curSel > 0 && curSel - 1 < this.pcList.getModel().getSize()) {
            this.setPartyMode(false);
            this.pcList.setSelectedIndex(curSel - 1);
        } else {
            this.setPartyMode(true);
            this.pcList.setSelectedIndex(this.pcList.getModel().getSize() - 1);
        }
        this.setDefaultTemplateSelection();
    }

    private void setDefaultTemplateSelection() {
        int templatePathEnd;
        String tempSel = this.partyMode ? SettingsHandler.getSelectedPartyPDFOutputSheet() : SettingsHandler.getSelectedCharacterPDFOutputSheet(Globals.getCurrentPC());
        File templateDir = SettingsHandler.getPcgenOutputSheetDir();
        if (templateDir != null && (templatePathEnd = templateDir.getAbsolutePath().length() + 1) > 1 && templatePathEnd < tempSel.length()) {
            tempSel = tempSel.substring(templatePathEnd);
        }
        int index = Math.max(0, this.templateModel.indexOf(tempSel));
        this.templateList.setSelectedIndex(index);
        this.templateList.ensureIndexIsVisible(index);
    }

    private void setPartyMode(boolean party) {
        if (this.partyMode != party) {
            this.partyMode = party;
            TemplateListModel tlModel = (TemplateListModel)this.templateList.getModel();
            tlModel.setPartyMode(party);
            tlModel.updateTemplateList();
            this.templateList.updateUI();
            this.cboxParty.setSelected(party);
        }
    }

    private void getTemplatePath() {
        PFileChooser fcTemplates = new PFileChooser();
        fcTemplates.setCurrentDirectory(new File(SettingsHandler.getPDFOutputSheetPath()));
        if (fcTemplates.showOpenDialog(this) == 0) {
            File newTemplatePath = fcTemplates.getSelectedFile();
            if (!newTemplatePath.isDirectory()) {
                newTemplatePath = newTemplatePath.getParentFile().getParentFile();
            }
            TemplateListModel tlModel = (TemplateListModel)this.templateList.getModel();
            tlModel.updateTemplateList();
            this.templateList.updateUI();
            this.setDefaultTemplateSelection();
        }
    }

    private void block() {
        this.closeButton.setEnabled(false);
        this.closeButton.update(this.closeButton.getGraphics());
        this.exportButton.setEnabled(false);
        this.exportButton.update(this.exportButton.getGraphics());
        this.printButton.setEnabled(false);
        this.printButton.update(this.printButton.getGraphics());
        this.progressField.setText(MSG);
        this.progressField.update(this.progressField.getGraphics());
        this.progressBar.setValue(0);
    }

    private void export() {
        String extension = ".pdf";
        PFileChooser fcExport = new PFileChooser();
        fcExport.setCurrentDirectory(new File(SettingsHandler.getPcgPath().toString()));
        fcExport.setFileSelectionMode(0);
        fcExport.addChoosableFileFilter(null, "All Files (*.*)");
        fcExport.addChoosableFileFilter("pdf", "PDF Documents (*.pdf)");
        int[] pcExports = !this.partyMode ? this.pcList.getSelectedIndices() : new int[]{-2};
        for (int loop = 0; loop < pcExports.length; ++loop) {
            String pcName;
            block14: {
                pcName = this.partyMode ? "Entire Party" : (String)this.pcList.getModel().getElementAt(pcExports[loop]);
                fcExport.setSelectedFile(new File(SettingsHandler.getPcgPath().toString() + File.separator + pcName + ".pdf"));
                fcExport.setDialogTitle("Export " + pcName);
                try {
                    if (fcExport.showSaveDialog(this) != 0) {
                    }
                    break block14;
                }
                catch (Exception ex) {
                    Logging.errorPrint("Could not show Save Dialog for " + pcName);
                }
                continue;
            }
            String characterFileName = fcExport.getSelectedFile().getAbsolutePath();
            if (characterFileName.length() < 1) {
                ShowMessageDelegate.showMessageDialog("You must set a filename.", "PCGen", MessageType.ERROR);
                continue;
            }
            try {
                String errMessage;
                File tmpFile;
                int reallyClose;
                File outFile = new File(characterFileName);
                if (outFile.isDirectory()) {
                    ShowMessageDelegate.showMessageDialog("You cannot overwrite a directory with a file.", "PCGen", MessageType.ERROR);
                    continue;
                }
                if (outFile.exists() && (reallyClose = JOptionPane.showConfirmDialog(this, "The file " + outFile.getName() + " already exists, " + "are you sure you want " + "to overwrite it?", "Confirm overwriting " + outFile.getName(), 0)) != 0) continue;
                this.block();
                String selectedTemplate = (String)this.templateList.getSelectedValue();
                if (selectedTemplate.endsWith(".xslt") || selectedTemplate.endsWith(".xsl")) {
                    tmpFile = File.createTempFile("currentPC_", ".xml");
                    this.printToXMLFile(tmpFile, pcExports[loop]);
                    File template = new File(SettingsHandler.getPcgenOutputSheetDir() + File.separator + (String)this.templateList.getSelectedValue());
                    this.fh.setInputFile(tmpFile, template);
                    SettingsHandler.setSelectedCharacterPDFOutputSheet(template.getAbsolutePath(), Globals.getCurrentPC());
                } else {
                    tmpFile = File.createTempFile("currentPC_", ".fo");
                    this.printToFile(tmpFile, pcExports[loop]);
                    this.fh.setInputFile(tmpFile);
                }
                this.fh.setMode(0);
                this.fh.setOutputFile(outFile);
                Throwable throwable = null;
                this.timer.start();
                try {
                    System.out.println("Fop Version: " + Version.getVersion());
                    this.fh.run();
                }
                catch (Throwable t) {
                    throwable = t;
                }
                this.timer.stop();
                this.unblock();
                tmpFile.deleteOnExit();
                if (throwable != null) {
                    ShowMessageDelegate.showMessageDialog(throwable.getClass().getName() + ": " + throwable.getMessage(), "PCGen", MessageType.ERROR);
                    throwable.printStackTrace();
                }
                if ((errMessage = this.fh.getErrorMessage()).length() > 0) {
                    ShowMessageDelegate.showMessageDialog(errMessage, "PCGen", MessageType.ERROR);
                }
                Globals.executePostExportCommand(characterFileName);
                continue;
            }
            catch (IOException ex) {
                Logging.errorPrint("Could not export " + pcName, ex);
                ShowMessageDelegate.showMessageDialog("Could not export " + pcName + ". Try another filename.", "PCGen", MessageType.ERROR);
            }
        }
    }

    private void jbInit() throws Exception {
        this.lblPCs.setText("Select a Character:");
        this.pcList = new JList(new PCListModel());
        this.pcList.setSelectionMode(2);
        this.pcScroll = new JScrollPane();
        this.pcScroll.getViewport().setView(this.pcList);
        this.lblTemplates.setText("Select a Template:");
        this.templateModel = new TemplateListModel(csheetFilter, psheetFilter, this.partyMode, "pdf");
        this.templateList = new JList(this.templateModel);
        this.templateList.setSelectionMode(0);
        this.templateScroll = new JScrollPane();
        this.templateScroll.getViewport().setView(this.templateList);
        this.templatePathButton.setText("Find Templates...");
        this.templatePathButton.setMnemonic(70);
        this.templatePathButton.addActionListener(this.bl);
        this.exportButton.setText("Export");
        this.exportButton.setMnemonic(69);
        this.exportButton.addActionListener(this.bl);
        this.printButton.setText("Print");
        this.printButton.setMnemonic(80);
        this.printButton.addActionListener(this.bl);
        this.closeButton.setText("Close");
        this.closeButton.setMnemonic(67);
        this.closeButton.addActionListener(this.bl);
        if (this.mode == 0) {
            this.buttonPanel.add(this.exportButton);
        } else if (this.mode == 1) {
            this.buttonPanel.add(this.printButton);
        }
        this.buttonPanel.add(this.closeButton);
        this.cboxParty.setText("Entire Party");
        this.cboxParty.addActionListener(this.bl);
        this.progressField.setBackground(UIManager.getColor("Panel.background"));
        this.progressField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.progressField.setEditable(false);
        this.progressField.setText("");
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setValue(0);
        JPanel progressPanel = new JPanel(new GridLayout(2, 1));
        progressPanel.add(this.progressField);
        progressPanel.add(this.progressBar);
        this.setLayout(new BorderLayout());
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BorderLayout());
        aPanel.add((Component)this.lblPCs, "North");
        aPanel.add((Component)this.pcScroll, "Center");
        aPanel.add((Component)this.cboxParty, "South");
        aPanel.setMinimumSize(new Dimension(200, 200));
        this.add((Component)aPanel, "West");
        JPanel bPanel = new JPanel();
        bPanel.setLayout(new BorderLayout());
        JPanel cPanel = new JPanel();
        cPanel.add(this.lblTemplates);
        bPanel.add((Component)cPanel, "North");
        bPanel.add((Component)this.templateScroll, "Center");
        bPanel.add((Component)this.buttonPanel, "South");
        this.add((Component)bPanel, "Center");
        this.add((Component)progressPanel, "South");
        this.setSize(new Dimension(500, 400));
    }

    private void print() {
        int[] pcExports = !this.partyMode ? this.pcList.getSelectedIndices() : new int[]{-2};
        for (int loop = 0; loop < pcExports.length; ++loop) {
            String pcName = this.partyMode ? "Entire Party" : (String)this.pcList.getModel().getElementAt(pcExports[loop]);
            this.block();
            try {
                String errMessage;
                File tmpFile;
                Logging.debugPrint((String)this.templateList.getSelectedValue());
                if (((String)this.templateList.getSelectedValue()).endsWith(".xslt")) {
                    Logging.debugPrint("Printing using XML/XSLT");
                    tmpFile = File.createTempFile("currentPC_", ".xml");
                    this.printToXMLFile(tmpFile, pcExports[loop]);
                    File template = new File(SettingsHandler.getPcgenOutputSheetDir() + File.separator + (String)this.templateList.getSelectedValue());
                    this.fh.setInputFile(tmpFile, template);
                } else {
                    Logging.debugPrint("Printing using FO sheets");
                    tmpFile = File.createTempFile("currentPC_", ".fo");
                    this.printToFile(tmpFile, pcExports[loop]);
                    this.fh.setInputFile(tmpFile);
                }
                this.fh.setMode(1);
                Throwable throwable = null;
                this.timer.start();
                try {
                    this.fh.run();
                }
                catch (Throwable t) {
                    throwable = t;
                }
                this.timer.stop();
                tmpFile.deleteOnExit();
                if (throwable != null) {
                    ShowMessageDelegate.showMessageDialog(throwable.getClass().getName() + ": " + throwable.getMessage(), "PCGen", MessageType.ERROR);
                    throwable.printStackTrace();
                }
                if ((errMessage = this.fh.getErrorMessage()).length() > 0) {
                    ShowMessageDelegate.showMessageDialog(errMessage, "PCGen", MessageType.ERROR);
                } else {
                    AWTRenderer awtRenderer = (AWTRenderer)this.fh.getRenderer();
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    printerJob.setPrintable((Printable)awtRenderer);
                    printerJob.setPageable((Pageable)awtRenderer);
                    if (printerJob.printDialog()) {
                        printerJob.print();
                    }
                }
            }
            catch (Exception ex) {
                Logging.errorPrint("Could not print " + pcName, ex);
                ShowMessageDelegate.showMessageDialog("Could not print " + pcName + ". Try again.", "PCGen", MessageType.ERROR);
            }
            this.unblock();
        }
    }

    private void printToFile(File outFile, int pcIndex) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
        File template = new File(SettingsHandler.getPcgenOutputSheetDir() + File.separator + (String)this.templateList.getSelectedValue());
        if (this.partyMode) {
            SettingsHandler.setSelectedPartyPDFOutputSheet(template.getAbsolutePath());
            new ExportHandler(template).write(Globals.getPCList(), bw);
        } else {
            System.out.println("### 2 " + template.getAbsolutePath());
            SettingsHandler.setSelectedCharacterPDFOutputSheet(template.getAbsolutePath(), Globals.getCurrentPC());
            PlayerCharacter aPC = (PlayerCharacter)Globals.getPCList().get(pcIndex);
            PlayerCharacter oldPC = Globals.getCurrentPC();
            Globals.setCurrentPC(aPC);
            new ExportHandler(template).write(aPC, bw);
            Globals.setCurrentPC(oldPC);
        }
        bw.close();
    }

    private void printToXMLFile(File outFile, int pcIndex) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
        File template = new File(SettingsHandler.getPcgenOutputSheetDir() + File.separator + "base.xml");
        PlayerCharacter oldPC = Globals.getCurrentPC();
        if (this.partyMode) {
            for (int i = 0; i < Globals.getPCList().size(); ++i) {
                PlayerCharacter aPC = (PlayerCharacter)Globals.getPCList().get(i);
                Globals.setCurrentPC(aPC);
                new ExportHandler(template).write(aPC, bw);
            }
        } else {
            PlayerCharacter aPC = (PlayerCharacter)Globals.getPCList().get(pcIndex);
            Globals.setCurrentPC(aPC);
            new ExportHandler(template).write(aPC, bw);
        }
        Globals.setCurrentPC(oldPC);
        bw.close();
    }

    private void unblock() {
        this.progressBar.setValue(0);
        this.progressField.setText("");
        this.progressField.update(this.progressField.getGraphics());
        this.printButton.setEnabled(true);
        this.printButton.update(this.printButton.getGraphics());
        this.exportButton.setEnabled(true);
        this.exportButton.update(this.exportButton.getGraphics());
        this.closeButton.setEnabled(true);
        this.closeButton.update(this.closeButton.getGraphics());
    }

    static /* synthetic */ void access$600(MainPrint x0) {
        x0.export();
    }

    static /* synthetic */ void access$800(MainPrint x0) {
        x0.print();
    }

    private static class PCListModel
    extends AbstractListModel {
        private PCListModel() {
        }

        public Object getElementAt(int index) {
            if (index < Globals.getPCList().size()) {
                PlayerCharacter aPC = (PlayerCharacter)Globals.getPCList().get(index);
                return aPC.getDisplayName();
            }
            return null;
        }

        public int getSize() {
            return Globals.getPCList().size();
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src.equals(MainPrint.this.exportButton)) {
                if (MainPrint.this.templateList.getSelectedValue() == null) {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_exportNoTemplate"), "PCGen", MessageType.ERROR);
                } else {
                    new Thread(new Runnable(this){
                        private final /* synthetic */ ButtonListener this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            MainPrint.access$600(ButtonListener.access$500(this.this$1));
                        }
                    }).start();
                }
            } else if (src.equals(MainPrint.this.printButton)) {
                if (MainPrint.this.templateList.getSelectedValue() == null) {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_printNoTemplate"), "PCGen", MessageType.ERROR);
                } else {
                    new Thread(new Runnable(this){
                        private final /* synthetic */ ButtonListener this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            MainPrint.access$800(ButtonListener.access$500(this.this$1));
                        }
                    }).start();
                }
            } else if (src.equals(MainPrint.this.closeButton)) {
                MainPrint.this.parentFrame.dispose();
            } else if (src.equals(MainPrint.this.cboxParty)) {
                MainPrint.this.setPartyMode(MainPrint.this.cboxParty.isSelected());
                MainPrint.this.pcList.setEnabled(!MainPrint.this.cboxParty.isSelected());
                MainPrint.this.templateList.updateUI();
                MainPrint.this.setDefaultTemplateSelection();
            } else if (src.equals(MainPrint.this.templatePathButton)) {
                MainPrint.this.getTemplatePath();
            }
        }

        static /* synthetic */ MainPrint access$500(ButtonListener x0) {
            return x0.MainPrint.this;
        }
    }
}

