/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreePath;
import pcgen.core.Campaign;
import pcgen.core.Constants;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.PCCCreator;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.PersistenceObserver;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.BrowserLauncher;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.Utility;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.PersistenceManager;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.SwingWorker;

public class MainSource
extends FilterAdapterPanel {
    public static final String SOURCE_MATERIALS_TAB = "Select and load source materials";
    static final long serialVersionUID = -2654080650560664447L;
    private static int splitOrientation = 1;
    private static final int COL_NAME = 0;
    private static final int COL_LOADED = 1;
    private static final int VIEW_PRODUCT = 0;
    private static final int VIEW_PUBLISH = 1;
    private static final int VIEW_PUBSET = 2;
    private static final int VIEW_PUBFMTSET = 3;
    private static int viewMode = 3;
    private static int viewSelectMode = 0;
    private static final int MODEL_AVAIL = 0;
    private static final int MODEL_SELECT = 1;
    private static PObjectNode typePubRoot;
    private static PObjectNode typePubSetRoot;
    private static PObjectNode typePubFmtSetRoot;
    private final JLabel avaLabel = new JLabel();
    private final JLabel selLabel = new JLabel();
    private CampaignModel availableModel = null;
    private CampaignModel selectedModel = null;
    private FlippingSplitPane asplit;
    private FlippingSplitPane bsplit;
    private FlippingSplitPane splitPane;
    private JButton leftButton;
    private JButton loadButton = new JButton();
    private JButton refreshButton = new JButton();
    private JButton removeAllButton;
    private JButton rightButton;
    private JButton unloadAllButton = new JButton();
    private JButton websiteButton;
    private JComboBoxEx viewComboBox = new JComboBoxEx();
    private JComboBoxEx viewSelectComboBox = new JComboBoxEx();
    private JLabelPane infoLabel;
    private JPanel center = new JPanel();
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel1n = new JPanel();
    private JPanel jPanel1s = new JPanel();
    private JScrollPane cScroll;
    private JTreeTable availableTable;
    private JTreeTable selectedTable;
    private List selectedCampaigns = new ArrayList();
    private PObjectNode lastSelection = null;
    private TreePath selPath;
    private boolean hasBeenSized = false;
    private boolean sourcesLoaded = false;
    private int selRow;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$pcgen$gui$utils$TreeTableModel;

    public MainSource() {
        this.setName(Constants.tabNames[1]);
        try {
            this.initComponents();
        }
        catch (Exception e) {
            ShowMessageDelegate.showMessageDialog("Error in MainSource whilst initialising:\n " + e.toString() + "\n" + "PCGen may not operate correctly as a result of this error. ", "PCGen", MessageType.ERROR);
            Logging.errorPrint("Error initialising MainSource: " + e.toString(), e);
        }
        this.initActionListeners();
        FilterFactory.restoreFilterSettings(this);
    }

    public boolean isMatchAnyEnabled() {
        return true;
    }

    public boolean isNegateEnabled() {
        return true;
    }

    public int getSelectionMode() {
        return -2;
    }

    public void changedGameMode() {
        this.selectedCampaigns.clear();
        this.resetViewNodes();
        this.unloadAllCampaigns_actionPerformed();
    }

    public void initializeFilters() {
    }

    public void refreshCampaigns() {
        PersistenceManager.getInstance().refreshCampaigns();
        this.updateModels();
    }

    public void refreshFiltering() {
        this.updateModels();
        this.selectCampaignsByFilename(PersistenceManager.getInstance().getChosenCampaignSourcefiles());
    }

    public void updateLoadedCampaignsUI() {
        this.selectedCampaigns.clear();
        Iterator campIter = Globals.getCampaignList().iterator();
        while (campIter.hasNext()) {
            Campaign aCamp = (Campaign)campIter.next();
            if (!aCamp.isLoaded()) continue;
            this.selectedCampaigns.add(aCamp);
        }
        this.updateModels();
        if (this.getParent() != null && Globals.displayListsHappy()) {
            PCGen_Frame1 parent = PCGen_Frame1.getRealParentFrame(this);
            parent.enableLstEditors(true);
        }
    }

    private void setInfoLabelText(PObjectNode aNode) {
        this.lastSelection = aNode;
        if (aNode != null) {
            if (aNode.getItem() instanceof Campaign) {
                Campaign aCamp = (Campaign)aNode.getItem();
                this.websiteButton.setEnabled(!aCamp.getSourceWeb().equals(""));
                StringBuffer b = new StringBuffer();
                b.append("<html><b>").append(aCamp.getName()).append("</b><br>");
                b.append("<b>TYPE</b>: ").append(aCamp.getType());
                b.append("&nbsp; <b>RANK</b>: ").append(aCamp.getRank());
                b.append("&nbsp; <b>GAME MODE</b>: ").append(aCamp.getGameModeString());
                String bString = aCamp.getSource();
                if (bString.length() > 0) {
                    b.append("&nbsp; <b>SOURCE</b>: ").append(bString);
                }
                boolean infoDisplayed = false;
                bString = aCamp.getInfoText();
                if (bString.length() > 0) {
                    b.append("<p><b>INFORMATION</b>:<br>").append(bString).append("</p>");
                    infoDisplayed = true;
                }
                if ((bString = aCamp.getSection15Info()).length() != 0) {
                    if (!infoDisplayed) {
                        b.append("<br");
                    }
                    b.append("<b>COPYRIGHT</b>:<br>").append(bString);
                }
                b.append("</html>");
                this.infoLabel.setText(b.toString());
            } else {
                this.websiteButton.setEnabled(false);
                PObjectNode pathNode = aNode;
                String path = pathNode.getItem().toString();
                while (pathNode.getParent() != this.availableTable.getTree().getModel().getRoot() && pathNode.getParent() != this.selectedTable.getTree().getModel().getRoot()) {
                    pathNode = pathNode.getParent();
                    path = pathNode.getItem().toString() + "." + path;
                }
                StringBuffer b = new StringBuffer();
                b.append("<html><b>").append(path).append("</b><br>");
                b.append("</html>");
                this.infoLabel.setText(b.toString());
            }
        }
    }

    private void setLoadedColMaxWidth() {
        this.selectedTable.getColumnModel().getColumn(1).setMaxWidth(50);
    }

    private int getSelectedIndex(ListSelectionEvent e) {
        DefaultListSelectionModel model = (DefaultListSelectionModel)e.getSource();
        if (model == null) {
            return -1;
        }
        return model.getMinSelectionIndex();
    }

    private void createAvailableModel() {
        if (this.availableModel == null) {
            this.availableModel = new CampaignModel(viewMode, true);
        } else {
            this.availableModel.resetModel(viewMode, true, false);
        }
    }

    private void createModels() {
        this.createAvailableModel();
        this.createSelectedModel();
    }

    private void createSelectedModel() {
        if (this.selectedModel == null) {
            this.selectedModel = new CampaignModel(viewSelectMode, false);
        } else {
            this.selectedModel.resetModel(viewSelectMode, false, false);
        }
    }

    private void createTreeTables() {
        this.availableTable = new JTreeTable(this.availableModel);
        this.availableTable.setSelectionMode(0);
        this.availableTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int idx = MainSource.this.getSelectedIndex(e);
                    if (idx < 0) {
                        return;
                    }
                    Object temp = MainSource.this.availableTable.getTree().getPathForRow(idx).getLastPathComponent();
                    if (temp == null || !(temp instanceof PObjectNode)) {
                        ShowMessageDelegate.showMessageDialog("No campaign selected. Try again.", "PCGen", MessageType.ERROR);
                        return;
                    }
                    MainSource.this.setInfoLabelText((PObjectNode)temp);
                    MainSource.this.rightButton.setEnabled(true);
                    MainSource.this.leftButton.setEnabled(false);
                }
            }
        });
        final JTree tree = this.availableTable.getTree();
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setCellRenderer(new LabelTreeCellRenderer());
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int mlSelRow = tree.getRowForLocation(e.getX(), e.getY());
                TreePath mlSelPath = tree.getPathForLocation(e.getX(), e.getY());
                if (mlSelRow != -1) {
                    if (e.getClickCount() == 1 && mlSelPath != null) {
                        tree.setSelectionPath(mlSelPath);
                    } else if (e.getClickCount() == 2) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                MainSource.access$600(2.access$500(this.this$1), true);
                            }
                        });
                    }
                }
            }

            static /* synthetic */ MainSource access$500(2 x0) {
                return x0.MainSource.this;
            }
        };
        tree.addMouseListener(ml);
        this.selectedTable = new JTreeTable(this.selectedModel);
        this.selectedTable.setSelectionMode(0);
        final JTree btree = this.selectedTable.getTree();
        btree.setRootVisible(false);
        btree.setShowsRootHandles(true);
        btree.setCellRenderer(new LabelTreeCellRenderer());
        this.selectedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int idx = MainSource.this.getSelectedIndex(e);
                    if (idx < 0) {
                        return;
                    }
                    Object temp = MainSource.this.selectedTable.getTree().getPathForRow(idx).getLastPathComponent();
                    if (temp == null || !(temp instanceof PObjectNode)) {
                        MainSource.this.lastSelection = null;
                        MainSource.this.infoLabel.setText();
                        return;
                    }
                    MainSource.this.setInfoLabelText((PObjectNode)temp);
                    MainSource.this.leftButton.setEnabled(true);
                    MainSource.this.rightButton.setEnabled(false);
                }
            }
        });
        ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int mlSelRow = btree.getRowForLocation(e.getX(), e.getY());
                TreePath mlSelPath = btree.getPathForLocation(e.getX(), e.getY());
                if (mlSelRow != -1) {
                    if (e.getClickCount() == 1) {
                        btree.setSelectionPath(mlSelPath);
                    } else if (e.getClickCount() == 2) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 5 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                MainSource.access$600(5.access$1000(this.this$1), false);
                            }
                        });
                    }
                }
            }

            static /* synthetic */ MainSource access$1000(5 x0) {
                return x0.MainSource.this;
            }
        };
        btree.addMouseListener(ml);
        this.hookupPopupMenu(this.availableTable);
        this.hookupPopupMenu(this.selectedTable);
    }

    private void doCampaign(boolean select) {
        if (this.lastSelection == null) {
            return;
        }
        if (this.lastSelection.getItem() instanceof Campaign) {
            Campaign theCamp = (Campaign)this.lastSelection.getItem();
            if (select) {
                if (!this.selectedCampaigns.contains(theCamp)) {
                    this.selectedCampaigns.add(theCamp);
                }
            } else {
                this.selectedCampaigns.remove(theCamp);
            }
        } else {
            this.selectAllLeaves(this.lastSelection, select);
        }
        Collections.sort(this.selectedCampaigns);
        this.updateModels();
        if (select) {
            this.selectedTable.expandByPObjectName(this.lastSelection.getItem().toString());
        }
        this.rememberSourceChanges();
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.getStatusBar().setText(SOURCE_MATERIALS_TAB);
        if (!this.hasBeenSized) {
            this.hasBeenSized = true;
            this.splitPane.setDividerSize(10);
            this.splitPane.setDividerLocation(0.5);
            this.bsplit.setDividerSize(10);
            this.bsplit.setDividerLocation(0.75);
            this.asplit.setDividerSize(10);
            this.asplit.setDividerLocation(0.5);
            this.setLoadedColMaxWidth();
        }
    }

    private void hookupPopupMenu(JTreeTable treeTable) {
        treeTable.addMouseListener(new CampaignPopupListener(treeTable, new CampaignPopupMenu(treeTable)));
    }

    private void initActionListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                MainSource.this.formComponentShown();
            }
        });
        this.rightButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainSource.this.doCampaign(true);
            }
        });
        this.leftButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainSource.this.doCampaign(false);
            }
        });
        this.viewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainSource.this.viewComboBoxActionPerformed();
            }
        });
        this.viewSelectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainSource.this.viewSelectComboBoxActionPerformed();
            }
        });
    }

    private void initComponents() {
        this.resetViewNodes();
        this.viewComboBox.addItem("Name Only");
        this.viewComboBox.addItem("Company");
        this.viewComboBox.addItem("Company/Setting");
        this.viewComboBox.addItem("Comp/Fmt/Setting");
        Utility.setDescription(this.viewComboBox, "You can change how the Sources in the Tables are listed.");
        viewMode = SettingsHandler.getPCGenOption("pcgen.options.sourceTab.availableListMode", 3);
        this.viewComboBox.setSelectedIndex(viewMode);
        this.viewSelectComboBox.addItem("Name Only");
        this.viewSelectComboBox.addItem("Company");
        this.viewSelectComboBox.addItem("Company/Setting");
        this.viewSelectComboBox.addItem("Company/Format/Setting");
        viewSelectMode = SettingsHandler.getPCGenOption("pcgen.options.sourceTab.selectedListMode", 0);
        Utility.setDescription(this.viewSelectComboBox, "You can change how the Sources in the Tables are listed.");
        this.viewSelectComboBox.setSelectedIndex(viewSelectMode);
        this.createModels();
        this.createTreeTables();
        this.center.setLayout(new BorderLayout());
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel leftPane = new JPanel();
        JPanel rightPane = new JPanel();
        leftPane.setLayout(gridbag);
        this.splitPane = new FlippingSplitPane(splitOrientation, leftPane, rightPane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.center.add((Component)this.splitPane, "Center");
        Utility.buildConstraints(c, 0, 0, 1, 1, 100.0, 5.0);
        c.fill = 0;
        c.anchor = 10;
        JPanel aPanel = new JPanel();
        gridbag.setConstraints(aPanel, c);
        this.avaLabel.setText(PropertyFactory.getString("in_available"));
        aPanel.add(this.avaLabel);
        aPanel.add(this.viewComboBox);
        ImageIcon newImage = IconUtilitities.getImageIcon("Forward16.gif");
        this.rightButton = new JButton(newImage);
        Utility.setDescription(this.rightButton, "Click to add the source");
        this.rightButton.setEnabled(false);
        aPanel.add(this.rightButton);
        leftPane.add(aPanel);
        newImage = IconUtilitities.getImageIcon("Refresh16.gif");
        JButton sButton = new JButton(newImage);
        Utility.setDescription(sButton, "Click to change the orientation of the tables");
        sButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (splitOrientation == 0) {
                    splitOrientation = 1;
                } else {
                    splitOrientation = 0;
                }
                MainSource.this.splitPane.setOrientation(splitOrientation);
                MainSource.this.splitPane.setDividerLocation(0.5);
            }
        });
        aPanel.add(sButton);
        Utility.buildConstraints(c, 0, 1, 1, 1, 0.0, 95.0);
        c.fill = 1;
        c.anchor = 10;
        JScrollPane scrollPane = new JScrollPane(this.availableTable);
        gridbag.setConstraints(scrollPane, c);
        leftPane.add(scrollPane);
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        rightPane.setLayout(gridbag);
        Utility.buildConstraints(c, 0, 0, 1, 1, 100.0, 5.0);
        c.fill = 0;
        c.anchor = 10;
        aPanel = new JPanel();
        gridbag.setConstraints(aPanel, c);
        this.selLabel.setText(PropertyFactory.getString("in_selected"));
        aPanel.add(this.selLabel);
        aPanel.add(this.viewSelectComboBox);
        newImage = IconUtilitities.getImageIcon("Back16.gif");
        this.leftButton = new JButton(newImage);
        Utility.setDescription(this.leftButton, "Click to remove the source");
        this.leftButton.setEnabled(false);
        aPanel.add(this.leftButton);
        rightPane.add(aPanel);
        Utility.buildConstraints(c, 0, 1, 1, 1, 0.0, 95.0);
        c.fill = 1;
        c.anchor = 10;
        scrollPane = new JScrollPane(this.selectedTable);
        gridbag.setConstraints(scrollPane, c);
        rightPane.add(scrollPane);
        this.selectedTable.setColAlign(1, 0);
        Border etched = null;
        TitledBorder title1 = BorderFactory.createTitledBorder(etched, "Source Info");
        title1.setTitleJustification(2);
        this.infoLabel = new JLabelPane();
        this.infoLabel.setBackground(rightPane.getBackground());
        this.cScroll = new JScrollPane(this.infoLabel);
        this.cScroll.setBorder(title1);
        FlowLayout aFlow = new FlowLayout();
        aFlow.setAlignment(1);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.add((Component)this.jPanel1n, "North");
        this.jPanel1.add((Component)this.jPanel1s, "Center");
        this.jPanel1n.setLayout(aFlow);
        aFlow = new FlowLayout();
        aFlow.setAlignment(1);
        this.jPanel1s.setLayout(aFlow);
        this.loadButton.setText("Load");
        this.loadButton.setMnemonic(76);
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainSource.this.loadCampaigns_actionPerformed();
            }
        });
        this.jPanel1n.add(this.loadButton);
        this.loadButton.setToolTipText("This loads all the sources listed in the above table");
        this.unloadAllButton.setText("Unload All");
        this.unloadAllButton.setMnemonic(85);
        this.unloadAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainSource.this.unloadAllCampaigns_actionPerformed();
            }
        });
        this.jPanel1n.add(this.unloadAllButton);
        this.removeAllButton = new JButton("Remove All");
        this.removeAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainSource.this.selectAll_actionPerformed(false);
            }
        });
        this.removeAllButton.setToolTipText("Remove all sources from the above table");
        this.jPanel1n.add(this.removeAllButton);
        this.refreshButton.setText("Refresh");
        this.refreshButton.setToolTipText("Refresh the list of sources");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainSource.this.refreshCampaigns();
            }
        });
        this.jPanel1s.add(this.refreshButton);
        this.websiteButton = new JButton("Website");
        this.websiteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainSource.this.launchProductWebsite(false, true);
            }
        });
        this.websiteButton.setToolTipText("Go to the selected product's website");
        this.websiteButton.setEnabled(false);
        this.jPanel1s.add(this.websiteButton);
        JButton pccButton = new JButton("Customise");
        final MainSource t = this;
        pccButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new PCCCreator(t);
            }
        });
        pccButton.setToolTipText("Customise your own source to ease your loading process");
        this.jPanel1s.add(pccButton);
        this.asplit = new FlippingSplitPane(1, this.cScroll, this.jPanel1);
        this.asplit.setOneTouchExpandable(true);
        this.asplit.setDividerSize(10);
        JPanel botPane = new JPanel();
        botPane.setLayout(new BorderLayout());
        botPane.add((Component)this.asplit, "Center");
        this.bsplit = new FlippingSplitPane(0, this.center, botPane);
        this.bsplit.setOneTouchExpandable(true);
        this.bsplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bsplit, "Center");
        if (SettingsHandler.isLoadCampaignsAtStart()) {
            this.selectCampaignsByFilename(PersistenceManager.getInstance().getChosenCampaignSourcefiles());
            if (this.selectedCampaigns.size() > 0) {
                this.loadCampaigns();
            }
        }
    }

    private void launchProductWebsite(boolean avail, boolean isProductNotHelp) {
        JTreeTable treeTable = avail ? this.availableTable : this.selectedTable;
        PObjectNode pon = (PObjectNode)treeTable.getTree().getLastSelectedPathComponent();
        if (pon != null) {
            if (pon.getItem() instanceof Campaign) {
                String theURL;
                Campaign theCamp = (Campaign)pon.getItem();
                String string = theURL = isProductNotHelp ? theCamp.getSourceWeb() : theCamp.getHelp();
                if (theURL != null && !theURL.equals("")) {
                    try {
                        BrowserLauncher.openURL(theURL);
                    }
                    catch (IOException ioEx) {
                        Logging.errorPrint("Could not open browser to " + theURL, ioEx);
                        ShowMessageDelegate.showMessageDialog("Could not open browser to " + theURL, "PCGen", MessageType.ERROR);
                    }
                } else {
                    String type = isProductNotHelp ? "web" : "help";
                    ShowMessageDelegate.showMessageDialog("No " + type + " information found for Source: " + theCamp.getName(), "PCGen", MessageType.WARNING);
                }
            }
        } else {
            ShowMessageDelegate.showMessageDialog("Please select a source.", "PCGen", MessageType.ERROR);
        }
    }

    private void loadCampaigns() {
        if (this.selectedCampaigns.size() < 1) {
            return;
        }
        PersistenceObserver observer = new PersistenceObserver();
        PersistenceManager pManager = PersistenceManager.getInstance();
        try {
            pManager.addObserver(observer);
            pManager.loadCampaigns(this.selectedCampaigns);
            pManager.deleteObserver(observer);
        }
        catch (PersistenceLayerException e) {
            ShowMessageDelegate.showMessageDialog(e.getMessage(), "PCGen", MessageType.WARNING);
            this.unloadAllCampaigns_actionPerformed();
        }
        Globals.sortCampaigns();
        if (this.getParent() != null && Globals.displayListsHappy()) {
            PCGen_Frame1 parent = PCGen_Frame1.getRealParentFrame(this);
            parent.enableLstEditors(true);
        }
        this.updateModels();
    }

    private void loadCampaigns_actionPerformed() {
        this.sourcesLoaded = true;
        this.loadButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.refreshButton.setToolTipText("Can't refresh while sources are loaded.");
        final String oldStatus = PCGen_Frame1.getStatusBar().getText();
        PCGen_Frame1.getStatusBar().setText("Loading Sources...");
        PCGen_Frame1.getStatusBar().revalidate();
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                MainSource.this.loadCampaigns();
                return "";
            }

            public void finished() {
                PCGen_Frame1.enableDisableMenuItems();
                PCGen_Frame1.getStatusBar().setText(oldStatus);
                PCGen_Frame1.restoreFilterSettings(null);
            }
        };
        worker.start();
    }

    private void rememberSourceChanges() {
        ArrayList<String> campaignStrings = new ArrayList<String>(this.selectedCampaigns.size());
        Iterator campaigns = this.selectedCampaigns.iterator();
        while (campaigns.hasNext()) {
            campaignStrings.add(((Campaign)campaigns.next()).getSourceFile());
        }
        PersistenceManager.getInstance().setChosenCampaignSourcefiles(campaignStrings);
    }

    private void resetViewNodes() {
        PObjectNode d;
        Iterator lI;
        String topType;
        int i;
        List allowedModes = Globals.getAllowedGameModes();
        typePubRoot = new PObjectNode();
        typePubSetRoot = new PObjectNode();
        typePubFmtSetRoot = new PObjectNode();
        ArrayList<String> aList = new ArrayList<String>();
        Iterator i2 = Globals.getCampaignList().iterator();
        while (i2.hasNext()) {
            Campaign aCamp = (Campaign)i2.next();
            if (!aCamp.isGameMode(allowedModes) || aCamp.getMyTypeCount() <= 0 || aList.contains(aCamp.getMyType(0))) continue;
            aList.add(aCamp.getMyType(0));
        }
        Collections.sort(aList);
        if (!aList.contains("Other")) {
            aList.add("Other");
        }
        PObjectNode[] p1 = new PObjectNode[aList.size()];
        PObjectNode[] p2 = new PObjectNode[aList.size()];
        PObjectNode[] p3 = new PObjectNode[aList.size()];
        for (i = 0; i < aList.size(); ++i) {
            p1[i] = new PObjectNode();
            p1[i].setItem(aList.get(i).toString());
            p1[i].setParent(typePubRoot);
            p2[i] = new PObjectNode();
            p2[i].setItem(aList.get(i).toString());
            p2[i].setParent(typePubSetRoot);
            p3[i] = new PObjectNode();
            p3[i].setItem(aList.get(i).toString());
            p3[i].setParent(typePubFmtSetRoot);
        }
        typePubRoot.setChildren(p1);
        typePubSetRoot.setChildren(p2);
        typePubFmtSetRoot.setChildren(p3);
        for (i = 0; i < p2.length; ++i) {
            aList.clear();
            for (int j = 0; j < Globals.getCampaignList().size(); ++j) {
                Campaign bCamp = (Campaign)Globals.getCampaignList().get(j);
                if (!bCamp.isType(topType = p2[i].toString()) || bCamp.getMyTypeCount() <= 2 || !bCamp.isGameMode(allowedModes) || aList.contains(bCamp.getMyType(2))) continue;
                aList.add(bCamp.getMyType(2));
            }
            Collections.sort(aList);
            lI = aList.iterator();
            while (lI.hasNext()) {
                String aString = (String)lI.next();
                d = new PObjectNode();
                d.setParent(p2[i]);
                p2[i].addChild(d);
                d.setItem(aString);
            }
        }
        for (i = 0; i < p3.length; ++i) {
            aList.clear();
            for (int j = 0; j < Globals.getCampaignList().size(); ++j) {
                Campaign bCamp = (Campaign)Globals.getCampaignList().get(j);
                if (!bCamp.isType(topType = p3[i].toString()) || bCamp.getMyTypeCount() <= 1 || !bCamp.isGameMode(allowedModes) || aList.contains(bCamp.getMyType(1))) continue;
                aList.add(bCamp.getMyType(1));
            }
            Collections.sort(aList);
            lI = aList.iterator();
            while (lI.hasNext()) {
                String aString = (String)lI.next();
                d = new PObjectNode(aString);
                p3[i].addChild(d);
            }
            ArrayList p4 = p3[i].getChildren();
            for (int k = 0; p4 != null && k < p4.size(); ++k) {
                PObjectNode p4node = (PObjectNode)p4.get(k);
                aList.clear();
                for (int m = 0; m < Globals.getCampaignList().size(); ++m) {
                    Campaign cCamp = (Campaign)Globals.getCampaignList().get(m);
                    String pubType = p4node.getParent().toString();
                    String formatType = p4node.toString();
                    if (!cCamp.isType(pubType) || !cCamp.isType(formatType) || cCamp.getMyTypeCount() <= 2 || !cCamp.isGameMode(allowedModes) || aList.contains(cCamp.getMyType(2))) continue;
                    aList.add(cCamp.getMyType(2));
                }
                Collections.sort(aList);
                Iterator lI2 = aList.iterator();
                while (lI2.hasNext()) {
                    String aString = (String)lI2.next();
                    PObjectNode d2 = new PObjectNode(aString);
                    p4node.addChild(d2);
                }
            }
        }
    }

    private void selectAllLeaves(PObjectNode node, boolean select) {
        for (int count = 0; count < node.getChildCount(); ++count) {
            PObjectNode child = node.getChild(count);
            if (child.isLeaf() && child.getItem() instanceof Campaign) {
                Campaign aCamp = (Campaign)child.getItem();
                if (aCamp == null) continue;
                if (select) {
                    if (this.selectedCampaigns.contains(aCamp)) continue;
                    this.selectedCampaigns.add(aCamp);
                    continue;
                }
                this.selectedCampaigns.remove(aCamp);
                continue;
            }
            this.selectAllLeaves(child, select);
        }
    }

    private void selectAll_actionPerformed(boolean select) {
        if (select) {
            this.selectAllLeaves((PObjectNode)this.availableTable.getTree().getModel().getRoot(), true);
        } else {
            this.selectedCampaigns.clear();
            this.unloadAllCampaigns_actionPerformed();
        }
        this.updateModels();
        this.rememberSourceChanges();
    }

    private void selectCampaignsByFilename(Collection campaigns) {
        Iterator iter = campaigns.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            Campaign aCampaign = Globals.getCampaignByFilename(element);
            if (aCampaign == null || this.selectedCampaigns.contains(aCampaign)) continue;
            this.selectedCampaigns.add(aCampaign);
            this.updateModels();
        }
    }

    private void unloadAllCampaigns_actionPerformed() {
        PCGen_Frame1 parent = PCGen_Frame1.getRealParentFrame(this);
        if (Logging.isDebugMode()) {
            ShowMessageDelegate.showMessageDialog("PC's are not closed in debug mode.  Please be aware that they may not function correctly until campaign data is loaded again.", "PCGen", MessageType.WARNING);
        } else {
            parent.closeAllPCs();
            if (PCGen_Frame1.getBaseTabbedPane().getTabCount() > PCGen_Frame1.FIRST_CHAR_TAB) {
                ShowMessageDelegate.showMessageDialog("Can't unload campaigns until all PC's are closed.", "PCGen", MessageType.INFORMATION);
                return;
            }
        }
        Globals.emptyLists();
        PersistenceManager.getInstance().emptyLists();
        PersistenceManager.getInstance().setChosenCampaignSourcefiles(new ArrayList());
        Iterator it = Globals.getCampaignList().iterator();
        while (it.hasNext()) {
            Campaign aCamp = (Campaign)it.next();
            aCamp.setIsLoaded(false);
        }
        parent.enableLstEditors(false);
        this.sourcesLoaded = false;
        this.refreshButton.setEnabled(true);
        this.refreshButton.setToolTipText("Refresh the list of sources");
        PCGen_Frame1.enableDisableMenuItems();
        this.updateModels();
    }

    private void updateAvailableModel() {
        List pathList = this.availableTable.getExpandedPaths();
        this.createAvailableModel();
        this.availableTable.updateUI();
        this.availableTable.expandPathList(pathList);
    }

    private void updateModels() {
        this.updateAvailableModel();
        this.updateSelectedModel();
        this.setLoadedColMaxWidth();
        if (this.selectedTable.getTree().getRowCount() == 0) {
            this.loadButton.setEnabled(false);
            this.unloadAllButton.setEnabled(false);
            this.removeAllButton.setEnabled(false);
        } else {
            this.loadButton.setEnabled(!this.sourcesLoaded);
            this.unloadAllButton.setEnabled(true);
            this.removeAllButton.setEnabled(true);
        }
    }

    private void updateSelectedModel() {
        List pathList = this.selectedTable.getExpandedPaths();
        this.createSelectedModel();
        this.selectedTable.updateUI();
        this.selectedTable.expandPathList(pathList);
    }

    private void viewComboBoxActionPerformed() {
        int index = this.viewComboBox.getSelectedIndex();
        if (index != viewMode) {
            viewMode = index;
            SettingsHandler.setPCGenOption("pcgen.options.sourceTab.availableListMode", viewMode);
            this.updateAvailableModel();
        }
    }

    private void viewSelectComboBoxActionPerformed() {
        int index = this.viewSelectComboBox.getSelectedIndex();
        if (index != viewSelectMode) {
            viewSelectMode = index;
            SettingsHandler.setPCGenOption("pcgen.options.sourceTab.selectedListMode", viewSelectMode);
            this.updateSelectedModel();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CampaignPopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = -2654080650560664447L;

        CampaignPopupMenu(JTreeTable treeTable) {
            if (treeTable == MainSource.this.availableTable) {
                this.add(this.createAddMenuItem("Select", "shortcut EQUALS"));
                this.add(this.createAddAllMenuItem("Select All", "alt A"));
                this.add(this.createWebMenuItem("Product Website...", "alt W", true));
                this.add(this.createHelpFileMenuItem("Product Help...", "alt H", true));
            } else {
                this.add(this.createRemoveMenuItem("Remove", "shortcut MINUS"));
                this.add(this.createRemoveAllMenuItem("Remove All", "alt A"));
                this.add(this.createWebMenuItem("Product Website...", "alt W", false));
                this.add(this.createHelpFileMenuItem("Product Help...", "alt H", false));
            }
        }

        private JMenuItem createAddAllMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new AddAllCampaignActionListener(), "selectall", '\u0000', accelerator, "Select All Source material to load", "Add16.gif", true);
        }

        private JMenuItem createAddMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new AddCampaignActionListener(), "select", '\u0000', accelerator, "Select Source material to load", "Add16.gif", true);
        }

        private JMenuItem createRemoveAllMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new RemoveAllCampaignActionListener(), "deselectall", '\u0000', accelerator, "Remove All Source material from loading", "Remove16.gif", true);
        }

        private JMenuItem createRemoveMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new RemoveCampaignActionListener(), "deselect", '\u0000', accelerator, "Remove Source material from loading", "Remove16.gif", true);
        }

        private JMenuItem createHelpFileMenuItem(String label, String accelerator, boolean fromAvail) {
            return Utility.createMenuItem(label, new HelpfileActionListener(fromAvail), "helpfile", '\u0000', accelerator, "Launch browser to product's helpfile", "Bookmarks16.gif", true);
        }

        private JMenuItem createWebMenuItem(String label, String accelerator, boolean fromAvail) {
            return Utility.createMenuItem(label, new WebActionListener(fromAvail), "website", '\u0000', accelerator, "Launch browser to product's website", "Bookmarks16.gif", true);
        }

        private class WebActionListener
        implements ActionListener {
            boolean available = true;

            WebActionListener(boolean fromAvail) {
                this.available = fromAvail;
            }

            public void actionPerformed(ActionEvent evt) {
                MainSource.this.launchProductWebsite(this.available, true);
            }
        }

        private class HelpfileActionListener
        implements ActionListener {
            boolean available = true;

            HelpfileActionListener(boolean fromAvail) {
                this.available = fromAvail;
            }

            public void actionPerformed(ActionEvent evt) {
                MainSource.this.launchProductWebsite(this.available, false);
            }
        }

        private class RemoveCampaignActionListener
        implements ActionListener {
            private RemoveCampaignActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                MainSource.this.doCampaign(false);
            }
        }

        private class RemoveAllCampaignActionListener
        implements ActionListener {
            private RemoveAllCampaignActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                MainSource.this.selectAll_actionPerformed(false);
            }
        }

        private class AddCampaignActionListener
        implements ActionListener {
            private AddCampaignActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                MainSource.this.doCampaign(true);
            }
        }

        private class AddAllCampaignActionListener
        implements ActionListener {
            private AddAllCampaignActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                MainSource.this.selectAll_actionPerformed(true);
            }
        }
    }

    private class CampaignPopupListener
    extends MouseAdapter {
        private CampaignPopupMenu menu;
        private JTree tree;

        CampaignPopupListener(JTreeTable treeTable, CampaignPopupMenu aMenu) {
            this.tree = treeTable.getTree();
            this.menu = aMenu;
            KeyListener myKeyListener = new KeyListener(this){
                private final /* synthetic */ CampaignPopupListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    CampaignPopupListener.access$2600(this.this$1).dispatchEvent(e);
                }

                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    if (keyCode != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                        for (int i = 0; i < CampaignPopupListener.access$2700(this.this$1).getComponentCount(); ++i) {
                            JMenuItem menuItem = (JMenuItem)CampaignPopupListener.access$2700(this.this$1).getComponent(i);
                            KeyStroke ks = menuItem.getAccelerator();
                            if (ks == null || !keyStroke.equals(ks)) continue;
                            MainSource.access$2802(CampaignPopupListener.access$2600(this.this$1), CampaignPopupListener.access$2900(this.this$1).getSelectionPath());
                            menuItem.doClick(2);
                            return;
                        }
                    }
                    CampaignPopupListener.access$2600(this.this$1).dispatchEvent(e);
                }

                public void keyReleased(KeyEvent e) {
                    CampaignPopupListener.access$2600(this.this$1).dispatchEvent(e);
                }
            };
            treeTable.addKeyListener(myKeyListener);
        }

        public void mousePressed(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        private void maybeShowPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                MainSource.this.selRow = this.tree.getRowForLocation(evt.getX(), evt.getY());
                if (MainSource.this.selRow == -1) {
                    return;
                }
                MainSource.this.selPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
                if (MainSource.this.selPath == null) {
                    return;
                }
                this.tree.setSelectionPath(MainSource.this.selPath);
                this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        static /* synthetic */ MainSource access$2600(CampaignPopupListener x0) {
            return x0.MainSource.this;
        }

        static /* synthetic */ CampaignPopupMenu access$2700(CampaignPopupListener x0) {
            return x0.menu;
        }

        static /* synthetic */ JTree access$2900(CampaignPopupListener x0) {
            return x0.tree;
        }
    }

    final class CampaignModel
    extends AbstractTreeTableModel {
        final String[] availNameList = new String[]{"Source Material"};
        final String[] selNameList = new String[]{"Source Material", "Loaded"};
        int modelType = 0;

        public CampaignModel(int mode, boolean available) {
            super(null);
            if (!available) {
                this.modelType = 1;
            }
            this.resetModel(mode, available, true);
        }

        public boolean isCellEditable(Object node, int column) {
            return column == 0;
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 1: {
                    return class$java$lang$String == null ? (class$java$lang$String = MainSource.class$("java.lang.String")) : class$java$lang$String;
                }
                case 0: {
                    return class$pcgen$gui$utils$TreeTableModel == null ? (class$pcgen$gui$utils$TreeTableModel = MainSource.class$("pcgen.gui.utils.TreeTableModel")) : class$pcgen$gui$utils$TreeTableModel;
                }
            }
            Logging.errorPrint("In MainSource.CampaignModel.getColumnClass the column " + column + " is not handled.");
            return class$java$lang$String == null ? (class$java$lang$String = MainSource.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            if (this.modelType == 0) {
                return this.availNameList.length;
            }
            return this.selNameList.length;
        }

        public String getColumnName(int column) {
            if (this.modelType == 0) {
                return this.availNameList[column];
            }
            return this.selNameList[column];
        }

        public void setRoot(PObjectNode aNode) {
            super.setRoot(aNode);
        }

        public final Object getRoot() {
            return (PObjectNode)super.getRoot();
        }

        public Object getValueAt(Object node, int column) {
            PObjectNode fn = (PObjectNode)node;
            Campaign aCamp = null;
            if (fn != null && fn.getItem() instanceof Campaign) {
                aCamp = (Campaign)fn.getItem();
            }
            switch (column) {
                case 0: {
                    if (fn != null) {
                        return fn.toString();
                    }
                    Logging.errorPrint("Somehow we have no active node when doing getValueAt in MainSource.");
                    return "";
                }
                case 1: {
                    if (aCamp == null) break;
                    if (aCamp.isLoaded()) {
                        return "Y";
                    }
                    return "N";
                }
                case -1: {
                    if (fn != null) {
                        return fn.getItem();
                    }
                    Logging.errorPrint("Somehow we have no active node when doing getValueAt in MainSource.");
                    return null;
                }
                default: {
                    Logging.errorPrint("In MainSource.CampaignModel.getValueAt the column " + column + " is not handled.");
                }
            }
            return null;
        }

        public void resetModel(int mode, boolean available, boolean newCall) {
            PObjectNode rootAsPObjectNode;
            List allowedModes = Globals.getAllowedGameModes();
            Iterator fI = available ? Globals.getCampaignList().iterator() : MainSource.this.selectedCampaigns.iterator();
            switch (mode) {
                case 3: {
                    this.setRoot((PObjectNode)typePubFmtSetRoot.clone());
                    while (fI.hasNext()) {
                        rootAsPObjectNode = (PObjectNode)super.getRoot();
                        Campaign aCamp = (Campaign)fI.next();
                        if (!this.shouldDisplayThis(aCamp) || !aCamp.isGameMode(allowedModes) || available && MainSource.this.selectedCampaigns.contains(aCamp)) continue;
                        boolean added = false;
                        for (int i = 0; i < rootAsPObjectNode.getChildCount(); ++i) {
                            ArrayList d;
                            if (!aCamp.isType(rootAsPObjectNode.getChild(i).getItem().toString()) && (added || i != rootAsPObjectNode.getChildCount() - 1)) continue;
                            if (aCamp.getMyTypeCount() < 2) {
                                d = new ArrayList(1);
                                d.add(rootAsPObjectNode.getChild(i));
                            } else {
                                d = rootAsPObjectNode.getChild(i).getChildren();
                            }
                            if (d != null && d.size() == 0) {
                                PObjectNode aFN = new PObjectNode(aCamp);
                                aFN.setIsValid(PrereqHandler.passesAll(aCamp.getPreReqList(), Globals.getCurrentPC(), aCamp));
                                rootAsPObjectNode.getChild(i).addChild(aFN);
                                added = true;
                            }
                            for (int j = 0; d != null && j < d.size(); ++j) {
                                ArrayList e;
                                if (!aCamp.isType(((PObjectNode)d.get(j)).getItem().toString()) && (added || j != d.size() - 1)) continue;
                                if (aCamp.getMyTypeCount() == 2) {
                                    e = new ArrayList(1);
                                    e.add(d.get(j));
                                } else if (aCamp.getMyTypeCount() < 2) {
                                    e = new ArrayList(1);
                                    e.add(rootAsPObjectNode.getChild(i));
                                } else {
                                    e = ((PObjectNode)d.get(j)).getChildren();
                                }
                                for (int k = 0; e != null && k < e.size(); ++k) {
                                    if (!aCamp.isType(((PObjectNode)e.get(k)).getItem().toString()) && (added || k != e.size() - 1)) continue;
                                    PObjectNode aFN = new PObjectNode(aCamp);
                                    aFN.setIsValid(PrereqHandler.passesAll(aCamp.getPreReqList(), Globals.getCurrentPC(), aCamp));
                                    ((PObjectNode)e.get(k)).addChild(aFN);
                                    added = true;
                                }
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    this.setRoot((PObjectNode)typePubSetRoot.clone());
                    while (fI.hasNext()) {
                        rootAsPObjectNode = (PObjectNode)super.getRoot();
                        Campaign aCamp = (Campaign)fI.next();
                        if (!this.shouldDisplayThis(aCamp) || !aCamp.isGameMode(allowedModes) || available && MainSource.this.selectedCampaigns.contains(aCamp)) continue;
                        boolean added = false;
                        for (int i = 0; i < rootAsPObjectNode.getChildCount(); ++i) {
                            ArrayList d;
                            if (!aCamp.isType(rootAsPObjectNode.getChild(i).getItem().toString()) && (added || i != rootAsPObjectNode.getChildCount() - 1)) continue;
                            if (aCamp.getMyTypeCount() < 3) {
                                d = new ArrayList(1);
                                d.add(rootAsPObjectNode.getChild(i));
                            } else {
                                d = rootAsPObjectNode.getChild(i).getChildren();
                            }
                            for (int k = 0; d != null && k < d.size(); ++k) {
                                if (((PObjectNode)d.get(k)).getItem() instanceof PObject || !aCamp.isType(((PObjectNode)d.get(k)).getItem().toString()) && (added || i != rootAsPObjectNode.getChildCount() - 1)) continue;
                                PObjectNode aFN = new PObjectNode(aCamp);
                                aFN.setIsValid(PrereqHandler.passesAll(aCamp.getPreReqList(), Globals.getCurrentPC(), aCamp));
                                ((PObjectNode)d.get(k)).addChild(aFN);
                                added = true;
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    this.setRoot((PObjectNode)typePubRoot.clone());
                    while (fI.hasNext()) {
                        rootAsPObjectNode = (PObjectNode)super.getRoot();
                        Campaign aCamp = (Campaign)fI.next();
                        if (!this.shouldDisplayThis(aCamp) || !aCamp.isGameMode(allowedModes) || available && MainSource.this.selectedCampaigns.contains(aCamp)) continue;
                        boolean added = false;
                        for (int i = 0; i < rootAsPObjectNode.getChildCount(); ++i) {
                            if (!aCamp.isType(rootAsPObjectNode.getChild(i).getItem().toString()) && (added || i != rootAsPObjectNode.getChildCount() - 1)) continue;
                            PObjectNode aFN = new PObjectNode();
                            aFN.setParent(rootAsPObjectNode.getChild(i));
                            aFN.setItem(aCamp);
                            aFN.setIsValid(PrereqHandler.passesAll(aCamp.getPreReqList(), Globals.getCurrentPC(), aCamp));
                            rootAsPObjectNode.getChild(i).addChild(aFN);
                            added = true;
                        }
                    }
                    break;
                }
                case 0: {
                    this.setRoot(new PObjectNode());
                    while (fI.hasNext()) {
                        rootAsPObjectNode = (PObjectNode)super.getRoot();
                        Campaign aCamp = (Campaign)fI.next();
                        if (!this.shouldDisplayThis(aCamp) || !aCamp.isGameMode(allowedModes) || available && MainSource.this.selectedCampaigns.contains(aCamp)) continue;
                        PObjectNode aFN = new PObjectNode();
                        aFN.setParent(rootAsPObjectNode);
                        aFN.setItem(aCamp);
                        aFN.setIsValid(PrereqHandler.passesAll(aCamp.getPreReqList(), Globals.getCurrentPC(), aCamp));
                        rootAsPObjectNode.addChild(aFN);
                    }
                    break;
                }
                default: {
                    Logging.errorPrint("In MainSource.CampaignlModel.resetModel the mode " + mode + " is not handled.");
                }
            }
            if ((rootAsPObjectNode = (PObjectNode)super.getRoot()).getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }

        private boolean shouldDisplayThis(Campaign aCamp) {
            if (aCamp.getName().length() == 0) {
                return false;
            }
            return this.modelType == 1 || MainSource.this.accept(Globals.getCurrentPC(), aCamp);
        }
    }
}

