/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.core.Globals;
import pcgen.core.Names;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.utils.Utility;

public final class NameGui
extends JFrame {
    static final long serialVersionUID = 8622642599843174001L;
    private JTextField generatedName;

    public NameGui() {
        super("Random Name Generator");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/pcgen/gui/resource/PcgenIcon.gif")));
        Utility.centerFrame(this, true);
        this.setDefaultCloseOperation(2);
        DefaultListModel<Object> listModel = new DefaultListModel<Object>();
        Object[] allNamesFiles = Names.findAllNamesFiles();
        Arrays.sort(allNamesFiles);
        for (int i = 0; i < allNamesFiles.length; ++i) {
            listModel.addElement(allNamesFiles[i]);
        }
        final JButton generateButton = new JButton("Generate Name");
        generateButton.setMnemonic('G');
        generateButton.setActionCommand("Roll");
        generateButton.addActionListener(new ReRollListener());
        this.generatedName = new JTextField(15);
        this.generatedName.setEditable(false);
        final JList list = new JList(listModel);
        list.setSelectionMode(0);
        list.setSelectedIndex(-1);
        list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (list.getSelectedIndex() == -1) {
                        NameGui.this.requestFocus();
                        generateButton.setEnabled(false);
                        NameGui.this.generatedName.setText("");
                    } else {
                        generateButton.setEnabled(true);
                        String name = list.getSelectedValue().toString();
                        System.out.println(name);
                        Names.getInstance().init(name, Globals.getCurrentPC());
                        NameGui.this.generatedName.setText(Names.getInstance().getRandomName());
                    }
                }
            }
        });
        JScrollPane listScrollPane = new JScrollPane(list);
        JButton acceptButton = new JButton("Accept");
        acceptButton.setMnemonic('A');
        acceptButton.setActionCommand("Accept");
        acceptButton.addActionListener(new AcceptListener());
        JLabel info = new JLabel("Select a ruleset for name creation");
        JLabel nameLabel = new JLabel("Name:");
        JPanel namePanel = new JPanel();
        Box nameBox = new Box(0);
        nameBox.add(nameLabel);
        nameBox.add(this.generatedName);
        namePanel.add(nameBox);
        Box generateButtonBox = new Box(0);
        generateButtonBox.add(Box.createHorizontalGlue());
        generateButtonBox.add(generateButton);
        generateButtonBox.add(Box.createHorizontalGlue());
        Box buttonAndNameBox = new Box(1);
        buttonAndNameBox.add(namePanel);
        buttonAndNameBox.add(generateButtonBox);
        JPanel namePlusButtonHolderPanel = new JPanel();
        namePlusButtonHolderPanel.setBorder(new EtchedBorder(1));
        namePlusButtonHolderPanel.add(buttonAndNameBox);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        contentPane.add((Component)info, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 5, 0), 0, 0));
        contentPane.add((Component)listScrollPane, new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 0), 0, 0));
        contentPane.add((Component)namePlusButtonHolderPanel, new GridBagConstraints(1, 1, 2, 1, 1.3, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        contentPane.add((Component)acceptButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 5, 5), 0, 0));
    }

    final class ReRollListener
    implements ActionListener {
        ReRollListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                NameGui.this.generatedName.setText(Names.getInstance().getRandomName());
            }
            catch (RuntimeException e1) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    final class AcceptListener
    implements ActionListener {
        AcceptListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String name = NameGui.this.generatedName.getText();
            if (name.equals("")) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (Globals.getCurrentPC() == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            Globals.getCurrentPC().setName(name);
            PCGen_Frame1.forceUpdate_PlayerTabs();
            PCGen_Frame1.getCurrentCharacterInfo().setTxtName(name);
            NameGui.this.dispose();
        }
    }
}

