/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import pcgen.core.SettingsHandler;
import pcgen.gui.MainSource;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.Logging;

final class PCCCreator
extends JFrame {
    static final long serialVersionUID = 923830359956243549L;
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private MainSource mSrc;
    private Map lstTypes = new HashMap();
    private SourceNode root;

    public PCCCreator(MainSource ms) {
        this.mSrc = ms;
        Toolkit kit = Toolkit.getDefaultToolkit();
        Image img = kit.getImage(this.getClass().getResource("/pcgen/gui/resource/PcgenIcon.gif"));
        this.setIconImage(img);
        this.buildTree();
        JButton writeBtn = new JButton("Write .pcc file");
        writeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PCCCreator.this.writePCCFile();
            }
        });
        this.mainPanel.add((Component)writeBtn, "South");
        this.getContentPane().add(this.mainPanel);
        this.setSize(400, 400);
        this.setDefaultCloseOperation(2);
        this.setTitle("Select Sources to include");
        this.setVisible(true);
    }

    private boolean buildSubTree(SourceNode parent, File f) {
        boolean addedChildren = false;
        File[] children = f.listFiles();
        for (int i = 0; i < children.length; ++i) {
            SourceNode n = new SourceNode(children[i]);
            boolean addThis = false;
            if (children[i].isDirectory()) {
                addThis = this.buildSubTree(n, children[i]) || addThis;
            } else if (children[i].getName().toLowerCase().endsWith(".lst")) {
                addThis = true;
            } else if (children[i].getName().toLowerCase().endsWith(".pcc")) {
                this.extractLSTTypes(children[i]);
            }
            if (addThis) {
                parent.add(n);
            }
            addedChildren |= addThis;
        }
        return addedChildren;
    }

    private void buildTree() {
        this.root = new SourceNode(SettingsHandler.getPccFilesLocation());
        this.root.nodeName = "All Source Materials";
        this.buildSubTree(this.root, this.root.nodeFile);
        DefaultTreeModel dtm = new DefaultTreeModel(this.root);
        JTree t = new JTree(dtm);
        t.setShowsRootHandles(true);
        t.setEditable(true);
        t.setSelectionModel(null);
        t.setRowHeight(-1);
        t.setCellRenderer(new SourceNodeTreeCellEditorAndRenderer());
        t.setCellEditor(new SourceNodeTreeCellEditorAndRenderer());
        JScrollPane s = new JScrollPane(t);
        s.setPreferredSize(new Dimension(400, 800));
        this.mainPanel.add((Component)s, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractLSTTypes(File f) {
        in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
                block12: while (true) {
                    if ((line = in.readLine()) == null) {
                        var9_11 = null;
                        if (in == null) return;
                        break;
                    }
                    start = line.indexOf(":");
                    if (line.startsWith("LSTEXCLUDE") || line.startsWith("PCC") || line.startsWith("CAMPAIGN") || line.startsWith("GAME") || line.startsWith("RANK") || line.startsWith("SOURCE") || line.startsWith("#") || start < 0) continue;
                    lstType = line.substring(0, start);
                    while (true) {
                        if (start != 0 && start < line.length()) ** break;
                        continue block12;
                        end = line.indexOf("|", start);
                        lstName = end == -1 ? line.substring(start + 1) : line.substring(start + 1, end);
                        lstName = new File(lstName).getName();
                        this.lstTypes.put(lstName, lstType);
                        start = end + 1;
                    }
                    break;
                }
            }
            catch (FileNotFoundException e) {
                Logging.errorPrint("Could not find pcc file " + f.toString(), e);
                var9_12 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException e) {
                    Logging.errorPrint("Failed to close pcc file reader in PCCCreator.extractLSTTypes", e);
                    return;
                }
            }
            catch (UnsupportedEncodingException e) {
                Logging.errorPrint("The pcc file's encoding is not supported.", e);
                var9_13 = null;
                if (in == null) return;
                try {}
                catch (IOException e) {
                    Logging.errorPrint("Failed to close pcc file reader in PCCCreator.extractLSTTypes", e);
                    return;
                }
                in.close();
                return;
            }
            catch (IOException e) {
                Logging.errorPrint("Excepti", e);
                var9_14 = null;
                if (in == null) return;
                try {}
                catch (IOException e) {
                    Logging.errorPrint("Failed to close pcc file reader in PCCCreator.extractLSTTypes", e);
                    return;
                }
                in.close();
                return;
            }
        }
        catch (Throwable var8_21) {
            var9_15 = null;
            if (in == null) throw var8_21;
            ** try [egrp 2[TRYBLOCK] [11 : 293->300)] { 
lbl62:
            // 1 sources

            in.close();
            throw var8_21;
lbl64:
            // 1 sources

            catch (IOException e) {
                Logging.errorPrint("Failed to close pcc file reader in PCCCreator.extractLSTTypes", e);
            }
            throw var8_21;
        }
        ** try [egrp 2[TRYBLOCK] [11 : 293->300)] { 
lbl69:
        // 1 sources

        in.close();
        return;
lbl71:
        // 1 sources

        catch (IOException e) {
            Logging.errorPrint("Failed to close pcc file reader in PCCCreator.extractLSTTypes", e);
        }
    }

    private void recurseNodes(PrintStream pr, SourceNode n, boolean force) {
        if (!force && n.getSelectedState() == 0) {
            return;
        }
        Enumeration<TreeNode> e = n.children();
        while (e.hasMoreElements()) {
            SourceNode sNode = (SourceNode)e.nextElement();
            if (sNode.isLeaf()) {
                String type = (String)this.lstTypes.get(sNode.nodeName);
                String absPath = sNode.nodeFile.getPath();
                String relPath = absPath.substring(absPath.indexOf(File.separator + "data" + File.separator) + 6);
                if (type == null) {
                    type = "# *** UNKNOWN TYPE, FIX ME ***";
                }
                if (!force && sNode.getSelectedState() != 1) continue;
                pr.println(type + ":" + relPath);
                continue;
            }
            this.recurseNodes(pr, sNode, force || sNode.getSelectedState() == 1);
        }
    }

    private void writePCCFile() {
        String name = JOptionPane.showInputDialog(this, (Object)"Enter PCC filename");
        if (name == null) {
            return;
        }
        if (!name.endsWith(".pcc")) {
            name = name + ".pcc";
        }
        try {
            FileOutputStream fout = new FileOutputStream(new File(this.root.nodeFile, name));
            PrintStream pr = new PrintStream(fout);
            pr.println("CAMPAIGN: Custom Source Materials (" + name + ")");
            this.recurseNodes(pr, this.root, this.root.getSelectedState() == 1);
            fout.close();
        }
        catch (IOException e) {
            Logging.errorPrint("", e);
        }
        this.mSrc.refreshCampaigns();
    }

    static final class SourceNodeTreeCellEditorAndRenderer
    extends DefaultCellEditor
    implements TreeCellRenderer,
    TreeCellEditor {
        public SourceNodeTreeCellEditorAndRenderer() {
            super(new JComboBoxEx());
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            SourceNode sNode = (SourceNode)value;
            return sNode.getPanel();
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            SourceNode sNode = (SourceNode)value;
            return sNode.getPanel();
        }
    }

    static final class SourceNode
    extends DefaultMutableTreeNode {
        public static final int NONE = 0;
        public static final int ALL = 1;
        public static final int MIXED = 2;
        public File nodeFile;
        public JLabel label;
        public JPanel panel;
        public String nodeName;
        JComboBoxEx combo;

        public SourceNode(File f) {
            super(f);
            this.nodeFile = f;
            this.nodeName = f.getName();
        }

        public JPanel getPanel() {
            if (this.panel == null) {
                this.panel = new JPanel();
                this.label = new JLabel(this.nodeName);
                this.combo = new JComboBoxEx(this){
                    private final /* synthetic */ SourceNode this$0;
                    {
                        this.this$0 = this$0;
                    }

                    protected void fireItemStateChanged(ItemEvent e) {
                        super.fireItemStateChanged(e);
                    }
                };
                if (this.nodeFile.isDirectory()) {
                    this.combo.addItem("INCLUDE NONE");
                    this.combo.addItem("INCLUDE ALL");
                    this.combo.addItem("MIXED");
                    if (this.isRoot()) {
                        this.combo.setSelectedIndex(2);
                    } else {
                        this.combo.setSelectedIndex(0);
                    }
                } else {
                    this.combo.addItem("EXCLUDE");
                    this.combo.addItem("INCLUDE");
                    this.combo.setSelectedIndex(1);
                }
                this.panel.setOpaque(false);
                this.panel.add(this.combo);
                this.panel.add(this.label);
            }
            if (this.isRelevant()) {
                this.combo.setEnabled(true);
                this.label.setForeground(this.getSelectedState() == 2 ? Color.black : (this.getSelectedState() == 1 ? Color.green : Color.red));
            } else {
                this.combo.setEnabled(false);
                this.label.setForeground(Color.gray);
            }
            return this.panel;
        }

        public boolean isRelevant() {
            TreeNode t = this.getParent();
            if (t == null) {
                return true;
            }
            if (((SourceNode)t).isRelevant()) {
                return ((SourceNode)t).getSelectedState() == 2;
            }
            return false;
        }

        public int getSelectedState() {
            if (this.combo != null) {
                return this.combo.getSelectedIndex();
            }
            if (this.isLeaf()) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return this.nodeName;
        }
    }
}

