/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import gmgen.GMGenSystem;
import gmgen.plugin.InitHolder;
import gmgen.plugin.InitHolderList;
import gmgen.plugin.PcgCombatant;
import gmgen.pluginmgr.GMBComponent;
import gmgen.pluginmgr.GMBMessage;
import gmgen.pluginmgr.GMBus;
import gmgen.pluginmgr.PluginLoader;
import gmgen.pluginmgr.messages.FetchOpenPCGRequestMessage;
import gmgen.pluginmgr.messages.InitHolderListSendMessage;
import gmgen.pluginmgr.messages.OpenPCGRequestMessage;
import gmgen.pluginmgr.messages.PCClosedMessage;
import gmgen.pluginmgr.messages.PCLoadedMessage;
import gmgen.pluginmgr.messages.SavePCGNotificationMessage;
import gmgen.pluginmgr.messages.StateChangedMessage;
import gmgen.pluginmgr.messages.TabAddMessage;
import gmgen.pluginmgr.messages.WindowClosedMessage;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.EmptyStackException;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import pcgen.core.CustomData;
import pcgen.core.Equipment;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.character.Follower;
import pcgen.core.party.Party;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.ExportPDFPopup;
import pcgen.gui.ExportPopup;
import pcgen.gui.FrameActionListener;
import pcgen.gui.KitSelector;
import pcgen.gui.LstConverter;
import pcgen.gui.LstEditorMain;
import pcgen.gui.MainAbout;
import pcgen.gui.MainDebug;
import pcgen.gui.MainPopupMenu;
import pcgen.gui.MainPrint;
import pcgen.gui.MainSource;
import pcgen.gui.Options;
import pcgen.gui.PCGenPopup;
import pcgen.gui.PCGenProp;
import pcgen.gui.PCPopupMenu;
import pcgen.gui.PToolBar;
import pcgen.gui.PcgFilter;
import pcgen.gui.PcpFilter;
import pcgen.gui.PreferencesDialog;
import pcgen.gui.UIFactory;
import pcgen.gui.filter.FilterDialogFactory;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.filter.Filterable;
import pcgen.gui.pcGenGUI;
import pcgen.gui.utils.BrowserLauncher;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JOpenRecentMenu;
import pcgen.gui.utils.LinkableHtmlMessage;
import pcgen.gui.utils.Utility;
import pcgen.io.PCGIOHandler;
import pcgen.util.FOPResourceChecker;
import pcgen.util.JEPResourceChecker;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class PCGen_Frame1
extends JFrame
implements GMBComponent,
Observer {
    static final long serialVersionUID = 1042236188732008819L;
    public static int FIRST_CHAR_TAB = 1;
    private static PCGen_Frame1 inst;
    private static WaitCursorEventQueue waitQueue;
    private static boolean usingWaitCursor;
    private static CharacterInfo characterPane;
    private static LstConverter lstConverter;
    private static JLabel statusBar;
    private static JTabbedPane baseTabbedPane;
    FrameActionListener frameActionListener;
    private final PcgFilter filter = new PcgFilter();
    private final PcpFilter partyFilter = new PcpFilter();
    private BorderLayout borderLayout1 = new BorderLayout();
    private BorderLayout borderLayout2 = new BorderLayout();
    private FlowLayout flowLayout1 = new FlowLayout();
    private FlowLayout flowLayout2 = new FlowLayout();
    private JPanel panelMain = new JPanel();
    private JPanel panelSouth = new JPanel();
    private JPanel panelSouthCenter = new JPanel();
    private JPanel panelSouthEast = new JPanel();
    private KitSelector kitSelector = null;
    private MainPopupMenu mainPopupMenu;
    private LinkedList tempTabList = new LinkedList();
    private MainSource mainSource = new MainSource();
    private MenuItems pcgenMenuBar;
    private PCPopupMenu pcPopupMenu;
    private PToolBar toolBar;
    private PopupListener popupListener;
    private String partyFileName = "";
    private int newPCNameCount = 0;
    private pcGenGUI mainClass;

    public PCGen_Frame1() {
        inst = this;
        Globals.setRootFrame(this);
        this.enableEvents(64L);
        this.setDefaultCloseOperation(0);
        this.frameActionListener = new FrameActionListener(this);
        this.mainPopupMenu = new MainPopupMenu(this.frameActionListener);
        this.pcPopupMenu = new PCPopupMenu(this.frameActionListener);
        this.popupListener = new PopupListener(baseTabbedPane, this.mainPopupMenu, this.pcPopupMenu);
        this.toolBar = PToolBar.createToolBar(this);
        this.pcgenMenuBar = new MenuItems();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Logging.errorPrint("jbInit", e);
        }
        GMBus.addToBus(this);
        GMBus.addToBus(PreferencesDialog.getPreferencesComponent());
        PluginLoader ploader = PluginLoader.inst();
        ploader.startSystemPlugins("PCGen");
    }

    public static JTabbedPane getBaseTabbedPane() {
        return baseTabbedPane;
    }

    public static CharacterInfo getCharacterPane() {
        return characterPane;
    }

    public static CharacterInfo getCurrentCharacterInfo() {
        int index = PCGen_Frame1.getBaseTabbedPane().getSelectedIndex();
        if (index >= FIRST_CHAR_TAB) {
            return characterPane;
        }
        return null;
    }

    public static Filterable getCurrentFilterable() {
        int index = PCGen_Frame1.getBaseTabbedPane().getSelectedIndex();
        if (index == 0) {
            return (Filterable)((Object)PCGen_Frame1.getBaseTabbedPane().getComponentAt(index));
        }
        if (index >= FIRST_CHAR_TAB) {
            return characterPane.getSelectedFilterable();
        }
        return null;
    }

    public static PCGen_Frame1 getInst() {
        return inst;
    }

    public void setMainClass(pcGenGUI owner) {
        this.mainClass = owner;
    }

    public MainSource getMainSource() {
        return this.mainSource;
    }

    public static JLabel getStatusBar() {
        return statusBar;
    }

    public void setGameModeTitle() {
        GameMode gameMode = SettingsHandler.getGame();
        String modeName = gameMode == null ? "???" : gameMode.getName();
        this.setTitle("PCGen v. " + PCGenProp.getVersionNumber() + " - " + modeName + " Campaign");
    }

    public static void enableDisableMenuItems() {
        if (!Globals.getUseGUI()) {
            return;
        }
        PCGen_Frame1 frame = PCGen_Frame1.getInst();
        frame.enableNew(true);
        frame.enableOpen(false);
        frame.enableClose(false);
        frame.enableCloseAll(false);
        frame.enableSave(false);
        frame.enableSaveAs(false);
        frame.enableSaveAll(false);
        frame.enableRevertToSaved(false);
        frame.enableSave(false);
        frame.enablePrintPreview(false);
        frame.enablePrint(false);
        frame.enablePartySave(false);
        frame.enablePartySaveAs(false);
        frame.enableExport(false);
        frame.enableKit(false);
        frame.enableLstEditors(false);
        if (!Globals.displayListsHappy()) {
            if (SettingsHandler.isExpertGUI()) {
                frame.enableNew(false);
            }
            if (SettingsHandler.isLoadCampaignsWithPC()) {
                frame.enableOpen(true);
            }
            return;
        }
        frame.enableOpen(true);
        frame.enableLstEditors(true);
        PlayerCharacter aPC = frame.getCurrentPC();
        if (aPC == null) {
            return;
        }
        frame.enableClose(true);
        frame.enableSaveAs(true);
        frame.enablePrintPreview(true);
        frame.enablePrint(true);
        frame.enablePartySave(true);
        frame.enablePartySaveAs(true);
        frame.enableExport(true);
        frame.enableKit(true);
        List allPCs = Globals.getPCList();
        int pcCount = allPCs.size();
        if (pcCount > 1) {
            frame.enableCloseAll(true);
        }
        for (int i = 0; i < pcCount; ++i) {
            if (!((PlayerCharacter)allPCs.get(i)).isDirty()) continue;
            frame.enableSaveAll(true);
            break;
        }
        if (!aPC.isDirty()) {
            return;
        }
        frame.enableSave(true);
        if (!aPC.wasEverSaved()) {
            return;
        }
        frame.enableRevertToSaved(true);
    }

    public void setOpenRecentPCs(String[] strings) {
        this.pcgenMenuBar.openRecentPCMenu.setEntriesAsStrings(strings);
    }

    public String[] getOpenRecentPCs() {
        return this.pcgenMenuBar.openRecentPCMenu.getEntriesAsStrings();
    }

    public void setOpenRecentParties(String[] strings) {
        this.pcgenMenuBar.openRecentPartyMenu.setEntriesAsStrings(strings);
    }

    public String[] getOpenRecentParties() {
        return this.pcgenMenuBar.openRecentPartyMenu.getEntriesAsStrings();
    }

    public static PCGen_Frame1 getRealParentFrame(JPanel child) {
        PCGen_Frame1 parent = (PCGen_Frame1)child.getTopLevelAncestor();
        return parent;
    }

    public static void addMonsterHD(int direction) {
        if (characterPane != null) {
            characterPane.infoSummary().addMonsterHD(direction);
        }
    }

    public void closeAllPCs() {
        int tabCount = baseTabbedPane.getTabCount();
        while (tabCount > FIRST_CHAR_TAB) {
            if (this.closePCTabAt(tabCount - 1, true)) {
                tabCount = baseTabbedPane.getTabCount();
                continue;
            }
            return;
        }
        this.enableClose(false);
        this.enableCloseAll(false);
        this.enableSave(false);
        this.enableSaveAs(false);
        this.enableRevertToSaved(false);
        this.enablePartySave(false);
        this.enablePartySaveAs(false);
        this.enablePartyClose(false);
        this.enablePrintPreview(false);
        this.enablePrint(false);
        this.enableExport(false);
        this.enableKit(false);
        this.newPCNameCount = 0;
    }

    public void enableLstEditors(boolean itemState) {
        this.pcgenMenuBar.listEditor.setEnabled(itemState);
    }

    public void enableNew(boolean itemState) {
        this.pcgenMenuBar.newItem.setEnabled(itemState);
        this.toolBar.newItem.setEnabled(itemState);
        this.mainPopupMenu.newItem.setEnabled(itemState);
        this.pcPopupMenu.getNewItem().setEnabled(itemState);
    }

    public void enableOpen(boolean itemState) {
        this.pcgenMenuBar.openItem.setEnabled(itemState);
        this.toolBar.openItem.setEnabled(itemState);
    }

    public void eqList_Changed(Equipment newEq, boolean purchase) {
        if (characterPane != null) {
            characterPane.infoInventory().getInfoGear().refreshAvailableList(newEq, purchase, true);
        }
    }

    public void exportToPDFItem_actionPerformed() {
        if (!this.pcgenMenuBar.enablePDF) {
            this.warnAboutMissingResource();
            return;
        }
        if (this.pcgenMenuBar.exportPDFPopup == null) {
            this.pcgenMenuBar.exportPDFPopup = new ExportPDFPopup(baseTabbedPane);
        }
        this.pcgenMenuBar.exportPDFPopup.setCurrentPCSelectionByTab();
    }

    public void exportToStandardItem_actionPerformed() {
        if (this.pcgenMenuBar.exportPopup == null) {
            this.pcgenMenuBar.exportPopup = new ExportPopup(baseTabbedPane);
        }
        this.pcgenMenuBar.exportPopup.setCurrentPCSelectionByTab();
    }

    public boolean loadPCFromFile(File file) {
        Party party = Party.makeSingleCharacterParty(file);
        if (this.mainClass == null || !party.load(null)) {
            ShowMessageDelegate.showMessageDialog("Unrecoverable problems occurred while loading the character.", "Error", MessageType.ERROR);
            Logging.errorPrint("Error in loadPCFromFile");
            return false;
        }
        PlayerCharacter aPC = Globals.getCurrentPC();
        this.addPCTab(aPC);
        this.pcgenMenuBar.openRecentPCMenu.add(aPC.getDisplayName(), file);
        if (aPC.getLoadCompanion() && !aPC.getFollowerList().isEmpty()) {
            Iterator aF = aPC.getFollowerList().iterator();
            while (aF.hasNext()) {
                Follower nPC = (Follower)aF.next();
                boolean aLoaded = false;
                Iterator p = Globals.getPCList().iterator();
                while (p.hasNext()) {
                    PlayerCharacter testPC = (PlayerCharacter)p.next();
                    if (!nPC.getFileName().equals(testPC.getFileName())) continue;
                    aLoaded = true;
                }
                if (aLoaded) continue;
                File aFile = new File(nPC.getFileName());
                Party followerParty = Party.makeSingleCharacterParty(aFile);
                if (this.mainClass != null && followerParty.load(null)) {
                    aPC = Globals.getCurrentPC();
                    this.addPCTab(aPC);
                    continue;
                }
                ShowMessageDelegate.showMessageDialog("Unrecoverable problems occurred while loading a companion or follower.", "Error", MessageType.ERROR);
            }
        }
        GMBus.send(new PCLoadedMessage(this, aPC));
        return true;
    }

    public static void restoreFilterSettings(String filterableName) {
        if (characterPane != null) {
            characterPane.restoreFilterSettings(filterableName);
        } else {
            FilterFactory.clearFilterCache();
        }
    }

    public void featList_Changed() {
        if (characterPane != null) {
            characterPane.setPaneForUpdate(characterPane.infoFeats());
            characterPane.refresh();
        }
    }

    public static void forceUpdate_PlayerTabs() {
        boolean tips = SettingsHandler.isToolTipTextShown();
        int x = baseTabbedPane.getTabCount();
        for (int i = FIRST_CHAR_TAB; i < x; ++i) {
            PlayerCharacter aPC = PCGen_Frame1.getPCForTabAt(i);
            PCGen_Frame1.setTabName(i, aPC.getDisplayName());
            baseTabbedPane.setToolTipTextAt(i, tips ? aPC.getFullDisplayName() : null);
        }
    }

    public void hpTotal_Changed() {
        if (characterPane != null) {
            characterPane.setPaneForUpdate(characterPane.infoClasses());
            characterPane.setPaneForUpdate(characterPane.infoSummary());
            characterPane.refresh();
        }
    }

    public void revertToSavedItem_actionPerformed(ActionEvent e) {
        PlayerCharacter aPC = this.getCurrentPC();
        if (aPC == null) {
            return;
        }
        if (!aPC.isDirty()) {
            return;
        }
        int reallyClose = JOptionPane.showConfirmDialog(this, aPC.getDisplayName() + " changed.\t Discard changes?", "Revert " + aPC.getDisplayName() + "?", 0);
        if (reallyClose != 0) {
            return;
        }
        String oldStatus = statusBar.getText();
        statusBar.setText("Reverting character to saved...");
        statusBar.revalidate();
        this.pcgenMenuBar.revertToSavedItem.requestFocus();
        String fileName = aPC.getFileName();
        if (fileName.equals("")) {
            statusBar.setText(oldStatus);
            return;
        }
        this.closeItem_actionPerformed(e);
        File pcFile = new File(fileName);
        if (pcFile.exists()) {
            this.loadPCFromFile(pcFile);
        }
        statusBar.setText(oldStatus);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean savePC(PlayerCharacter aPC, boolean saveas) {
        File file;
        File prevFile;
        boolean newPC = false;
        String aPCFileName = aPC.getFileName();
        GMBus.send(new SavePCGNotificationMessage(this, aPC));
        if (aPCFileName.equals("")) {
            prevFile = new File(SettingsHandler.getPcgPath(), aPC.getDisplayName() + ".pcg");
            aPCFileName = prevFile.getAbsolutePath();
            newPC = true;
        } else {
            prevFile = new File(aPCFileName);
        }
        if (saveas || newPC) {
            int reallyClose;
            JFileChooser fc = new JFileChooser();
            fc.setFileFilter(this.filter);
            fc.setSelectedFile(prevFile);
            FilenameChangeListener listener = new FilenameChangeListener(aPCFileName, fc);
            fc.addPropertyChangeListener(listener);
            int returnVal = fc.showSaveDialog(this);
            fc.removePropertyChangeListener(listener);
            if (returnVal != 0) return false;
            file = fc.getSelectedFile();
            if (!file.getName().endsWith(".pcg")) {
                file = new File(file.getParent(), file.getName() + ".pcg");
            }
            if (file.isDirectory()) {
                ShowMessageDelegate.showMessageDialog("You cannot overwrite a directory with a character.", "PCGen", MessageType.ERROR);
                return false;
            }
            if (file.exists() && (newPC || prevFile == null || !file.getName().equals(prevFile.getName())) && (reallyClose = JOptionPane.showConfirmDialog(this, "The file " + file.getName() + " already exists, are you sure you want to overwrite it?", "Confirm overwriting " + file.getName(), 0)) != 0) {
                return false;
            }
            aPC.setFileName(file.getAbsolutePath());
        } else {
            file = prevFile;
        }
        try {
            new PCGIOHandler().write(aPC, file.getAbsolutePath());
            SettingsHandler.setPcgPath(file.getParentFile());
        }
        catch (Exception ex) {
            ShowMessageDelegate.showMessageDialog("Could not save " + aPC.getDisplayName(), "PCGen", MessageType.ERROR);
            Logging.errorPrint("Could not save " + aPC.getDisplayName(), ex);
            return false;
        }
        this.pcgenMenuBar.openRecentPCMenu.add(aPC.getDisplayName(), file);
        return true;
    }

    public static void useWaitCursor(boolean b) {
        if (b) {
            if (!usingWaitCursor) {
                usingWaitCursor = true;
                Toolkit.getDefaultToolkit().getSystemEventQueue().push(waitQueue);
            }
        } else if (usingWaitCursor) {
            try {
                waitQueue.doPop();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
            usingWaitCursor = false;
        }
    }

    public void setPcgenMenuBar(MenuItems pcgenMenuBar) {
        this.pcgenMenuBar = pcgenMenuBar;
    }

    public MenuItems getPcgenMenuBar() {
        return this.pcgenMenuBar;
    }

    public void handleMessage(GMBMessage message) {
        if (message instanceof OpenPCGRequestMessage) {
            this.handleOpenPCGRequestMessage((OpenPCGRequestMessage)message);
        } else if (message instanceof FetchOpenPCGRequestMessage) {
            this.handleFetchOpenPCGRequestMessage((FetchOpenPCGRequestMessage)message);
        } else if (message instanceof InitHolderListSendMessage) {
            this.handleInitHolderListSendMessage((InitHolderListSendMessage)message);
        } else if (message instanceof StateChangedMessage) {
            this.handleStateChangedMessage((StateChangedMessage)message);
        } else if (message instanceof TabAddMessage) {
            this.handleTabAddMessage((TabAddMessage)message);
        }
    }

    public void stateUpdate(EventObject e) {
        GMBus.send(new StateChangedMessage(this, null));
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.handleQuit();
        }
    }

    void addKit_actionPerformed() {
        this.toolBar.addKit.requestFocus();
        this.pcgenMenuBar.addKit.requestFocus();
        PlayerCharacter aPC = this.getCurrentPC();
        if (aPC == null) {
            return;
        }
        int currTab = baseTabbedPane.getSelectedIndex();
        if (currTab >= FIRST_CHAR_TAB) {
            String kitFilter = PCGen_Frame1.getCharacterPane().getKitFilter();
            if (this.kitSelector == null) {
                this.kitSelector = new KitSelector(aPC);
            }
            this.kitSelector.setVisible(true);
            this.kitSelector.setFilter(kitFilter);
        }
    }

    void closeAllItem_actionPerformed() {
        this.pcgenMenuBar.closeAllItem.requestFocus();
        this.closeAllPCs();
    }

    void closeItem_actionPerformed(ActionEvent e) {
        this.pcgenMenuBar.closeItem.requestFocus();
        int currTab = baseTabbedPane.getSelectedIndex();
        if (currTab >= FIRST_CHAR_TAB) {
            String command = e.getActionCommand();
            if (!this.closePCTabAt(currTab, command.equals("file.close"))) {
                return;
            }
            if (baseTabbedPane.getTabCount() <= FIRST_CHAR_TAB) {
                this.newPCNameCount = 0;
            }
        }
    }

    void closePopupItem_actionPerformed() {
        int index = this.popupListener.getTabIndex();
        this.closePCTabAt(index, true);
        baseTabbedPane.setSelectedIndex(index < baseTabbedPane.getTabCount() ? index : index - 1);
    }

    boolean loadPartyFromFile(File file) {
        Party party = Party.makePartyFromFile(file);
        if (this.mainClass == null || !party.load(this)) {
            ShowMessageDelegate.showMessageDialog("Problems occurred while loading the party.", "Error", MessageType.ERROR);
            Logging.errorPrint("PCGen_Frame1: Error in loadPartyFromFile");
            return false;
        }
        this.partyFileName = file.getAbsolutePath();
        String displayName = party.getDisplayName();
        this.pcgenMenuBar.openRecentPartyMenu.add(displayName, file);
        this.enablePartyClose(true);
        return true;
    }

    void newItem_actionPerformed() {
        this.toolBar.newItem.requestFocus();
        this.pcgenMenuBar.newItem.requestFocus();
        this.doNewItem();
    }

    void newPopupItem_actionPerformed() {
        this.doNewItem();
    }

    void openGMGen_actionPerformed() {
        if (GMGenSystem.inst == null) {
            new GMGenSystem();
        } else {
            GMGenSystem.inst.setVisible(true);
        }
    }

    void openItem_actionPerformed() {
        this.toolBar.openItem.requestFocus();
        this.pcgenMenuBar.openItem.requestFocus();
        String oldStatus = statusBar.getText();
        statusBar.setText("Opening character.  Please wait...");
        statusBar.revalidate();
        this.pcgenMenuBar.openItem.requestFocus();
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(SettingsHandler.getPcgPath());
        fc.setFileFilter(this.filter);
        fc.setMultiSelectionEnabled(true);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File[] pcFiles = fc.getSelectedFiles();
            for (int i = 0; i < pcFiles.length; ++i) {
                SettingsHandler.setPcgPath(pcFiles[i].getParentFile());
                fc.setMultiSelectionEnabled(false);
                this.loadPCFromFile(pcFiles[i]);
            }
            Globals.sortCampaigns();
        }
        statusBar.setText(oldStatus);
    }

    void partyCloseItem_actionPerformed() {
        String oldStatus = statusBar.getText();
        statusBar.setText("Closing party...");
        statusBar.revalidate();
        this.closeAllPCs();
        int tabCount = baseTabbedPane.getTabCount();
        if (tabCount == FIRST_CHAR_TAB) {
            this.pcgenMenuBar.partyCloseItem.requestFocus();
            this.enablePartyClose(false);
        }
        statusBar.setText(oldStatus);
    }

    void partyOpenItem_actionPerformed() {
        String oldStatus = statusBar.getText();
        statusBar.setText("Opening party...");
        statusBar.revalidate();
        this.pcgenMenuBar.partyOpenItem.requestFocus();
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(SettingsHandler.getPcgPath());
        fc.setFileFilter(this.partyFilter);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            SettingsHandler.setPcgPath(file.getParentFile());
            this.loadPartyFromFile(file);
        }
        statusBar.setText(oldStatus);
    }

    void partySaveAsItem_actionPerformed() {
        this.pcgenMenuBar.partySaveAsItem.requestFocus();
        this.saveAllPCs();
        this.partySaveItem(true);
    }

    void partySaveItem_actionPerformed() {
        this.pcgenMenuBar.partySaveItem.requestFocus();
        this.saveAllPCs();
        this.partySaveItem(false);
    }

    void preferencesItem_actionPerformed() {
        String oldStatus = statusBar.getText();
        statusBar.setText("Preferences...");
        statusBar.revalidate();
        PreferencesDialog.show(this);
        statusBar.setText(oldStatus);
    }

    void printItem_actionPerformed() {
        if (!this.pcgenMenuBar.enablePDF) {
            this.warnAboutMissingResource();
            return;
        }
        this.pcgenMenuBar.checkPrintFrame();
        this.pcgenMenuBar.printFrame.setCurrentPCSelectionByTab();
        this.pcgenMenuBar.printFrame.pack();
        this.pcgenMenuBar.printFrame.setVisible(true);
    }

    void printPreviewItem_actionPerformed() {
        Utility.previewInBrowser();
    }

    void saveAllItem_actionPerformed() {
        this.pcgenMenuBar.saveAllItem.requestFocus();
        this.saveAllPCs();
    }

    void saveAsItem_actionPerformed() {
        this.pcgenMenuBar.saveAsItem.requestFocus();
        PlayerCharacter aPC = this.getCurrentPC();
        if (aPC == null) {
            return;
        }
        this.savePC(aPC, true);
    }

    void saveAsPopupItem_actionPerformed() {
        this.savePC(PCGen_Frame1.getPCForTabAt(this.popupListener.getTabIndex()), true);
    }

    void saveItem_actionPerformed() {
        this.pcgenMenuBar.saveItem.requestFocus();
        PlayerCharacter aPC = this.getCurrentPC();
        if (aPC == null) {
            return;
        }
        this.savePC(aPC, false);
    }

    void savePopupItem_actionPerformed() {
        this.savePC(PCGen_Frame1.getPCForTabAt(this.popupListener.getTabIndex()), false);
    }

    void shiftLeftPopupItem_actionPerformed() {
        int index;
        this.moveTab(index, (index = this.popupListener.getTabIndex()) == FIRST_CHAR_TAB ? baseTabbedPane.getTabCount() - 1 : index - 1);
    }

    void shiftRightPopupItem_actionPerformed() {
        int index;
        this.moveTab(index, (index = this.popupListener.getTabIndex()) == baseTabbedPane.getTabCount() - 1 ? FIRST_CHAR_TAB : index + 1);
    }

    void updateByKludge() {
        KitSelector ks = this.kitSelector;
        this.kitSelector = null;
        int idx = baseTabbedPane.getSelectedIndex();
        baseTabbedPane.setSelectedIndex(0);
        baseTabbedPane.setSelectedIndex(idx);
        this.kitSelector = ks;
    }

    private static PlayerCharacter getPCForTabAt(int index) {
        int idx = index - FIRST_CHAR_TAB;
        if (idx >= 0 && idx < Globals.getPCList().size()) {
            return (PlayerCharacter)Globals.getPCList().get(idx);
        }
        return null;
    }

    private PlayerCharacter getCurrentPC() {
        int currTab = baseTabbedPane.getSelectedIndex();
        if (currTab < FIRST_CHAR_TAB) {
            return null;
        }
        return PCGen_Frame1.getPCForTabAt(currTab);
    }

    private static void setTabName(int index, String aName) {
        PCGen_Frame1.getBaseTabbedPane().setTitleAt(index, aName);
    }

    private boolean getUserChoice() {
        try {
            AskUserPopup dlg = new AskUserPopup(this, "Remove temporary files?", true);
            dlg.setVisible(true);
            return dlg.getDelete();
        }
        catch (Exception e) {
            Logging.errorPrint("Error in PCGen_Frame1::getUserChoice", e);
            return false;
        }
    }

    private void addPCTab(PlayerCharacter aPC) {
        aPC.addObserver(this);
        if (characterPane == null) {
            characterPane = new CharacterInfo(aPC, this.tempTabList);
        } else {
            this.resetCharacterTabs();
        }
        characterPane.resetToSummaryTab();
        baseTabbedPane.addTab(aPC.getDisplayName(), null, characterPane, SettingsHandler.isToolTipTextShown() ? aPC.getFullDisplayName() : null);
        baseTabbedPane.setSelectedIndex(baseTabbedPane.getTabCount() - 1);
    }

    private void baseTabbedPane_changePanel() {
        baseTabbedPane.requestFocus();
        PCGen_Frame1.enableDisableMenuItems();
        this.killKitSelector();
        int currentPanel = baseTabbedPane.getSelectedIndex();
        if (currentPanel < FIRST_CHAR_TAB) {
            PToolBar.displayHelpPanel(false);
        } else {
            Globals.setCurrentPC(this.getCurrentPC());
            characterPane.setPc(this.getCurrentPC());
            if (Globals.getPCList().size() > 1) {
                this.resetCharacterTabs();
            }
            baseTabbedPane.setComponentAt(currentPanel, characterPane);
            this.featList_Changed();
            JTabbedPane aPane = (JTabbedPane)characterPane.getComponent(0);
            int si = aPane.getSelectedIndex();
            if (si >= 0) {
                aPane.getComponent(si).requestFocus();
                ComponentEvent ce = new ComponentEvent(aPane.getComponent(si), 102);
                aPane.getComponent(si).dispatchEvent(ce);
            }
        }
        baseTabbedPane.requestFocus();
    }

    private void checkResources() {
        if (JEPResourceChecker.getMissingResourceCount() != 0) {
            new LinkableHtmlMessage((Frame)this, JEPResourceChecker.getMissingResourceMessage(), "PCGen").setVisible(true);
        }
    }

    private boolean closePCTabAt(int index, boolean isClosing) {
        boolean bSave = true;
        PlayerCharacter aPC = PCGen_Frame1.getPCForTabAt(index);
        Globals.setCurrentPC(aPC);
        if (aPC != null && aPC.isDirty()) {
            int reallyClose = 0;
            if (isClosing) {
                reallyClose = JOptionPane.showConfirmDialog(this, aPC.getDisplayName() + " changed.  Save changes before closing?", "Save " + aPC.getDisplayName() + " before closing?", 1);
            } else {
                bSave = false;
            }
            if (reallyClose == 2 || reallyClose == -1) {
                return false;
            }
            if (reallyClose == 1) {
                bSave = false;
            }
        } else {
            bSave = false;
        }
        characterPane.setPaneForUpdate(characterPane.infoSpells());
        characterPane.refresh();
        if (index >= FIRST_CHAR_TAB) {
            String fileName;
            characterPane.storeFilterSettings();
            if (bSave && !this.savePC(aPC, (fileName = aPC.getFileName()).equals(""))) {
                return false;
            }
        }
        GMBus.send(new PCClosedMessage(this, aPC));
        this.disposePCTabAt(index);
        return true;
    }

    private void disposePCTabAt(int index) {
        PlayerCharacter oldPC = PCGen_Frame1.getPCForTabAt(index);
        Globals.setCurrentPC(oldPC);
        int newIndex = index == baseTabbedPane.getTabCount() - 1 ? index - 1 : index;
        baseTabbedPane.removeTabAt(index);
        Globals.getPCList().remove(index - FIRST_CHAR_TAB);
        baseTabbedPane.setSelectedIndex(newIndex == FIRST_CHAR_TAB - 1 ? 0 : newIndex);
        if (index == newIndex) {
            this.baseTabbedPane_changePanel();
        }
        this.killKitSelector();
        PlayerCharacter aPC = PCGen_Frame1.getPCForTabAt(newIndex);
        Globals.setCurrentPC(aPC);
    }

    private void doNewItem() {
        if (!Globals.displayListsHappy()) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_newCharNoSources"), "PCGen", MessageType.ERROR);
            return;
        }
        PlayerCharacter aPC = new PlayerCharacter();
        Globals.getPCList().add(aPC);
        ++this.newPCNameCount;
        aPC.setName("New" + this.newPCNameCount);
        aPC.setDirty(true);
        this.addPCTab(aPC);
        GMBus.send(new PCLoadedMessage(this, aPC));
    }

    private void enableClose(boolean itemState) {
        this.pcgenMenuBar.closeItem.setEnabled(itemState);
        this.toolBar.closeItem.setEnabled(itemState);
        this.pcPopupMenu.getCloseItem().setEnabled(itemState);
    }

    private void enableCloseAll(boolean itemState) {
        this.pcgenMenuBar.closeAllItem.setEnabled(itemState);
    }

    private void enableExport(boolean itemState) {
        this.pcgenMenuBar.exportMenu.setEnabled(itemState);
    }

    private void enableKit(boolean itemState) {
        this.pcgenMenuBar.addKit.setEnabled(itemState);
        this.toolBar.addKit.setEnabled(itemState);
    }

    private void enablePartyClose(boolean itemState) {
        this.pcgenMenuBar.partyCloseItem.setEnabled(itemState);
    }

    private void enablePartySave(boolean itemState) {
        this.pcgenMenuBar.partySaveItem.setEnabled(itemState);
    }

    private void enablePartySaveAs(boolean itemState) {
        this.pcgenMenuBar.partySaveAsItem.setEnabled(itemState);
    }

    private void enablePrint(boolean itemState) {
        this.pcgenMenuBar.printItem.setEnabled(itemState);
        this.toolBar.printItem.setEnabled(itemState);
    }

    private void enablePrintPreview(boolean itemState) {
        this.pcgenMenuBar.printPreviewItem.setEnabled(itemState);
        this.toolBar.printPreviewItem.setEnabled(itemState);
    }

    private void enableRevertToSaved(boolean itemState) {
        this.pcgenMenuBar.revertToSavedItem.setEnabled(itemState);
        this.pcPopupMenu.getRevertToSavedItem().setEnabled(itemState);
    }

    private void enableSave(boolean itemState) {
        this.pcgenMenuBar.saveItem.setEnabled(itemState);
        this.toolBar.saveItem.setEnabled(itemState);
        this.pcPopupMenu.getSaveItem().setEnabled(itemState);
    }

    private void enableSaveAll(boolean itemState) {
        this.pcgenMenuBar.saveAllItem.setEnabled(itemState);
    }

    private void enableSaveAs(boolean itemState) {
        this.pcgenMenuBar.saveAsItem.setEnabled(itemState);
        this.pcPopupMenu.getSaveAsItem().setEnabled(itemState);
    }

    private void exitItem_actionPerformed() {
        this.pcgenMenuBar.exitItem.requestFocus();
        this.handleQuit();
    }

    private void handleInitHolderListSendMessage(InitHolderListSendMessage message) {
        InitHolderList list = message.getInitHolderList();
        for (int i = 0; i < list.size(); ++i) {
            InitHolder iH = (InitHolder)list.get(i);
            if (!(iH instanceof PcgCombatant)) continue;
            PcgCombatant pcg = (PcgCombatant)iH;
            PlayerCharacter aPC = pcg.getPC();
            Globals.getPCList().add(aPC);
            aPC.setDirty(true);
            this.addPCTab(aPC);
        }
    }

    private void handleOpenPCGRequestMessage(OpenPCGRequestMessage message) {
        File pcFile = message.getFile();
        if (pcFile.toString().endsWith(".pcg")) {
            this.loadPCFromFile(pcFile);
        } else if (pcFile.toString().endsWith(".pcp")) {
            this.loadPartyFromFile(pcFile);
        }
    }

    private void handleFetchOpenPCGRequestMessage(FetchOpenPCGRequestMessage message) {
        for (int i = 0; i < Globals.getPCList().size(); ++i) {
            GMBus.send(new PCLoadedMessage(this, (PlayerCharacter)Globals.getPCList().get(i)));
        }
    }

    private void handleQuit() {
        if (SettingsHandler.getLeftUpperCorner() == null) {
            SettingsHandler.setLeftUpperCorner(new Point(0, 0));
        }
        if (this.getState() != 1) {
            SettingsHandler.getLeftUpperCorner().setLocation(this.getLocationOnScreen().getX(), this.getLocationOnScreen().getY());
        }
        if ((this.getExtendedState() & 6) != 0) {
            SettingsHandler.setWindowState(6);
        } else if ((this.getExtendedState() & 2) != 0) {
            SettingsHandler.setWindowState(2);
        } else if ((this.getExtendedState() & 4) != 0) {
            SettingsHandler.setWindowState(4);
        } else {
            SettingsHandler.setWindowState(0);
        }
        int tabCount = baseTabbedPane.getTabCount();
        while (tabCount > FIRST_CHAR_TAB) {
            if (this.closePCTabAt(tabCount - 1, true)) {
                tabCount = baseTabbedPane.getTabCount();
                continue;
            }
            return;
        }
        GMBus.send(new WindowClosedMessage(this));
        SettingsHandler.storeFilterSettings(this.mainSource);
        if (SettingsHandler.getSaveCustomEquipment()) {
            CustomData.writeCustomItems();
        }
        this.removeTemporaryFiles();
        SettingsHandler.writeOptionsProperties(Globals.getCurrentPC());
        this.dispose();
        System.exit(0);
    }

    private void handleStateChangedMessage(StateChangedMessage message) {
        if (this.isFocused() && characterPane != null) {
            PlayerCharacter aPC = PCGen_Frame1.getPCForTabAt(baseTabbedPane.getSelectedIndex());
            Globals.setCurrentPC(aPC);
            characterPane.setPaneForUpdate(characterPane.infoAbilities());
            characterPane.setPaneForUpdate(characterPane.infoSummary());
            characterPane.setPaneForUpdate(characterPane.infoRace());
            characterPane.setPaneForUpdate(characterPane.infoClasses());
            characterPane.setPaneForUpdate(characterPane.infoDomain());
            characterPane.setPaneForUpdate(characterPane.infoFeats());
            characterPane.setPaneForUpdate(characterPane.infoSkills());
            characterPane.setPaneForUpdate(characterPane.infoSpells());
            characterPane.setPaneForUpdate(characterPane.infoInventory());
            characterPane.setPaneForUpdate(characterPane.infoDesc());
            characterPane.refresh();
            PCGen_Frame1.forceUpdate_PlayerTabs();
        }
    }

    private void handleTabAddMessage(TabAddMessage message) {
        if (message.getSystem().equals("PCGen")) {
            if (message.getPane() instanceof CharacterInfoTab) {
                if (characterPane == null) {
                    this.tempTabList.add(message.getPane());
                } else {
                    characterPane.addTab((CharacterInfoTab)((Object)message.getPane()));
                }
            } else {
                ++FIRST_CHAR_TAB;
                baseTabbedPane.addTab(message.getName(), message.getPane());
            }
        }
    }

    private void jbInit() throws Exception {
        IconUtilitities.maybeSetIcon(this, "PcgenIcon.gif");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panelMain, "Center");
        this.panelMain.setLayout(this.borderLayout1);
        this.setSize(new Dimension(700, 600));
        this.setGameModeTitle();
        this.setJMenuBar(this.pcgenMenuBar);
        this.panelMain.add((Component)this.toolBar, "North");
        this.showToolBar();
        statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        statusBar.setDoubleBuffered(true);
        statusBar.setMaximumSize(new Dimension(Short.MAX_VALUE, 17));
        statusBar.setMinimumSize(new Dimension(620, 17));
        statusBar.setOpaque(true);
        statusBar.setPreferredSize(new Dimension(620, 17));
        statusBar.setHorizontalTextPosition(2);
        statusBar.setText(" ");
        baseTabbedPane.setTabPlacement(SettingsHandler.getTabPlacement());
        baseTabbedPane.setDoubleBuffered(true);
        baseTabbedPane.setMinimumSize(new Dimension(620, 350));
        baseTabbedPane.setPreferredSize(new Dimension(620, 350));
        baseTabbedPane.addMouseListener(this.popupListener);
        this.panelSouth.setLayout(this.borderLayout2);
        this.panelSouthEast.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(2);
        this.panelSouthCenter.setLayout(this.flowLayout2);
        this.flowLayout2.setAlignment(0);
        this.panelMain.add((Component)baseTabbedPane, "Center");
        GameMode game = SettingsHandler.getGame();
        if (game != null && game.getTabShown(1)) {
            baseTabbedPane.addTab(game.getTabName(1), this.mainSource);
            baseTabbedPane.setToolTipTextAt(0, SettingsHandler.isToolTipTextShown() ? "Select and load source materials" : null);
        }
        this.getContentPane().add((Component)this.panelSouth, "South");
        this.panelSouth.add((Component)statusBar, "South");
        baseTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent c) {
                PCGen_Frame1.this.baseTabbedPane_changePanel();
            }
        });
        this.mainSource.addComponentListener(this.toolBar.getComponentListener());
        if (!UIFactory.isWindowsUI() || !System.getProperty("java.version").startsWith("1.4.0")) {
            this.addWindowFocusListener(new WindowFocusListener(){

                public void windowGainedFocus(WindowEvent e) {
                    PCGen_Frame1.this.stateUpdate(e);
                }

                public void windowLostFocus(WindowEvent e) {
                }
            });
        }
    }

    private void killKitSelector() {
        if (this.kitSelector != null) {
            if (this.kitSelector.isVisible()) {
                this.kitSelector.closeDialog();
            }
            this.kitSelector = null;
        }
    }

    private void moveTab(int oldIndex, int newIndex) {
        List pcList = Globals.getPCList();
        PlayerCharacter aPC = (PlayerCharacter)pcList.get(oldIndex - FIRST_CHAR_TAB);
        pcList.remove(oldIndex - FIRST_CHAR_TAB);
        pcList.add(newIndex - FIRST_CHAR_TAB, aPC);
        Globals.setPCList(pcList);
        PCGen_Frame1.forceUpdate_PlayerTabs();
        baseTabbedPane.setSelectedIndex(newIndex);
    }

    private void partySaveItem(boolean saveas) {
        File prevFile;
        boolean newParty = false;
        if (this.partyFileName.length() == 0) {
            prevFile = new File(SettingsHandler.getPcgPath(), "Party.pcp");
            this.partyFileName = prevFile.getAbsolutePath();
            newParty = true;
        } else {
            prevFile = new File(this.partyFileName);
        }
        File file = prevFile;
        if (saveas || newParty) {
            JFileChooser fc = new JFileChooser();
            fc.setFileFilter(this.partyFilter);
            fc.setSelectedFile(prevFile);
            FilenameChangeListener listener = new FilenameChangeListener(this.partyFileName, fc);
            fc.addPropertyChangeListener(listener);
            int returnVal = fc.showSaveDialog(this);
            fc.removePropertyChangeListener(listener);
            if (returnVal == 0) {
                int reallyClose;
                file = fc.getSelectedFile();
                if (!file.getName().endsWith(".pcp")) {
                    file = new File(file.getParent(), file.getName() + ".pcp");
                }
                if (file.isDirectory()) {
                    ShowMessageDelegate.showMessageDialog("You cannot overwrite a directory with a party.", "PCGen", MessageType.ERROR);
                    return;
                }
                if (file.exists() && (newParty || prevFile == null || !file.getName().equals(prevFile.getName())) && (reallyClose = JOptionPane.showConfirmDialog(this, "The file " + file.getName() + " already exists, are you sure you want to overwrite it?", "Confirm overwriting " + file.getName(), 0)) != 0) {
                    return;
                }
            } else {
                return;
            }
        }
        try {
            this.partyFileName = file.getAbsolutePath();
            Party party = Party.makePartyFromFile(file);
            party.addAllOpenCharacters();
            party.save();
            this.enablePartyClose(true);
        }
        catch (IOException ex) {
            ShowMessageDelegate.showMessageDialog("Could not save " + this.partyFileName, "PCGen", MessageType.ERROR);
            Logging.errorPrint("Could not save" + this.partyFileName, ex);
            return;
        }
        this.pcgenMenuBar.openRecentPartyMenu.add(this.partyFileName, file);
    }

    private void removeTemporaryFiles() {
        int cleanMode = SettingsHandler.getCleanupTempFiles();
        if (cleanMode < 0) {
            return;
        }
        String aDirectory = SettingsHandler.getTempPath() + File.separator;
        new File(aDirectory).list(new FilenameFilter(cleanMode){
            int myCleanMode;
            private final /* synthetic */ int val$cleanMode;
            {
                this.myCleanMode = this.val$cleanMode = val$cleanMode;
            }

            public boolean accept(File aFile, String aString) {
                try {
                    if (aString.startsWith("currentPC")) {
                        if (this.myCleanMode == 0) {
                            this.myCleanMode = !PCGen_Frame1.this.getUserChoice() ? -1 : 1;
                        }
                        if (this.myCleanMode > 0) {
                            File tf = new File(aFile, aString);
                            tf.delete();
                        }
                    }
                }
                catch (Exception e) {
                    Logging.errorPrint("removeTemporaryFiles", e);
                }
                return false;
            }
        });
    }

    private void resetCharacterTabs() {
        if (characterPane == null) {
            return;
        }
        for (int i = FIRST_CHAR_TAB; i < baseTabbedPane.getTabCount(); ++i) {
            baseTabbedPane.setComponentAt(i, new JPanel());
        }
    }

    private void saveAllPCs() {
        int x = Globals.getPCList().size();
        for (int i = 0; i < x; ++i) {
            PlayerCharacter aPC = (PlayerCharacter)Globals.getPCList().get(i);
            if (!aPC.isDirty()) continue;
            this.savePC(aPC, false);
        }
    }

    private void showToolBar() {
        this.toolBar.setVisible(SettingsHandler.isToolBarShown());
    }

    private void warnAboutMissingResource() {
        new LinkableHtmlMessage((Frame)this, FOPResourceChecker.getMissingResourceMessage(), "PCGen").setVisible(true);
    }

    public void update(Observable o, Object arg) {
        if (arg != null && "TabName".equals(arg.toString())) {
            PCGen_Frame1.forceUpdate_PlayerTabs();
        }
        PCGen_Frame1.enableDisableMenuItems();
    }

    static /* synthetic */ void access$600(PCGen_Frame1 x0) {
        x0.warnAboutMissingResource();
    }

    static /* synthetic */ void access$700(PCGen_Frame1 x0) {
        x0.exitItem_actionPerformed();
    }

    static /* synthetic */ LstConverter access$800() {
        return lstConverter;
    }

    static /* synthetic */ LstConverter access$802(LstConverter x0) {
        lstConverter = x0;
        return lstConverter;
    }

    static {
        waitQueue = new WaitCursorEventQueue(750);
        usingWaitCursor = false;
        characterPane = null;
        lstConverter = null;
        statusBar = new JLabel();
        baseTabbedPane = new JTabbedPane();
    }

    private static final class WaitCursorEventQueue
    extends EventQueue {
        private WaitCursorTimer waitTimer;
        private int delay;

        public WaitCursorEventQueue(int delay) {
            this.delay = delay;
            this.waitTimer = new WaitCursorTimer();
            this.waitTimer.setDaemon(true);
            this.waitTimer.start();
        }

        public void doPop() {
            this.pop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void dispatchEvent(AWTEvent event) {
            this.waitTimer.startTimer(event.getSource());
            try {
                super.dispatchEvent(event);
            }
            catch (Exception e) {
                e.getMessage();
                e.printStackTrace();
            }
            finally {
                this.waitTimer.stopTimer();
            }
        }

        private final class WaitCursorTimer
        extends Thread {
            private Component parent;
            private Object source;

            private WaitCursorTimer() {
            }

            public synchronized void run() {
                while (true) {
                    try {
                        while (true) {
                            MenuContainer mParent;
                            this.wait();
                            this.wait(WaitCursorEventQueue.this.delay);
                            if (this.source instanceof Component) {
                                this.parent = SwingUtilities.getRoot((Component)this.source);
                            } else if (this.source instanceof MenuComponent && (mParent = ((MenuComponent)this.source).getParent()) instanceof Component) {
                                this.parent = SwingUtilities.getRoot((Component)mParent);
                            }
                            if (this.parent == null || !this.parent.isShowing()) continue;
                            this.parent.setCursor(Cursor.getPredefinedCursor(3));
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }

            synchronized void startTimer(Object argSource) {
                this.source = argSource;
                this.notify();
            }

            synchronized void stopTimer() {
                if (this.parent == null) {
                    this.interrupt();
                } else {
                    this.parent.setCursor(null);
                    this.parent = null;
                }
            }
        }
    }

    private class AskUserPopup
    extends JDialog {
        static final long serialVersionUID = 1042236188732008819L;
        private boolean doDelete = false;

        public AskUserPopup(JFrame owner, String title, boolean modal) {
            super(owner, title, modal);
            this.initComponents();
            this.setLocationRelativeTo(owner);
        }

        public boolean getDelete() {
            return this.doDelete;
        }

        private void setDelete(boolean argDoDelete) {
            this.doDelete = argDoDelete;
        }

        private void initComponents() {
            JButton btnYes = new JButton("Yes");
            JButton btnNo = new JButton("No");
            JPanel jPanel = new JPanel();
            JCheckBox chkDontAsk = new JCheckBox("Don't ask again");
            jPanel.add(chkDontAsk);
            jPanel.add(btnYes);
            jPanel.add(btnNo);
            btnYes.addActionListener(new ActionListener(this, chkDontAsk){
                private final /* synthetic */ JCheckBox val$chkDontAsk;
                private final /* synthetic */ AskUserPopup this$1;
                {
                    this.this$1 = this$1;
                    this.val$chkDontAsk = val$chkDontAsk;
                }

                public void actionPerformed(ActionEvent evt) {
                    if (this.val$chkDontAsk.isSelected()) {
                        SettingsHandler.setCleanupTempFiles(1);
                    }
                    AskUserPopup.access$900(this.this$1, true);
                    this.this$1.dispose();
                }
            });
            btnNo.addActionListener(new ActionListener(this, chkDontAsk){
                private final /* synthetic */ JCheckBox val$chkDontAsk;
                private final /* synthetic */ AskUserPopup this$1;
                {
                    this.this$1 = this$1;
                    this.val$chkDontAsk = val$chkDontAsk;
                }

                public void actionPerformed(ActionEvent evt) {
                    if (this.val$chkDontAsk.isSelected()) {
                        SettingsHandler.setCleanupTempFiles(-1);
                    }
                    this.this$1.dispose();
                }
            });
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)jPanel, "South");
            this.pack();
        }

        static /* synthetic */ void access$900(AskUserPopup x0, boolean x1) {
            x0.setDelete(x1);
        }
    }

    static final class PopupListener
    extends MouseAdapter {
        JTabbedPane tabbedPane;
        MainPopupMenu mainPopupMenu;
        PCPopupMenu pcPopupMenu;
        int index;

        PopupListener(JTabbedPane tabbedPane, MainPopupMenu mainPopupMenu, PCPopupMenu pcPopupMenu) {
            this.tabbedPane = tabbedPane;
            this.mainPopupMenu = mainPopupMenu;
            this.pcPopupMenu = pcPopupMenu;
        }

        public int getTabIndex() {
            return this.index;
        }

        public void mousePressed(MouseEvent e) {
            if (!e.isPopupTrigger() && !SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            this.index = this.indexAtLocation(e.getX(), e.getY());
            if (this.index < 0) {
                return;
            }
            PCGen_Frame1.enableDisableMenuItems();
            if (this.index < FIRST_CHAR_TAB) {
                this.mainPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                return;
            }
            int tabCount = this.tabbedPane.getTabCount();
            if (tabCount == FIRST_CHAR_TAB + 1) {
                this.pcPopupMenu.setShiftType(0);
            } else if (tabCount == FIRST_CHAR_TAB + 2) {
                this.pcPopupMenu.setShiftType(this.index == 1 ? 2 : 1);
            } else if (this.index == FIRST_CHAR_TAB) {
                this.pcPopupMenu.setShiftType(5);
            } else if (this.index == tabCount - 1) {
                this.pcPopupMenu.setShiftType(4);
            } else {
                this.pcPopupMenu.setShiftType(3);
            }
            this.pcPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }

        private int indexAtLocation(int x, int y) {
            TabbedPaneUI ui = this.tabbedPane.getUI();
            if (ui != null) {
                return ui.tabForCoordinate(this.tabbedPane, x, y);
            }
            return -1;
        }
    }

    final class MenuItems
    extends JMenuBar {
        static final long serialVersionUID = 1042236188732008819L;
        public ExportPopup exportPopup = null;
        AboutFrame aboutFrame = null;
        DebugFrame debugFrame = null;
        ExportPDFPopup exportPDFPopup = null;
        JCheckBoxMenuItem debugMode;
        JMenu exportMenu;
        JMenu filtersMenu;
        JMenu helpMenu;
        JMenu importMenu;
        JMenuItem addKit;
        JMenuItem closeAllItem;
        JMenuItem closeItem;
        JMenuItem exitItem;
        JMenuItem exportItem;
        JMenuItem exportPDFItem;
        JMenuItem listEditor;
        JMenuItem newItem;
        JMenuItem openItem;
        JMenuItem partyCloseItem;
        JMenuItem partyOpenItem;
        JMenuItem partySaveAsItem;
        JMenuItem partySaveItem;
        JMenuItem preferencesItem;
        JMenuItem printItem;
        JMenuItem printPreviewItem;
        JMenuItem revertToSavedItem;
        JMenuItem saveAllItem;
        JMenuItem saveAsItem;
        JMenuItem saveItem;
        JOpenRecentMenu openRecentPCMenu;
        JOpenRecentMenu openRecentPartyMenu;
        PrintFrame printFrame = null;
        private boolean enablePDF = FOPResourceChecker.getMissingResourceCount() == 0;

        public MenuItems() {
            PCGen_Frame1.this.checkResources();
            JMenu fileMenu = Utility.createMenu("mnuFile", null, true);
            this.newItem = Utility.createMenuItem("mnuFileNew", PCGen_Frame1.this.frameActionListener.newActionListener, "file.new", "shortcut N", "New16.gif", false);
            fileMenu.add(this.newItem);
            this.openItem = Utility.createMenuItem("mnuFileOpen", PCGen_Frame1.this.frameActionListener.openActionListener, "file.open", "shortcut O", "Open16.gif", true);
            fileMenu.add(this.openItem);
            this.openRecentPCMenu = new JOpenRecentMenu(new JOpenRecentMenu.OpenRecentCallback(this){
                private final /* synthetic */ MenuItems this$1;
                {
                    this.this$1 = this$1;
                }

                public void openRecentPerformed(ActionEvent e, File file) {
                    MenuItems.access$400(this.this$1).loadPCFromFile(file);
                }
            });
            fileMenu.add(this.openRecentPCMenu);
            fileMenu.addSeparator();
            this.closeItem = Utility.createMenuItem("mnuFileClose", PCGen_Frame1.this.frameActionListener.closeActionListener, "file.close", "shortcut W", "Close16.gif", false);
            fileMenu.add(this.closeItem);
            this.closeAllItem = Utility.createMenuItem("mnuFileCloseAll", PCGen_Frame1.this.frameActionListener.closeAllActionListener, "file.closeall", null, "CloseAll16.gif", false);
            fileMenu.add(this.closeAllItem);
            this.saveItem = Utility.createMenuItem("mnuFileSave", PCGen_Frame1.this.frameActionListener.saveActionListener, "file.save", "shortcut S", "Save16.gif", false);
            fileMenu.add(this.saveItem);
            this.saveAsItem = Utility.createMenuItem("mnuFileSaveAs", PCGen_Frame1.this.frameActionListener.saveAsActionListener, "file.saveas", "shift-shortcut S", "SaveAs16.gif", false);
            fileMenu.add(this.saveAsItem);
            this.saveAllItem = Utility.createMenuItem("mnuFileSaveAll", PCGen_Frame1.this.frameActionListener.saveAllActionListener, "file.saveall", null, "SaveAll16.gif", false);
            fileMenu.add(this.saveAllItem);
            this.revertToSavedItem = Utility.createMenuItem("mnuFileRevertToSaved", PCGen_Frame1.this.frameActionListener.revertToSavedActionListener, "file.reverttosaved", "shortcut R", null, false);
            fileMenu.add(this.revertToSavedItem);
            fileMenu.addSeparator();
            JMenu partyMenu = Utility.createMenu("mnuFileParty", null, true);
            fileMenu.add(partyMenu);
            this.partyOpenItem = Utility.createMenuItem("mnuFilePartyOpen", PCGen_Frame1.this.frameActionListener.partyOpenActionListener, "file.party.open", null, "Open16.gif", true);
            partyMenu.add(this.partyOpenItem);
            this.openRecentPartyMenu = new JOpenRecentMenu(new JOpenRecentMenu.OpenRecentCallback(this){
                private final /* synthetic */ MenuItems this$1;
                {
                    this.this$1 = this$1;
                }

                public void openRecentPerformed(ActionEvent e, File file) {
                    MenuItems.access$400(this.this$1).loadPartyFromFile(file);
                }
            });
            partyMenu.add(this.openRecentPartyMenu);
            this.partyCloseItem = Utility.createMenuItem("mnuFilePartyClose", PCGen_Frame1.this.frameActionListener.partyCloseActionListener, "file.party.close", null, "Close16.gif", false);
            partyMenu.addSeparator();
            partyMenu.add(this.partyCloseItem);
            this.partySaveItem = Utility.createMenuItem("mnuFilePartySave", PCGen_Frame1.this.frameActionListener.partySaveActionListener, "file.party.save", null, "Save16.gif", false);
            partyMenu.add(this.partySaveItem);
            this.partySaveAsItem = Utility.createMenuItem("mnuFilePartySaveAs", PCGen_Frame1.this.frameActionListener.partySaveAsActionListener, "file.party.saveas", null, "SaveAs16.gif", false);
            partyMenu.add(this.partySaveAsItem);
            fileMenu.addSeparator();
            this.printPreviewItem = Utility.createMenuItem("mnuFilePrintPreview", PCGen_Frame1.this.frameActionListener.printPreviewActionListener, "file.printpreview", null, "PrintPreview16.gif", false);
            fileMenu.add(this.printPreviewItem);
            this.printItem = Utility.createMenuItem("mnuFilePrint", PCGen_Frame1.this.frameActionListener.printActionListener, "file.print", "shortcut P", "Print16.gif", false);
            fileMenu.add(this.printItem);
            fileMenu.addSeparator();
            this.importMenu = Utility.createMenu("Import", 'I', "Import from other file formats", "Import16.gif", true);
            this.exportMenu = Utility.createMenu("mnuFileExport", "Export16.gif", false);
            fileMenu.add(this.exportMenu);
            this.exportItem = Utility.createMenuItem("mnuFileExportStandard", PCGen_Frame1.this.frameActionListener.exportToStandardActionListener, "file.export.standard", null, null, true);
            this.exportMenu.add(this.exportItem);
            this.exportPDFItem = Utility.createMenuItem("mnuFileExportPDF", new ActionListener(this){
                private final /* synthetic */ MenuItems this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    if (MenuItems.access$000(this.this$1)) {
                        if (this.this$1.exportPDFPopup == null) {
                            this.this$1.exportPDFPopup = new ExportPDFPopup(PCGen_Frame1.access$500());
                        }
                        this.this$1.exportPDFPopup.setCurrentPCSelectionByTab();
                    } else {
                        PCGen_Frame1.access$600(MenuItems.access$400(this.this$1));
                    }
                }
            }, "file.export.pdf", null, null, true);
            this.exportMenu.add(this.exportPDFItem);
            fileMenu.addSeparator();
            this.addKit = Utility.createMenuItem("mnuFileAddKit", PCGen_Frame1.this.frameActionListener.addKitActionListener, "assign.kit", "shortcut K", "Information16.gif", false);
            fileMenu.add(this.addKit);
            fileMenu.addSeparator();
            this.exitItem = Utility.createMenuItem("mnuFileExit", new ActionListener(this, PCGen_Frame1.this){
                private final /* synthetic */ PCGen_Frame1 val$this$0;
                private final /* synthetic */ MenuItems this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    PCGen_Frame1.access$700(MenuItems.access$400(this.this$1));
                }
            }, "file.exit", "shortcut Q", null, true);
            fileMenu.add(this.exitItem);
            this.add(fileMenu);
            Options optionMenu = new Options();
            this.add(optionMenu);
            JMenu toolsMenu = Utility.createMenu("mnuTools", "wrench.gif", true);
            this.add(toolsMenu);
            JMenuItem converterItem = Utility.createMenuItem("mnuToolsLstConverter", new ActionListener(this){
                private final /* synthetic */ MenuItems this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    int returnVal;
                    String basePath = null;
                    if (PCGen_Frame1.access$800() == null) {
                        if (SettingsHandler.getPccFilesLocation() != null) {
                            basePath = SettingsHandler.getPccFilesLocation().toString();
                        }
                    } else {
                        basePath = PCGen_Frame1.access$800().getBasePath();
                    }
                    JFileChooser fc = new JFileChooser();
                    fc.setFileSelectionMode(1);
                    fc.setDialogTitle("Select base directory to convert");
                    if (System.getProperty("os.name").startsWith("Mac OS")) {
                        fc.putClientProperty("JFileChooser.appBundleIsTraversable", "never");
                    }
                    if (basePath != null) {
                        File baseFile = new File(basePath);
                        fc.setCurrentDirectory(baseFile.getParentFile());
                        fc.setSelectedFile(baseFile);
                    }
                    if ((returnVal = fc.showOpenDialog(this.this$1.getParent().getParent())) == 0) {
                        File file = fc.getSelectedFile();
                        if (PCGen_Frame1.access$800() == null || basePath == null || !basePath.equals(file.toString())) {
                            PCGen_Frame1.access$802(new LstConverter(file.toString()));
                        }
                        PCGen_Frame1.access$800().setVisible(true);
                    }
                }
            }, "tools.converter", null, "wrench.gif", true);
            toolsMenu.add(converterItem);
            this.filtersMenu = Utility.createMenu("mnuToolsFilters", "Zoom16.gif", true);
            toolsMenu.add(this.filtersMenu);
            JMenuItem openFiltersItem = Utility.createMenuItem("mnuToolsFiltersOpen", new ActionListener(this){
                private final /* synthetic */ MenuItems this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    FilterDialogFactory.showHideFilterSelectDialog();
                }
            }, "tools.filters.open", null, "Zoom16.gif", true);
            this.filtersMenu.add(openFiltersItem);
            JMenuItem clearFiltersItem = Utility.createMenuItem("mnuToolsFiltersClear", new ActionListener(this){
                private final /* synthetic */ MenuItems this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    FilterDialogFactory.clearSelectedFiltersForSelectedFilterable();
                }
            }, "tools.filters.clear", null, "RemoveZoom16.gif", true);
            this.filtersMenu.add(clearFiltersItem);
            JMenuItem customFiltersItem = Utility.createMenuItem("mnuToolsFiltersCustom", new ActionListener(this){
                private final /* synthetic */ MenuItems this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    FilterDialogFactory.showHideFilterCustomDialog();
                }
            }, "tools.filters.custom", null, "CustomZoom16.gif", true);
            this.filtersMenu.add(customFiltersItem);
            JMenuItem editFiltersItem = Utility.createMenuItem("mnuToolsFiltersEdit", new ActionListener(this){
                private final /* synthetic */ MenuItems this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    FilterDialogFactory.showHideFilterEditorDialog();
                }
            }, "tools.filters.edit", null, "EditZoom16.gif", true);
            this.filtersMenu.add(editFiltersItem);
            toolsMenu.addSeparator();
            JMenuItem gmgenItem = Utility.createMenuItem("mnuToolsGMGen", new ActionListener(this){
                private final /* synthetic */ MenuItems this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    MenuItems.access$400(this.this$1).openGMGen_actionPerformed();
                }
            }, "tools.gmgen", null, "gmgen_icon.png", true);
            toolsMenu.add(gmgenItem);
            toolsMenu.addSeparator();
            this.listEditor = Utility.createMenuItem("mnuToolsListEditors", new ActionListener(this){
                private final /* synthetic */ MenuItems this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    new LstEditorMain().setVisible(true);
                }
            }, "tools.editors", null, null, true);
            toolsMenu.add(this.listEditor);
            JMenu debugMenu = Utility.createMenu("mnuDebug", null, true);
            this.debugMode = new JCheckBoxMenuItem();
            this.debugMode.setText(PropertyFactory.getString("in_mnuDebugMode"));
            this.debugMode.setMnemonic(PropertyFactory.getMnemonic("in_mn_mnuDebugMode"));
            Utility.setDescription(this.debugMode, PropertyFactory.getString("in_mnuDebugModeTip"));
            this.debugMode.setSelected(Logging.isDebugMode());
            this.debugMode.addActionListener(new ActionListener(this){
                private final /* synthetic */ MenuItems this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    Logging.setDebugMode(this.this$1.debugMode.isSelected());
                    if (this.this$1.exportPopup != null) {
                        this.this$1.exportPopup.refreshTemplates();
                    }
                }
            });
            debugMenu.add(this.debugMode);
            JMenuItem consoleMenuItem = Utility.createMenuItem("mnuDebugConsole", new ActionListener(this, PCGen_Frame1.this){
                private final /* synthetic */ PCGen_Frame1 val$this$0;
                private final /* synthetic */ MenuItems this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    if (this.this$1.debugFrame == null) {
                        this.this$1.debugFrame = this.this$1.new DebugFrame();
                    }
                    this.this$1.debugFrame.setVisible(true);
                }
            }, "debug.console", null, null, true);
            debugMenu.add(consoleMenuItem);
            this.add(debugMenu);
            this.helpMenu = Utility.createMenu("mnuHelp", "Help16.gif", true);
            JMenuItem contextHelpItem = Utility.createMenuItem("mnuHelpContext", new ActionListener(this){
                private final /* synthetic */ MenuItems this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    PToolBar.displayHelpPanel(true);
                }
            }, "help.context", null, "ContextualHelp16.gif", true);
            this.helpMenu.add(contextHelpItem);
            JMenuItem docsItem = Utility.createMenuItem("mnuHelpDocumentation", new ActionListener(this, PCGen_Frame1.this){
                private final /* synthetic */ PCGen_Frame1 val$this$0;
                private final /* synthetic */ MenuItems this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.new DocsFrame();
                }
            }, "help.docs", "F1", "Help16.gif", true);
            this.helpMenu.add(docsItem);
            this.helpMenu.addSeparator();
            JMenuItem oglItem = Utility.createMenuItem("mnuHelpOGL", new ActionListener(this){
                private final /* synthetic */ MenuItems this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    pcGenGUI.showLicense();
                }
            }, "help.ogl", null, null, true);
            this.helpMenu.add(oglItem);
            JMenuItem todItem = Utility.createMenuItem("mnuHelpTipOfTheDay", new ActionListener(this){
                private final /* synthetic */ MenuItems this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    pcGenGUI.showTipOfTheDay();
                }
            }, "help.tod", null, "TipOfTheDay16.gif", true);
            this.helpMenu.add(todItem);
            this.helpMenu.addSeparator();
            JMenuItem aboutItem = Utility.createMenuItem("mnuHelpAbout", new ActionListener(this, PCGen_Frame1.this){
                private final /* synthetic */ PCGen_Frame1 val$this$0;
                private final /* synthetic */ MenuItems this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    if (this.this$1.aboutFrame == null) {
                        this.this$1.aboutFrame = this.this$1.new AboutFrame();
                        this.this$1.aboutFrame.pack();
                    }
                    this.this$1.aboutFrame.setVisible(true);
                }
            }, "help.about", null, "About16.gif", true);
            this.helpMenu.add(aboutItem);
            this.add(this.helpMenu);
            this.separateHelpMenu(!UIFactory.isWindowsUI());
        }

        public void separateHelpMenu(boolean b) {
            boolean hasGlue;
            if (this.helpMenu == null) {
                throw new IllegalStateException();
            }
            int i = this.getComponentIndex(this.helpMenu);
            if (i == -1) {
                throw new IllegalStateException();
            }
            Component o = this.getComponent(i - 1);
            boolean bl = hasGlue = !(o instanceof JMenu);
            if (b && hasGlue) {
                return;
            }
            if (!b && !hasGlue) {
                return;
            }
            if (b) {
                this.add(Box.createHorizontalGlue(), i);
            } else {
                this.remove(i - 1);
            }
        }

        void checkPrintFrame() {
            if (this.printFrame == null) {
                this.printFrame = new PrintFrame();
            }
        }

        static /* synthetic */ PCGen_Frame1 access$400(MenuItems x0) {
            return x0.PCGen_Frame1.this;
        }

        private final class DocsFrame
        extends JFrame {
            public DocsFrame() {
                try {
                    BrowserLauncher.openURL(SettingsHandler.getPcgenDocsDir().getAbsolutePath() + File.separator + "index.html");
                }
                catch (IOException ex) {
                    ShowMessageDelegate.showMessageDialog("Could not open docs in external browser. Have you set your default browser in the Preference menu? Sorry...", "PCGen", MessageType.ERROR);
                    Logging.errorPrint("Could not open docs in external browser", ex);
                }
            }
        }

        final class PrintFrame
        extends PCGenPopup {
            MainPrint mainPrint = new MainPrint(this, 1);

            public PrintFrame() {
                super("Print a PC or Party");
                this.setPanel(this.mainPrint);
                this.pack();
                this.setVisible(true);
            }

            public void setCurrentPCSelectionByTab() {
                if (this.mainPrint != null) {
                    this.mainPrint.setCurrentPCSelection(baseTabbedPane.getSelectedIndex());
                }
            }
        }

        final class DebugFrame
        extends PCGenPopup {
            public DebugFrame() {
                super("Debug Console", new MainDebug());
            }
        }

        final class AboutFrame
        extends PCGenPopup {
            public AboutFrame() {
                super("About PCGen", new MainAbout());
            }
        }
    }

    static final class FilenameChangeListener
    implements PropertyChangeListener {
        private JFileChooser fileChooser;
        private String lastSelName;

        FilenameChangeListener(String aFileName, JFileChooser aFileChooser) {
            this.lastSelName = aFileName;
            this.fileChooser = aFileChooser;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName.equals("SelectedFileChangedProperty")) {
                this.onSelectedFileChange(evt);
            } else if (propName.equals("directoryChanged")) {
                this.onDirectoryChange();
            }
        }

        private void onDirectoryChange() {
            this.fileChooser.setSelectedFile(new File(this.fileChooser.getCurrentDirectory(), this.lastSelName));
        }

        private void onSelectedFileChange(PropertyChangeEvent evt) {
            File newSelFile = (File)evt.getNewValue();
            if (newSelFile != null && !newSelFile.isDirectory()) {
                this.lastSelName = newSelFile.getName();
            }
        }
    }
}

