/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import pcgen.core.Constants;
import pcgen.core.GameMode;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.gui.CharacterInfo;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterDialogFactory;
import pcgen.gui.filter.Filterable;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class PToolBar
extends JToolBar {
    static final long serialVersionUID = 6970993764494046979L;
    private static PToolBar currentInstance = null;
    private static JFrame helpFrame = new JFrame("Help");
    private static JEditorPane helpPane = new JEditorPane("text/html", "");
    JButton addKit;
    JButton closeItem;
    JButton gmgenItem;
    JButton newItem;
    JButton openItem;
    JButton printItem;
    JButton printPreviewItem;
    JButton saveItem;
    private FilterComponentListener fcl;
    private FilterToolTipButton openFilters;
    private JButton clearFilters;
    private JButton customFilters;
    private JButton editorFilters;
    private JButton helpItem;
    private JButton preferencesItem;

    private PToolBar(PCGen_Frame1 main) {
        this.init(main);
        this.setFloatable(true);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.fcl = new FilterComponentListener();
    }

    public static void displayHelpPanel(boolean forceDisplay) {
        Component curPanel = PCGen_Frame1.getBaseTabbedPane().getSelectedComponent();
        if (curPanel == null) {
            return;
        }
        if (curPanel instanceof CharacterInfo) {
            curPanel = ((CharacterInfo)curPanel).getActivePane();
        }
        String panelName = "";
        if (curPanel != null) {
            panelName = curPanel.getName();
        }
        int index = -1;
        if (panelName != null && panelName.length() > 0) {
            if (panelName.equals(Constants.tabNames[6])) {
                Component subPanel = ((JTabbedPane)curPanel).getSelectedComponent();
                if (curPanel != null) {
                    panelName = subPanel.getName();
                }
            }
            index = GameMode.getTabNumber(panelName);
        }
        try {
            String helpPath = SettingsHandler.getGame().getContextPath(index);
            if (helpPath.equals("")) {
                return;
            }
            helpPath = CoreUtility.fixFilenamePath(SettingsHandler.getPcgenDocsDir() + File.separator + helpPath);
            File helpFile = new File(helpPath);
            if (!helpFile.exists()) {
                throw new MissingDocumentationException(helpFile.getAbsolutePath());
            }
            BufferedReader helpReader = new BufferedReader(new FileReader(helpFile));
            int length = (int)helpFile.length();
            char[] inputLine = new char[length];
            helpReader.read(inputLine, 0, length);
            helpReader.close();
            String aString = new String(inputLine);
            int i = 0;
            boolean wholeFile = true;
            String rep = "";
            String other = ">";
            String search = "";
            for (int j = 0; j < 13; ++j) {
                switch (j) {
                    case 0: {
                        search = "<img";
                        rep = " ";
                        break;
                    }
                    case 1: {
                        search = "<html ";
                        rep = "<html>";
                        break;
                    }
                    case 2: {
                        search = "<body ";
                        rep = "<body>";
                        break;
                    }
                    case 3: {
                        search = "<meta ";
                        rep = " ";
                        break;
                    }
                    case 4: {
                        search = "<!--[";
                        other = "<![endif]-->";
                        break;
                    }
                    case 5: {
                        search = "<xml>";
                        other = "</xml>";
                        break;
                    }
                    case 6: {
                        search = "<![endif";
                        other = ">";
                        rep = " ";
                        break;
                    }
                    case 7: {
                        search = "![endif";
                        other = ">";
                        rep = " ";
                        break;
                    }
                    case 8: {
                        search = "<o:p";
                        other = ">";
                        rep = " ";
                        break;
                    }
                    case 9: {
                        search = "</o:p";
                        other = ">";
                        rep = " ";
                        break;
                    }
                    case 10: {
                        search = "<link ";
                        other = ">";
                        rep = " ";
                        break;
                    }
                    case 11: {
                        search = "<style";
                        other = "</style>";
                        rep = " ";
                        break;
                    }
                    case 12: {
                        search = "<li ";
                        other = ">";
                        rep = "<li>";
                        break;
                    }
                    default: {
                        Logging.errorPrint("Index " + j + " not handled in Ptoolbar.displayHelpPanel");
                    }
                }
                i = aString.indexOf(search);
                while (i >= 0) {
                    int k = aString.substring(i).indexOf(other);
                    String replacement = rep;
                    if (k == -1) {
                        replacement = " ";
                    }
                    aString = aString.substring(0, i) + replacement + aString.substring(i + k + 1);
                    i = aString.indexOf(search);
                    wholeFile = false;
                }
            }
            if (!wholeFile) {
                helpPane.setText(aString);
            } else {
                URL aurl = helpFile.toURL();
                helpPane.setPage(aurl);
            }
        }
        catch (IOException e) {
            Logging.errorPrint("Something went wrong printing ", e);
        }
        catch (MissingDocumentationException mde) {
            Logging.errorPrint("Could not find " + mde.getMessage());
            helpPane.setText("<html>" + PropertyFactory.getString("in_noHelpAvailable") + "</html>");
        }
        if (helpFrame.isVisible() || forceDisplay) {
            helpFrame.setVisible(true);
        }
        helpPane.setCaretPosition(0);
    }

    public ComponentListener getComponentListener() {
        return this.fcl;
    }

    public static PToolBar getCurrentInstance() {
        return currentInstance;
    }

    public void setFilterActive() {
        this.openFilters.setActiveIcon();
    }

    public void setFilterInactive() {
        this.openFilters.setInactiveIcon();
    }

    public static PToolBar createToolBar(PCGen_Frame1 main) {
        if (currentInstance == null) {
            currentInstance = new PToolBar(main);
        }
        return currentInstance;
    }

    private void disableFilterButtons() {
        this.setFilterInactive();
        this.filterButtonsSetEnabled(false);
    }

    private void filterButtonsSetEnabled(boolean b) {
        this.openFilters.setEnabled(b);
        this.clearFilters.setEnabled(b);
        this.customFilters.setEnabled(b);
        this.editorFilters.setEnabled(b);
    }

    private void init(PCGen_Frame1 main) {
        this.newItem = Utility.createButton(main.frameActionListener.newActionListener, "file.new", PropertyFactory.getString("in_mnuFileNewTip"), "New16.gif", false);
        this.add(this.newItem);
        this.openItem = Utility.createButton(main.frameActionListener.openActionListener, "file.open", PropertyFactory.getString("in_mnuFileOpenTip"), "Open16.gif", true);
        this.add(this.openItem);
        this.closeItem = Utility.createButton(main.frameActionListener.closeActionListener, "file.close", PropertyFactory.getString("in_mnuFileCloseTip"), "Close16.gif", false);
        this.add(this.closeItem);
        this.saveItem = Utility.createButton(main.frameActionListener.saveActionListener, "file.save", PropertyFactory.getString("in_mnuFileSaveTip"), "Save16.gif", false);
        this.add(this.saveItem);
        this.addSeparator();
        this.printPreviewItem = Utility.createButton(main.frameActionListener.printPreviewActionListener, "file.printpreview", PropertyFactory.getString("in_mnuFilePrintPreviewTip"), "PrintPreview16.gif", false);
        this.add(this.printPreviewItem);
        this.printItem = Utility.createButton(main.frameActionListener.printActionListener, "file.print", PropertyFactory.getString("in_mnuFilePrintTip"), "Print16.gif", false);
        this.add(this.printItem);
        this.addSeparator();
        this.openFilters = new FilterToolTipButton(IconUtilitities.getImageIcon("Zoom16.gif"), IconUtilitities.getImageIcon("ZoomHighlightBlue16.gif"));
        this.openFilters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterDialogFactory.showHideFilterSelectDialog();
            }
        });
        this.add(this.openFilters);
        this.clearFilters = Utility.createButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterDialogFactory.clearSelectedFiltersForSelectedFilterable();
            }
        }, "filter.clear", PropertyFactory.getString("in_mnuToolsFiltersClearTip"), "RemoveZoom16.gif", false);
        this.add(this.clearFilters);
        this.customFilters = Utility.createButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterDialogFactory.showHideFilterCustomDialog();
            }
        }, "filter.custom", PropertyFactory.getString("in_mnuToolsFiltersCustomTip"), "CustomZoom16.gif", false);
        this.add(this.customFilters);
        this.editorFilters = Utility.createButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterDialogFactory.showHideFilterEditorDialog();
            }
        }, "filter.editor", PropertyFactory.getString("in_mnuToolsFiltersEditTip"), "EditZoom16.gif", false);
        this.add(this.editorFilters);
        this.addSeparator();
        this.addKit = Utility.createButton(main.frameActionListener.addKitActionListener, "assign.kit", PropertyFactory.getString("in_mnuFileAddKitTip"), "Information16.gif", false);
        this.add(this.addKit);
        this.addSeparator();
        this.preferencesItem = Utility.createButton(main.frameActionListener.preferencesActionListener, "settings.preferences", PropertyFactory.getString("in_mnuSettingsPreferencesTip"), "Preferences16.gif", true);
        this.add(this.preferencesItem);
        this.addSeparator();
        this.gmgenItem = Utility.createButton(main.frameActionListener.gmgenActionListener, "gmgen.load", PropertyFactory.getString("in_launchGMGen"), "gmgen_icon.png", true);
        this.add(this.gmgenItem);
        this.addSeparator();
        this.helpItem = Utility.createButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PToolBar.displayHelpPanel(true);
            }
        }, "help.context", PropertyFactory.getString("in_mnuHelpContext"), "ContextualHelp16.gif", true);
        this.add(this.helpItem);
        helpFrame.setSize(new Dimension(400, 400));
        helpFrame.getContentPane().add(new JScrollPane(helpPane));
        helpFrame.setLocation(100, 100);
        helpPane.setEditable(false);
    }

    private static class MissingDocumentationException
    extends Exception {
        MissingDocumentationException(String docpath) {
            super(docpath);
        }
    }

    private class FilterToolTipButton
    extends FilterIconButton {
        public FilterToolTipButton(Icon inactiveIcon, Icon activeIcon) {
            super(inactiveIcon, activeIcon);
            this.setToolTipText(PropertyFactory.getString("in_filterIcon"));
        }

        public String getToolTipText(MouseEvent event) {
            return FilterDialogFactory.getSelectedFiltersToolTipText();
        }
    }

    private static class FilterIconButton
    extends JButton {
        private Icon activeIcon;
        private Icon inactiveIcon;

        public FilterIconButton(Icon inactiveIcon, Icon activeIcon) {
            super(inactiveIcon);
            this.activeIcon = activeIcon;
            this.inactiveIcon = inactiveIcon;
            this.setMargin(new Insets(0, 0, 0, 0));
        }

        public void setActiveIcon() {
            this.setIcon(this.activeIcon);
        }

        public void setInactiveIcon() {
            this.setIcon(this.inactiveIcon);
        }
    }

    private class FilterComponentListener
    extends ComponentAdapter {
        private FilterComponentListener() {
        }

        public void componentShown(ComponentEvent e) {
            JTabbedPane tabPane;
            PToolBar.displayHelpPanel(false);
            Component c = e.getComponent();
            if (c.getParent() instanceof JTabbedPane && !(tabPane = (JTabbedPane)c.getParent()).isVisible()) {
                return;
            }
            if (c instanceof Filterable) {
                this.handleFilterableShown((Filterable)((Object)c));
            } else if (c instanceof CharacterInfo) {
                this.handleFilterableShown(((CharacterInfo)c).getSelectedFilterable());
            } else {
                PToolBar.this.disableFilterButtons();
                PCGen_Frame1.getInst().getPcgenMenuBar().filtersMenu.setEnabled(false);
            }
        }

        private void handleFilterableShown(Filterable f) {
            if (f != null && f.getSelectionMode() != -2) {
                PToolBar.this.filterButtonsSetEnabled(true);
                if (f.getSelectedFilters().size() > 0) {
                    PToolBar.this.setFilterActive();
                } else {
                    PToolBar.this.setFilterInactive();
                }
                PCGen_Frame1.getInst().getPcgenMenuBar().filtersMenu.setEnabled(true);
            } else {
                PToolBar.this.disableFilterButtons();
                PCGen_Frame1.getInst().getPcgenMenuBar().filtersMenu.setEnabled(false);
            }
        }
    }
}

