/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;
import pcgen.core.PObject;
import pcgen.gui.SourceLoadProgressDialog;

public class PersistenceObserver
implements Observer {
    int totalFileCount = 0;
    int currentFileCount = 0;
    SourceLoadProgressDialog dialog = new SourceLoadProgressDialog(null, false);

    public PersistenceObserver() {
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof URL) {
            this.setCurrentFileCount(this.getCurrentFileCount() + 1);
            final URL url = (URL)arg;
            Runnable doWork = new Runnable(){

                public void run() {
                    PersistenceObserver.this.dialog.setCurrentFile(url.toString());
                }
            };
            SwingUtilities.invokeLater(doWork);
        } else if (!(arg instanceof PObject)) {
            if (arg instanceof Exception) {
                final Exception e = (Exception)arg;
                Runnable doWork = new Runnable(){

                    public void run() {
                        PersistenceObserver.this.dialog.addMessage(e.getMessage());
                        PersistenceObserver.this.dialog.setErrorState(true);
                    }
                };
                SwingUtilities.invokeLater(doWork);
            } else if (arg instanceof Integer) {
                int count = (Integer)arg;
                this.setTotalFileCount(count);
            } else if (arg instanceof String && arg.equals("DONE")) {
                this.setCurrentFileCount(this.getTotalFileCount());
                Runnable doWork = new Runnable(){

                    public void run() {
                        PersistenceObserver.this.dialog.addMessage("All Done");
                        PersistenceObserver.this.end();
                    }
                };
                SwingUtilities.invokeLater(doWork);
            }
        }
    }

    protected int getTotalFileCount() {
        return this.totalFileCount;
    }

    protected void setTotalFileCount(final int iFileCount) {
        this.totalFileCount = iFileCount;
        Runnable doWork = new Runnable(){

            public void run() {
                PersistenceObserver.this.dialog.setTotalFileCount(iFileCount);
            }
        };
        SwingUtilities.invokeLater(doWork);
    }

    protected int getCurrentFileCount() {
        return this.currentFileCount;
    }

    protected void setCurrentFileCount(final int iFileCount) {
        this.currentFileCount = iFileCount;
        Runnable doWork = new Runnable(){

            public void run() {
                PersistenceObserver.this.dialog.setCurrentFileCount(iFileCount);
            }
        };
        SwingUtilities.invokeLater(doWork);
    }

    public void end() {
        if (!this.dialog.getErrorState()) {
            this.dialog.setVisible(false);
        }
    }
}

