/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

public final class PortraitChooser
extends JPanel {
    static final long serialVersionUID = -2286034876554542232L;
    private static final boolean ALLOW_PNG = Globals.javaVersionMajor > 1 || Globals.javaVersionMajor == 1 && Globals.javaVersionMinor >= 4;
    private static final JFileChooser fileChooser;
    private static Image default_portrait;
    private File directory;
    private File portraitFile;
    private GridBagConstraints gbc;
    private GridBagLayout gbl;
    private ImageIcon cachedIcon;
    private JButton dirButton;
    private JButton refreshButton;
    private JButton removeButton;
    private JLabel portraitLabel;
    private String title;

    public PortraitChooser() {
        this("Portrait");
    }

    public PortraitChooser(String title) {
        this.title = title;
        this.directory = SettingsHandler.getPortraitsPath();
        if (default_portrait == null) {
            default_portrait = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/pcgen/gui/resource/DefaultPortrait.gif"));
        }
        this.initComponents();
    }

    public void refresh(PlayerCharacter currPC) {
        this.refresh(true, currPC);
    }

    private void setPortrait(File portraitFile, PlayerCharacter currPC) {
        String newPortraitPath;
        Image image;
        if (portraitFile == null) {
            image = default_portrait;
            newPortraitPath = "";
        } else {
            newPortraitPath = portraitFile.getAbsolutePath();
            image = Toolkit.getDefaultToolkit().getImage(newPortraitPath);
        }
        this.portraitFile = portraitFile;
        this.cachedIcon = this.createScaledImageIcon(image);
        this.portraitLabel.setIcon(this.cachedIcon);
        if (currPC != null && !newPortraitPath.equals(currPC.getPortraitPath())) {
            currPC.setPortraitPath(newPortraitPath);
            currPC.setDirty(true);
        }
    }

    private void add(JComponent comp, int row, int col, int width, int height) {
        this.gbc.gridx = col;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbl.setConstraints(comp, this.gbc);
        super.add(comp);
    }

    private ImageIcon createScaledImageIcon(Image image) {
        double factorHeight;
        ImageIcon icon = new ImageIcon(image);
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        double factorWidth = (double)width / this.portraitLabel.getSize().getWidth();
        if (factorWidth > (factorHeight = (double)height / this.portraitLabel.getSize().getHeight())) {
            width = (int)((double)width / factorWidth);
            height = -1;
        } else {
            width = -1;
            height = (int)((double)height / factorHeight);
        }
        if (width != 0 && height != 0) {
            icon = new ImageIcon(image.getScaledInstance(width, height, 8));
        }
        return icon;
    }

    private void initComponents() {
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.setLayout(this.gbl);
        if (this.title != null) {
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.title, 2, 0));
        }
        this.portraitLabel = new JLabel();
        this.portraitLabel.setHorizontalAlignment(0);
        this.portraitLabel.setVerticalAlignment(0);
        this.portraitLabel.setVerticalTextPosition(0);
        this.portraitLabel.setHorizontalTextPosition(0);
        this.portraitLabel.setIcon(new ImageIcon(default_portrait));
        this.portraitLabel.setText("");
        this.portraitLabel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                PortraitChooser.this.resizePortrait();
            }
        });
        JPanel portraitPanel = new JPanel(new GridLayout(1, 1));
        portraitPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        portraitPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0), portraitPanel.getBorder()));
        portraitPanel.add(this.portraitLabel);
        this.gbc.weightx = 10.0;
        this.gbc.weighty = 10.0;
        this.gbc.fill = 1;
        this.add(portraitPanel, 0, 0, 3, 1);
        JPanel buttonPanel = new JPanel();
        this.refreshButton = Utility.createButton(null, null, PropertyFactory.getString("in_refreshTipString"), "Refresh16.gif", true);
        this.refreshButton.setMargin(new Insets(2, 2, 2, 2));
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PortraitChooser.this.refresh(false, Globals.getCurrentPC());
            }
        });
        buttonPanel.add(this.refreshButton);
        this.dirButton = new JButton(PropertyFactory.getString("in_selectPortrait"));
        if (SettingsHandler.isToolTipTextShown()) {
            Utility.setDescription(this.dirButton, PropertyFactory.getString("in_selectPortraitTipString"));
        }
        this.dirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                fileChooser.setCurrentDirectory(PortraitChooser.this.directory);
                if (fileChooser.showOpenDialog(PortraitChooser.this) == 0) {
                    PortraitChooser.this.directory = fileChooser.getSelectedFile().getParentFile();
                    PortraitChooser.this.setPortrait(fileChooser.getSelectedFile(), Globals.getCurrentPC());
                }
            }
        });
        buttonPanel.add(this.dirButton);
        this.removeButton = new JButton(PropertyFactory.getString("in_removePortrait"));
        if (SettingsHandler.isToolTipTextShown()) {
            Utility.setDescription(this.removeButton, PropertyFactory.getString("in_removePortraitTipString"));
        }
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PortraitChooser.this.setPortrait(null, Globals.getCurrentPC());
            }
        });
        buttonPanel.add(this.removeButton);
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 0;
        this.add(buttonPanel, 1, 2, 1, 1);
        this.initPortrait(true, Globals.getCurrentPC());
    }

    private void initPortrait(boolean resetPortraitsPathToDefaultIfCharacterHasNone, PlayerCharacter currPC) {
        String portraitPath = "";
        if (currPC != null) {
            portraitPath = currPC.getPortraitPath();
        }
        if (portraitPath.length() > 0) {
            File portraitFile = new File(portraitPath);
            this.setPortrait(portraitFile, currPC);
        } else {
            if (resetPortraitsPathToDefaultIfCharacterHasNone) {
                this.directory = SettingsHandler.getPortraitsPath();
            }
            this.setPortrait(null, currPC);
        }
    }

    private void refresh(boolean resetPortraitsPathToDefaultIfCharacterHasNone, PlayerCharacter currPC) {
        this.initPortrait(resetPortraitsPathToDefaultIfCharacterHasNone, currPC);
    }

    private void resizePortrait() {
        Image image = this.portraitFile != null ? Toolkit.getDefaultToolkit().getImage(this.portraitFile.getAbsolutePath()) : default_portrait;
        this.cachedIcon = this.createScaledImageIcon(image);
        this.portraitLabel.setIcon(this.cachedIcon);
    }

    static {
        default_portrait = null;
        fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                boolean isImage;
                if (f.isDirectory()) {
                    return true;
                }
                String fileName = f.getName().toLowerCase();
                boolean bl = isImage = fileName.endsWith(".gif") || fileName.endsWith(".jpg") || fileName.endsWith(".jpeg");
                if (ALLOW_PNG) {
                    isImage |= fileName.endsWith(".png");
                }
                return isImage;
            }

            public String getDescription() {
                if (ALLOW_PNG) {
                    return "Images (*.gif, *.jpg, *.jpeg, *.png)";
                }
                return "Images (*.gif, *.jpg, *.jpeg)";
            }
        });
    }
}

