/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.table.AbstractTableModel;
import pcgen.core.CustomData;
import pcgen.core.Globals;
import pcgen.core.PointBuyMethod;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.NewPurchaseMethodDialog;
import pcgen.gui.utils.JComboBoxEx;

final class PurchaseModeFrame
extends JDialog {
    static final long serialVersionUID = -5244500546425680322L;
    private static String s_TITLE = "Purchase Mode Configuration";
    private static final int STANDARD_MIN_PURCHASE_SCORE = 8;
    private static final int STANDARD_MAX_PURCHASE_SCORE = 18;
    private JButton addMethodButton = null;
    private JButton cancelButton;
    private JButton okButton;
    private JButton purchaseScoreMaxDecreaseButton;
    private JButton purchaseScoreMaxIncreaseButton;
    private JButton purchaseScoreMinDecreaseButton;
    private JButton purchaseScoreMinIncreaseButton;
    private JButton removeMethodButton = null;
    private JButton resetButton;
    private JComboBoxEx currentPurchaseMethods = null;
    private JLabel methodPointsLabel = null;
    private JLabel purchaseScoreMaxLabel;
    private JLabel purchaseScoreMinLabel;
    private JLabel savedMethodLabel = null;
    private JLabel statusBar;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel purchaseMethodButtonPanel;
    private JPanel purchaseMethodNamePanel;
    private JPanel purchaseMethodPanel;
    private JPanel purchaseMethodPointsPanel;
    private JScrollPane jScrollPane1;
    private JTable abilityScoreCostTable;
    private JTextField purchaseMethodPointsEdit;
    private JTextField purchaseScoreMaxEdit;
    private JTextField purchaseScoreMinEdit;
    private PurchaseModel purchaseModel = null;
    static /* synthetic */ Class class$java$lang$Integer;

    public PurchaseModeFrame() {
        this.initComponents();
    }

    public PurchaseModeFrame(JDialog parent) {
        super(parent);
        this.initComponents();
    }

    public static void main(String[] args) {
        new PurchaseModeFrame().setVisible(true);
    }

    private void addMethodButtonActionPerformed() {
        NewPurchaseMethodDialog npmd = new NewPurchaseMethodDialog(this, true);
        npmd.setVisible(true);
        if (!npmd.getWasCancelled()) {
            String methodName = npmd.getEnteredName();
            if (SettingsHandler.getPurchaseMethodByName(methodName) == null) {
                PointBuyMethod pbm = new PointBuyMethod(methodName, npmd.getEnteredPoints());
                this.currentPurchaseMethods.addItem(pbm);
                this.currentPurchaseMethods.setSelectedItem(pbm);
            } else {
                ShowMessageDelegate.showMessageDialog("Cannot add method. Name already exists.", "PCGen", MessageType.ERROR);
            }
        }
    }

    private void cancelButtonActionPerformed() {
        this.dispose();
    }

    private int convertStringToInt(String valueString) {
        int value;
        try {
            value = Integer.parseInt(valueString);
        }
        catch (NumberFormatException nfe) {
            value = -1;
        }
        return value;
    }

    private void currentPurchaseMethodsActionPerformed() {
        PointBuyMethod method = (PointBuyMethod)this.currentPurchaseMethods.getSelectedItem();
        if (method == null) {
            this.removeMethodButton.setEnabled(false);
            this.purchaseMethodPointsEdit.setText("");
        } else {
            this.purchaseMethodPointsEdit.setText(Integer.toString(method.getPoints()));
            this.removeMethodButton.setEnabled(true);
        }
    }

    private void exitForm() {
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.purchaseScoreMinIncreaseButton = new JButton();
        this.purchaseScoreMinDecreaseButton = new JButton();
        this.purchaseScoreMaxIncreaseButton = new JButton();
        this.purchaseScoreMaxDecreaseButton = new JButton();
        this.cancelButton = new JButton();
        this.resetButton = new JButton();
        this.purchaseScoreMinLabel = new JLabel();
        this.purchaseScoreMinEdit = new JTextField();
        this.purchaseScoreMaxLabel = new JLabel();
        this.purchaseScoreMaxEdit = new JTextField();
        this.statusBar = new JLabel();
        this.jPanel2 = new JPanel();
        this.currentPurchaseMethods = new JComboBoxEx();
        this.currentPurchaseMethods.setAutoSort(true);
        this.savedMethodLabel = new JLabel();
        this.methodPointsLabel = new JLabel();
        this.purchaseMethodPointsEdit = new JTextField();
        this.purchaseMethodPanel = new JPanel();
        this.purchaseMethodNamePanel = new JPanel();
        this.purchaseMethodPointsPanel = new JPanel();
        this.purchaseMethodButtonPanel = new JPanel();
        this.addMethodButton = new JButton();
        this.removeMethodButton = new JButton();
        this.jPanel3 = new JPanel();
        this.okButton = new JButton();
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CustomData.writePurchaseModeConfiguration();
            }
        });
        this.jScrollPane1 = new JScrollPane();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle(s_TITLE);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PurchaseModeFrame.this.exitForm();
            }
        });
        this.jPanel1.setLayout(new FlowLayout(0, 2, 5));
        this.purchaseScoreMinLabel.setText("Purchase Score Min:");
        this.purchaseScoreMinLabel.setToolTipText("The ability score can not go below this value");
        this.purchaseScoreMinLabel.setPreferredSize(new Dimension(140, 15));
        this.jPanel1.add(this.purchaseScoreMinLabel);
        this.purchaseScoreMinEdit.setHorizontalAlignment(4);
        this.purchaseScoreMinEdit.setPreferredSize(new Dimension(30, 20));
        this.jPanel1.add(this.purchaseScoreMinEdit);
        this.purchaseScoreMinIncreaseButton.setText("+");
        this.purchaseScoreMinIncreaseButton.setToolTipText("Increase score minimum");
        this.purchaseScoreMinIncreaseButton.setMargin(new Insets(2, 2, 2, 2));
        this.purchaseScoreMinIncreaseButton.setPreferredSize(new Dimension(30, 20));
        this.purchaseScoreMinIncreaseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PurchaseModeFrame.this.purchaseScoreMinIncreaseButtonActionPerformed();
            }
        });
        this.jPanel1.add(this.purchaseScoreMinIncreaseButton);
        this.purchaseScoreMinDecreaseButton.setText("-");
        this.purchaseScoreMinDecreaseButton.setToolTipText("Decrease score minimum");
        this.purchaseScoreMinDecreaseButton.setMargin(new Insets(2, 2, 2, 2));
        this.purchaseScoreMinDecreaseButton.setPreferredSize(new Dimension(30, 20));
        this.purchaseScoreMinDecreaseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PurchaseModeFrame.this.purchaseScoreMinDecreaseButtonActionPerformed();
            }
        });
        this.jPanel1.add(this.purchaseScoreMinDecreaseButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new FlowLayout(0, 2, 5));
        this.purchaseScoreMaxLabel.setText("Purchase Score Max:");
        this.purchaseScoreMaxLabel.setToolTipText("The ability score can not go above this value");
        this.purchaseScoreMaxLabel.setPreferredSize(new Dimension(140, 15));
        this.jPanel2.add(this.purchaseScoreMaxLabel);
        this.purchaseScoreMaxEdit.setHorizontalAlignment(4);
        this.purchaseScoreMaxEdit.setPreferredSize(new Dimension(30, 20));
        this.jPanel2.add(this.purchaseScoreMaxEdit);
        this.purchaseScoreMaxIncreaseButton.setText("+");
        this.purchaseScoreMaxIncreaseButton.setToolTipText("Increase score maximum");
        this.purchaseScoreMaxIncreaseButton.setMargin(new Insets(2, 2, 2, 2));
        this.purchaseScoreMaxIncreaseButton.setPreferredSize(new Dimension(30, 20));
        this.purchaseScoreMaxIncreaseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PurchaseModeFrame.this.purchaseScoreMaxIncreaseButtonActionPerformed();
            }
        });
        this.jPanel2.add(this.purchaseScoreMaxIncreaseButton);
        this.purchaseScoreMaxDecreaseButton.setText("-");
        this.purchaseScoreMaxDecreaseButton.setToolTipText("Decrease score maximum");
        this.purchaseScoreMaxDecreaseButton.setMargin(new Insets(2, 2, 2, 2));
        this.purchaseScoreMaxDecreaseButton.setPreferredSize(new Dimension(30, 20));
        this.purchaseScoreMaxDecreaseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PurchaseModeFrame.this.purchaseScoreMaxDecreaseButtonActionPerformed();
            }
        });
        this.jPanel2.add(this.purchaseScoreMaxDecreaseButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.purchaseMethodPanel.setLayout(new GridBagLayout());
        this.purchaseMethodPanel.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.purchaseMethodPanel, gridBagConstraints);
        this.purchaseMethodNamePanel.setLayout(new FlowLayout(0, 2, 5));
        this.savedMethodLabel.setText("Saved Methods:");
        this.savedMethodLabel.setPreferredSize(new Dimension(140, 15));
        this.purchaseMethodNamePanel.add(this.savedMethodLabel);
        this.purchaseMethodNamePanel.add(this.currentPurchaseMethods);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.purchaseMethodNamePanel, gridBagConstraints);
        this.purchaseMethodPanel.add((Component)this.purchaseMethodNamePanel, gridBagConstraints);
        this.purchaseMethodPointsPanel.setLayout(new FlowLayout(0, 2, 5));
        this.methodPointsLabel.setText("Points:");
        this.methodPointsLabel.setPreferredSize(new Dimension(140, 15));
        this.purchaseMethodPointsPanel.add(this.methodPointsLabel);
        this.purchaseMethodPointsEdit.setHorizontalAlignment(4);
        this.purchaseMethodPointsEdit.setEditable(false);
        this.purchaseMethodPointsEdit.setPreferredSize(new Dimension(30, 20));
        this.purchaseMethodPointsPanel.add(this.purchaseMethodPointsEdit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.purchaseMethodPanel.add((Component)this.purchaseMethodPointsPanel, gridBagConstraints);
        this.currentPurchaseMethods.setPreferredSize(new Dimension(140, 21));
        this.currentPurchaseMethods.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PurchaseModeFrame.this.currentPurchaseMethodsActionPerformed();
            }
        });
        this.purchaseMethodButtonPanel.setLayout(new FlowLayout(2));
        this.addMethodButton.setText("New");
        this.addMethodButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PurchaseModeFrame.this.addMethodButtonActionPerformed();
            }
        });
        this.purchaseMethodButtonPanel.add(this.addMethodButton);
        this.removeMethodButton.setText("Remove");
        this.removeMethodButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PurchaseModeFrame.this.removeMethodButtonActionPerformed();
            }
        });
        this.purchaseMethodButtonPanel.add(this.removeMethodButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.purchaseMethodPanel.add((Component)this.purchaseMethodButtonPanel, gridBagConstraints);
        this.statusBar.setText("Set the cost for each ability score");
        this.statusBar.setBorder(new BevelBorder(1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.statusBar, gridBagConstraints);
        this.jPanel3.setLayout(new FlowLayout(2));
        this.okButton.setText("OK");
        this.okButton.setToolTipText("Accept these values");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PurchaseModeFrame.this.okButtonActionPerformed();
            }
        });
        this.jPanel3.add(this.okButton);
        this.resetButton.setText("Reset");
        this.resetButton.setToolTipText("Reset to saved values");
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PurchaseModeFrame.this.resetButtonActionPerformed();
            }
        });
        this.jPanel3.add(this.resetButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Cancel Purchase Mode Configuration");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PurchaseModeFrame.this.cancelButtonActionPerformed();
            }
        });
        this.jPanel3.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jScrollPane1.setViewportBorder(new BevelBorder(1));
        this.jScrollPane1.setPreferredSize(new Dimension(100, 200));
        this.purchaseModel = new PurchaseModel();
        this.renewAbilityScoreCostTable();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.pack();
        this.initializeCurrentPurchaseMethods();
    }

    private void initializeCurrentPurchaseMethods() {
        int methodCount = SettingsHandler.getPurchaseMethodCount();
        if (methodCount > 0) {
            PointBuyMethod[] methods = new PointBuyMethod[methodCount];
            for (int i = 0; i < methodCount; ++i) {
                methods[i] = SettingsHandler.getPurhaseMethod(i);
            }
            this.currentPurchaseMethods.setModel(new DefaultComboBoxModel<PointBuyMethod>(methods));
        }
        this.currentPurchaseMethodsActionPerformed();
    }

    private void okButtonActionPerformed() {
        this.purchaseModel.keepNewValues();
        this.dispose();
    }

    private void purchaseScoreMaxDecreaseButtonActionPerformed() {
        int oldValue = this.purchaseModel.getPurchaseScoreMax();
        String valueString = this.purchaseScoreMaxEdit.getText();
        int value = this.convertStringToInt(valueString);
        if (value == -1) {
            this.statusBar.setText("Bad value for purchase maximum score, fixing...");
        } else if (!this.purchaseModel.setPurchaseScoreMax(value - 1)) {
            this.statusBar.setText("Purchase Score Maximum value can no go below Purchase Score Minimum!");
        }
        this.updatePurchaseScoreMax(oldValue);
    }

    private void purchaseScoreMaxIncreaseButtonActionPerformed() {
        int oldValue = this.purchaseModel.getPurchaseScoreMax();
        String valueString = this.purchaseScoreMaxEdit.getText();
        int value = this.convertStringToInt(valueString);
        boolean updateOk = false;
        if (!Globals.checkRule("ABILRANGE") && value == 18) {
            this.statusBar.setText("May not increase score past 18 in standard mode");
            return;
        }
        if (value == -1) {
            this.statusBar.setText("Bad value for purchase maximum score, fixing...");
        } else {
            updateOk = this.purchaseModel.setPurchaseScoreMax(value + 1);
        }
        this.updatePurchaseScoreMax(oldValue);
        if (updateOk) {
            this.purchaseModel.setValueAt(new Integer(this.purchaseModel.predictNextPurchaseCostMax()), this.purchaseModel.getRowCount() - 1, 1);
        }
    }

    private void purchaseScoreMinDecreaseButtonActionPerformed() {
        int oldValue = this.purchaseModel.getPurchaseScoreMin();
        String valueString = this.purchaseScoreMinEdit.getText();
        int value = this.convertStringToInt(valueString);
        boolean updateOk = false;
        if (!Globals.checkRule("ABILRANGE") && value == 8) {
            this.statusBar.setText("May not decrease score past 8 in standard mode");
            return;
        }
        if (value == -1) {
            this.statusBar.setText("Bad value for purchase minimum score, fixing...");
        } else {
            updateOk = this.purchaseModel.setPurchaseScoreMin(value - 1);
            if (!updateOk) {
                this.statusBar.setText("Purchase Score Minimum value is 0!");
            }
        }
        this.updatePurchaseScoreMin(oldValue);
        if (updateOk) {
            this.purchaseModel.setValueAt(new Integer(this.purchaseModel.predictNextPurchaseCostMin()), 0, 1);
        }
    }

    private void purchaseScoreMinIncreaseButtonActionPerformed() {
        int oldValue = this.purchaseModel.getPurchaseScoreMin();
        String valueString = this.purchaseScoreMinEdit.getText();
        int value = this.convertStringToInt(valueString);
        if (value == -1) {
            this.statusBar.setText("Bad value for purchase minimum score, fixing...");
        } else if (!this.purchaseModel.setPurchaseScoreMin(value + 1)) {
            this.statusBar.setText("Purchase Score Minimum value can not exceed Purchase Score Maximum Value!");
        }
        this.updatePurchaseScoreMin(oldValue);
    }

    private void removeMethodButtonActionPerformed() {
        PointBuyMethod method = (PointBuyMethod)this.currentPurchaseMethods.getSelectedItem();
        if (method != null) {
            this.currentPurchaseMethods.removeItem(method);
        }
    }

    private void renewAbilityScoreCostTable() {
        this.abilityScoreCostTable = new JTable();
        this.abilityScoreCostTable.setBorder(new BevelBorder(1));
        this.abilityScoreCostTable.setModel(this.purchaseModel);
        this.abilityScoreCostTable.setToolTipText("Set the cost for each ability score");
        this.jScrollPane1.setViewportView(this.abilityScoreCostTable);
    }

    private void resetButtonActionPerformed() {
        this.purchaseModel.copySavedToCurrent();
        this.updatePurchaseScoreMin(-1);
        this.updatePurchaseScoreMax(-1);
        this.purchaseModel.fireTableStructureChanged();
        this.initializeCurrentPurchaseMethods();
    }

    private void updatePurchaseScoreMax(int oldValue) {
        int score = this.purchaseModel.getPurchaseScoreMax();
        this.purchaseScoreMaxEdit.setText(Integer.toString(score));
        if (oldValue != -1 && oldValue != score) {
            this.purchaseModel.appendRows(score - oldValue);
            this.purchaseModel.fireTableStructureChanged();
        }
    }

    private void updatePurchaseScoreMin(int oldValue) {
        int score = this.purchaseModel.getPurchaseScoreMin();
        this.purchaseScoreMinEdit.setText(Integer.toString(score));
        if (oldValue != -1 && oldValue != score) {
            this.purchaseModel.prependRows(score - oldValue);
            this.purchaseModel.fireTableStructureChanged();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PurchaseModel
    extends AbstractTableModel {
        private boolean[] canEdit = new boolean[]{false, true};
        private String[] columnHeaders = new String[]{"Ability Score", "Cost"};
        private Object[][] currentValues = null;
        private Object[][] savedValues = null;
        private Class[] types = new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = PurchaseModeFrame.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = PurchaseModeFrame.class$("java.lang.Integer")) : class$java$lang$Integer};
        private int currentPurchaseScoreMax = 10;
        private int currentPurchaseScoreMin = 10;
        private int savedPurchaseScoreMax = 0;
        private int savedPurchaseScoreMin = 0;

        PurchaseModel() {
            this.initValues();
            this.copySavedToCurrent();
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.canEdit[columnIndex];
        }

        public Class getColumnClass(int columnIndex) {
            return this.types[columnIndex];
        }

        public int getColumnCount() {
            return this.columnHeaders.length;
        }

        public String getColumnName(int param) {
            return this.columnHeaders[param];
        }

        public int getRowCount() {
            return this.currentValues.length;
        }

        public void setValueAt(Object obj, int row, int column) {
            if (row < 0 || row >= this.currentValues.length) {
                throw new ArrayIndexOutOfBoundsException("Row index out of bounds: " + row);
            }
            if (column != 0 && column != 1) {
                throw new ArrayIndexOutOfBoundsException("Column index out of bounds: " + column);
            }
            this.currentValues[row][column] = obj;
            this.fireTableCellUpdated(row, column);
        }

        public Object getValueAt(int row, int column) {
            if (row < 0 || row >= this.currentValues.length) {
                throw new ArrayIndexOutOfBoundsException("Row index out of bounds: " + row);
            }
            if (column == 0 || column == 1) {
                return this.currentValues[row][column];
            }
            throw new ArrayIndexOutOfBoundsException("Column index out of bounds: " + column);
        }

        public void copySavedToCurrent() {
            if (this.savedValues != null) {
                this.currentPurchaseScoreMin = this.savedPurchaseScoreMin;
                this.currentPurchaseScoreMax = this.savedPurchaseScoreMax;
                int nrEntries = this.currentPurchaseScoreMax - this.currentPurchaseScoreMin + 1;
                this.currentValues = new Object[nrEntries][2];
                for (int i = 0; i < nrEntries; ++i) {
                    this.currentValues[i][0] = this.savedValues[i][0];
                    this.currentValues[i][1] = this.savedValues[i][1];
                }
            }
        }

        public void initValues() {
            int[] scoreCosts = SettingsHandler.getAbilityScoreCost();
            if (scoreCosts != null) {
                this.savedPurchaseScoreMin = SettingsHandler.getPurchaseScoreMin();
                this.savedPurchaseScoreMax = SettingsHandler.getPurchaseScoreMax();
                this.savedValues = new Object[scoreCosts.length][2];
                for (int i = this.savedPurchaseScoreMin; i <= this.savedPurchaseScoreMax; ++i) {
                    int index = i - this.savedPurchaseScoreMin;
                    this.savedValues[index][0] = new Integer(i);
                    this.savedValues[index][1] = new Integer(scoreCosts[index]);
                }
            } else {
                this.savedPurchaseScoreMin = 10;
                this.savedPurchaseScoreMax = 10;
                scoreCosts = new int[]{0};
                this.savedValues = new Object[1][2];
                this.savedValues[0][0] = new Integer(10);
                this.savedValues[0][1] = new Integer(0);
            }
            PurchaseModeFrame.this.purchaseScoreMinEdit.setText(Integer.toString(this.savedPurchaseScoreMin));
            PurchaseModeFrame.this.purchaseScoreMaxEdit.setText(Integer.toString(this.savedPurchaseScoreMax));
        }

        public int predictNextPurchaseCostMax() {
            int maxIndex = this.getRowCount() - 2;
            int max = (Integer)this.getValueAt(maxIndex, 1);
            if (this.getRowCount() == 2) {
                return max + 1;
            }
            int penultimate = (Integer)this.getValueAt(maxIndex - 1, 1);
            return max + (max - penultimate);
        }

        public int predictNextPurchaseCostMin() {
            int minIndex = 1;
            int min = (Integer)this.getValueAt(minIndex, 1);
            if (this.getRowCount() == 2) {
                return min - 1;
            }
            int penultimate = (Integer)this.getValueAt(minIndex + 1, 1);
            return min - (penultimate - min);
        }

        boolean setPurchaseScoreMax(int purchaseScoreMax) {
            if (purchaseScoreMax >= 0 && purchaseScoreMax >= this.currentPurchaseScoreMin) {
                this.currentPurchaseScoreMax = purchaseScoreMax;
                return true;
            }
            return false;
        }

        int getPurchaseScoreMax() {
            return this.currentPurchaseScoreMax;
        }

        boolean setPurchaseScoreMin(int purchaseScoreMin) {
            if (purchaseScoreMin >= 0 && purchaseScoreMin <= this.currentPurchaseScoreMax) {
                this.currentPurchaseScoreMin = purchaseScoreMin;
                return true;
            }
            return false;
        }

        int getPurchaseScoreMin() {
            return this.currentPurchaseScoreMin;
        }

        void appendRows(int nrRows) {
            int nrEntries = this.currentPurchaseScoreMax - this.currentPurchaseScoreMin + 1;
            Object[][] newValues = new Object[nrEntries][2];
            if (nrRows < 0) {
                System.arraycopy(this.currentValues, 0, newValues, 0, nrEntries);
            } else {
                System.arraycopy(this.currentValues, 0, newValues, 0, this.currentValues.length);
                int preLength = this.currentValues.length;
                for (int i = 0; i < nrRows; ++i) {
                    int score = i + this.currentPurchaseScoreMax - nrRows + 1;
                    int preVal = -1;
                    newValues[i + preLength][0] = new Integer(score);
                    if (i + preLength != 0) {
                        preVal = (Integer)newValues[i + preLength - 1][1];
                    }
                    newValues[i + preLength][1] = new Integer(preVal + 1);
                }
            }
            this.currentValues = newValues;
        }

        void keepNewValues() {
            int i;
            SettingsHandler.clearPointBuyStatCosts();
            for (i = this.currentPurchaseScoreMin; i <= this.currentPurchaseScoreMax; ++i) {
                SettingsHandler.addPointBuyStatCost(i, (Integer)this.currentValues[i - this.currentPurchaseScoreMin][1]);
            }
            SettingsHandler.clearPurchaseModeMethods();
            int x = PurchaseModeFrame.this.currentPurchaseMethods.getItemCount();
            for (i = 0; i < x; ++i) {
                PointBuyMethod pbm = (PointBuyMethod)PurchaseModeFrame.this.currentPurchaseMethods.getItemAt(i);
                SettingsHandler.addPurchaseModeMethod(pbm.getMethodName(), pbm.getPoints());
            }
        }

        void prependRows(int nrRows) {
            int nrEntries = this.currentPurchaseScoreMax - this.currentPurchaseScoreMin + 1;
            Object[][] newValues = new Object[nrEntries][2];
            if (nrRows > 0) {
                System.arraycopy(this.currentValues, nrRows, newValues, 0, nrEntries);
            } else {
                nrRows = Math.abs(nrRows);
                System.arraycopy(this.currentValues, 0, newValues, nrRows, this.currentValues.length);
                for (int i = 0; i < nrRows; ++i) {
                    int score = i + this.currentPurchaseScoreMin;
                    newValues[i][0] = new Integer(score);
                }
            }
            this.currentValues = newValues;
        }
    }
}

