/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SourceLoadProgressPanel
extends JPanel {
    private JProgressBar jProgressBar = null;
    private JLabel jLabel = null;
    private JTextArea jTextArea = null;
    private JScrollPane scrollPane = null;
    private boolean errorState = false;

    public SourceLoadProgressPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints consGridBagConstraints3 = new GridBagConstraints();
        GridBagConstraints consGridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints consGridBagConstraints4 = new GridBagConstraints();
        consGridBagConstraints3.gridx = 0;
        consGridBagConstraints3.gridy = 1;
        consGridBagConstraints3.ipadx = 0;
        consGridBagConstraints3.ipady = 0;
        consGridBagConstraints3.weightx = 1.0;
        consGridBagConstraints3.fill = 2;
        consGridBagConstraints3.insets = new Insets(5, 10, 5, 10);
        consGridBagConstraints2.gridx = 0;
        consGridBagConstraints2.gridy = 0;
        consGridBagConstraints2.ipadx = 0;
        consGridBagConstraints2.ipady = 0;
        consGridBagConstraints2.weightx = 1.0;
        consGridBagConstraints2.fill = 2;
        consGridBagConstraints2.insets = new Insets(0, 10, 5, 10);
        consGridBagConstraints4.gridx = 0;
        consGridBagConstraints4.gridy = 2;
        consGridBagConstraints4.weightx = 1.0;
        consGridBagConstraints4.weighty = 2.0;
        consGridBagConstraints4.fill = 1;
        consGridBagConstraints4.ipadx = 340;
        consGridBagConstraints4.ipady = 40;
        consGridBagConstraints4.insets = new Insets(5, 0, 0, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJProgressBar(), consGridBagConstraints2);
        this.add((Component)this.getJLabel(), consGridBagConstraints3);
        this.add((Component)this.getScrollPane(), consGridBagConstraints4);
        this.setSize(594, 193);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private JProgressBar getJProgressBar() {
        if (this.jProgressBar == null) {
            this.jProgressBar = new JProgressBar();
            this.jProgressBar.setValue(17);
            this.jProgressBar.setStringPainted(true);
        }
        return this.jProgressBar;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("Current File Name");
            this.jLabel.setFont(new Font("Dialog", 0, 12));
            this.jLabel.setName("labelCurrentFileName");
        }
        return this.jLabel;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
            this.jTextArea.setName("errorMessageBox");
            this.jTextArea.setEditable(false);
            this.jTextArea.setTabSize(8);
        }
        return this.jTextArea;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.getJTextArea());
        }
        return this.scrollPane;
    }

    public void setMaxProgress(int max) {
        this.getJProgressBar().setMaximum(max);
    }

    public void setCutrrentProgress(int curr) {
        this.getJProgressBar().setValue(curr);
    }

    public void setCurrentFilename(String filename) {
        Graphics g = this.getJLabel().getGraphics();
        FontMetrics fm = g.getFontMetrics();
        int width = fm.stringWidth(filename);
        if (width < this.getJLabel().getWidth()) {
            this.getJLabel().setText(filename);
        } else {
            this.getJLabel().setText(this.shortenString(fm, filename, this.getJLabel().getWidth()));
        }
    }

    private String shortenString(FontMetrics fm, String string, int maxWidth) {
        for (int i = string.length(); i > 0; i -= 5) {
            String foo = "..." + string.substring(string.length() - i);
            int width = fm.stringWidth(foo);
            if (width >= maxWidth) continue;
            return foo;
        }
        return "";
    }

    public void addMessage(String message) {
        this.getJTextArea().append(message + "\n");
    }

    public void setErrorState(boolean aBool) {
        this.errorState = aBool;
    }

    public boolean getErrorState() {
        return this.errorState;
    }
}

