/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JOptionPane;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.gui.CsheetFilter;

class TemplateListModel
extends AbstractListModel {
    private CsheetFilter csheetFilter = null;
    private CsheetFilter psheetFilter = null;
    private String fileType = null;
    private String[] cSheets;
    private String[] pSheets;
    private boolean partyMode = false;
    private int attempts = 0;

    public TemplateListModel(CsheetFilter argCsheetFilter, CsheetFilter argPsheetFilter, boolean argPartyMode, String argFileType) {
        this.csheetFilter = argCsheetFilter;
        this.psheetFilter = argPsheetFilter;
        this.partyMode = argPartyMode;
        this.fileType = argFileType;
        this.updateTemplateList();
    }

    public Object getElementAt(int index) {
        if (this.partyMode) {
            if (index >= this.pSheets.length) {
                return null;
            }
            return this.pSheets[index];
        }
        if (index >= this.cSheets.length) {
            return null;
        }
        return this.cSheets[index];
    }

    public int getSize() {
        if (this.partyMode) {
            return this.pSheets.length;
        }
        return this.cSheets.length;
    }

    public int indexOf(Object o) {
        if (this.partyMode) {
            return Arrays.binarySearch(this.pSheets, o);
        }
        return Arrays.binarySearch(this.cSheets, o);
    }

    public void updateTemplateList() {
        int i;
        this.csheetFilter.setDirFilter(this.fileType);
        this.csheetFilter.setIgnoreExtension(".");
        List aList = this.csheetFilter.getAccepted();
        if (aList.size() == 0 && this.attempts == 0) {
            Object[] options = new Object[]{"OK", "CANCEL"};
            if (JOptionPane.showOptionDialog(null, "No templates found. Attempt to change to " + Globals.getDefaultPath() + File.separator + "outputsheets ?", "Warning", -1, 2, null, options, options[0]) == 0) {
                SettingsHandler.setPcgenOutputSheetDir(new File(Globals.getDefaultPath() + File.separator + "outputsheets"));
                this.attempts = 1;
                aList = this.csheetFilter.getAccepted();
            }
        }
        this.cSheets = new String[aList.size()];
        for (i = 0; i < aList.size(); ++i) {
            this.cSheets[i] = aList.get(i).toString();
        }
        this.psheetFilter.setDirFilter(this.fileType);
        this.psheetFilter.setIgnoreExtension(".");
        aList = this.psheetFilter.getAccepted();
        this.pSheets = new String[aList.size()];
        for (i = 0; i < aList.size(); ++i) {
            this.pSheets[i] = aList.get(i).toString();
        }
        Arrays.sort(this.pSheets);
        Arrays.sort(this.cSheets);
    }

    public boolean isPartyMode() {
        return this.partyMode;
    }

    public void setPartyMode(boolean b) {
        this.partyMode = b;
    }
}

