/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pcgen.core.SettingsHandler;
import pcgen.gui.utils.Hyperactive;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

final class TipOfTheDay
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 6109389084434712217L;
    private static final String NEXT = "next";
    private static final String HTML_START = "<html><body style=\"margin-left: 5px;margin-right: 5px;margin-top: 5px\">";
    private static final String HTML_END = "</body></html>";
    private JCheckBox chkShowTips;
    private JLabelPane tipText;
    private List tipList = null;
    private int lastNumber = -1;

    TipOfTheDay() {
        IconUtilitities.maybeSetIcon(this, "TipOfTheDay16.gif");
        this.setTitle(PropertyFactory.getString("in_tod_title"));
        this.initUI();
        this.loadTips();
        this.pack();
        Utility.centerFrame(this, false);
        this.lastNumber = SettingsHandler.getLastTipShown();
        this.showNextTip();
    }

    public void actionPerformed(ActionEvent e) {
        if (NEXT.equals(e.getActionCommand())) {
            this.showNextTip();
            return;
        }
        this.quit();
    }

    private boolean hasTips() {
        return this.tipList != null && this.tipList.size() > 0;
    }

    private void initUI() {
        JPanel panel = new JPanel(new BorderLayout(2, 2));
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        ImageIcon icon = IconUtilitities.getImageIcon("TipOfTheDay24.gif");
        JLabel iconLabel = icon != null ? new JLabel(icon) : new JLabel("TipOfTheDay24.gif");
        iconLabel.setOpaque(true);
        panel.add((Component)iconLabel, "West");
        JLabel lblDidYouKnow = new JLabel("    " + PropertyFactory.getString("in_tod_didyouknow"));
        Font old = lblDidYouKnow.getFont();
        lblDidYouKnow.setFont(old.deriveFont(old.getStyle() | 2, 18.0f));
        lblDidYouKnow.setOpaque(true);
        this.tipText = new JLabelPane();
        this.tipText.setBorder(null);
        this.tipText.addHyperlinkListener(new Hyperactive());
        JScrollPane pane = new JScrollPane(this.tipText);
        pane.setBorder(null);
        JPanel content = new JPanel(new BorderLayout(0, 2));
        content.add((Component)lblDidYouKnow, "North");
        content.add((Component)pane, "Center");
        content.setPreferredSize(new Dimension(585, 230));
        panel.add((Component)content, "Center");
        this.chkShowTips = new JCheckBox(PropertyFactory.getString("in_tod_showTips"), SettingsHandler.getShowTipOfTheDay());
        JButton btnClose = new JButton(PropertyFactory.getString("in_close"));
        btnClose.setMnemonic(PropertyFactory.getMnemonic("in_mn_close"));
        btnClose.addActionListener(this);
        JButton btnNextTip = new JButton(PropertyFactory.getString("in_tod_nextTip"));
        btnNextTip.setMnemonic(PropertyFactory.getMnemonic("in_mn_tod_nextTip"));
        btnNextTip.addActionListener(this);
        btnNextTip.setActionCommand(NEXT);
        JPanel actions = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0);
        actions.add((Component)this.chkShowTips, c);
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(btnNextTip);
        buttons.add(btnClose);
        c.gridx = 1;
        c.anchor = 13;
        actions.add((Component)buttons, c);
        panel.add((Component)actions, "South");
        this.setContentPane(panel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TipOfTheDay.this.quit();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    TipOfTheDay.this.quit();
                }
            }
        });
    }

    private void loadTips() {
        this.tipList = new ArrayList(20);
        String tipsFilePath = SettingsHandler.getPcgenSystemDir() + File.separator + "tips.lst";
        try {
            File tipsFile = new File(tipsFilePath);
            BufferedReader tipsReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tipsFile), "UTF-8"));
            int length = (int)tipsFile.length();
            char[] inputLine = new char[length];
            tipsReader.read(inputLine, 0, length);
            tipsReader.close();
            StringTokenizer aTok = new StringTokenizer(new String(inputLine), "\r\n", false);
            while (aTok.hasMoreTokens()) {
                this.tipList.add(aTok.nextToken());
            }
        }
        catch (FileNotFoundException e) {
            Logging.errorPrint("Could not find tips.lst at " + tipsFilePath, e);
        }
        catch (IOException e) {
            Logging.errorPrint("Could not find tips.lst at " + tipsFilePath, e);
        }
    }

    private void quit() {
        this.setVisible(false);
        SettingsHandler.setLastTipShown(this.lastNumber);
        SettingsHandler.setShowTipOfTheDay(this.chkShowTips.isSelected());
        this.dispose();
    }

    private void showNextTip() {
        if (this.hasTips()) {
            if (++this.lastNumber >= this.tipList.size()) {
                this.lastNumber = 0;
            }
            String tip = (String)this.tipList.get(this.lastNumber);
            try {
                this.tipText.setText("<html><body style=\"margin-left: 5px;margin-right: 5px;margin-top: 5px\"><b>Tip#" + Integer.toString(this.lastNumber + 1) + "</b><br>" + tip + HTML_END);
                this.repaint();
            }
            catch (Exception exc) {
                exc.printStackTrace(System.err);
            }
        }
    }
}

