/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.utils.SkinManager;
import pcgen.util.Logging;
import pcgen.util.SkinLFResourceChecker;

public final class UIFactory {
    private static String[][] lafData;
    private static final int NAME = 0;
    private static final int CLASSNAME = 1;
    private static final int TOOLTIP = 2;
    private static final int systemIndex = 0;
    private static final int crossPlatformIndex = 1;
    private static final boolean windowsPlatform;

    public static void setLookAndFeel(int looknfeel) {
        UIFactory.setLookAndFeel(new Integer(looknfeel));
    }

    public static int getLookAndFeelCount() {
        return lafData.length;
    }

    public static String getLookAndFeelName(int index) {
        if (index == lafData.length) {
            return "Skinned";
        }
        return lafData[index][0];
    }

    public static String getLookAndFeelTooltip(int index) {
        if (index == lafData.length) {
            return "Sets the look to skinned";
        }
        return lafData[index][2];
    }

    public static boolean isWindowsUI() {
        String lnfName = UIFactory.getLookAndFeelName(SettingsHandler.getLookAndFeel());
        return lnfName.equals("Windows") || lnfName.equals("System") && UIFactory.isWindowsPlatform();
    }

    public static int indexOfCrossPlatformLookAndFeel() {
        return 1;
    }

    public static void initLookAndFeel() {
        block7: {
            if (SettingsHandler.getLookAndFeel() < lafData.length) {
                UIFactory.setLookAndFeel(new Integer(SettingsHandler.getLookAndFeel()));
            } else if (SettingsHandler.getLookAndFeel() == lafData.length) {
                try {
                    if (SkinLFResourceChecker.getMissingResourceCount() == 0) {
                        SkinManager.applySkin();
                        break block7;
                    }
                    Logging.errorPrint(SkinLFResourceChecker.getMissingResourceMessage());
                    UIFactory.setLookAndFeel(lafData[1][1]);
                }
                catch (Exception e) {
                    SettingsHandler.setLookAndFeel(0);
                    UIFactory.setLookAndFeel(lafData[1][1]);
                    ShowMessageDelegate.showMessageDialog("There was a problem setting the skinned look and feel.\nThe look and feel has been reset to cross-platform.\nError: " + e.toString(), "PCGen", MessageType.ERROR);
                }
            } else {
                SettingsHandler.setLookAndFeel(0);
                UIFactory.setLookAndFeel(lafData[1][1]);
            }
        }
    }

    private static void setLookAndFeel(Object looknfeel) {
        try {
            if (looknfeel instanceof String) {
                UIManager.setLookAndFeel((String)looknfeel);
            } else if (looknfeel instanceof LookAndFeel) {
                UIManager.setLookAndFeel((LookAndFeel)looknfeel);
            } else if (looknfeel instanceof Integer) {
                UIManager.setLookAndFeel(lafData[(Integer)looknfeel][1]);
            }
            LookAndFeel laf = UIManager.getLookAndFeel();
            if (laf instanceof MetalLookAndFeel) {
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            }
            PCGen_Frame1.getInst().getPcgenMenuBar().separateHelpMenu(!UIFactory.isWindowsUI());
        }
        catch (Exception e) {
            Logging.errorPrint("Exception in UIFactory::setLookAndFeel", e);
        }
        SwingUtilities.updateComponentTreeUI(Globals.getRootFrame());
    }

    private static boolean isWindowsPlatform() {
        return windowsPlatform;
    }

    static {
        int i;
        windowsPlatform = System.getProperty("os.name").startsWith("Windows ");
        UIManager.installLookAndFeel("Kunststoff", "com.incors.plaf.kunststoff.KunststoffLookAndFeel");
        try {
            if (SkinLFResourceChecker.getMissingResourceCount() == 0) {
                SkinManager.loadLinuxSkin();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
        lafData = new String[lafInfo.length][3];
        UIFactory.lafData[0][0] = "System";
        UIFactory.lafData[0][1] = UIManager.getSystemLookAndFeelClassName();
        UIFactory.lafData[0][2] = "Sets the look to that of the System you are using";
        int j = 1;
        if (!lafData[0][1].equals(UIManager.getCrossPlatformLookAndFeelClassName())) {
            UIFactory.lafData[1][0] = "Java";
            UIFactory.lafData[1][1] = UIManager.getCrossPlatformLookAndFeelClassName();
            UIFactory.lafData[1][2] = "Sets the look to that of Java's cross platform look";
            ++j;
        }
        for (i = 0; i < lafInfo.length && j < lafData.length; ++i) {
            UIFactory.lafData[j][1] = lafInfo[i].getClassName();
            if (lafData[j][1].equals(UIManager.getSystemLookAndFeelClassName()) || lafData[j][1].equals(UIManager.getCrossPlatformLookAndFeelClassName())) continue;
            UIFactory.lafData[j][0] = lafInfo[i].getName();
            UIFactory.lafData[j][2] = "Sets the look to " + lafData[j][0] + " look";
            ++j;
        }
        if (!UIFactory.isWindowsPlatform()) {
            for (i = 0; i < lafInfo.length; ++i) {
                if (!lafInfo[i].getClassName().endsWith("WindowsLookAndFeel")) continue;
                lafInfo[i] = new UIManager.LookAndFeelInfo(lafInfo[i].getName(), "pcgen.gui.FakeWindowsLookAndFeel");
                break;
            }
        }
        UIManager.setInstalledLookAndFeels(lafInfo);
        if (!UIFactory.isWindowsPlatform()) {
            for (i = 0; i < lafData.length; ++i) {
                if (!lafData[i][1].endsWith("WindowsLookAndFeel")) continue;
                UIFactory.lafData[i][1] = "pcgen.gui.FakeWindowsLookAndFeel";
                break;
            }
        }
    }
}

