/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.Race;
import pcgen.gui.editor.PObjectUpdater;
import pcgen.util.PropertyFactory;

final class AgePanel
extends JPanel
implements PObjectUpdater {
    static final long serialVersionUID = -5835737108073399178L;
    private static String defaultRegionName = "None";
    private static final int COL_MINAGE = 1;
    private AgeTableModel ageModel = null;

    AgePanel() {
        this.initComponents();
    }

    public void updateData(PObject obj) {
        if (!(obj instanceof Race)) {
            return;
        }
        Race race = (Race)obj;
        String region = race.getRegionString();
        if (region == null) {
            region = defaultRegionName;
        }
        String raceName = race.getName();
        this.ageModel.saveValues(region, raceName);
    }

    public void updateView(PObject obj) {
        if (!(obj instanceof Race)) {
            return;
        }
        Race race = (Race)obj;
        String region = race.getRegionString();
        if (region == null) {
            region = defaultRegionName;
        }
        String raceName = race.getName();
        this.ageModel.reset(region, raceName);
    }

    private void initComponents() {
        this.ageModel = new AgeTableModel("", null);
        JTable table = new JTable(this.ageModel);
        table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        JScrollPane scrollPane = new JScrollPane(table);
        this.add(scrollPane);
    }

    static final class AgeTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{PropertyFactory.getString("in_demAgeName"), PropertyFactory.getString("in_demAgeMin"), PropertyFactory.getString("in_demAgeRoll"), PropertyFactory.getString("in_demAgeMax")};
        private List data = null;

        AgeTableModel(String region, String raceName) {
            this.reset(region, raceName);
        }

        public boolean isCellEditable(int row, int col) {
            return col >= 1;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public int getRowCount() {
            return this.data.size();
        }

        public void setValueAt(Object value, int row, int col) {
            Object[] rowData = (Object[])this.data.get(row);
            rowData[col] = value;
            this.fireTableCellUpdated(row, col);
        }

        public Object getValueAt(int row, int col) {
            Object[] rowData = (Object[])this.data.get(row);
            if (rowData == null || col < 0 || col > rowData.length) {
                return null;
            }
            return rowData[col];
        }

        void reset(String region, String raceName) {
            if (region == null || region.length() == 0) {
                region = defaultRegionName;
            }
            this.data = new ArrayList();
            Map ageMap = Globals.getBioSet().getAgeMap();
            TreeSet sortedAges = new TreeSet(ageMap.keySet());
            Iterator e = sortedAges.iterator();
            while (e.hasNext()) {
                String keyValue = (String)e.next();
                if (!keyValue.startsWith(region)) continue;
                String dataValue = (String)ageMap.get(keyValue);
                StringTokenizer tok = new StringTokenizer(dataValue, "\t");
                Object[] ageSet = new Object[]{tok.nextToken(), "", "", "", keyValue};
                this.data.add(ageSet);
            }
            if (raceName != null) {
                Object[] element;
                String value;
                Iterator iter;
                Iterator dI;
                ArrayList dataValues = Globals.getBioSet().getTagForRace(region, raceName, "BASEAGE");
                if (dataValues != null) {
                    dI = dataValues.iterator();
                    iter = this.data.iterator();
                    while (iter.hasNext() && dI.hasNext()) {
                        value = (String)dI.next();
                        element = (Object[])iter.next();
                        element[1] = value;
                    }
                }
                if (dataValues != null) {
                    dataValues = Globals.getBioSet().getTagForRace(region, raceName, "AGEDIEROLL");
                    dI = dataValues.iterator();
                    iter = this.data.iterator();
                    while (iter.hasNext() && dI.hasNext()) {
                        value = (String)dI.next();
                        element = (Object[])iter.next();
                        element[2] = value;
                    }
                }
                if (dataValues != null) {
                    dataValues = Globals.getBioSet().getTagForRace(region, raceName, "MAXAGE");
                    dI = dataValues.iterator();
                    iter = this.data.iterator();
                    while (iter.hasNext() && dI.hasNext()) {
                        value = (String)dI.next();
                        element = (Object[])iter.next();
                        element[3] = value;
                    }
                }
            }
        }

        void saveValues(String region, String raceName) {
            if (region == null || region.length() == 0) {
                region = defaultRegionName;
            }
            Globals.getBioSet().removeFromUserMap(region, raceName, "BASEAGE");
            Globals.getBioSet().removeFromUserMap(region, raceName, "AGEDIEROLL");
            Globals.getBioSet().removeFromUserMap(region, raceName, "MAXAGE");
            int currentAgeSetIndex = 0;
            Iterator iter = this.data.iterator();
            while (iter.hasNext()) {
                Object[] element = (Object[])iter.next();
                if (String.valueOf(element[1]).length() > 0) {
                    Globals.getBioSet().addToUserMap(region, raceName, "BASEAGE:" + String.valueOf(element[1]), currentAgeSetIndex);
                }
                if (String.valueOf(element[2]).length() > 0) {
                    Globals.getBioSet().addToUserMap(region, raceName, "AGEDIEROLL:" + String.valueOf(element[2]), currentAgeSetIndex);
                }
                if (String.valueOf(element[3]).length() > 0) {
                    Globals.getBioSet().addToUserMap(region, raceName, "MAXAGE:" + String.valueOf(element[3]), currentAgeSetIndex);
                }
                ++currentAgeSetIndex;
            }
        }
    }
}

