/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.Race;
import pcgen.gui.editor.EditUtil;
import pcgen.gui.editor.PObjectUpdater;
import pcgen.gui.editor.TypePanel;
import pcgen.util.PropertyFactory;

final class AppearancePanel
extends JPanel
implements PObjectUpdater {
    private static String defaultRegionName = "None";
    private TypePanel pnlEyeColor;
    private TypePanel pnlHairColor;
    private TypePanel pnlSkinTone;

    AppearancePanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void setEyeColorAvailableList(List aList, boolean sort) {
        this.pnlEyeColor.setAvailableList(aList, sort);
    }

    public void setHairColorAvailableList(List aList, boolean sort) {
        this.pnlHairColor.setAvailableList(aList, sort);
    }

    public void setSkinToneAvailableList(List aList, boolean sort) {
        this.pnlSkinTone.setAvailableList(aList, sort);
    }

    public void updateData(PObject obj) {
        if (!(obj instanceof Race)) {
            return;
        }
        Race race = (Race)obj;
        String region = race.getRegionString();
        if (region == null) {
            region = defaultRegionName;
        }
        String raceName = race.getName();
        Object[] sel = this.pnlHairColor.getSelectedList();
        String aString = EditUtil.delimitArray(sel, '|');
        Globals.getBioSet().removeFromUserMap(region, raceName, "HAIR");
        Globals.getBioSet().addToUserMap(region, raceName, "HAIR:" + aString, 0);
        sel = this.pnlEyeColor.getSelectedList();
        aString = EditUtil.delimitArray(sel, '|');
        Globals.getBioSet().removeFromUserMap(region, raceName, "EYES");
        Globals.getBioSet().addToUserMap(region, raceName, "EYES:" + aString, 0);
        sel = this.pnlSkinTone.getSelectedList();
        aString = EditUtil.delimitArray(sel, '|');
        Globals.getBioSet().removeFromUserMap(region, raceName, "SKINTONE");
        Globals.getBioSet().addToUserMap(region, raceName, "SKINTONE:" + aString, 0);
    }

    public void updateView(PObject obj) {
        if (!(obj instanceof Race)) {
            return;
        }
        Race race = (Race)obj;
        String region = race.getRegionString();
        if (region == null) {
            region = defaultRegionName;
        }
        String raceName = race.getName();
        ArrayList aList = Globals.getBioSet().getTagForRace(region, raceName, "HAIR");
        this.pnlHairColor.setSelectedList(aList, true);
        aList = Globals.getBioSet().getTagForRace(region, raceName, "EYES");
        this.pnlEyeColor.setSelectedList(aList, true);
        aList = Globals.getBioSet().getTagForRace(region, raceName, "SKINTONE");
        this.pnlSkinTone.setSelectedList(aList, true);
    }

    private void initComponentContents() {
    }

    private void initComponents() {
        this.pnlHairColor = new TypePanel(PropertyFactory.getString("in_appNewHairColor"), PropertyFactory.getString("in_appHairColor"));
        this.pnlEyeColor = new TypePanel(PropertyFactory.getString("in_appNewEyeColor"), PropertyFactory.getString("in_appEyeColor"));
        this.pnlSkinTone = new TypePanel(PropertyFactory.getString("in_appNewSkintoneColor"), PropertyFactory.getString("in_appSkintoneColor"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        this.add((Component)this.pnlHairColor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        this.add((Component)this.pnlEyeColor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        this.add((Component)this.pnlSkinTone, gridBagConstraints);
    }
}

