/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pcgen.gui.editor.EditUtil;
import pcgen.gui.editor.EditorAddFilter;
import pcgen.gui.editor.JListModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.util.PropertyFactory;

class AvailableSelectedPanel
extends JPanel {
    static final long serialVersionUID = -647497427782936111L;
    private EditorAddFilter addFilter = null;
    private JButton btnAdd;
    private JButton btnAdd2 = null;
    private JButton btnRemove;
    private JButton btnRemove2;
    private JLabel lblAvailable;
    private JLabel lblHeader;
    private JLabel lblSelected;
    private JLabel lblSelected2 = null;
    private JList lstAvailable;
    private JList lstSelected;
    private JList lstSelected2 = null;
    private JPanel pnlAvailable;
    private JPanel pnlExtra;
    private JPanel pnlHeader;
    private JPanel pnlSelected;
    private JPanel pnlSelected2;
    private JScrollPane scpAvailable;
    private JScrollPane scpSelected;
    private JScrollPane scpSelected2;

    AvailableSelectedPanel() {
        this(false);
    }

    AvailableSelectedPanel(boolean twoSelectedLists) {
        this.initComponents(twoSelectedLists);
    }

    final void setAddFilter(EditorAddFilter eaf) {
        this.addFilter = eaf;
    }

    void setAvailableList(List argAvailable, boolean argSort) {
        JListModel lmd = (JListModel)this.lstAvailable.getModel();
        lmd.setSort(argSort);
        int x = argAvailable.size();
        for (int i = 0; i < x; ++i) {
            lmd.addElement(argAvailable.get(i));
        }
    }

    Object[] getAvailableList() {
        return ((JListModel)this.lstAvailable.getModel()).getElements();
    }

    void setExtraLayout(LayoutManager manager) {
        this.pnlExtra.setLayout(manager);
    }

    void setHeader(String argHeader) {
        this.lblHeader.setText(argHeader);
        this.pnlHeader.setVisible(argHeader.length() != 0);
    }

    void setLblSelected2Text(String txt) {
        if (this.lblSelected2 != null) {
            this.lblSelected2.setText(txt);
        }
    }

    void setLblSelectedText(String txt) {
        this.lblSelected.setText(txt);
    }

    void setSelectedList(List argSelected, boolean argSort) {
        JListModel lmd = (JListModel)this.lstSelected.getModel();
        lmd.setSort(argSort);
        if (argSelected == null) {
            return;
        }
        int x = argSelected.size();
        for (int i = 0; i < x; ++i) {
            lmd.addElement(argSelected.get(i));
        }
    }

    Object[] getSelectedList() {
        return ((JListModel)this.lstSelected.getModel()).getElements();
    }

    void setSelectedList2(List argSelected, boolean argSort) {
        JListModel lmd = (JListModel)this.lstSelected2.getModel();
        lmd.setSort(argSort);
        int x = argSelected.size();
        for (int i = 0; i < x; ++i) {
            lmd.addElement(argSelected.get(i));
        }
    }

    Object[] getSelectedList2() {
        if (this.lstSelected2 != null) {
            return ((JListModel)this.lstSelected2.getModel()).getElements();
        }
        return null;
    }

    void addExtra(Component comp, Object constraints) {
        this.pnlExtra.setVisible(true);
        this.pnlExtra.add(comp, constraints);
    }

    void addItemToSelected(Object obj) {
        JListModel lmd = (JListModel)this.lstSelected.getModel();
        JListModel lms = (JListModel)this.lstAvailable.getModel();
        if (this.addFilter != null) {
            lmd.addElement(this.addFilter.encode(obj), false);
        } else {
            lmd.addElement(obj, false);
        }
        lms.removeElement(obj);
    }

    private void btnAddActionPerformed(JList lst, JButton btn) {
        this.swapEntries(lst, this.lstAvailable, btn, 1);
        if (this.btnAdd2 != null) {
            this.btnAdd.setEnabled(false);
            this.btnAdd2.setEnabled(false);
        }
    }

    private void btnRemoveActionPerformed(JList lst, JButton btn) {
        this.swapEntries(this.lstAvailable, lst, btn, -1);
    }

    private void initComponents(boolean twoSelectedLists) {
        try {
            this.btnAdd = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
            this.btnRemove = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        }
        catch (Exception exc) {
            this.btnAdd = new JButton(">");
            this.btnRemove = new JButton("<");
        }
        this.lblAvailable = new JLabel();
        this.lblHeader = new JLabel();
        this.lblSelected = new JLabel();
        this.lstAvailable = new JList(new JListModel(new ArrayList(), true));
        this.lstSelected = new JList(new JListModel(new ArrayList(), true));
        this.pnlAvailable = new JPanel();
        this.pnlExtra = new JPanel();
        this.pnlHeader = new JPanel();
        this.pnlSelected = new JPanel();
        this.scpAvailable = new JScrollPane();
        this.scpSelected = new JScrollPane();
        if (twoSelectedLists) {
            try {
                this.btnAdd2 = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
                this.btnRemove2 = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
            }
            catch (Exception exc) {
                this.btnAdd2 = new JButton();
                this.btnRemove2 = new JButton();
            }
            this.lblSelected2 = new JLabel();
            this.lstSelected2 = new JList(new JListModel(new ArrayList(), true));
            this.pnlSelected2 = new JPanel();
            this.scpSelected2 = new JScrollPane();
        }
        this.setLayout(new GridBagLayout());
        this.pnlHeader.add(this.lblHeader);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.pnlHeader, gridBagConstraints);
        this.pnlHeader.setVisible(false);
        this.pnlAvailable.setLayout(new GridBagLayout());
        this.lblAvailable.setText(PropertyFactory.getString("in_available"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        this.pnlAvailable.add((Component)this.lblAvailable, gridBagConstraints);
        this.btnAdd.setEnabled(false);
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AvailableSelectedPanel.this.btnAddActionPerformed(AvailableSelectedPanel.this.lstSelected, AvailableSelectedPanel.this.btnAdd);
            }
        });
        if (!twoSelectedLists) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            this.pnlAvailable.add((Component)this.btnAdd, gridBagConstraints);
        }
        this.lstAvailable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AvailableSelectedPanel.this.lstAvailableMouseClicked(evt);
            }
        });
        this.scpAvailable.setPreferredSize(new Dimension(90, 20));
        this.scpAvailable.setViewportView(this.lstAvailable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.pnlAvailable.add((Component)this.scpAvailable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.pnlAvailable.add((Component)this.pnlExtra, gridBagConstraints);
        this.pnlExtra.setVisible(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        if (twoSelectedLists) {
            gridBagConstraints.gridheight = 2;
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAvailable, gridBagConstraints);
        this.pnlSelected.setLayout(new GridBagLayout());
        if (twoSelectedLists) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints.anchor = 17;
            this.pnlSelected.add((Component)this.btnAdd, gridBagConstraints);
        }
        this.lblSelected.setText(PropertyFactory.getString("in_selected"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        this.pnlSelected.add((Component)this.lblSelected, gridBagConstraints);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AvailableSelectedPanel.this.btnRemoveActionPerformed(AvailableSelectedPanel.this.lstSelected, AvailableSelectedPanel.this.btnRemove);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlSelected.add((Component)this.btnRemove, gridBagConstraints);
        this.lstSelected.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AvailableSelectedPanel.this.lstSelectedMouseClicked(evt);
            }
        });
        this.scpSelected.setPreferredSize(new Dimension(90, 20));
        this.scpSelected.setViewportView(this.lstSelected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = twoSelectedLists ? 3 : 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.pnlSelected.add((Component)this.scpSelected, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlSelected, gridBagConstraints);
        if (twoSelectedLists) {
            this.pnlSelected2.setLayout(new GridBagLayout());
            this.btnAdd2.setEnabled(false);
            this.btnAdd2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    AvailableSelectedPanel.this.btnAddActionPerformed(AvailableSelectedPanel.this.lstSelected2, AvailableSelectedPanel.this.btnAdd2);
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints.anchor = 17;
            this.pnlSelected2.add((Component)this.btnAdd2, gridBagConstraints);
            this.lblSelected2.setText(PropertyFactory.getString("in_selected"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints.anchor = 17;
            this.pnlSelected2.add((Component)this.lblSelected2, gridBagConstraints);
            this.btnRemove2.setEnabled(false);
            this.btnRemove2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    AvailableSelectedPanel.this.btnRemoveActionPerformed(AvailableSelectedPanel.this.lstSelected2, AvailableSelectedPanel.this.btnRemove2);
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            this.pnlSelected2.add((Component)this.btnRemove2, gridBagConstraints);
            this.lstSelected2.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    AvailableSelectedPanel.this.lstSelectedMouseClicked(evt);
                }
            });
            this.scpSelected2.setPreferredSize(new Dimension(90, 20));
            this.scpSelected2.setViewportView(this.lstSelected2);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 1.0;
            this.pnlSelected2.add((Component)this.scpSelected2, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)this.pnlSelected2, gridBagConstraints);
        }
    }

    private void lstAvailableMouseClicked(MouseEvent evt) {
        if (EditUtil.isDoubleClick(evt, this.lstAvailable, this.btnAdd) && this.btnAdd2 == null) {
            this.btnAddActionPerformed(this.lstSelected, this.btnAdd);
        }
        if (this.btnAdd2 != null) {
            this.btnAdd2.setEnabled(this.btnAdd.isEnabled());
        }
    }

    private void lstSelectedMouseClicked(MouseEvent evt) {
        if (evt.getSource().equals(this.lstSelected)) {
            if (EditUtil.isDoubleClick(evt, this.lstSelected, this.btnRemove)) {
                this.btnRemoveActionPerformed(this.lstSelected, this.btnRemove);
            }
        } else if (EditUtil.isDoubleClick(evt, this.lstSelected2, this.btnRemove2)) {
            this.btnRemoveActionPerformed(this.lstSelected2, this.btnRemove2);
        }
    }

    private void swapEntries(JList dst, JList src, JButton btn, int dir) {
        btn.setEnabled(false);
        JListModel lms = (JListModel)src.getModel();
        JListModel lmd = (JListModel)dst.getModel();
        Object[] selectedValues = src.getSelectedValues();
        for (int i = 0; i < selectedValues.length; ++i) {
            if (this.addFilter != null) {
                if (dir == 1) {
                    lmd.addElement(this.addFilter.encode(selectedValues[i]));
                    lms.removeElement(selectedValues[i]);
                    continue;
                }
                lmd.addElement(this.addFilter.decode(selectedValues[i]));
                lms.removeElement(selectedValues[i]);
                continue;
            }
            lmd.addElement(selectedValues[i]);
            lms.removeElement(selectedValues[i]);
        }
    }
}

