/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.gui.editor.PObjectUpdater;
import pcgen.gui.utils.JComboBoxEx;

public class ClassAbilityPanel
extends JPanel
implements PObjectUpdater {
    private JCheckBox memorize = new JCheckBox();
    private JCheckBox spellBook = new JCheckBox();
    private JComboBoxEx spellStat = new JComboBoxEx();
    private JComboBoxEx spellType = new JComboBoxEx();
    private JTextField attackCycle = new JTextField();
    private JTextField castAs = new JTextField();
    private JTextField deity = new JTextField();
    private JTextField extraFeats = new JTextField();
    private JTextField hitDice = new JTextField();
    private JTextField itemCreate = new JTextField();
    private JTextField knownSpells = new JTextField();
    private JTextField levelsPerFeat = new JTextField();
    private JTextField maxLevel = new JTextField();
    private JTextField prohibited = new JTextField();
    private JTextField specialtyKnown = new JTextField();
    private JTextField spellList = new JTextField();

    public ClassAbilityPanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void updateData(PObject po) {
        if (!(po instanceof PCClass)) {
            return;
        }
        PCClass obj = (PCClass)po;
        String a = this.attackCycle.getText().trim();
        if (a.length() > 0) {
            obj.setAttackCycle(a);
        }
        if ((a = this.hitDice.getText().trim()).length() > 0) {
            obj.setHitDie(Integer.parseInt(a));
        }
        if ((a = this.deity.getText().trim()).length() > 0) {
            Object[] deities = a.split("\\|");
            obj.setDeityList(CoreUtility.arrayToList(deities));
        }
        a = this.itemCreate.getText().trim();
        obj.setItemCreationMultiplier(a);
        a = this.extraFeats.getText().trim();
        if (a.length() > 0) {
            obj.setInitialFeats(Integer.parseInt(a));
        }
        if ((a = this.levelsPerFeat.getText().trim()).length() > 0) {
            obj.setLevelsPerFeat(new Integer(a));
        }
        if ((a = this.castAs.getText().trim()).length() > 0) {
            obj.setCastAs(a);
        }
        if ((a = this.knownSpells.getText().trim()).length() > 0) {
            obj.addKnownSpellsList(a);
        }
        obj.setMemorizeSpells(this.memorize.getSelectedObjects() != null);
        a = this.prohibited.getText().trim();
        if (a.length() > 0) {
            obj.setProhibitedString(a);
        }
        if ((a = this.specialtyKnown.getText().trim()).length() > 0) {
            obj.getSpecialtyKnownList().add(a);
        }
        obj.setSpellBookUsed(this.spellBook.getSelectedObjects() != null);
        a = this.spellList.getText().trim();
        if (a.length() > 0) {
            obj.setSpellLevelString(a);
        }
        obj.setSpellBaseStat("None");
        a = (String)this.spellStat.getSelectedItem();
        if (a != null && a.length() > 0) {
            obj.setSpellBaseStat(a);
        }
        obj.setSpellType("None");
        a = (String)this.spellType.getSelectedItem();
        if (a != null && a.length() > 0) {
            obj.setSpellType(a);
        }
        if ((a = this.maxLevel.getText().trim()).length() > 0) {
            obj.setMaxLevel(Integer.valueOf(a));
        }
    }

    public void updateView(PObject po) {
        if (!(po instanceof PCClass)) {
            return;
        }
        PCClass obj = (PCClass)po;
        this.attackCycle.setText(obj.getAttackCycle());
        this.hitDice.setText(String.valueOf(obj.getBaseHitDie()));
        this.deity.setText(CoreUtility.join((Collection)obj.getDeityList(), '|'));
        this.itemCreate.setText(obj.getItemCreationMultiplier());
        this.extraFeats.setText(String.valueOf(obj.getInitialFeats()));
        if (obj.getLevelsPerFeat() != null) {
            this.levelsPerFeat.setText(obj.getLevelsPerFeat().toString());
        }
        this.castAs.setText(obj.getCastAs());
        this.memorize.setSelected(obj.getMemorizeSpells());
        this.prohibited.setText(obj.getProhibitedString());
        this.spellBook.setSelected(obj.getSpellBookUsed());
        this.spellList.setText(obj.getSpellLevelString());
        this.spellStat.setSelectedItem(obj.getSpellBaseStat());
        this.spellType.setSelectedItem(obj.getSpellType());
        this.maxLevel.setText(String.valueOf(obj.getMaxLevel()));
    }

    private static GridBagConstraints buildConstraints(GridBagConstraints gridBagConstraints, int gridx, int gridy, boolean useInsets) {
        gridBagConstraints.gridx = gridx;
        gridBagConstraints.gridy = gridy;
        if (useInsets) {
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        }
        return gridBagConstraints;
    }

    private void initComponentContents() {
        ArrayList<String> aList = new ArrayList<String>();
        Iterator e = SettingsHandler.getGame().getUnmodifiableStatList().iterator();
        while (e.hasNext()) {
            aList.add(((PCStat)e.next()).getAbb());
        }
        aList.remove("None");
        Collections.sort(aList);
        aList.add(0, "None");
        this.spellStat.setModel(new DefaultComboBoxModel<Object>(aList.toArray()));
        aList.clear();
        e = Globals.getClassList().iterator();
        while (e.hasNext()) {
            String aString = ((PCClass)e.next()).getSpellType();
            if (aList.contains(aString)) continue;
            aList.add(aString);
        }
        aList.remove("None");
        Collections.sort(aList);
        aList.add(0, "None");
        this.spellType.setModel(new DefaultComboBoxModel<Object>(aList.toArray()));
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.16;
        JLabel tempLabel = new JLabel("Attack Cycle:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 0, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 0, true);
        this.add((Component)this.attackCycle, gridBagConstraints);
        tempLabel = new JLabel("Hit Die:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 2, 0, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 3, 0, true);
        this.add((Component)this.hitDice, gridBagConstraints);
        tempLabel = new JLabel("Max Level:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 4, 0, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 5, 0, true);
        gridBagConstraints.weightx = 0.2;
        this.add((Component)this.maxLevel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        tempLabel = new JLabel("Bonus Feats:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 1, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 1, true);
        this.add((Component)this.extraFeats, gridBagConstraints);
        tempLabel = new JLabel("Levels Per Feat:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 2, 1, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 3, 1, true);
        this.add((Component)this.levelsPerFeat, gridBagConstraints);
        tempLabel = new JLabel("Item Create Mult:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 4, 1, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 5, 1, true);
        this.add((Component)this.itemCreate, gridBagConstraints);
        tempLabel = new JLabel("Spell Type:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 2, true);
        this.add((Component)tempLabel, gridBagConstraints);
        this.spellType.setEditable(true);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 2, true);
        this.add((Component)this.spellType, gridBagConstraints);
        tempLabel = new JLabel("Spell Stat:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 2, 2, true);
        this.add((Component)tempLabel, gridBagConstraints);
        this.spellStat.setEditable(true);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 3, 2, true);
        this.add((Component)this.spellStat, gridBagConstraints);
        tempLabel = new JLabel("Cast As:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 4, 2, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 5, 2, true);
        this.add((Component)this.castAs, gridBagConstraints);
        tempLabel = new JLabel("Uses Spell Book:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 3, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 3, true);
        this.add((Component)this.spellBook, gridBagConstraints);
        tempLabel = new JLabel("Memorizes Spells:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 2, 3, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 3, 3, true);
        this.add((Component)this.memorize, gridBagConstraints);
        tempLabel = new JLabel("Prohibited:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 4, 3, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 5, 3, true);
        this.add((Component)this.prohibited, gridBagConstraints);
        tempLabel = new JLabel("Specialty Known:");
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 4, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 4, true);
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.specialtyKnown, gridBagConstraints);
        tempLabel = new JLabel("Spell List:");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 3, 4, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 4, 4, true);
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.spellList, gridBagConstraints);
        tempLabel = new JLabel("Known Spells:");
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 0, 5, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassAbilityPanel.buildConstraints(gridBagConstraints, 1, 5, true);
        gridBagConstraints.gridwidth = 5;
        this.add((Component)this.knownSpells, gridBagConstraints);
    }
}

