/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.TypePanel;
import pcgen.util.PropertyFactory;

class ClassBasePanel
extends BasePanel {
    private JCheckBox chkVisible;
    private JCheckBox hasSubClass;
    private JCheckBox modToSkills;
    private JCheckBox multiPreReq;
    private JTextField abbreviation;
    private JTextField exClass;
    private JTextField exchangeLevel;
    private JTextField qualify;
    private JTextField specials;
    private JTextField startSkillPoints;
    private JTextField txtDisplayName;
    private TypePanel pnlTemplateTypes;

    public ClassBasePanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void setTypesAvailableList(List aList, boolean sort) {
        this.pnlTemplateTypes.setAvailableList(aList, sort);
    }

    public void setTypesSelectedList(List aList, boolean sort) {
        this.pnlTemplateTypes.setSelectedList(aList, sort);
    }

    public Object[] getTypesSelectedList() {
        return this.pnlTemplateTypes.getSelectedList();
    }

    public void updateData(PObject thisPObject) {
        if (!(thisPObject instanceof PCClass)) {
            return;
        }
        PCClass obj = (PCClass)thisPObject;
        obj.setOutputName(this.txtDisplayName.getText().trim());
        obj.setAbbrev(this.abbreviation.getText().trim());
        obj.setLevelExchange(this.exchangeLevel.getText().trim());
        obj.setSkillPoints(Integer.parseInt(this.startSkillPoints.getText().trim()));
        obj.setQualifyString(this.qualify.getText().trim());
        obj.setSpecialsString(this.specials.getText().trim());
        obj.setExClass(this.exClass.getText().trim());
        obj.setHasSubClass(this.hasSubClass.getSelectedObjects() != null);
        obj.setModToSkills(this.modToSkills.getSelectedObjects() != null);
        obj.setMultiPreReqs(this.multiPreReq.getSelectedObjects() != null);
        obj.setVisible(this.chkVisible.getSelectedObjects() != null);
        Object[] sel = this.getTypesSelectedList();
        thisPObject.setTypeInfo(".CLEAR");
        for (int i = 0; i < sel.length; ++i) {
            thisPObject.setTypeInfo(sel[i].toString());
        }
    }

    public void updateView(PObject thisPObject) {
        String aString;
        if (!(thisPObject instanceof PCClass)) {
            return;
        }
        ArrayList<String> availableList = new ArrayList<String>();
        ArrayList<String> selectedList = new ArrayList<String>();
        Iterator e = Globals.getClassList().iterator();
        while (e.hasNext()) {
            PCClass obj = (PCClass)e.next();
            int i = obj.getMyTypeCount();
            while (i > 0) {
                if ((aString = obj.getMyType(--i)).equals("CUSTOM") || availableList.contains(aString)) continue;
                availableList.add(aString);
            }
        }
        int i = thisPObject.getMyTypeCount();
        while (i > 0) {
            if ((aString = thisPObject.getMyType(--i)).equals("CUSTOM")) continue;
            selectedList.add(aString);
            availableList.remove(aString);
        }
        PCClass obj = (PCClass)thisPObject;
        this.setTypesAvailableList(availableList, true);
        this.setTypesSelectedList(selectedList, true);
        this.txtDisplayName.setText(obj.getOutputName());
        this.abbreviation.setText(obj.getAbbrev());
        this.exchangeLevel.setText(obj.getLevelExchange());
        this.startSkillPoints.setText(String.valueOf(obj.getSkillPoints()));
        this.qualify.setText(obj.getQualifyString());
        this.specials.setText(obj.specialsString());
        this.exClass.setText(obj.getExClass());
        this.hasSubClass.setSelected(obj.hasSubClass());
        this.modToSkills.setSelected(obj.getModToSkills());
        this.multiPreReq.setSelected(obj.multiPreReqs());
        this.chkVisible.setSelected(obj.isVisible());
    }

    private static GridBagConstraints buildConstraints(GridBagConstraints gridBagConstraints, int gridx, int gridy, boolean useInsets) {
        gridBagConstraints.gridx = gridx;
        gridBagConstraints.gridy = gridy;
        if (useInsets) {
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        }
        return gridBagConstraints;
    }

    private void initComponentContents() {
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.txtDisplayName = new JTextField();
        this.abbreviation = new JTextField();
        this.qualify = new JTextField();
        this.specials = new JTextField();
        this.exchangeLevel = new JTextField();
        this.startSkillPoints = new JTextField();
        this.exClass = new JTextField();
        this.hasSubClass = new JCheckBox();
        this.modToSkills = new JCheckBox();
        this.chkVisible = new JCheckBox();
        this.multiPreReq = new JCheckBox();
        this.pnlTemplateTypes = new TypePanel(PropertyFactory.getString("in_demEnterNewType"));
        this.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        JLabel tempLabel = new JLabel("Display Name");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 0, 0, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 1, 0, true);
        gridBagConstraints.gridwidth = 5;
        this.add((Component)this.txtDisplayName, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.16;
        tempLabel = new JLabel("ABB:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 0, 1, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 1, 1, true);
        this.add((Component)this.abbreviation, gridBagConstraints);
        tempLabel = new JLabel("Ex-Class:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 2, 1, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 3, 1, true);
        this.add((Component)this.exClass, gridBagConstraints);
        tempLabel = new JLabel("Exchange Level:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 4, 1, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 5, 1, true);
        this.add((Component)this.exchangeLevel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        tempLabel = new JLabel("Has SubClass:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 0, 2, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 1, 2, true);
        this.add((Component)this.hasSubClass, gridBagConstraints);
        tempLabel = new JLabel("Mod To Skills:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 2, 2, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 3, 2, true);
        this.add((Component)this.modToSkills, gridBagConstraints);
        tempLabel = new JLabel("Starting Skill Points:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 4, 2, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 5, 2, true);
        this.add((Component)this.startSkillPoints, gridBagConstraints);
        tempLabel = new JLabel("Qualify:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 0, 3, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 1, 3, true);
        this.add((Component)this.qualify, gridBagConstraints);
        tempLabel = new JLabel("Multi-Class Pre-Reqs:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 2, 3, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 3, 3, true);
        this.add((Component)this.multiPreReq, gridBagConstraints);
        tempLabel = new JLabel("Visible:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 4, 3, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 5, 3, true);
        this.add((Component)this.chkVisible, gridBagConstraints);
        tempLabel = new JLabel("Specials:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 0, 4, true);
        this.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 1, 4, true);
        gridBagConstraints.gridwidth = 5;
        this.add((Component)this.specials, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlTemplateTypes, gridBagConstraints);
    }
}

