/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import pcgen.core.Campaign;
import pcgen.core.CustomData;
import pcgen.core.Globals;
import pcgen.core.LevelAbility;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.SpecialAbility;
import pcgen.core.bonus.BonusObj;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.editor.AvailableSelectedPanel;
import pcgen.gui.editor.PObjectUpdater;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.TableSorter;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.PCClassLoader;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class ClassLevelPanel
extends JPanel
implements PObjectUpdater {
    static final long serialVersionUID = 1485178774957708877L;
    private static List levelTagList = new ArrayList();
    private JButton addBtn = new JButton();
    private JButton delBtn = new JButton();
    private JComboBoxEx tagList = new JComboBoxEx();
    private JScrollPane levelPane;
    private JTableEx levelTable = new JTableEx();
    private JTextField level = new JTextField();
    private LevelModel levelModel = new LevelModel();
    private PCClass obj = null;
    private TableSorter sortedLevelModel = new TableSorter();
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public ClassLevelPanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void updateData(PObject po) {
        if (!(po instanceof PCClass)) {
            Logging.errorPrint("Invalid PObject passed to ClassLevelPanel.updateData()!");
            return;
        }
        PCClass obj = (PCClass)po;
        try {
            Campaign customCampaign = new Campaign();
            customCampaign.setName("Custom");
            customCampaign.setDescription("Custom data");
            String sourceFile = obj.getSourceFile();
            if (sourceFile == null) {
                sourceFile = new URL("file:" + CustomData.customClassFilePath(true)).toString();
                obj.setSourceFile(sourceFile);
                obj.setSourceCampaign(customCampaign);
            }
            CampaignSourceEntry tempSource = new CampaignSourceEntry(customCampaign, sourceFile);
            Iterator i = levelTagList.iterator();
            while (i.hasNext()) {
                LevelTag lt = (LevelTag)i.next();
                if (!lt.needsSaving()) continue;
                String b = lt.getLevel() + "\t" + lt.getTag() + ":" + lt.getValue();
                PCClassLoader classLoader = new PCClassLoader();
                classLoader.parseLine(obj, b, tempSource);
            }
        }
        catch (MalformedURLException exc) {
            Logging.errorPrint(exc.getMessage());
        }
        catch (PersistenceLayerException exc) {
            Logging.errorPrint(exc.getMessage());
        }
    }

    public void updateView(PObject po) {
        LevelTag lt;
        String s;
        Collection aCol;
        LevelTag lt2;
        Iterator se;
        LevelTag lt3;
        String lev;
        String src;
        int x;
        LevelTag lt4;
        Iterator i;
        if (!(po instanceof PCClass)) {
            return;
        }
        levelTagList.clear();
        this.obj = (PCClass)po;
        ArrayList aList = this.obj.getLevelAbilityList();
        if (aList != null) {
            i = aList.iterator();
            while (i.hasNext()) {
                LevelAbility la = (LevelAbility)i.next();
                LevelTag lt5 = new LevelTag(la.level(), 0, la.getList());
                levelTagList.add(lt5);
            }
        }
        if ((aList = this.obj.getAddDomains()) != null) {
            i = aList.iterator();
            while (i.hasNext()) {
                String v = (String)i.next();
                int sepPos = v.indexOf(124);
                String l = v.substring(0, sepPos);
                String t = v.substring(sepPos + 1);
                LevelTag lt6 = new LevelTag(l, 1, t);
                levelTagList.add(lt6);
            }
        }
        Iterator bonusIter = this.obj.getBonusList().iterator();
        while (bonusIter.hasNext()) {
            String levelString;
            BonusObj bonus = (BonusObj)bonusIter.next();
            String bonusValue = bonus.toString();
            if (bonusValue.startsWith(levelString = String.valueOf(bonus.getPCLevel()))) {
                bonusValue = bonusValue.substring(levelString.length() + 1);
            }
            lt4 = new LevelTag(bonus.getPCLevel(), 2, bonusValue);
            levelTagList.add(lt4);
        }
        for (x = 0; x < this.obj.getVariableCount(); ++x) {
            String c = this.obj.getVariableDefinition(x);
            int y = c.indexOf(124);
            lt4 = new LevelTag(c.substring(0, y), 4, c.substring(y + 1));
            levelTagList.add(lt4);
        }
        for (x = 1; x < this.obj.getMaxLevel(); ++x) {
            String c = this.obj.getCastStringForLevel(x);
            if (c.equals("0") || c.equals("")) continue;
            LevelTag lt7 = new LevelTag(x, 3, c);
            levelTagList.add(lt7);
        }
        Object[] oList = this.obj.getKnownList().toArray();
        for (int x2 = 0; x2 < oList.length; ++x2) {
            String c = (String)oList[x2];
            if (c.equals("0")) continue;
            lt4 = new LevelTag(x2 + 1, 9, c);
            levelTagList.add(lt4);
        }
        boolean flag = true;
        int index = 0;
        while (flag) {
            if ((src = this.obj.getSpellListItemAsString(index++, Globals.getCurrentPC())) != null) {
                int y = src.indexOf(124);
                lev = src.substring(y + 1);
                src = src.substring(0, y);
                lt3 = new LevelTag(src, 12, lev);
                levelTagList.add(lt3);
                continue;
            }
            flag = false;
        }
        flag = true;
        index = 0;
        while (flag) {
            if ((src = this.obj.getDRListString(index++, "|")) != null) {
                int y = src.indexOf(124);
                lev = src.substring(y + 1);
                src = src.substring(0, y);
                lt3 = new LevelTag(src, 5, lev);
                levelTagList.add(lt3);
                continue;
            }
            flag = false;
        }
        aList = this.obj.getSpecialAbilityList();
        if (aList != null && aList.size() != 0) {
            se = aList.iterator();
            while (se.hasNext()) {
                SpecialAbility sa = (SpecialAbility)se.next();
                String src2 = sa.getSASource();
                String lev2 = src2.substring(src2.lastIndexOf(124) + 1);
                lt2 = new LevelTag(lev2, 11, sa.toString());
                levelTagList.add(lt2);
            }
        }
        flag = true;
        index = 0;
        while (flag) {
            if ((src = this.obj.getSRListString(index++, "|")) != null) {
                int y = src.indexOf(124);
                lev = src.substring(y + 1);
                src = src.substring(0, y);
                lt3 = new LevelTag(src, 13, lev);
                levelTagList.add(lt3);
                continue;
            }
            flag = false;
        }
        aList = this.obj.getFeatList();
        if (aList != null && aList.size() != 0) {
            se = aList.iterator();
            while (se.hasNext()) {
                String c = (String)se.next();
                int y = c.indexOf(58);
                lt3 = new LevelTag(c.substring(0, y), 6, c.substring(y + 1));
                levelTagList.add(lt3);
            }
        }
        if ((aCol = this.obj.getFeatAutos()) != null) {
            Iterator se2 = aCol.iterator();
            while (se2.hasNext()) {
                String c = (String)se2.next();
                int y = c.indexOf(124);
                try {
                    lt2 = new LevelTag(c.substring(0, y), 7, c.substring(y + 1));
                    levelTagList.add(lt2);
                }
                catch (Exception exc) {
                    Logging.errorPrint("Unrecognized FEATAUTO format:" + c, exc);
                }
            }
        }
        int iKit = 0;
        while ((s = this.obj.getKitString(iKit)) != null) {
            int y = s.indexOf(124);
            String l = "1";
            if (y > 0) {
                l = s.substring(0, y);
                s = s.substring(y + 1);
            }
            lt = new LevelTag(l, 8, s);
            levelTagList.add(lt);
            ++iKit;
        }
        s = this.obj.getRegionString();
        if (s != null && !s.equals("")) {
            int y = s.indexOf(124);
            String l = "1";
            if (y > 0) {
                l = s.substring(0, y);
                s = s.substring(y + 1);
            }
            lt2 = new LevelTag(l, 10, s);
            levelTagList.add(lt2);
        }
        for (int x3 = 0; x3 < this.obj.getTemplates().size(); ++x3) {
            String c = (String)this.obj.getTemplates().get(x3);
            int y = c.indexOf(124);
            lt = new LevelTag(c.substring(0, y), 14, c.substring(y + 1));
            levelTagList.add(lt);
        }
        aList = this.obj.getUmultList();
        if (aList != null && aList.size() != 0) {
            Iterator se3 = aList.iterator();
            while (se3.hasNext()) {
                String c = (String)se3.next();
                int y = c.indexOf(124);
                lt = new LevelTag(c.substring(0, y), 16, c.substring(y + 1));
                levelTagList.add(lt);
            }
        }
        if ((aList = this.obj.getUdamList()) != null) {
            for (int x4 = 0; x4 < aList.size(); ++x4) {
                String c = (String)aList.get(x4);
                if (c.equals("")) continue;
                LevelTag lt8 = new LevelTag(x4 + 1, 15, c);
                levelTagList.add(lt8);
            }
        }
        this.levelModel.updateModel();
    }

    private void initComponentContents() {
    }

    private void initComponents() {
        for (int i = 0; i < LevelTag.validTags.length; ++i) {
            this.tagList.addItem(LevelTag.validTags[i]);
        }
        this.tagList.setSelectedIndex(0);
        this.level.setText("1     ");
        this.setLayout(new BorderLayout());
        this.levelPane = new JScrollPane(this.levelTable);
        this.sortedLevelModel.setModel(this.levelModel);
        this.levelTable.setModel(this.sortedLevelModel);
        this.levelTable.setColAlign(0, 0);
        this.levelPane.setViewportView(this.levelTable);
        this.levelTable.setSelectionMode(0);
        this.sortedLevelModel.addMouseListenerToHeaderInTable(this.levelTable);
        this.levelTable.getColumnModel().getColumn(0).setPreferredWidth(5);
        this.levelTable.getColumnModel().getColumn(1).setPreferredWidth(10);
        this.add((Component)this.levelPane, "Center");
        JPanel sth = new JPanel();
        sth.setLayout(new FlowLayout());
        JLabel tempLabel = new JLabel("Level:");
        sth.add(tempLabel);
        sth.add(this.level);
        tempLabel = new JLabel("Tag:");
        sth.add(tempLabel);
        sth.add(this.tagList);
        this.addBtn.setText(PropertyFactory.getString("in_add"));
        sth.add(this.addBtn);
        this.addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String tag = ClassLevelPanel.this.tagList.getSelectedItem().toString();
                if (tag.equals("CAST") || tag.equals("KNOWN")) {
                    String[] cols = new String[]{"Level 0", "Level 1", "Level 2", "Level 3", "Level 4", "Level 5", "Level 6", "Level 7", "Level 8", "Level 9"};
                    String[] values = new String[]{"", "", "", "", "", "", "", "", "", ""};
                    MatrixFrame mf = new MatrixFrame(cols, 10, values, tag);
                    String v = "";
                    for (int col = 0; col < 10; ++col) {
                        if (col > 0) {
                            v = v + ",";
                        }
                        v = v + mf.fields[col];
                    }
                    int x = 0;
                    while (v.endsWith(",") && x++ < 9) {
                        v = v.substring(0, v.length() - 1);
                    }
                    if (!v.equals("")) {
                        LevelTag lt = new LevelTag(ClassLevelPanel.this.level.getText().trim(), tag, v.trim(), true);
                        levelTagList.add(lt);
                        ClassLevelPanel.this.levelModel.updateModel();
                    }
                } else if (tag.equals("FEAT") || tag.equals("VFEAT") || tag.equals("FEATAUTO")) {
                    ListFrame lf = new ListFrame("Choices for " + tag, Globals.getFeatList());
                    String v = lf.getSelectedList();
                    if (!v.equals("")) {
                        LevelTag lt = new LevelTag(ClassLevelPanel.this.level.getText().trim(), tag, v.trim(), true);
                        levelTagList.add(lt);
                        ClassLevelPanel.this.levelModel.updateModel();
                    }
                } else {
                    InputInterface ii = InputFactory.getInputInstance();
                    Object selectedValue = ii.showInputDialog(null, "Enter the value for " + tag, "PCGen", MessageType.INFORMATION, null, "");
                    if (selectedValue == null) {
                        return;
                    }
                    LevelTag lt = new LevelTag(ClassLevelPanel.this.level.getText().trim(), tag, selectedValue.toString().trim(), true);
                    levelTagList.add(lt);
                    ClassLevelPanel.this.levelModel.updateModel();
                }
            }
        });
        this.delBtn.setText(PropertyFactory.getString("in_remove"));
        sth.add(this.delBtn);
        this.delBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassLevelPanel.this.removeLevelTag();
            }
        });
        this.add((Component)sth, "South");
    }

    private void removeLevelTag() {
        int x = this.levelTable.getSelectedRow();
        if (x >= 0 && x < levelTagList.size()) {
            LevelTag lt = (LevelTag)levelTagList.get(x = this.sortedLevelModel.getRowTranslated(x));
            if (!lt.needsSaving()) {
                if (this.obj == null) {
                    return;
                }
                boolean bRemoved = false;
                switch (lt.getTagVal()) {
                    case 0: {
                        this.obj.removeLevelAbility(lt.getLevel(), lt.getValue());
                        bRemoved = true;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        this.obj.getFeatAutos().remove(Integer.toString(lt.getLevel()) + "|" + lt.getValue());
                        bRemoved = true;
                        break;
                    }
                }
                if (!bRemoved) {
                    Logging.errorPrint("This tag " + lt.getTag() + ":" + lt.getValue() + " needs to be hand-deleted from customClasses.lst");
                    ShowMessageDelegate.showMessageDialog("This tag " + lt.getTag() + ":" + lt.getValue() + " needs to be hand-deleted from customClasses.lst", "PCGen", MessageType.ERROR);
                    return;
                }
            }
            levelTagList.remove(x);
            this.levelModel.updateModel();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class LevelTag {
        static final String[] validTags = new String[]{"ADD", "ADDDOMAINS", "BONUS", "CAST", "DEFINE", "DR", "FEAT", "FEATAUTO", "KIT", "KNOWN", "REGION", "SA", "SPELL", "SR", "TEMPLATE", "UDAM", "UMULT", "VFEAT"};
        private static final int TAG_ADD = 0;
        private static final int TAG_ADDDOMAINS = 1;
        private static final int TAG_BONUS = 2;
        private static final int TAG_CAST = 3;
        private static final int TAG_DEFINE = 4;
        private static final int TAG_DR = 5;
        private static final int TAG_FEAT = 6;
        private static final int TAG_FEATAUTO = 7;
        private static final int TAG_KIT = 8;
        private static final int TAG_KNOWN = 9;
        private static final int TAG_REGION = 10;
        private static final int TAG_SA = 11;
        private static final int TAG_SPELL = 12;
        private static final int TAG_SR = 13;
        private static final int TAG_TEMPLATE = 14;
        private static final int TAG_UDAM = 15;
        private static final int TAG_UMULT = 16;
        private static final int TAG_VFEAT = 17;
        private String value;
        private boolean needsSaving;
        private int level;
        private int tagVal;

        public LevelTag(String l, String t, String v, boolean b) {
            int i = 0;
            if (l != null && l.length() > 0) {
                i = Integer.parseInt(l);
            }
            this.setData(i, this.parseTag(t), v, b);
        }

        LevelTag(String l, int ttag, String val) {
            int i = 0;
            if (l != null && l.length() > 0) {
                i = Integer.parseInt(l);
            }
            this.setData(i, ttag, val, true);
        }

        LevelTag(int l, int ttag, String val) {
            this.setData(l, ttag, val, true);
        }

        LevelTag(int llevel, String ttag, String val, boolean saveIt) {
            this.setData(llevel, this.parseTag(ttag), val, saveIt);
        }

        public int getLevel() {
            return this.level;
        }

        public String getTag() {
            if (this.tagVal >= 0) {
                return validTags[this.tagVal];
            }
            return "Unknown";
        }

        public int getTagVal() {
            return this.tagVal;
        }

        public String getValue() {
            return this.value;
        }

        public boolean needsSaving() {
            return this.needsSaving;
        }

        void setData(int llevel, int ttagval, String val, boolean saveIt) {
            if (ttagval >= validTags.length) {
                ttagval = -1;
            }
            this.level = llevel;
            this.tagVal = ttagval;
            this.value = val;
            this.needsSaving = saveIt;
        }

        private int parseTag(String ttag) {
            for (int i = 0; i < validTags.length; ++i) {
                if (!validTags[i].equalsIgnoreCase(ttag)) continue;
                return i;
            }
            return -1;
        }
    }

    private static final class LevelModel
    extends AbstractTableModel {
        static final long serialVersionUID = 1485178774957708877L;
        private final String[] colNames = new String[]{"Level", "Tag", "Value"};

        private LevelModel() {
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = ClassLevelPanel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            return class$java$lang$String == null ? (class$java$lang$String = ClassLevelPanel.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return this.colNames.length;
        }

        public String getColumnName(int columnIndex) {
            return columnIndex >= 0 && columnIndex < this.colNames.length ? this.colNames[columnIndex] : "Out Of Bounds";
        }

        public int getRowCount() {
            return levelTagList.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= 0 && rowIndex < levelTagList.size()) {
                LevelTag lt = (LevelTag)levelTagList.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return new Integer(lt.getLevel());
                    }
                    case 1: {
                        return lt.getTag();
                    }
                    case 2: {
                        return lt.getValue();
                    }
                }
                Logging.errorPrint("In ClassLevelPanel.LevelModel.getValueAt the column " + columnIndex + " is not supported.");
            }
            return null;
        }

        private void updateModel() {
            this.fireTableDataChanged();
        }
    }

    static final class MatrixFrame
    extends JDialog {
        public String[] fields;
        String[] colNames;
        JTextField[] textField;
        String[] values;
        int columns;

        public MatrixFrame(String[] colNs, int colNum, String[] vals, String title) {
            super(Globals.getRootFrame(), title, true);
            this.colNames = colNs;
            this.columns = colNum;
            this.values = vals;
            this.initComponents();
            this.setSize(new Dimension(60 * this.columns, 140));
            this.setVisible(true);
            this.pack();
        }

        private GridBagConstraints buildConstraints(GridBagConstraints gridBagConstraints, int gridx, int gridy, boolean useInsets) {
            gridBagConstraints.gridx = gridx;
            gridBagConstraints.gridy = gridy;
            if (useInsets) {
                gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            }
            return gridBagConstraints;
        }

        private void initComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            this.textField = new JTextField[this.columns];
            for (int col = 0; col < this.columns; ++col) {
                JLabel tempLabel = new JLabel(this.colNames[col]);
                gridBagConstraints = this.buildConstraints(gridBagConstraints, col, 0, true);
                this.getContentPane().add((Component)tempLabel, gridBagConstraints);
                this.textField[col] = new JTextField();
                gridBagConstraints = this.buildConstraints(gridBagConstraints, col, 1, true);
                this.getContentPane().add((Component)this.textField[col], gridBagConstraints);
            }
            JButton btn = new JButton(PropertyFactory.getString("in_ok"));
            gridBagConstraints = this.buildConstraints(gridBagConstraints, this.columns - 2, 2, true);
            this.getContentPane().add((Component)btn, gridBagConstraints);
            btn.addActionListener(new ActionListener(this){
                private final /* synthetic */ MatrixFrame this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent evt) {
                    this.this$0.setVisible(false);
                    this.this$0.fields = new String[this.this$0.columns];
                    for (int col = 0; col < this.this$0.columns; ++col) {
                        this.this$0.fields[col] = this.this$0.textField[col].getText();
                    }
                }
            });
            btn = new JButton(PropertyFactory.getString("in_cancel"));
            gridBagConstraints = this.buildConstraints(gridBagConstraints, this.columns - 1, 2, true);
            this.getContentPane().add((Component)btn, gridBagConstraints);
            btn.addActionListener(new ActionListener(this){
                private final /* synthetic */ MatrixFrame this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent evt) {
                    this.this$0.setVisible(false);
                    this.this$0.fields = new String[this.this$0.columns];
                    for (int col = 0; col < this.this$0.columns; ++col) {
                        this.this$0.fields[col] = "";
                    }
                }
            });
        }
    }

    static final class ListFrame
    extends JDialog {
        AvailableSelectedPanel asPanel = new AvailableSelectedPanel();

        public ListFrame(String title, List aList) {
            super(Globals.getRootFrame(), title, true);
            this.initComponents();
            this.asPanel.setAvailableList(aList, true);
            this.setSize(new Dimension(400, 400));
            this.setVisible(true);
            this.pack();
        }

        public String getSelectedList() {
            Object[] sels = this.asPanel.getSelectedList();
            if (sels.length == 0) {
                return "";
            }
            String ret = sels[0].toString();
            for (int i = 1; i < sels.length; ++i) {
                ret = ret + "|" + sels[i].toString();
            }
            return ret;
        }

        private void initComponents() {
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.asPanel, "Center");
            JButton btn = new JButton(PropertyFactory.getString("in_ok"));
            this.getContentPane().add((Component)btn, "South");
            btn.addActionListener(new ActionListener(this){
                private final /* synthetic */ ListFrame this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent evt) {
                    this.this$0.setVisible(false);
                }
            });
        }
    }
}

