/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pcgen.core.Deity;
import pcgen.core.Globals;
import pcgen.core.PCAlignment;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.core.WeaponProf;
import pcgen.gui.editor.AvailableSelectedPanel;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.DescriptionPanel;
import pcgen.gui.editor.EditUtil;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.PropertyFactory;

final class DeityBasePanel
extends BasePanel {
    private AvailableSelectedPanel pnlFavoredWeapons;
    private DescriptionPanel pnlDescription;
    private JComboBoxEx cmbDeityAlignment;
    private JLabel lblDeityAlignment;
    private JLabel lblHolyItem;
    private JPanel pnlDeityAlignment;
    private JPanel pnlHolyItem;
    private JTextField txtHolyItem;

    DeityBasePanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void setDeityAlignment(String aString) {
        Iterator e = SettingsHandler.getGame().getUnmodifiableAlignmentList().iterator();
        while (e.hasNext()) {
            PCAlignment anAlignment = (PCAlignment)e.next();
            if (!anAlignment.isValidForDeity() || !anAlignment.getKeyName().equals(aString)) continue;
            this.cmbDeityAlignment.setSelectedItem(anAlignment.getName());
        }
    }

    public String getDeityAlignment() {
        int dix;
        String aString = (String)this.cmbDeityAlignment.getSelectedItem();
        if (aString != null && (dix = SettingsHandler.getGame().getIndexOfAlignment(aString)) >= 0) {
            return SettingsHandler.getGame().getShortAlignmentAtIndex(dix);
        }
        return null;
    }

    public void setDescIsPI(boolean descIsPI) {
        this.pnlDescription.setDescIsPI(descIsPI);
    }

    public boolean getDescIsPI() {
        return this.pnlDescription.getDescIsPI();
    }

    public void setDescriptionText(String aString) {
        this.pnlDescription.setText(aString);
    }

    public String getDescriptionText() {
        return this.pnlDescription.getText();
    }

    public void setFavoredWeaponsAvailableList(List aList, boolean sort) {
        this.pnlFavoredWeapons.setAvailableList(aList, sort);
    }

    public Object[] getFavoredWeaponsAvailableList() {
        return this.pnlFavoredWeapons.getAvailableList();
    }

    public void setFavoredWeaponsSelectedList(List aList, boolean sort) {
        this.pnlFavoredWeapons.setSelectedList(aList, sort);
    }

    public Object[] getFavoredWeaponsSelectedList() {
        return this.pnlFavoredWeapons.getSelectedList();
    }

    public void setHolyItemText(String aString) {
        this.txtHolyItem.setText(aString);
    }

    public String getHolyItemText() {
        return this.txtHolyItem.getText().trim();
    }

    public void updateData(PObject thisPObject) {
        String aString;
        ((Deity)thisPObject).setHolyItem(this.getHolyItemText());
        ((Deity)thisPObject).setAlignment(this.getDeityAlignment());
        thisPObject.setDescription(this.getDescriptionText());
        thisPObject.setDescIsPI(this.getDescIsPI());
        if (this.getFavoredWeaponsAvailableList().length == 0) {
            aString = "Any";
        } else {
            Object[] sel = this.getFavoredWeaponsSelectedList();
            aString = EditUtil.delimitArray(sel, '|');
        }
        ((Deity)thisPObject).setFavoredWeapon(aString);
    }

    public void updateView(PObject thisPObject) {
        this.setHolyItemText(((Deity)thisPObject).getHolyItem());
        this.setDescriptionText(thisPObject.getDescription());
        this.setDescIsPI(thisPObject.getDescIsPI());
        this.setDeityAlignment(((Deity)thisPObject).getAlignment());
        ArrayList<WeaponProf> selectedList = new ArrayList<WeaponProf>();
        List availableList = Globals.getWeaponProfArrayCopy();
        StringTokenizer aTok = new StringTokenizer(((Deity)thisPObject).getFavoredWeapon(), "|", false);
        while (aTok.hasMoreTokens()) {
            String deityWeap = aTok.nextToken();
            if (deityWeap.equalsIgnoreCase("ALL") || "ANY".equalsIgnoreCase(deityWeap)) {
                selectedList.addAll(availableList);
                availableList.clear();
                break;
            }
            WeaponProf wp = Globals.getWeaponProfNamed(deityWeap);
            if (wp == null) continue;
            selectedList.add(wp);
            availableList.remove(wp);
        }
        this.setFavoredWeaponsAvailableList(availableList, true);
        this.setFavoredWeaponsSelectedList(selectedList, true);
    }

    private void initComponentContents() {
        ArrayList<String> availableList = new ArrayList<String>();
        Iterator e = SettingsHandler.getGame().getUnmodifiableAlignmentList().iterator();
        while (e.hasNext()) {
            PCAlignment anAlignment = (PCAlignment)e.next();
            if (!anAlignment.isValidForDeity()) continue;
            availableList.add(anAlignment.getName());
        }
        this.cmbDeityAlignment.setModel(new DefaultComboBoxModel<Object>(availableList.toArray()));
    }

    private void initComponents() {
        this.pnlHolyItem = new JPanel();
        this.lblHolyItem = new JLabel();
        this.txtHolyItem = new JTextField();
        this.pnlDeityAlignment = new JPanel();
        this.lblDeityAlignment = new JLabel();
        this.cmbDeityAlignment = new JComboBoxEx();
        this.pnlDescription = new DescriptionPanel();
        this.pnlFavoredWeapons = new AvailableSelectedPanel();
        this.setLayout(new GridBagLayout());
        this.pnlHolyItem.setLayout(new GridBagLayout());
        this.lblHolyItem.setLabelFor(this.txtHolyItem);
        this.lblHolyItem.setText(PropertyFactory.getString("in_demHolyItem"));
        this.lblHolyItem.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_demHolyItem"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlHolyItem.add((Component)this.lblHolyItem, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 1.0;
        this.pnlHolyItem.add((Component)this.txtHolyItem, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlHolyItem, gridBagConstraints);
        this.pnlDeityAlignment.setLayout(new GridBagLayout());
        this.lblDeityAlignment.setLabelFor(this.cmbDeityAlignment);
        this.lblDeityAlignment.setText(PropertyFactory.getString("in_demDeityAlign"));
        this.lblDeityAlignment.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_demDeityAlign"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlDeityAlignment.add((Component)this.lblDeityAlignment, gridBagConstraints);
        this.cmbDeityAlignment.setPreferredSize(new Dimension(180, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlDeityAlignment.add((Component)this.cmbDeityAlignment, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlDeityAlignment, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlDescription, gridBagConstraints);
        this.pnlFavoredWeapons.setHeader(PropertyFactory.getString("in_demFavWea"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlFavoredWeapons, gridBagConstraints);
    }
}

