/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.EquipmentList;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PCAlignment;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.Variable;
import pcgen.core.WeaponProf;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.editor.AgePanel;
import pcgen.gui.editor.AppearancePanel;
import pcgen.gui.editor.AvailableSelectedPanel;
import pcgen.gui.editor.ClassAbilityPanel;
import pcgen.gui.editor.ClassLevelPanel;
import pcgen.gui.editor.EditUtil;
import pcgen.gui.editor.EditorAddFilter;
import pcgen.gui.editor.EditorBasePanel;
import pcgen.gui.editor.JListModel;
import pcgen.gui.editor.LevelAbilitiesPanel;
import pcgen.gui.editor.MovementPanel;
import pcgen.gui.editor.NaturalAttacksPanel;
import pcgen.gui.editor.QualifiedAvailableSelectedPanel;
import pcgen.gui.editor.SourceFilesPanel;
import pcgen.gui.editor.SpellBasePanel2;
import pcgen.gui.editor.VisionPanel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.PObjectLoader;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public final class EditorMainForm
extends JDialog {
    static final long serialVersionUID = 608648521263089459L;
    private static final String[] qualifiers = new String[]{"(None)", "VARDEFINED"};
    private static final String[] tags = new String[]{"ADD", "AUTO", "BONUS", "CHOOSE", "DEFINE", "DR", "KEY", "PANTHEON", "PREALIGN", "PREAMORPROF", "PREARMORTYPE", "PREATT", "PREBASESIZEGT", "PREBASESIZEGTEQ", "PREBASESIZELT", "PREBASESIZELTEQ", "PREBASESIZEQ", "PREBASESIZENEQ", "PREBIRTHPLACE", "PRECITY", "PRECHECK", "PRECHECKBASE", "PRECLASS", "PREDR", "PREDEFAULTMONSTER", "PREDEITY", "PREDEITYALIGN", "PREDEITYDOMAIN", "PREDOMAIN", "PREEQUIP", "PREEQUIPBOTH", "PREEQUIPPRIMARY", "PREEQUIPSECONDARY", "PREEQUIPTWOWEAPON", "PREFEAT", "PREGENDER", "PREHANDSEQ", "PREHANDSGT", "PREHANDSGTEQ", "PREHANDSLT", "PREHANDSLTEQ", "PREHANDSNEQ", "PREHD", "PREHP", "PREITEM", "PRELANG", "PRELEGS", "PRELEVEL", "PRELEVELMAX", "PREMOVE", "PRERACE", "PREREGION", "PRESA", "PRESIZEEQ", "PRESIZELT", "PRESIZELTEQ", "PRESIZEGT", "PRESIZEGTEQ", "PRESIZENEQ", "PRESKILL", "PRESKILLMULT", "PRESKILLTOT", "PRESPELL", "PRESPELLCAST", "PRESPELLSCHOOL", "PRESPELLSCHOOLSUB", "PRESPELLTYPE", "PRESR", "PRESTAT", "PRETEMPLATE", "PRETEXT", "PRETYPE", "PREUATT", "PREVAR", "PREWEAPONPROF", "QUALIFY", "SA", "SPELL", "SR", "UMDAM", "UMULT", "VISION"};
    private AgePanel pnlAge;
    private AppearancePanel pnlAppearance;
    private AvailableSelectedPanel pnlBonusLang;
    private AvailableSelectedPanel pnlClasses;
    private AvailableSelectedPanel pnlDomains;
    private AvailableSelectedPanel pnlFeats;
    private AvailableSelectedPanel pnlLanguages;
    private AvailableSelectedPanel pnlRaces;
    private AvailableSelectedPanel pnlSkills;
    private AvailableSelectedPanel pnlTemplates;
    private AvailableSelectedPanel pnlVFeats;
    private AvailableSelectedPanel pnlWeapons;
    private ClassAbilityPanel pnlClassAbility;
    private ClassLevelPanel pnlClassLevel;
    private EditorBasePanel pnlMainTab;
    private JButton btnAddAdvanced;
    private JButton btnCancel;
    private JButton btnRemoveAdvanced;
    private JButton btnSave;
    private JComboBoxEx cmbAdvancedTag;
    private JLabel lblAdvancedHeader;
    private JLabel lblAdvancedSelected;
    private JLabel lblAdvancedTag;
    private JLabel lblAdvancedTagValue;
    private JList lstAdvancedSelected;
    private JPanel pnlAdvanced;
    private JPanel pnlAdvancedAvailable;
    private JPanel pnlAdvancedButtons;
    private JPanel pnlAdvancedHeader;
    private JPanel pnlAdvancedSelected;
    private JPanel pnlAdvancedTag;
    private JPanel pnlAdvancedTagValue;
    private JPanel pnlBase2;
    private JPanel pnlButtons;
    private JPanel pnlMainDialog;
    private JPanel pnlTabs;
    private JPanel pnllstAdvancedSelected;
    private JPanel pnllstAdvancedTagValue;
    private JScrollPane scpAdvancedSelected;
    private JScrollPane scpAdvancedTagValue;
    private JTabbedPane jTabbedPane1;
    private JTextArea txtAdvancedTagValue;
    private LevelAbilitiesPanel pnlLevelAbilities;
    private MovementPanel pnlMovement;
    private NaturalAttacksPanel pnlNaturalAttacks;
    private PObject thisPObject = null;
    private QualifiedAvailableSelectedPanel pnlFollowers;
    private QualifiedAvailableSelectedPanel pnlQClasses;
    private QualifiedAvailableSelectedPanel pnlQDomains;
    private QualifiedAvailableSelectedPanel pnlSynergy;
    private SourceFilesPanel pnlFileTypes;
    private VisionPanel pnlVision;
    private boolean wasCancelled = true;
    private int editType = -1;

    public EditorMainForm(JFrame parent, PObject argPObject, int argEditType) throws Exception {
        super(parent);
        if (argPObject == null) {
            throw new NullPointerException();
        }
        this.setModal(true);
        this.editType = argEditType;
        this.thisPObject = argPObject;
        this.initComponents();
        this.initComponentContents();
        this.setLocationRelativeTo(parent);
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    private static void addVariables(List availableList, Collection objList) {
        Iterator e = objList.iterator();
        while (e.hasNext()) {
            Object obj = e.next();
            if (obj instanceof PObject) {
                PObject pobj = (PObject)obj;
                Iterator i = pobj.getVariableIterator();
                while (i.hasNext()) {
                    Variable var = (Variable)i.next();
                    if (var.getUpperName().startsWith("LOCK.") || availableList.contains(var.getName())) continue;
                    availableList.add(var.getName());
                }
                continue;
            }
            Logging.errorPrint(PropertyFactory.getString("in_demEr1") + ": " + obj.getClass().getName());
        }
    }

    private void btnAddAdvancedActionPerformed() {
        this.btnAddAdvanced.setEnabled(false);
        String newEntry = (String)this.cmbAdvancedTag.getSelectedItem() + ":" + this.txtAdvancedTagValue.getText().trim();
        boolean result = false;
        try {
            result = PObjectLoader.parseTag(this.thisPObject, newEntry);
        }
        catch (PersistenceLayerException ple) {
            Logging.errorPrint(ple.getMessage(), ple);
        }
        if (!result) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_demTagInvalid"), "PCGen", MessageType.ERROR);
            this.btnAddAdvanced.setEnabled(true);
        } else {
            JListModel lmd = (JListModel)this.lstAdvancedSelected.getModel();
            lmd.addElement(newEntry);
        }
    }

    private void btnRemoveAdvancedActionPerformed() {
        this.btnRemoveAdvanced.setEnabled(false);
        JListModel lms = (JListModel)this.lstAdvancedSelected.getModel();
        Object[] x = this.lstAdvancedSelected.getSelectedValues();
        for (int i = 0; i < x.length; ++i) {
            String entry = (String)x[i];
            int idx = entry.indexOf(58);
            if (idx >= 0) {
                String tag = entry.substring(0, idx);
                this.cmbAdvancedTag.setSelectedItem(tag);
                entry = entry.substring(idx + 1);
                this.txtAdvancedTagValue.setText(entry);
            }
            lms.removeElement(x[i]);
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void cmbQualifierItemStateChanged() {
        String qualifier = (String)this.pnlFollowers.getQualifierSelectedItem();
        if (qualifier != null && !"(None)".equalsIgnoreCase(qualifier)) {
            this.pnlFollowers.setVariableEnabled(true);
        } else {
            this.pnlFollowers.setVariableEnabled(false);
        }
    }

    private static String decodeDomainEntry(String entry) {
        int idx = entry.indexOf(61);
        if (idx >= 0) {
            entry = entry.substring(0, idx);
        }
        return entry;
    }

    private String decodeFollowerEntry(String entry) {
        int idx = -1;
        if (entry.indexOf(91) >= 0) {
            String qualifier;
            for (int j = 0; j < this.pnlFollowers.getQualifierItemCount() && (idx = entry.indexOf(qualifier = " [" + (String)this.pnlFollowers.getQualifierItemAt(j) + ":")) < 0; ++j) {
            }
        }
        if (idx >= 0) {
            entry = entry.substring(0, idx);
        }
        return entry;
    }

    private String decodeSynergyEntry(String entry) {
        int idx = -1;
        if (entry.indexOf(61) >= 0) {
            String qualifier;
            for (int j = 0; j < this.pnlSynergy.getQualifierItemCount() && (idx = entry.indexOf(qualifier = "=" + (String)this.pnlSynergy.getQualifierItemAt(j) + "=")) < 0; ++j) {
            }
        }
        if (idx >= 0) {
            entry = entry.substring(0, idx);
        }
        return entry;
    }

    private String encodeDomainEntry(QualifiedAvailableSelectedPanel pnl, String newEntry) {
        String qualifier = null;
        if (pnl.getQualifierSelectedIndex() >= 0) {
            qualifier = pnl.getQualifierSelectedItem().toString();
        }
        return EditorMainForm.encodeDomainEntry(newEntry, qualifier);
    }

    private static String encodeDomainEntry(String newEntry, String qualifier) {
        if (qualifier != null) {
            newEntry = newEntry + "=" + qualifier;
        }
        return newEntry;
    }

    private String encodeFollowerEntry(String newEntry) {
        String condition = null;
        String qualifier = (String)this.pnlFollowers.getQualifierSelectedItem();
        if (qualifier != null && !"(None)".equalsIgnoreCase(qualifier)) {
            condition = " [" + qualifier + ":" + (String)this.pnlFollowers.getVariableSelectedItem() + ']';
        }
        if (condition != null) {
            newEntry = newEntry + condition;
        }
        return newEntry;
    }

    private String encodeSynergyEntry(String newEntry) {
        String condition = null;
        String qualifier = null;
        if (this.pnlSynergy.getQualifierSelectedIndex() >= 0) {
            qualifier = this.pnlSynergy.getQualifierSelectedItem().toString();
            if (this.pnlSynergy.getVariableSelectedIndex() >= 0) {
                condition = this.pnlSynergy.getVariableSelectedItem().toString();
            }
        }
        return EditorMainForm.encodeSynergyEntry(newEntry, qualifier, condition);
    }

    private static String encodeSynergyEntry(String newEntry, String qualifier, String condition) {
        if (qualifier != null && condition != null) {
            newEntry = newEntry + "=" + qualifier + "=" + condition;
        }
        return newEntry;
    }

    private void btnCancelActionPerformed() {
        this.wasCancelled = true;
        this.closeDialog();
    }

    private void btnSaveActionPerformed() {
        Object[] sel;
        String aString = this.pnlMainTab.getNameText();
        if (aString.length() == 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_demMes1"), "PCGen", MessageType.ERROR);
            return;
        }
        this.thisPObject.setName(aString);
        aString = this.pnlMainTab.getSourceText();
        if (aString.length() != 0) {
            // empty if block
        }
        this.thisPObject.setNameIsPI(this.pnlMainTab.getProductIdentity());
        this.pnlMainTab.updateData(this.thisPObject);
        this.thisPObject.getBonusList().clear();
        this.thisPObject.clearVariableList();
        this.thisPObject.setDR(".CLEAR");
        this.thisPObject.clearPreReq();
        this.thisPObject.clearSpecialAbilityList();
        this.thisPObject.setSR(".CLEAR");
        this.thisPObject.clearSpellList();
        this.thisPObject.clearAutoList();
        switch (this.editType) {
            case 1: {
                Deity deity = (Deity)this.thisPObject;
                if (this.pnlDomains.getAvailableList().length == 0) {
                    deity.setDomainList(null);
                } else {
                    sel = this.pnlDomains.getSelectedList();
                    deity.setDomainList(CoreUtility.arrayToList(sel));
                }
                sel = this.pnlFollowers.getSelectedList();
                StringBuffer tbuf = new StringBuffer(100);
                for (int i = 0; i < sel.length; ++i) {
                    String qualifier = null;
                    aString = (String)sel[i];
                    int idx = aString.indexOf(" [VARDEFINED:");
                    if (idx >= 0) {
                        qualifier = aString.substring(idx + 1);
                        if (qualifier.endsWith("]")) {
                            qualifier = qualifier.substring(0, qualifier.length() - 1);
                        }
                        qualifier = qualifier.replace(':', '=');
                        aString = aString.substring(0, idx);
                    }
                    for (int align = 0; align < SettingsHandler.getGame().getUnmodifiableAlignmentList().size(); ++align) {
                        if (!aString.equals(SettingsHandler.getGame().getLongAlignmentAtIndex(align))) continue;
                        if (qualifier != null) {
                            tbuf.append(qualifier).append('=');
                        }
                        tbuf.append(align);
                        if (qualifier == null) continue;
                        tbuf.append(']');
                    }
                }
                ((Deity)this.thisPObject).setFollowerAlignments(tbuf.toString());
                sel = this.pnlRaces.getSelectedList();
                ArrayList<String> raceArray = new ArrayList<String>(sel.length);
                for (int i = 0; i < sel.length; ++i) {
                    raceArray.add(((Race)sel[i]).getName());
                }
                ((Deity)this.thisPObject).setRaceNameList(raceArray);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                Race thisRace = (Race)this.thisPObject;
                thisRace.setMoveRates(this.pnlMovement.getMoveValues());
                thisRace.setMovementTypes(this.pnlMovement.getMoveTypes());
                thisRace.setVisionTable(this.pnlVision.getVision());
                thisRace.setNaturalWeapons(this.pnlNaturalAttacks.getNaturalWeapons());
                this.pnlAppearance.updateData(this.thisPObject);
                this.pnlAge.updateData(this.thisPObject);
                thisRace.addTemplate(".CLEAR");
                sel = this.pnlTemplates.getSelectedList();
                for (int index = 0; index < sel.length; ++index) {
                    thisRace.addTemplate((String)sel[index]);
                }
                sel = this.pnlTemplates.getSelectedList2();
                aString = EditUtil.delimitArray(sel, '|');
                if (aString != null && aString.length() > 0) {
                    thisRace.addTemplate("CHOOSE:" + aString);
                }
                sel = this.pnlClasses.getSelectedList();
                aString = EditUtil.delimitArray(sel, '|');
                thisRace.setFavoredClass(aString);
                sel = this.pnlLanguages.getSelectedList2();
                aString = EditUtil.delimitArray(sel, '|');
                thisRace.setChooseLanguageAutos(aString);
                sel = this.pnlFeats.getSelectedList();
                aString = EditUtil.delimitArray(sel, '|');
                thisRace.setFeatList(aString);
                sel = this.pnlFeats.getSelectedList2();
                aString = EditUtil.delimitArray(sel, '|');
                thisRace.setMFeatList(aString);
                thisRace.setLanguageBonus(".CLEAR");
                sel = this.pnlBonusLang.getSelectedList();
                aString = EditUtil.delimitArray(sel, ',');
                thisRace.setLanguageBonus(aString);
                break;
            }
            case 6: {
                int i;
                ((Skill)this.thisPObject).getSynergyList().clear();
                sel = this.pnlSynergy.getSelectedList();
                for (i = 0; i < sel.length; ++i) {
                    StringTokenizer aTok = new StringTokenizer(sel[i].toString(), "=");
                    if (aTok.countTokens() == 3) {
                        String skillName = aTok.nextToken();
                        String skillRank = aTok.nextToken();
                        StringBuffer sb = new StringBuffer(50);
                        sb.append("SKILL|").append(this.thisPObject.getName());
                        sb.append('|').append(aTok.nextToken());
                        sb.append("|PRESKILL:1,").append(skillName).append('=').append(skillRank);
                        sb.append("|TYPE=Synergy.STACK");
                        this.thisPObject.addBonusList(sb.toString());
                        continue;
                    }
                    Logging.errorPrint("Synergy has invalid format: " + sel[i].toString());
                }
                ((Skill)this.thisPObject).getClassList().clear();
                sel = this.pnlClasses.getSelectedList2();
                for (i = 0; i < sel.length; ++i) {
                    ((Skill)this.thisPObject).addClassList('!' + sel[i].toString());
                }
                sel = this.pnlClasses.getSelectedList();
                for (i = 0; i < sel.length; ++i) {
                    ((Skill)this.thisPObject).addClassList(sel[i].toString());
                }
                break;
            }
            case 7: {
                int idx;
                int i;
                ((SpellBasePanel2)this.pnlBase2).updateData(this.thisPObject);
                ((Spell)this.thisPObject).setLevelInfo(".CLEAR", 0);
                sel = this.pnlQClasses.getSelectedList();
                for (i = 0; i < sel.length; ++i) {
                    aString = sel[i].toString();
                    idx = aString.indexOf(61);
                    if (idx <= 0) continue;
                    ((Spell)this.thisPObject).setLevelInfo("CLASS|" + aString.substring(0, idx), aString.substring(idx + 1));
                }
                sel = this.pnlQDomains.getSelectedList();
                for (i = 0; i < sel.length; ++i) {
                    aString = sel[i].toString();
                    idx = aString.indexOf(61);
                    if (idx <= 0) continue;
                    ((Spell)this.thisPObject).setLevelInfo("DOMAIN|" + aString.substring(0, idx), aString.substring(idx + 1));
                }
                break;
            }
            case 8: {
                int index;
                PCTemplate thisPCTemplate = (PCTemplate)this.thisPObject;
                thisPCTemplate.setMoveRates(this.pnlMovement.getMoveValues());
                thisPCTemplate.setMoveRatesFlag(this.pnlMovement.getMoveRateType());
                thisPCTemplate.addTemplate(".CLEAR");
                sel = this.pnlTemplates.getSelectedList();
                for (index = 0; index < sel.length; ++index) {
                    thisPCTemplate.addTemplate((String)sel[index]);
                }
                sel = this.pnlTemplates.getSelectedList2();
                aString = EditUtil.delimitArray(sel, '|');
                if (aString != null && aString.length() > 0) {
                    thisPCTemplate.addTemplate("CHOOSE:" + aString);
                }
                sel = this.pnlClasses.getSelectedList();
                aString = EditUtil.delimitArray(sel, '|');
                thisPCTemplate.setFavoredClass(aString);
                sel = this.pnlLanguages.getSelectedList2();
                aString = EditUtil.delimitArray(sel, '|');
                thisPCTemplate.setChooseLanguageAutos(aString);
                thisPCTemplate.addFeatString(".CLEAR");
                sel = this.pnlFeats.getSelectedList();
                aString = EditUtil.delimitArray(sel, '|');
                thisPCTemplate.addFeatString(aString);
                thisPCTemplate.setLanguageBonus(".CLEAR");
                sel = this.pnlBonusLang.getSelectedList();
                aString = EditUtil.delimitArray(sel, ',');
                thisPCTemplate.setLanguageBonus(aString);
                thisPCTemplate.addHitDiceString(".CLEAR");
                thisPCTemplate.addLevelString(".CLEAR");
                sel = this.pnlLevelAbilities.getSelectedList();
                for (index = 0; index < sel.length; ++index) {
                    aString = (String)sel[index];
                    if (aString.startsWith("HD:")) {
                        thisPCTemplate.addHitDiceString(aString.substring(3));
                        continue;
                    }
                    if (!aString.startsWith("LEVEL:")) continue;
                    thisPCTemplate.addLevelString(aString.substring(6));
                }
                break;
            }
            case 9: {
                this.pnlFileTypes.updateData(this.thisPObject);
                break;
            }
        }
        if (this.pnlLanguages != null) {
            this.thisPObject.addLanguageAutos(".CLEAR");
            sel = this.pnlLanguages.getSelectedList();
            aString = EditUtil.delimitArray(sel, ',');
            this.thisPObject.addLanguageAutos(aString);
        }
        if (this.pnlWeapons != null) {
            this.thisPObject.addWeaponProfAutos(".CLEAR");
            sel = this.pnlWeapons.getSelectedList();
            aString = EditUtil.delimitArray(sel, '|');
            this.thisPObject.addWeaponProfAutos(aString);
            sel = this.pnlWeapons.getSelectedList2();
            if (sel != null) {
                aString = EditUtil.delimitArray(sel, '|');
                if (this.editType == 0) {
                    ((PCClass)this.thisPObject).setWeaponProfBonus(aString);
                } else if (this.editType == 5) {
                    ((Race)this.thisPObject).setWeaponProfBonus(aString);
                }
            }
        }
        if (this.pnlSkills != null) {
            this.thisPObject.setCSkillList(".CLEAR");
            sel = this.pnlSkills.getSelectedList();
            aString = EditUtil.delimitArray(sel, '|');
            this.thisPObject.setCSkillList(aString);
            this.thisPObject.setCcSkillList(".CLEAR");
            sel = this.pnlSkills.getSelectedList2();
            aString = EditUtil.delimitArray(sel, '|');
            this.thisPObject.setCcSkillList(aString);
        }
        switch (this.editType) {
            case 1: {
                ((Deity)this.thisPObject).getPantheonList().clear();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                ((Skill)this.thisPObject).setChoiceString(null);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
        }
        if (this.editType == 6) {
            ((Skill)this.thisPObject).setChoiceString(null);
        } else if (this.editType == 2 || this.editType == 3) {
            this.thisPObject.setChoiceString("");
        }
        sel = ((JListModel)this.lstAdvancedSelected.getModel()).getElements();
        if (this.editType == 0) {
            this.pnlClassAbility.updateData(this.thisPObject);
            this.pnlClassLevel.updateData(this.thisPObject);
        }
        for (int i = 0; i < sel.length; ++i) {
            aString = (String)sel[i];
            try {
                PObjectLoader.parseTag(this.thisPObject, aString);
            }
            catch (PersistenceLayerException ple) {
                Logging.errorPrint(ple.getMessage(), ple);
            }
            if (this.editType != 1 || !aString.startsWith("PANTHEON:")) continue;
            ((Deity)this.thisPObject).addPantheonToList(aString.substring(9));
        }
        this.thisPObject.setTypeInfo("CUSTOM");
        this.wasCancelled = false;
        this.closeDialog();
    }

    private void initComponentContents() {
        ArrayList saList;
        int i;
        StringTokenizer aTok;
        String aString;
        Iterator<Object> e;
        List<Language> availableList = new ArrayList();
        ArrayList<Object> selectedList = new ArrayList<Object>();
        ArrayList<Object> selectedList2 = new ArrayList<Object>();
        PlayerCharacter aPC = Globals.getCurrentPC();
        this.pnlMainTab.setNameText(this.thisPObject.getName());
        this.pnlMainTab.setProductIdentity(this.thisPObject.getNameIsPI());
        this.pnlMainTab.setSourceText(this.thisPObject.getSourcePage());
        this.pnlMainTab.updateView(this.thisPObject);
        switch (this.editType) {
            case 0: {
                break;
            }
            case 1: {
                availableList.clear();
                selectedList.clear();
                e = SettingsHandler.getGame().getUnmodifiableAlignmentList().iterator();
                while (e.hasNext()) {
                    PCAlignment anAlignment = (PCAlignment)e.next();
                    if (!anAlignment.isValidForFollower()) continue;
                    availableList.add((Language)((Object)anAlignment.getName()));
                }
                String followerAlignments = ((Deity)this.thisPObject).getFollowerAlignments();
                this.parseAlignment(availableList, selectedList, followerAlignments, null);
                this.pnlFollowers.setAvailableList(availableList, true);
                this.pnlFollowers.setSelectedList(selectedList, true);
                selectedList.clear();
                availableList.clear();
                e = Globals.getDomainList().iterator();
                while (e.hasNext()) {
                    Domain aDomain = (Domain)e.next();
                    if (((Deity)this.thisPObject).hasDomain(aDomain)) {
                        selectedList.add(aDomain);
                        continue;
                    }
                    availableList.add((Language)((Object)aDomain));
                }
                this.pnlDomains.setAvailableList(availableList, true);
                this.pnlDomains.setSelectedList(selectedList, true);
                selectedList.clear();
                availableList.clear();
                List raceList = ((Deity)this.thisPObject).getRaceList();
                e = Globals.getRaceMap().values().iterator();
                while (e.hasNext()) {
                    Race aRace = (Race)e.next();
                    String raceName = aRace.getName();
                    if (raceName.equals("<none selected>")) continue;
                    if (raceList.contains(raceName)) {
                        selectedList.add(aRace);
                        continue;
                    }
                    availableList.add((Language)((Object)aRace));
                }
                this.pnlRaces.setAvailableList(availableList, true);
                this.pnlRaces.setSelectedList(selectedList, true);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                String featName;
                Feat aFeat;
                availableList.clear();
                selectedList.clear();
                selectedList2.clear();
                e = Globals.getTemplateList().iterator();
                while (e.hasNext()) {
                    PCTemplate aTemplate = (PCTemplate)e.next();
                    aString = aTemplate.getName();
                    if (availableList.contains(aString)) continue;
                    availableList.add((Language)((Object)aString));
                }
                EditorMainForm.moveGrantedTemplatesFromAvailableToSelected(((Race)this.thisPObject).getTemplateList(), selectedList, selectedList2, availableList);
                this.pnlTemplates.setAvailableList(availableList, true);
                this.pnlTemplates.setSelectedList(selectedList, true);
                this.pnlTemplates.setSelectedList2(selectedList2, true);
                availableList.clear();
                selectedList.clear();
                e = Globals.getClassList().iterator();
                while (e.hasNext()) {
                    PCClass aClass = (PCClass)e.next();
                    availableList.add((Language)((Object)aClass.getName()));
                }
                availableList.add((Language)((Object)"Any"));
                aString = ((Race)this.thisPObject).getFavoredClass();
                aTok = new StringTokenizer(aString, "|", false);
                while (aTok.hasMoreTokens()) {
                    String favouredClass = aTok.nextToken();
                    if (selectedList.contains(favouredClass)) continue;
                    int idx = availableList.indexOf(favouredClass);
                    if (idx < 0) {
                        Logging.errorPrint("Unknown class: " + favouredClass);
                        continue;
                    }
                    availableList.remove(idx);
                    selectedList.add(favouredClass);
                }
                this.pnlClasses.setAvailableList(availableList, true);
                this.pnlClasses.setSelectedList(selectedList, true);
                availableList.clear();
                selectedList.clear();
                selectedList2.clear();
                e = Globals.getFeatList().iterator();
                while (e.hasNext()) {
                    aFeat = (Feat)e.next();
                    availableList.add((Language)((Object)aFeat.getName()));
                }
                aString = ((Race)this.thisPObject).getFeatList(aPC, false);
                aTok = new StringTokenizer(aString, "|", false);
                while (aTok.hasMoreTokens()) {
                    featName = aTok.nextToken();
                    if (selectedList.contains(featName)) continue;
                    availableList.remove(featName);
                    selectedList.add(featName);
                }
                aString = ((Race)this.thisPObject).getMFeatList();
                aTok = new StringTokenizer(aString, "|", false);
                while (aTok.hasMoreTokens()) {
                    featName = aTok.nextToken();
                    if (selectedList2.contains(featName)) continue;
                    availableList.remove(featName);
                    selectedList2.add(featName);
                }
                this.pnlFeats.setAvailableList(availableList, true);
                this.pnlFeats.setSelectedList(selectedList, true);
                this.pnlFeats.setSelectedList2(selectedList2, true);
                availableList.clear();
                selectedList.clear();
                e = Globals.getFeatList().iterator();
                while (e.hasNext()) {
                    aFeat = (Feat)e.next();
                    availableList.add((Language)((Object)aFeat.getName()));
                }
                e = ((Race)this.thisPObject).getVirtualFeatList().iterator();
                while (e.hasNext()) {
                    aFeat = (Feat)e.next();
                    String featName2 = aFeat.getName();
                    if (selectedList.contains(featName2)) continue;
                    availableList.remove(featName2);
                    selectedList.add(featName2);
                }
                this.pnlVFeats.setAvailableList(availableList, true);
                this.pnlVFeats.setSelectedList(selectedList, true);
                selectedList.clear();
                availableList.clear();
                ArrayList aList = ((Race)this.thisPObject).getLanguageBonus();
                e = Globals.getLanguageList().iterator();
                while (e.hasNext()) {
                    Language aLang = (Language)e.next();
                    if (aList.contains(aLang)) {
                        selectedList.add(aLang);
                        continue;
                    }
                    availableList.add(aLang);
                }
                this.pnlBonusLang.setAvailableList(availableList, true);
                this.pnlBonusLang.setSelectedList(selectedList, true);
                ArrayList<String> movementValues = new ArrayList();
                if (this.thisPObject.getNumberOfMovementTypes() > 0) {
                    for (int index = 0; index < this.thisPObject.getNumberOfMovementTypes(); ++index) {
                        String aMove = MovementPanel.makeMoveString(this.thisPObject.getMovementType(index), this.thisPObject.getMovement(index), null, null);
                        movementValues.add(aMove);
                    }
                }
                this.pnlMovement.setSelectedList(movementValues);
                Map vision = ((Race)this.thisPObject).getVisionTable();
                ArrayList<String> visionValues = new ArrayList<String>();
                if (vision != null) {
                    Iterator i2 = vision.keySet().iterator();
                    while (i2.hasNext()) {
                        StringBuffer vis = new StringBuffer(25);
                        String aKey = i2.next().toString();
                        String aVal = vision.get(aKey).toString();
                        vis.append(aKey);
                        vis.append(',').append(aVal);
                        visionValues.add(vis.toString());
                    }
                }
                this.pnlVision.setSelectedList(visionValues);
                List naturalAttacks = this.thisPObject.getNaturalWeapons();
                this.pnlNaturalAttacks.setSelectedList(aPC, naturalAttacks);
                ArrayList<String> eyeColorList = new ArrayList<String>();
                ArrayList<String> hairColorList = new ArrayList<String>();
                ArrayList<String> skinToneList = new ArrayList<String>();
                e = Globals.getRaceMap().keySet().iterator();
                while (e.hasNext()) {
                    String ast;
                    StringTokenizer at;
                    String as;
                    Iterator ai;
                    String raceName = (String)e.next();
                    Race aRace = (Race)Globals.getRaceMap().get(raceName);
                    aString = aRace.getRegionString();
                    if (aString == null) {
                        aString = "None";
                    }
                    if ((aList = Globals.getBioSet().getTagForRace(aString, raceName, "HAIR")) != null) {
                        ai = aList.iterator();
                        while (ai.hasNext()) {
                            as = (String)ai.next();
                            at = new StringTokenizer(as, "|", false);
                            while (at.hasMoreTokens()) {
                                ast = at.nextToken();
                                if (hairColorList.contains(ast)) continue;
                                hairColorList.add(ast);
                            }
                        }
                    }
                    if ((aList = Globals.getBioSet().getTagForRace(aString, raceName, "EYES")) != null) {
                        ai = aList.iterator();
                        while (ai.hasNext()) {
                            as = (String)ai.next();
                            at = new StringTokenizer(as, "|", false);
                            while (at.hasMoreTokens()) {
                                ast = at.nextToken();
                                if (eyeColorList.contains(ast)) continue;
                                eyeColorList.add(ast);
                            }
                        }
                    }
                    if ((aList = Globals.getBioSet().getTagForRace(aString, raceName, "SKINTONE")) == null) continue;
                    ai = aList.iterator();
                    while (ai.hasNext()) {
                        as = (String)ai.next();
                        at = new StringTokenizer(as, "|", false);
                        while (at.hasMoreTokens()) {
                            ast = at.nextToken();
                            if (skinToneList.contains(ast)) continue;
                            skinToneList.add(ast);
                        }
                    }
                }
                this.pnlAppearance.setEyeColorAvailableList(eyeColorList, true);
                this.pnlAppearance.setHairColorAvailableList(hairColorList, true);
                this.pnlAppearance.setSkinToneAvailableList(skinToneList, true);
                this.pnlAppearance.updateView(this.thisPObject);
                this.pnlAge.updateView(this.thisPObject);
                break;
            }
            case 6: {
                availableList.clear();
                selectedList.clear();
                selectedList2.clear();
                e = Globals.getClassList().iterator();
                while (e.hasNext()) {
                    PCClass aClass = (PCClass)e.next();
                    availableList.add((Language)((Object)aClass.getName()));
                }
                e = ((Skill)this.thisPObject).getClassList().iterator();
                while (e.hasNext()) {
                    boolean negate;
                    aString = (String)e.next();
                    if (aString.length() <= 0) continue;
                    if (aString.charAt(0) == '!') {
                        aString = aString.substring(1);
                        negate = true;
                    } else {
                        negate = false;
                    }
                    int idx = availableList.indexOf(aString);
                    if (idx < 0) {
                        Logging.errorPrint("Unknown class: " + aString);
                        continue;
                    }
                    availableList.remove(idx);
                    if (negate) {
                        selectedList2.add(aString);
                        continue;
                    }
                    selectedList.add(aString);
                }
                this.pnlClasses.setAvailableList(availableList, true);
                this.pnlClasses.setSelectedList(selectedList, true);
                this.pnlClasses.setSelectedList2(selectedList2, true);
                this.pnlClasses.setLblSelectedText("Class Skill");
                this.pnlClasses.setLblSelected2Text("Not allowed");
                break;
            }
            case 7: {
                PCClass aClass;
                Integer lvl;
                ((SpellBasePanel2)this.pnlBase2).updateView(this.thisPObject);
                Map lvlInfo = ((Spell)this.thisPObject).getLevelInfo(aPC);
                int iCount = 0;
                selectedList.clear();
                availableList.clear();
                e = Globals.getDomainList().iterator();
                while (e.hasNext()) {
                    Domain aDomain = (Domain)e.next();
                    lvl = null;
                    if (lvlInfo != null) {
                        lvl = (Integer)lvlInfo.get("DOMAIN|" + aDomain.getName());
                    }
                    if (lvl != null) {
                        selectedList.add(EditorMainForm.encodeDomainEntry(aDomain.getName(), lvl.toString()));
                        ++iCount;
                        continue;
                    }
                    availableList.add((Language)((Object)aDomain.getName()));
                }
                this.pnlQDomains.setAvailableList(availableList, true);
                this.pnlQDomains.setSelectedList(selectedList, true);
                selectedList.clear();
                availableList.clear();
                e = Globals.getClassList().iterator();
                while (e.hasNext()) {
                    aClass = (PCClass)e.next();
                    lvl = null;
                    if (lvlInfo != null) {
                        lvl = (Integer)lvlInfo.get("CLASS|" + aClass.getName());
                    }
                    if (lvl != null) {
                        selectedList.add(EditorMainForm.encodeDomainEntry(aClass.getName(), lvl.toString()));
                        ++iCount;
                        continue;
                    }
                    availableList.add((Language)((Object)aClass.getName()));
                }
                this.pnlQClasses.setAvailableList(availableList, true);
                this.pnlQClasses.setSelectedList(selectedList, true);
                if (lvlInfo == null || lvlInfo.size() == iCount) break;
                Logging.errorPrint(Integer.toString(iCount) + " classes and domains found. Should have been " + Integer.toString(lvlInfo.size()) + "\n" + lvlInfo);
                break;
            }
            case 8: {
                PCClass aClass;
                availableList.clear();
                selectedList.clear();
                selectedList2.clear();
                e = Globals.getTemplateList().iterator();
                while (e.hasNext()) {
                    PCTemplate aTemplate = (PCTemplate)e.next();
                    aString = aTemplate.getName();
                    if (availableList.contains(aString)) continue;
                    availableList.add((Language)((Object)aString));
                }
                EditorMainForm.moveGrantedTemplatesFromAvailableToSelected(((PCTemplate)this.thisPObject).getTemplateList(), selectedList, selectedList2, availableList);
                this.pnlTemplates.setAvailableList(availableList, true);
                this.pnlTemplates.setSelectedList(selectedList, true);
                this.pnlTemplates.setSelectedList2(selectedList2, true);
                availableList.clear();
                selectedList.clear();
                e = Globals.getClassList().iterator();
                while (e.hasNext()) {
                    aClass = (PCClass)e.next();
                    availableList.add((Language)((Object)aClass.getName()));
                }
                availableList.add((Language)((Object)"Any"));
                aString = ((PCTemplate)this.thisPObject).getFavoredClass();
                aTok = new StringTokenizer(aString, "|", false);
                while (aTok.hasMoreTokens()) {
                    String favouredClass = aTok.nextToken();
                    if (selectedList.contains(favouredClass)) continue;
                    int idx = availableList.indexOf(favouredClass);
                    if (idx < 0) {
                        Logging.errorPrint("Unknown class: " + favouredClass);
                        continue;
                    }
                    availableList.remove(idx);
                    selectedList.add(favouredClass);
                }
                this.pnlClasses.setAvailableList(availableList, true);
                this.pnlClasses.setSelectedList(selectedList, true);
                availableList.clear();
                selectedList.clear();
                e = Globals.getFeatList().iterator();
                while (e.hasNext()) {
                    Feat aFeat = (Feat)e.next();
                    availableList.add((Language)((Object)aFeat.getName()));
                }
                List featList = ((PCTemplate)this.thisPObject).feats(-1, -1, aPC);
                e = featList.iterator();
                while (e.hasNext()) {
                    aString = (String)e.next();
                    if (selectedList.contains(aString)) continue;
                    availableList.remove(aString);
                    selectedList.add(aString);
                }
                this.pnlFeats.setAvailableList(availableList, true);
                this.pnlFeats.setSelectedList(selectedList, true);
                ArrayList<String> movementValues = new ArrayList<String>();
                if (this.thisPObject.getNumberOfMovementTypes() > 0) {
                    for (int index = 0; index < this.thisPObject.getNumberOfMovementTypes(); ++index) {
                        String aMove = MovementPanel.makeMoveString(this.thisPObject.getMovementType(index), this.thisPObject.getMovement(index), this.thisPObject.getMovementMult(index), this.thisPObject.getMovementMultOp(index));
                        movementValues.add(aMove);
                    }
                }
                this.pnlMovement.setSelectedList(movementValues);
                this.pnlMovement.setMoveRateType(this.thisPObject.getMoveRatesFlag());
                selectedList.clear();
                ArrayList abilitiesList = ((PCTemplate)this.thisPObject).getLevelStrings();
                if (abilitiesList != null) {
                    e = abilitiesList.iterator();
                    while (e.hasNext()) {
                        aString = (String)e.next();
                        selectedList.add("LEVEL:" + aString);
                    }
                }
                if ((abilitiesList = ((PCTemplate)this.thisPObject).getHitDiceStrings()) != null) {
                    e = abilitiesList.iterator();
                    while (e.hasNext()) {
                        aString = (String)e.next();
                        selectedList.add("HD:" + aString);
                    }
                }
                this.pnlLevelAbilities.setSelectedList(selectedList);
                selectedList.clear();
                availableList.clear();
                Set aSet = ((PCTemplate)this.thisPObject).getLanguageBonus();
                e = Globals.getLanguageList().iterator();
                while (e.hasNext()) {
                    Language aLang = (Language)e.next();
                    if (aSet.contains(aLang)) {
                        selectedList.add(aLang);
                        continue;
                    }
                    availableList.add(aLang);
                }
                this.pnlBonusLang.setAvailableList(availableList, true);
                this.pnlBonusLang.setSelectedList(selectedList, true);
                break;
            }
            case 9: {
                this.pnlFileTypes.updateView(this.thisPObject);
                break;
            }
        }
        if (this.pnlLanguages != null) {
            Language aLang;
            selectedList.clear();
            selectedList2.clear();
            availableList.clear();
            Set aSet = this.thisPObject.getAutoLanguages();
            e = Globals.getLanguageList().iterator();
            while (e.hasNext()) {
                aLang = (Language)e.next();
                if (aSet.contains(aLang)) {
                    selectedList.add(aLang);
                    continue;
                }
                availableList.add(aLang);
            }
            if (this.editType == 8 || this.editType == 5) {
                aString = this.editType == 8 ? ((PCTemplate)this.thisPObject).getChooseLanguageAutos() : ((Race)this.thisPObject).getChooseLanguageAutos();
                aTok = new StringTokenizer(aString, "|", false);
                while (aTok.hasMoreTokens()) {
                    aLang = Globals.getLanguageNamed(aTok.nextToken());
                    if (aLang == null) continue;
                    selectedList2.add(aLang);
                    availableList.remove(aLang);
                }
                this.pnlLanguages.setSelectedList2(selectedList2, true);
            }
            this.pnlLanguages.setAvailableList(availableList, true);
            this.pnlLanguages.setSelectedList(selectedList, true);
        }
        if (this.pnlWeapons != null) {
            WeaponProf wp;
            selectedList.clear();
            availableList = Globals.getWeaponProfArrayCopy();
            ArrayList autoWeap = this.thisPObject.getWeaponProfAutos();
            if (autoWeap != null) {
                e = autoWeap.iterator();
                while (e.hasNext()) {
                    wp = Globals.getWeaponProfNamed((String)e.next());
                    if (wp == null) continue;
                    selectedList.add(wp);
                    availableList.remove(wp);
                }
            }
            if ((e = this.editType == 0 ? ((PCClass)this.thisPObject).getWeaponProfBonus().iterator() : (this.editType == 5 ? ((Race)this.thisPObject).getWeaponProfBonus().iterator() : null)) != null) {
                selectedList2.clear();
                while (e.hasNext()) {
                    wp = Globals.getWeaponProfNamed((String)e.next());
                    if (wp == null) continue;
                    selectedList2.add(wp);
                    availableList.remove(wp);
                }
                this.pnlWeapons.setSelectedList2(selectedList2, true);
                this.pnlWeapons.setLblSelectedText(PropertyFactory.getString("in_demAllGranted"));
                this.pnlWeapons.setLblSelected2Text(PropertyFactory.getString("in_demChoiceGranted"));
            }
            this.pnlWeapons.setAvailableList(availableList, true);
            this.pnlWeapons.setSelectedList(selectedList, true);
        }
        switch (this.editType) {
            case 1: {
                this.pnlFollowers.setQualifierModel(new DefaultComboBoxModel<String>(qualifiers));
                availableList.clear();
                EditorMainForm.addVariables(availableList, Globals.getClassList());
                EditorMainForm.addVariables(availableList, Globals.getFeatList());
                EditorMainForm.addVariables(availableList, Globals.getRaceMap().values());
                EditorMainForm.addVariables(availableList, Globals.getSkillList());
                EditorMainForm.addVariables(availableList, EquipmentList.getModifierList());
                EditorMainForm.addVariables(availableList, Globals.getTemplateList());
                EditorMainForm.addVariables(availableList, Globals.getCompanionModList());
                Collections.sort(availableList);
                this.pnlFollowers.setVariableModel(new DefaultComboBoxModel<Object>(availableList.toArray()));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                availableList.clear();
                selectedList.clear();
                e = Globals.getSkillList().iterator();
                while (e.hasNext()) {
                    Skill aSkill = (Skill)e.next();
                    if (aSkill.getName().equals(this.thisPObject.getName())) continue;
                    availableList.add((Language)((Object)aSkill.getName()));
                }
                if (((Skill)this.thisPObject).getSynergyList() != null) {
                    e = ((Skill)this.thisPObject).getSynergyList().iterator();
                    while (e.hasNext()) {
                        aString = (String)e.next();
                        aTok = new StringTokenizer(aString, "=", false);
                        if (aTok.countTokens() != 3) {
                            Logging.errorPrint("Badly formed synergy element: " + aString);
                            continue;
                        }
                        String skill = aTok.nextToken();
                        String ranks = aTok.nextToken();
                        String bonus = aTok.nextToken();
                        availableList.remove(skill);
                        selectedList.add(EditorMainForm.encodeSynergyEntry(skill, ranks, bonus));
                    }
                }
                e = this.thisPObject.getBonusList().iterator();
                while (e.hasNext()) {
                    EditorMainForm.parseSynergyBonus((BonusObj)e.next(), availableList, selectedList);
                }
                this.pnlSynergy.setAvailableList(availableList, true);
                this.pnlSynergy.setSelectedList(selectedList, true);
                String[] values = new String[30];
                for (int i3 = 0; i3 < values.length; ++i3) {
                    values[i3] = String.valueOf(i3 + 1);
                }
                this.pnlSynergy.setQualifierModel(new DefaultComboBoxModel<String>(values));
                this.pnlSynergy.setVariableModel(new DefaultComboBoxModel<String>(values));
                this.pnlSynergy.setQualifierSelectedIndex(4);
                this.pnlSynergy.setVariableSelectedIndex(1);
                break;
            }
            case 7: {
                availableList.clear();
                for (int i4 = 1; i4 <= 9; ++i4) {
                    availableList.add((Language)((Object)String.valueOf(i4)));
                }
                this.pnlQDomains.setQualifierModel(new DefaultComboBoxModel<Object>(availableList.toArray()));
                this.pnlQDomains.setQualifierSelectedIndex(0);
                availableList.add(0, (Language)((Object)"0"));
                this.pnlQClasses.setQualifierModel(new DefaultComboBoxModel<Object>(availableList.toArray()));
                this.pnlQClasses.setQualifierSelectedIndex(0);
                break;
            }
            case 8: {
                break;
            }
        }
        if (this.pnlSkills != null) {
            selectedList.clear();
            availableList.clear();
            e = Globals.getSkillList().iterator();
            while (e.hasNext()) {
                Skill aSkill = (Skill)e.next();
                aString = aSkill.getName();
                if (!availableList.contains(aString)) {
                    availableList.add((Language)((Object)aString));
                }
                int x = aSkill.getMyTypeCount();
                for (int i5 = 0; i5 < x; ++i5) {
                    aString = "TYPE." + aSkill.getMyType(i5);
                    if (availableList.contains(aString)) continue;
                    availableList.add((Language)((Object)aString));
                }
            }
            ArrayList skills = this.thisPObject.getCSkillList();
            if (skills != null) {
                e = skills.iterator();
                while (e.hasNext()) {
                    aString = (String)e.next();
                    selectedList.add(aString);
                    if (!availableList.contains(aString)) continue;
                    availableList.remove(aString);
                }
            }
            this.pnlSkills.setSelectedList(selectedList, true);
            selectedList.clear();
            skills = this.thisPObject.getCcSkillList();
            if (skills != null) {
                e = skills.iterator();
                while (e.hasNext()) {
                    aString = (String)e.next();
                    selectedList.add(aString);
                    if (!availableList.contains(aString)) continue;
                    availableList.remove(aString);
                }
            }
            this.pnlSkills.setSelectedList2(selectedList, true);
            this.pnlSkills.setAvailableList(availableList, true);
        }
        this.cmbAdvancedTag.setModel(new DefaultComboBoxModel<String>(tags));
        this.cmbAdvancedTag.setSelectedIndex(0);
        selectedList.clear();
        switch (this.editType) {
            case 1: {
                this.cmbAdvancedTag.removeItem("ADD");
                this.cmbAdvancedTag.removeItem("CHOOSE");
                e = ((Deity)this.thisPObject).getPantheonList().iterator();
                while (e.hasNext()) {
                    selectedList.add("PANTHEON:" + e.next());
                }
                break;
            }
            case 4: 
            case 7: {
                this.cmbAdvancedTag.removeItem("ADD");
                this.cmbAdvancedTag.removeItem("CHOOSE");
                this.cmbAdvancedTag.removeItem("PANTHEON");
                break;
            }
            case 2: {
                this.cmbAdvancedTag.removeItem("ADD");
                this.cmbAdvancedTag.removeItem("PANTHEON");
                if (this.thisPObject.getChoiceString().length() == 0) break;
                selectedList.add("CHOOSE:" + this.thisPObject.getChoiceString());
                break;
            }
            case 3: {
                this.cmbAdvancedTag.removeItem("PANTHEON");
                if (this.thisPObject.getChoiceString().length() == 0) break;
                selectedList.add("CHOOSE:" + this.thisPObject.getChoiceString());
                break;
            }
            case 5: {
                this.cmbAdvancedTag.removeItem("ADD");
                this.cmbAdvancedTag.removeItem("PANTHEON");
                break;
            }
            case 6: {
                this.cmbAdvancedTag.removeItem("ADD");
                this.cmbAdvancedTag.removeItem("PANTHEON");
                Skill mySkill = (Skill)this.thisPObject;
                String choiceString = mySkill.getChoiceString();
                if (choiceString == null || choiceString.length() <= 0) break;
                e = ((Skill)this.thisPObject).getChoiceStringList().iterator();
                while (e.hasNext()) {
                    selectedList.add("CHOOSE:" + e.next());
                }
                break;
            }
            case 8: {
                this.cmbAdvancedTag.removeItem("ADD");
                this.cmbAdvancedTag.removeItem("PANTHEON");
                break;
            }
        }
        ArrayList autoList = this.thisPObject.getAutoArray();
        if (autoList != null) {
            e = autoList.iterator();
            while (e.hasNext()) {
                selectedList.add("AUTO:" + e.next().toString());
            }
        }
        if (this.editType != 0) {
            e = this.thisPObject.getBonusList().iterator();
            while (e.hasNext()) {
                BonusObj bonus = (BonusObj)e.next();
                if (EditorMainForm.parseSynergyBonus(bonus, null, null)) continue;
                selectedList.add("BONUS:" + bonus.toString());
            }
        }
        int x = this.thisPObject.getPreReqCount();
        for (i = 0; i < x; ++i) {
            StringWriter writer = new StringWriter();
            Prerequisite prereq = this.thisPObject.getPreReq(i);
            PrerequisiteWriter prereqWriter = new PrerequisiteWriter();
            try {
                prereqWriter.write(writer, prereq);
            }
            catch (PersistenceLayerException e1) {
                e1.printStackTrace();
            }
            selectedList.add(writer.toString());
        }
        if (this.editType != 0) {
            x = this.thisPObject.getVariableCount();
            for (i = 0; i < x; ++i) {
                aString = this.thisPObject.getVariableDefinition(i);
                if (aString.startsWith("-9|")) {
                    aString = aString.substring(3);
                }
                selectedList.add("DEFINE:" + aString);
            }
        }
        if ((saList = this.thisPObject.getSpecialAbilityList()) != null && saList.size() != 0 && this.editType != 0) {
            e = saList.iterator();
            while (e.hasNext()) {
                Object specialAbility = e.next();
                String saSource = ((SpecialAbility)specialAbility).getSource();
                String saLevel = saSource.substring(saSource.indexOf("|") + 1);
                String saTxt = specialAbility.toString();
                if (saLevel.length() > 0) {
                    saLevel = saLevel + "|";
                }
                selectedList.add("SA:" + saLevel + saTxt);
            }
            saList.clear();
        }
        if ((aString = this.thisPObject.getDR()) != null) {
            aTok = new StringTokenizer(aString, "|", false);
            while (aTok.hasMoreTokens()) {
                selectedList.add("DR:" + aTok.nextToken());
            }
        }
        if (this.editType != 0) {
            int idx = 0;
            while ((aString = this.thisPObject.getSpellListItemAsString(idx, aPC)) != null) {
                selectedList.add("SPELL:" + aString);
                ++idx;
            }
        }
        if ((aString = this.thisPObject.getSRFormula()) != null) {
            selectedList.add("SR:" + aString);
        }
        this.lstAdvancedSelected.setModel(new JListModel(selectedList, true));
    }

    private static void moveGrantedTemplatesFromAvailableToSelected(List templateList, List selectedList, List selectedList2, List availableList) {
        Iterator e = templateList.iterator();
        while (e.hasNext()) {
            String aString = (String)e.next();
            if (aString.startsWith("CHOOSE:")) {
                StringTokenizer aTok = new StringTokenizer(aString.substring(7), "|", false);
                while (aTok.hasMoreTokens()) {
                    String chooseTemplate = aTok.nextToken();
                    if (selectedList.contains(chooseTemplate)) continue;
                    selectedList2.add(chooseTemplate);
                }
                continue;
            }
            selectedList.add(aString);
            availableList.remove(aString);
        }
    }

    private void initComponents() {
        try {
            this.btnAddAdvanced = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
            this.btnRemoveAdvanced = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        }
        catch (Exception exc) {
            this.btnAddAdvanced = new JButton(">");
            this.btnRemoveAdvanced = new JButton("<");
        }
        this.btnCancel = new JButton();
        this.btnSave = new JButton();
        this.cmbAdvancedTag = new JComboBoxEx();
        this.jTabbedPane1 = new JTabbedPane();
        this.lblAdvancedHeader = new JLabel();
        this.lblAdvancedSelected = new JLabel();
        this.lblAdvancedTag = new JLabel();
        this.lblAdvancedTagValue = new JLabel();
        this.lstAdvancedSelected = new JList();
        this.pnlAdvanced = new JPanel();
        this.pnlAdvancedAvailable = new JPanel();
        this.pnlAdvancedButtons = new JPanel();
        this.pnlAdvancedHeader = new JPanel();
        this.pnlAdvancedSelected = new JPanel();
        this.pnlAdvancedTag = new JPanel();
        this.pnlAdvancedTagValue = new JPanel();
        this.pnlButtons = new JPanel();
        this.pnlMainDialog = new JPanel();
        this.pnlTabs = new JPanel();
        this.pnllstAdvancedSelected = new JPanel();
        this.pnllstAdvancedTagValue = new JPanel();
        this.scpAdvancedSelected = new JScrollPane();
        this.scpAdvancedTagValue = new JScrollPane();
        this.txtAdvancedTagValue = new JTextArea();
        switch (this.editType) {
            case 0: {
                this.pnlLanguages = new AvailableSelectedPanel();
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel(true);
                this.pnlClassAbility = new ClassAbilityPanel();
                this.pnlClassAbility.updateView(this.thisPObject);
                this.pnlClassLevel = new ClassLevelPanel();
                this.pnlClassLevel.updateView(this.thisPObject);
                break;
            }
            case 1: {
                this.pnlLanguages = new AvailableSelectedPanel();
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel();
                this.pnlDomains = new AvailableSelectedPanel();
                this.pnlFollowers = new QualifiedAvailableSelectedPanel("in_demQualifier", "in_demVariable", new EditorAddFilter(){

                    public Object encode(Object anObj) {
                        return EditorMainForm.this.encodeFollowerEntry((String)anObj);
                    }

                    public Object decode(Object anObj) {
                        return EditorMainForm.this.decodeFollowerEntry((String)anObj);
                    }
                }, new ItemListener(){

                    public void itemStateChanged(ItemEvent evt) {
                        EditorMainForm.this.cmbQualifierItemStateChanged();
                    }
                });
                this.pnlRaces = new AvailableSelectedPanel();
                break;
            }
            case 2: {
                this.pnlLanguages = new AvailableSelectedPanel();
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel();
                break;
            }
            case 3: {
                this.pnlLanguages = new AvailableSelectedPanel();
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.pnlMovement = new MovementPanel(true);
                this.pnlVision = new VisionPanel();
                this.pnlNaturalAttacks = new NaturalAttacksPanel();
                this.pnlLanguages = new AvailableSelectedPanel(true);
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlTemplates = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel(true);
                this.pnlClasses = new AvailableSelectedPanel();
                this.pnlFeats = new AvailableSelectedPanel(true);
                this.pnlVFeats = new AvailableSelectedPanel();
                this.pnlBonusLang = new AvailableSelectedPanel();
                this.pnlAppearance = new AppearancePanel();
                this.pnlAge = new AgePanel();
                break;
            }
            case 6: {
                this.pnlLanguages = new AvailableSelectedPanel();
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel();
                this.pnlClasses = new AvailableSelectedPanel(true);
                this.pnlSynergy = new QualifiedAvailableSelectedPanel("in_demSkillRank", "in_demSynergyBonus", new EditorAddFilter(){

                    public Object encode(Object anObj) {
                        return EditorMainForm.this.encodeSynergyEntry((String)anObj);
                    }

                    public Object decode(Object anObj) {
                        return EditorMainForm.this.decodeSynergyEntry((String)anObj);
                    }
                }, null);
                break;
            }
            case 7: {
                this.pnlBase2 = new SpellBasePanel2();
                this.pnlQClasses = new QualifiedAvailableSelectedPanel("in_demLevel", null, new EditorAddFilter(){

                    public Object encode(Object anObj) {
                        return EditorMainForm.this.encodeDomainEntry(EditorMainForm.this.pnlQClasses, (String)anObj);
                    }

                    public Object decode(Object anObj) {
                        return EditorMainForm.decodeDomainEntry((String)anObj);
                    }
                }, null);
                this.pnlQDomains = new QualifiedAvailableSelectedPanel("in_demLevel", null, new EditorAddFilter(){

                    public Object encode(Object anObj) {
                        return EditorMainForm.this.encodeDomainEntry(EditorMainForm.this.pnlQDomains, (String)anObj);
                    }

                    public Object decode(Object anObj) {
                        return EditorMainForm.decodeDomainEntry((String)anObj);
                    }
                }, null);
                break;
            }
            case 8: {
                this.pnlMovement = new MovementPanel(false);
                this.pnlLevelAbilities = new LevelAbilitiesPanel();
                this.pnlLanguages = new AvailableSelectedPanel(true);
                this.pnlSkills = new AvailableSelectedPanel(true);
                this.pnlTemplates = new AvailableSelectedPanel(true);
                this.pnlWeapons = new AvailableSelectedPanel();
                this.pnlClasses = new AvailableSelectedPanel();
                this.pnlFeats = new AvailableSelectedPanel();
                this.pnlBonusLang = new AvailableSelectedPanel();
                break;
            }
            case 9: {
                this.pnlFileTypes = new SourceFilesPanel();
                break;
            }
        }
        this.getContentPane().setLayout(new GridBagLayout());
        String ttl = "";
        switch (this.editType) {
            case 0: {
                ttl = "Class";
                break;
            }
            case 1: {
                ttl = "Deity";
                break;
            }
            case 2: {
                ttl = "Domain";
                break;
            }
            case 3: {
                ttl = "Feat";
                break;
            }
            case 4: {
                ttl = "Language";
                break;
            }
            case 5: {
                ttl = "Race";
                break;
            }
            case 6: {
                ttl = "Skill";
                break;
            }
            case 7: {
                ttl = "Spell";
                break;
            }
            case 8: {
                ttl = "Template";
                break;
            }
        }
        this.setTitle(PropertyFactory.getString("in_demTitle" + ttl));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                EditorMainForm.this.wasCancelled = true;
                EditorMainForm.this.closeDialog();
            }
        });
        this.pnlMainDialog.setLayout(new GridBagLayout());
        this.pnlMainDialog.setPreferredSize(new Dimension(640, 460));
        this.pnlTabs.setLayout(new BorderLayout());
        this.pnlTabs.setMinimumSize(new Dimension(128, 88));
        this.pnlTabs.setPreferredSize(new Dimension(640, 440));
        this.jTabbedPane1.setName(PropertyFactory.getString("in_demDeitytab"));
        this.pnlMainTab = new EditorBasePanel(this.editType);
        this.jTabbedPane1.addTab(PropertyFactory.getString("in_demBase"), this.pnlMainTab);
        switch (this.editType) {
            case 0: {
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_classability"), this.pnlClassAbility);
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_classlevel"), this.pnlClassLevel);
                break;
            }
            case 1: {
                this.pnlDomains.setHeader(PropertyFactory.getString("in_demGrantDom"));
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_domains"), this.pnlDomains);
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demFollowers"), this.pnlFollowers);
                this.pnlRaces.setHeader(PropertyFactory.getString("in_demRacWors"));
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_race"), this.pnlRaces);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.pnlClasses.setHeader(PropertyFactory.getString("in_demFavoredClasses"));
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demClasses"), this.pnlClasses);
                this.pnlTemplates.setLblSelectedText(PropertyFactory.getString("in_demAllGranted"));
                this.pnlTemplates.setLblSelected2Text(PropertyFactory.getString("in_demChoiceGranted"));
                this.pnlLanguages.setLblSelectedText(PropertyFactory.getString("in_demAllGranted"));
                this.pnlLanguages.setLblSelected2Text(PropertyFactory.getString("in_demChoiceGranted"));
                this.pnlBonusLang.setHeader(PropertyFactory.getString("in_demBonusLang"));
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demBonusLangAbbrev"), this.pnlBonusLang);
                this.pnlFeats.setLblSelectedText(PropertyFactory.getString("in_demSelFeats"));
                this.pnlFeats.setLblSelected2Text(PropertyFactory.getString("in_demSelMFeats"));
                break;
            }
            case 6: {
                this.pnlSynergy.setHeader(" ");
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demSynergy"), this.pnlSynergy);
                this.pnlClasses.setHeader(" ");
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demClasses"), this.pnlClasses);
                break;
            }
            case 7: {
                this.jTabbedPane1.addTab("?Base2?", this.pnlBase2);
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demClasses"), this.pnlQClasses);
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_domains"), this.pnlQDomains);
                break;
            }
            case 8: {
                this.pnlClasses.setHeader(PropertyFactory.getString("in_demFavoredClasses"));
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demClasses"), this.pnlClasses);
                this.pnlTemplates.setLblSelectedText(PropertyFactory.getString("in_demAllGranted"));
                this.pnlTemplates.setLblSelected2Text(PropertyFactory.getString("in_demChoiceGranted"));
                this.pnlLanguages.setLblSelectedText(PropertyFactory.getString("in_demAllGranted"));
                this.pnlLanguages.setLblSelected2Text(PropertyFactory.getString("in_demChoiceGranted"));
                this.pnlBonusLang.setHeader(PropertyFactory.getString("in_demBonusLang"));
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_demBonusLangAbbrev"), this.pnlBonusLang);
                break;
            }
            case 9: {
                this.jTabbedPane1.addTab(PropertyFactory.getString("in_fileTypes"), this.pnlFileTypes);
                break;
            }
        }
        if (this.pnlLanguages != null) {
            this.pnlLanguages.setHeader(PropertyFactory.getString("in_demGrantLang"));
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_languages"), this.pnlLanguages);
        }
        if (this.pnlWeapons != null) {
            this.pnlWeapons.setHeader(PropertyFactory.getString("in_demGraWeaPro"));
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_weapon"), this.pnlWeapons);
        }
        if (this.pnlSkills != null) {
            this.pnlSkills.setHeader(PropertyFactory.getString("in_demGraSkil"));
            this.pnlSkills.setLblSelectedText(PropertyFactory.getString("in_demSelClaSkil"));
            this.pnlSkills.setLblSelected2Text(PropertyFactory.getString("in_demSelCroCla"));
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_skills"), this.pnlSkills);
        }
        if (this.pnlLevelAbilities != null) {
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_abilities"), this.pnlLevelAbilities);
        }
        if (this.pnlMovement != null) {
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_movement"), this.pnlMovement);
        }
        if (this.pnlTemplates != null) {
            this.pnlTemplates.setHeader(PropertyFactory.getString("in_demGraTemp"));
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_templates"), this.pnlTemplates);
        }
        if (this.pnlVision != null) {
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_demVision"), this.pnlVision);
        }
        if (this.pnlAge != null) {
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_demAge"), this.pnlAge);
        }
        if (this.pnlAppearance != null) {
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_demAppearance"), this.pnlAppearance);
        }
        if (this.pnlNaturalAttacks != null) {
            this.jTabbedPane1.addTab("Natural Weapons", this.pnlNaturalAttacks);
        }
        if (this.pnlFeats != null) {
            this.pnlFeats.setHeader(PropertyFactory.getString("in_demGraFeat"));
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_feats"), this.pnlFeats);
        }
        if (this.pnlVFeats != null) {
            this.pnlVFeats.setHeader(PropertyFactory.getString("in_demGraVFeat"));
            this.jTabbedPane1.addTab(PropertyFactory.getString("in_demVFeats"), this.pnlVFeats);
        }
        this.pnlAdvanced.setLayout(new GridBagLayout());
        this.pnlAdvanced.setName(PropertyFactory.getString("in_demLangTab"));
        this.pnlAdvancedAvailable.setLayout(new GridBagLayout());
        this.pnlAdvancedAvailable.setPreferredSize(new Dimension(259, 147));
        this.pnlAdvancedTag.setLayout(new GridBagLayout());
        this.lblAdvancedTag.setText(PropertyFactory.getString("in_demTag"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlAdvancedTag.add((Component)this.lblAdvancedTag, gridBagConstraints);
        this.cmbAdvancedTag.setEditable(true);
        this.cmbAdvancedTag.setPreferredSize(new Dimension(180, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlAdvancedTag.add((Component)this.cmbAdvancedTag, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.pnlAdvancedAvailable.add((Component)this.pnlAdvancedTag, gridBagConstraints);
        this.pnlAdvancedTagValue.setLayout(new GridBagLayout());
        this.lblAdvancedTagValue.setText(PropertyFactory.getString("in_demTagVal"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlAdvancedTagValue.add((Component)this.lblAdvancedTagValue, gridBagConstraints);
        this.pnllstAdvancedTagValue.setLayout(new BorderLayout());
        this.pnllstAdvancedTagValue.setPreferredSize(new Dimension(100, 16));
        this.scpAdvancedTagValue.setPreferredSize(new Dimension(259, 131));
        this.txtAdvancedTagValue.setLineWrap(true);
        this.txtAdvancedTagValue.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                super.keyReleased(evt);
                EditorMainForm.this.txtAdvancedTagValueKeyReleased();
            }
        });
        this.scpAdvancedTagValue.setViewportView(this.txtAdvancedTagValue);
        this.pnllstAdvancedTagValue.add((Component)this.scpAdvancedTagValue, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.8;
        this.pnlAdvancedTagValue.add((Component)this.pnllstAdvancedTagValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.8;
        this.pnlAdvancedAvailable.add((Component)this.pnlAdvancedTagValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlAdvanced.add((Component)this.pnlAdvancedAvailable, gridBagConstraints);
        this.pnlAdvancedButtons.setLayout(new GridBagLayout());
        this.btnAddAdvanced.setEnabled(false);
        this.btnAddAdvanced.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorMainForm.this.btnAddAdvancedActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.pnlAdvancedButtons.add((Component)this.btnAddAdvanced, gridBagConstraints);
        this.btnRemoveAdvanced.setEnabled(false);
        this.btnRemoveAdvanced.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorMainForm.this.btnRemoveAdvancedActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.pnlAdvancedButtons.add((Component)this.btnRemoveAdvanced, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        this.pnlAdvanced.add((Component)this.pnlAdvancedButtons, gridBagConstraints);
        this.pnlAdvancedSelected.setLayout(new GridBagLayout());
        this.lblAdvancedSelected.setText(PropertyFactory.getString("in_selected"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.pnlAdvancedSelected.add((Component)this.lblAdvancedSelected, gridBagConstraints);
        this.pnllstAdvancedSelected.setLayout(new BorderLayout());
        this.lstAdvancedSelected.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                EditorMainForm.this.lstAdvancedSelectedMouseClicked(evt);
            }
        });
        this.scpAdvancedSelected.setViewportView(this.lstAdvancedSelected);
        this.pnllstAdvancedSelected.add((Component)this.scpAdvancedSelected, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlAdvancedSelected.add((Component)this.pnllstAdvancedSelected, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlAdvanced.add((Component)this.pnlAdvancedSelected, gridBagConstraints);
        this.lblAdvancedHeader.setText(PropertyFactory.getString("in_demMiscTags"));
        this.pnlAdvancedHeader.add(this.lblAdvancedHeader);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.pnlAdvanced.add((Component)this.pnlAdvancedHeader, gridBagConstraints);
        this.jTabbedPane1.addTab(PropertyFactory.getString("in_demAdv"), this.pnlAdvanced);
        this.pnlTabs.add((Component)this.jTabbedPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 6.0;
        this.pnlMainDialog.add((Component)this.pnlTabs, gridBagConstraints);
        this.pnlButtons.setLayout(new FlowLayout(2));
        this.btnCancel.setMnemonic(PropertyFactory.getMnemonic("in_mn_cancel"));
        this.btnCancel.setText(PropertyFactory.getString("in_cancel"));
        this.btnCancel.setPreferredSize(new Dimension(80, 26));
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorMainForm.this.btnCancelActionPerformed();
            }
        });
        this.pnlButtons.add(this.btnCancel);
        this.btnSave.setMnemonic(PropertyFactory.getMnemonic("in_mn_save"));
        this.btnSave.setText(PropertyFactory.getString("in_save"));
        this.btnSave.setPreferredSize(new Dimension(80, 26));
        this.btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditorMainForm.this.btnSaveActionPerformed();
            }
        });
        this.pnlButtons.add(this.btnSave);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlMainDialog.add((Component)this.pnlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.pnlMainDialog, gridBagConstraints);
        this.pack();
    }

    private void lstAdvancedSelectedMouseClicked(MouseEvent evt) {
        if (EditUtil.isDoubleClick(evt, this.lstAdvancedSelected, this.btnRemoveAdvanced)) {
            this.btnRemoveAdvancedActionPerformed();
        }
    }

    private void parseAlignment(List availableList, List selectedList, String alignmentString, String qualifier) {
        for (int i = 0; i < alignmentString.length(); ++i) {
            int idx;
            char alignmentChar = alignmentString.charAt(i);
            if (alignmentChar == '[') {
                idx = alignmentString.indexOf(93, i);
                if (idx < 0) continue;
                StringTokenizer aTok = new StringTokenizer(alignmentString.substring(i + 1, idx), "=", false);
                if (aTok.countTokens() == 3) {
                    String qualifierType = aTok.nextToken();
                    String variableName = aTok.nextToken();
                    this.parseAlignment(availableList, selectedList, aTok.nextToken(), " [" + qualifierType + ":" + variableName + ']');
                }
                i = idx;
                continue;
            }
            if (alignmentChar < '0' || alignmentChar > '9') continue;
            idx = alignmentChar - 48;
            availableList.remove(SettingsHandler.getGame().getLongAlignmentAtIndex(idx));
            selectedList.add(SettingsHandler.getGame().getLongAlignmentAtIndex(idx) + (qualifier == null ? "" : qualifier));
        }
    }

    private static boolean parseSynergyBonus(BonusObj aBonus, List availableList, List selectedList) {
        List bonusParts;
        String aString = aBonus.toString();
        if (aString.startsWith("SKILL|") && (bonusParts = CoreUtility.split(aString, '|')).size() == 5 && ((String)bonusParts.get(3)).startsWith("PRESKILL:1,") && ((String)bonusParts.get(4)).equalsIgnoreCase("TYPE=Synergy.STACK")) {
            String bonus = (String)bonusParts.get(2);
            String skill = ((String)bonusParts.get(3)).substring(11);
            int idx = skill.indexOf(61);
            if (idx > 0) {
                String ranks = skill.substring(idx + 1);
                skill = skill.substring(0, idx);
                if (availableList != null) {
                    availableList.remove(skill);
                }
                if (selectedList != null) {
                    selectedList.add(EditorMainForm.encodeSynergyEntry(skill, ranks, bonus));
                }
                return true;
            }
        }
        return false;
    }

    private void txtAdvancedTagValueKeyReleased() {
        this.btnAddAdvanced.setEnabled(this.txtAdvancedTagValue.getText().trim().length() != 0);
    }
}

