/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.DescriptionPanel;
import pcgen.gui.editor.TypePanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.WholeNumberField;
import pcgen.util.DecimalNumberField;
import pcgen.util.PropertyFactory;

public class FeatBasePanel
extends BasePanel {
    private static final String[] visibleValues = new String[]{"No", "Yes", "Export", "Display"};
    private DecimalNumberField txtCost;
    private DescriptionPanel pnlDescription;
    private JCheckBox chkMultiple;
    private JCheckBox chkStack;
    private JComboBoxEx cmbVisible;
    private JLabel lblCost;
    private JLabel lblSpellLevels;
    private JLabel lblVisible;
    private JPanel pnlMisc;
    private TypePanel pnlFeatType;
    private WholeNumberField txtSpellLevels;

    public FeatBasePanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void setCost(double argCost) {
        this.txtCost.setValue(argCost);
    }

    public double getCost() {
        return this.txtCost.getValue();
    }

    public void setDescIsPI(boolean descIsPI) {
        this.pnlDescription.setDescIsPI(descIsPI);
    }

    public boolean getDescIsPI() {
        return this.pnlDescription.getDescIsPI();
    }

    public void setDescriptionText(String aString) {
        this.pnlDescription.setText(aString);
    }

    public String getDescriptionText() {
        return this.pnlDescription.getText();
    }

    public void setMultiples(boolean argMultiples) {
        this.chkMultiple.setSelected(argMultiples);
    }

    public boolean getMultiples() {
        return this.chkMultiple.isSelected();
    }

    public void setSpellLevels(int argSpellLevels) {
        this.txtSpellLevels.setValue(argSpellLevels);
    }

    public int getSpellLevels() {
        return this.txtSpellLevels.getValue();
    }

    public void setStacks(boolean argStacks) {
        this.chkStack.setSelected(argStacks);
    }

    public boolean getStacks() {
        return this.chkStack.isSelected();
    }

    public void setTypesAvailableList(List aList, boolean sort) {
        this.pnlFeatType.setAvailableList(aList, sort);
    }

    public void setTypesSelectedList(List aList, boolean sort) {
        this.pnlFeatType.setSelectedList(aList, sort);
    }

    public Object[] getTypesSelectedList() {
        return this.pnlFeatType.getSelectedList();
    }

    public void setVisible(int aNumber) {
        if (aNumber >= 0 && aNumber <= 3) {
            this.cmbVisible.setSelectedIndex(aNumber);
        }
    }

    public int getVisible() {
        return this.cmbVisible.getSelectedIndex();
    }

    public void updateData(PObject thisPObject) {
        Feat thisFeat = (Feat)thisPObject;
        thisFeat.setDescription(this.getDescriptionText());
        thisFeat.setDescIsPI(this.getDescIsPI());
        thisFeat.setMultiples(this.getMultiples() ? "Y" : "N");
        thisFeat.setStacks(this.getStacks() ? "Y" : "N");
        thisFeat.setVisible(this.getVisible());
        thisFeat.setCost(Double.toString(this.getCost()));
        thisFeat.setAddSpellLevel(this.getSpellLevels());
        Object[] sel = this.getTypesSelectedList();
        thisFeat.setTypeInfo(".CLEAR");
        for (int i = 0; i < sel.length; ++i) {
            thisFeat.setTypeInfo(sel[i].toString());
        }
    }

    public void updateView(PObject thisPObject) {
        String aString;
        Feat thisFeat = (Feat)thisPObject;
        this.setDescriptionText(thisPObject.getDescription());
        this.setDescIsPI(thisPObject.getDescIsPI());
        ArrayList<String> availableList = new ArrayList<String>();
        ArrayList<String> selectedList = new ArrayList<String>();
        Iterator e = Globals.getFeatList().iterator();
        while (e.hasNext()) {
            Feat aFeat = (Feat)e.next();
            int i = aFeat.getMyTypeCount();
            while (i > 0) {
                if ((aString = aFeat.getMyType(--i)).equals("CUSTOM") || availableList.contains(aString)) continue;
                availableList.add(aString);
            }
        }
        int i = thisFeat.getMyTypeCount();
        while (i > 0) {
            if ((aString = thisFeat.getMyType(--i)).equals("CUSTOM")) continue;
            selectedList.add(aString);
            availableList.remove(aString);
        }
        this.setTypesAvailableList(availableList, true);
        this.setTypesSelectedList(selectedList, true);
        this.setVisible(thisFeat.isVisible());
        this.setMultiples(thisFeat.isMultiples());
        this.setStacks(thisFeat.isStacks());
        this.setCost(thisFeat.getCost());
        this.setSpellLevels(thisFeat.getAddSpellLevel());
    }

    private void initComponentContents() {
        this.cmbVisible.setModel(new DefaultComboBoxModel<String>(visibleValues));
    }

    private void initComponents() {
        this.pnlDescription = new DescriptionPanel();
        this.pnlFeatType = new TypePanel(PropertyFactory.getString("in_demEnterNewType"));
        this.pnlMisc = new JPanel();
        this.lblCost = new JLabel();
        this.lblVisible = new JLabel();
        this.cmbVisible = new JComboBoxEx();
        this.chkMultiple = new JCheckBox();
        this.chkStack = new JCheckBox();
        this.txtCost = new DecimalNumberField(0.0, 5);
        this.lblSpellLevels = new JLabel();
        this.txtSpellLevels = new WholeNumberField(0, 3);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.5;
        this.add((Component)this.pnlDescription, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.pnlFeatType, gbc);
        this.pnlMisc.setLayout(new GridBagLayout());
        this.lblCost.setText("Cost");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.anchor = 13;
        gbc.weightx = 0.1;
        this.pnlMisc.add((Component)this.lblCost, gbc);
        this.lblVisible.setText("Visible");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.anchor = 13;
        gbc.weightx = 0.1;
        this.pnlMisc.add((Component)this.lblVisible, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 0.4;
        gbc.insets = new Insets(2, 5, 2, 5);
        this.pnlMisc.add((Component)this.cmbVisible, gbc);
        this.chkMultiple.setText("Multiples allowed");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 5, 2, 5);
        this.pnlMisc.add((Component)this.chkMultiple, gbc);
        this.chkStack.setText("Stacks");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 5, 2, 5);
        this.pnlMisc.add((Component)this.chkStack, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.weightx = 0.4;
        this.pnlMisc.add((Component)this.txtCost, gbc);
        this.lblSpellLevels.setText("Spell Levels");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 5, 2, 5);
        gbc.anchor = 13;
        this.pnlMisc.add((Component)this.lblSpellLevels, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 5, 2, 5);
        this.pnlMisc.add((Component)this.txtSpellLevels, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.pnlMisc, gbc);
    }
}

