/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;

final class JListModel
extends AbstractListModel {
    private List listData = null;
    private boolean sort = false;

    JListModel(List listdata, boolean argSort) {
        this.initModel(listdata, argSort);
    }

    public void setData(List argListData) {
        this.listData = (List)((ArrayList)argListData).clone();
        if (this.sort) {
            Collections.sort(this.listData);
        }
        this.fireIntervalAdded(this, 0, this.listData.size());
    }

    public Object getElementAt(int i) {
        if (this.listData != null && i < this.listData.size()) {
            return this.listData.get(i);
        }
        return null;
    }

    public int getSize() {
        if (this.listData != null) {
            return this.listData.size();
        }
        return 0;
    }

    Object[] getElements() {
        return this.listData.toArray();
    }

    void setSort(boolean argSort) {
        this.sort = argSort;
    }

    void addElement(Object obj, boolean allowDup) {
        if (allowDup || !this.listData.contains(obj)) {
            this.addElement(obj);
        }
    }

    void addElement(Object obj) {
        this.listData.add(obj);
        if (this.sort) {
            Collections.sort(this.listData);
        }
        this.fireIntervalAdded(this, 0, this.listData.size());
    }

    void addElement(int index, Object obj) {
        this.listData.add(index, obj);
        if (this.sort) {
            Collections.sort(this.listData);
        }
        this.fireIntervalAdded(this, 0, this.listData.size());
    }

    boolean removeElement(Object obj) {
        int idx = this.listData.indexOf(obj);
        if (idx >= 0) {
            this.listData.remove(idx);
            this.fireIntervalRemoved(this, idx, idx);
        }
        return idx >= 0;
    }

    private void initModel(List argListData, boolean argSort) {
        this.sort = argSort;
        this.setData(argListData);
    }
}

