/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.editor.EditUtil;
import pcgen.gui.editor.JListModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.PropertyFactory;

final class LevelAbilitiesPanel
extends JPanel {
    static final long serialVersionUID = -3457383056896786976L;
    private static final String[] levelTypes = new String[]{"HD", "LEVEL"};
    private static final String[] abilityTypes = new String[]{"DR", "SR", "CR", "SA", "FEAT"};
    private JButton btnAdd;
    private JButton btnRemove;
    private JComboBoxEx cmbAbilityType;
    private JComboBoxEx cmbLevelType;
    private JLabel lblAvailable;
    private JLabel lblHeader;
    private JLabel lblSelected;
    private JList lstSelected;
    private JPanel pnlAddRemove;
    private JPanel pnlAvailable;
    private JPanel pnlHeader;
    private JPanel pnlSelected;
    private JScrollPane scpSelected;
    private JTextField txtAbility;
    private JTextField txtLevel;

    LevelAbilitiesPanel() {
        this.initComponents();
        this.initComponentContents();
    }

    void setSelectedList(List argSelected) {
        JListModel lmd = (JListModel)this.lstSelected.getModel();
        int x = argSelected.size();
        for (int i = 0; i < x; ++i) {
            lmd.addElement(argSelected.get(i));
        }
    }

    Object[] getSelectedList() {
        return ((JListModel)this.lstSelected.getModel()).getElements();
    }

    private void btnAddActionPerformed() {
        String levelType = (String)this.cmbLevelType.getSelectedItem();
        String abilityType = (String)this.cmbAbilityType.getSelectedItem();
        if (levelType == null || levelType.length() == 0 || abilityType == null || abilityType.length() == 0 || this.txtLevel.getText().trim().length() == 0 || this.txtAbility.getText().trim().length() == 0) {
            ShowMessageDelegate.showMessageDialog("You must enter a level type, level, ability type and ability details.", "PCGen", MessageType.ERROR);
            return;
        }
        StringBuffer newEntry = new StringBuffer();
        newEntry.append(levelType).append(':');
        newEntry.append(this.txtLevel.getText().trim()).append(':');
        newEntry.append(abilityType).append(':');
        newEntry.append(this.txtAbility.getText().trim());
        JListModel lmd = (JListModel)this.lstSelected.getModel();
        lmd.addElement(newEntry.toString());
    }

    private void btnRemoveActionPerformed() {
        this.btnRemove.setEnabled(false);
        JListModel lms = (JListModel)this.lstSelected.getModel();
        Object[] x = this.lstSelected.getSelectedValues();
        for (int i = 0; i < x.length; ++i) {
            String[] entry = LevelAbilitiesPanel.splitAbilityString((String)x[i]);
            if (entry != null) {
                this.cmbLevelType.setSelectedItem(entry[0]);
                this.txtLevel.setText(entry[1]);
                this.cmbAbilityType.setSelectedItem(entry[2]);
                this.txtAbility.setText(entry[3]);
            }
            lms.removeElement(x[i]);
        }
    }

    private void initComponentContents() {
    }

    private void initComponents() {
        this.cmbLevelType = new JComboBoxEx(levelTypes);
        this.cmbAbilityType = new JComboBoxEx(abilityTypes);
        this.txtLevel = new JTextField();
        this.txtAbility = new JTextField();
        try {
            this.btnAdd = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
            this.btnRemove = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        }
        catch (Exception exc) {
            this.btnAdd = new JButton(">");
            this.btnRemove = new JButton("<");
        }
        this.lblAvailable = new JLabel();
        this.lblHeader = new JLabel();
        this.lblSelected = new JLabel();
        this.lstSelected = new JList(new JListModel(new ArrayList(), true));
        this.pnlHeader = new JPanel();
        this.pnlAvailable = new JPanel();
        this.pnlAddRemove = new JPanel();
        this.pnlSelected = new JPanel();
        this.scpSelected = new JScrollPane();
        this.pnlHeader.setLayout(new GridBagLayout());
        this.lblHeader = new JLabel("Level/Hit dice based abilities");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.1;
        this.pnlHeader.add((Component)this.lblHeader, gridBagConstraints);
        Border etched = null;
        TitledBorder title1 = BorderFactory.createTitledBorder(etched, "");
        title1.setTitleJustification(1);
        this.pnlAvailable.setBorder(title1);
        this.pnlAvailable.setLayout(new GridBagLayout());
        JLabel lblTemp = new JLabel("Tag Type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)lblTemp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAvailable.add((Component)this.cmbLevelType, gridBagConstraints);
        lblTemp = new JLabel("Level Number/Hit dice range:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)lblTemp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAvailable.add((Component)this.txtLevel, gridBagConstraints);
        lblTemp = new JLabel("Ability type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)lblTemp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAvailable.add((Component)this.cmbAbilityType, gridBagConstraints);
        lblTemp = new JLabel("Ability details:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)lblTemp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAvailable.add((Component)this.txtAbility, gridBagConstraints);
        this.pnlAddRemove.setLayout(new GridBagLayout());
        this.btnAdd.setEnabled(true);
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LevelAbilitiesPanel.this.btnAddActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAddRemove.add((Component)this.btnAdd, gridBagConstraints);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LevelAbilitiesPanel.this.btnRemoveActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAddRemove.add((Component)this.btnRemove, gridBagConstraints);
        this.pnlSelected.setLayout(new GridBagLayout());
        this.lblSelected.setText(PropertyFactory.getString("in_selected"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        this.pnlSelected.add((Component)this.lblSelected, gridBagConstraints);
        this.lstSelected.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LevelAbilitiesPanel.this.lstSelectedMouseClicked(evt);
            }
        });
        this.scpSelected.setPreferredSize(new Dimension(90, 20));
        this.scpSelected.setViewportView(this.lstSelected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.pnlSelected.add((Component)this.scpSelected, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.pnlHeader, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAvailable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAddRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlSelected, gridBagConstraints);
    }

    private void lstSelectedMouseClicked(MouseEvent evt) {
        if (evt.getSource().equals(this.lstSelected) && EditUtil.isDoubleClick(evt, this.lstSelected, this.btnRemove)) {
            this.btnRemoveActionPerformed();
        }
    }

    private static String[] splitAbilityString(String abilityString) {
        String[] returnValue = null;
        int idx = abilityString.indexOf(":");
        if (idx >= 0) {
            returnValue = new String[4];
            returnValue[0] = abilityString.substring(0, idx);
            int prevIdx = idx;
            idx = abilityString.substring(prevIdx + 1).indexOf(":") + prevIdx + 1;
            returnValue[1] = abilityString.substring(prevIdx + 1, idx);
            prevIdx = idx;
            idx = abilityString.substring(prevIdx + 1).indexOf(":") + prevIdx + 1;
            returnValue[2] = abilityString.substring(prevIdx + 1, idx);
            returnValue[3] = abilityString.substring(idx + 1);
        }
        return returnValue;
    }
}

