/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.editor.EditUtil;
import pcgen.gui.editor.JListModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.PropertyFactory;

final class MovementPanel
extends JPanel {
    static final long serialVersionUID = 3024201499870849149L;
    private static final String[] rateTypes = new String[]{"MOVE (Set movement rate)", "MOVEA (Adjust movement rate)", "MOVECLONE (Adjust based on default rate)"};
    private JButton btnAdd;
    private JButton btnRemove;
    private JComboBoxEx cmbMoveType;
    private JComboBoxEx cmbRateType;
    private JLabel lblAvailable;
    private JLabel lblHeader;
    private JLabel lblSelected;
    private JList lstSelected;
    private JPanel pnlAddRemove;
    private JPanel pnlAvailable;
    private JPanel pnlHeader;
    private JPanel pnlSelected;
    private JScrollPane scpSelected;
    private JTextField txtMoveAmount;
    private JRadioButton[] rdbAdjustType;

    MovementPanel(boolean isMoveOnly) {
        this.initComponents(isMoveOnly);
        this.initComponentContents(isMoveOnly);
    }

    void setMoveRateType(int moveRateType) {
        this.cmbRateType.setSelectedIndex(moveRateType);
    }

    int getMoveRateType() {
        return this.cmbRateType.getSelectedIndex();
    }

    String[] getMoveTypes() {
        Object[] selected = this.getSelectedList();
        String[] types = new String[selected.length];
        for (int index = 0; index < selected.length; ++index) {
            String moveString = (String)selected[index];
            int idx = moveString.indexOf(",");
            types[index] = moveString.substring(0, idx);
        }
        return types;
    }

    String getMoveValues() {
        StringBuffer buffer = new StringBuffer();
        Object[] selected = this.getSelectedList();
        for (int index = 0; index < selected.length; ++index) {
            if (index > 0) {
                buffer.append(',');
            }
            buffer.append(selected[index]);
        }
        return buffer.toString();
    }

    void setSelectedList(List argSelected) {
        JListModel lmd = (JListModel)this.lstSelected.getModel();
        int x = argSelected.size();
        for (int i = 0; i < x; ++i) {
            lmd.addElement(argSelected.get(i));
        }
    }

    Object[] getSelectedList() {
        return ((JListModel)this.lstSelected.getModel()).getElements();
    }

    static String makeMoveString(String rateType, Double moveRate, Double multAmount, String movementMultOp) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(rateType).append(',');
        if ("*".equals(movementMultOp) || "/".equals(movementMultOp)) {
            buffer.append(movementMultOp);
            buffer.append(multAmount);
        } else {
            buffer.append(moveRate);
        }
        return buffer.toString();
    }

    private void btnAddActionPerformed() {
        String moveType = (String)this.cmbMoveType.getSelectedItem();
        if (moveType == null || moveType.length() == 0 || !this.rdbAdjustType[0].isSelected() && !this.rdbAdjustType[1].isSelected() && !this.rdbAdjustType[2].isSelected() || this.txtMoveAmount.getText().trim().length() == 0) {
            ShowMessageDelegate.showMessageDialog("You must enter a movement type, adjustment and amount.", "PCGen", MessageType.ERROR);
            return;
        }
        String newEntry = (String)this.cmbMoveType.getSelectedItem() + ",";
        if (this.rdbAdjustType[1].isSelected()) {
            newEntry = newEntry + "*";
        } else if (this.rdbAdjustType[2].isSelected()) {
            newEntry = newEntry + "/";
        }
        newEntry = newEntry + this.txtMoveAmount.getText().trim();
        JListModel lmd = (JListModel)this.lstSelected.getModel();
        lmd.addElement(newEntry);
    }

    private void btnRemoveActionPerformed() {
        this.btnRemove.setEnabled(false);
        JListModel lms = (JListModel)this.lstSelected.getModel();
        Object[] x = this.lstSelected.getSelectedValues();
        for (int i = 0; i < x.length; ++i) {
            String[] entry = MovementPanel.splitMoveString((String)x[i]);
            if (entry != null) {
                this.cmbMoveType.setSelectedItem(entry[0]);
                if (entry[1].equals("*")) {
                    this.rdbAdjustType[1].setSelected(true);
                } else if (entry[1].equals("/")) {
                    this.rdbAdjustType[2].setSelected(true);
                } else {
                    this.rdbAdjustType[0].setSelected(true);
                }
                this.txtMoveAmount.setText(entry[2]);
            }
            lms.removeElement(x[i]);
        }
    }

    private void initComponentContents(boolean isMoveOnly) {
        if (isMoveOnly) {
            this.cmbRateType.setModel(new DefaultComboBoxModel<String>(new String[]{rateTypes[0]}));
            this.cmbRateType.setSelectedIndex(0);
        } else {
            this.cmbRateType.setModel(new DefaultComboBoxModel<String>(rateTypes));
        }
    }

    private void initComponents(boolean isMoveOnly) {
        GridBagConstraints gridBagConstraints;
        this.cmbRateType = new JComboBoxEx();
        this.cmbMoveType = new JComboBoxEx(new String[]{"Walk", "Fly", "Swim", "ALL"});
        this.cmbMoveType.setEditable(true);
        this.rdbAdjustType = new JRadioButton[]{new JRadioButton("Add/Set to"), new JRadioButton("Multiply by"), new JRadioButton("Divide by")};
        ButtonGroup adjustTypeGroup = new ButtonGroup();
        adjustTypeGroup.add(this.rdbAdjustType[0]);
        adjustTypeGroup.add(this.rdbAdjustType[1]);
        adjustTypeGroup.add(this.rdbAdjustType[2]);
        this.txtMoveAmount = new JTextField();
        try {
            this.btnAdd = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
            this.btnRemove = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        }
        catch (Exception exc) {
            this.btnAdd = new JButton(">");
            this.btnRemove = new JButton("<");
        }
        this.lblAvailable = new JLabel();
        this.lblHeader = new JLabel();
        this.lblSelected = new JLabel();
        this.lstSelected = new JList(new JListModel(new ArrayList(), true));
        this.pnlHeader = new JPanel();
        this.pnlAvailable = new JPanel();
        this.pnlAddRemove = new JPanel();
        this.pnlSelected = new JPanel();
        this.scpSelected = new JScrollPane();
        this.pnlHeader.setLayout(new GridBagLayout());
        if (!isMoveOnly) {
            this.lblHeader = new JLabel("Movement Rate Type of ");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.1;
            this.pnlHeader.add((Component)this.lblHeader, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints.weightx = 0.4;
            this.pnlHeader.add((Component)this.cmbRateType, gridBagConstraints);
        }
        Border etched = null;
        TitledBorder title1 = BorderFactory.createTitledBorder(etched, PropertyFactory.getString("in_demTag"));
        title1.setTitleJustification(1);
        this.pnlAvailable.setBorder(title1);
        this.pnlAvailable.setLayout(new GridBagLayout());
        JLabel lblTemp = new JLabel("Movement Type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)lblTemp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAvailable.add((Component)this.cmbMoveType, gridBagConstraints);
        if (isMoveOnly) {
            this.rdbAdjustType[0].setSelected(true);
        } else {
            lblTemp = new JLabel("Adjustment:");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.1;
            this.pnlAvailable.add((Component)lblTemp, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints.weightx = 0.4;
            this.pnlAvailable.add((Component)this.rdbAdjustType[0], gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints.weightx = 0.4;
            this.pnlAvailable.add((Component)this.rdbAdjustType[1], gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints.weightx = 0.4;
            this.pnlAvailable.add((Component)this.rdbAdjustType[2], gridBagConstraints);
        }
        lblTemp = new JLabel("Amount:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)lblTemp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAvailable.add((Component)this.txtMoveAmount, gridBagConstraints);
        this.pnlAvailable.add((Component)lblTemp, gridBagConstraints);
        this.pnlAddRemove.setLayout(new GridBagLayout());
        this.btnAdd.setEnabled(true);
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MovementPanel.this.btnAddActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAddRemove.add((Component)this.btnAdd, gridBagConstraints);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MovementPanel.this.btnRemoveActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAddRemove.add((Component)this.btnRemove, gridBagConstraints);
        this.pnlSelected.setLayout(new GridBagLayout());
        this.lblSelected.setText(PropertyFactory.getString("in_selected"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        this.pnlSelected.add((Component)this.lblSelected, gridBagConstraints);
        this.lstSelected.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MovementPanel.this.lstSelectedMouseClicked(evt);
            }
        });
        this.scpSelected.setPreferredSize(new Dimension(90, 20));
        this.scpSelected.setViewportView(this.lstSelected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.pnlSelected.add((Component)this.scpSelected, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.pnlHeader, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAvailable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAddRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlSelected, gridBagConstraints);
    }

    private void lstSelectedMouseClicked(MouseEvent evt) {
        if (evt.getSource().equals(this.lstSelected) && EditUtil.isDoubleClick(evt, this.lstSelected, this.btnRemove)) {
            this.btnRemoveActionPerformed();
        }
    }

    private static String[] splitMoveString(String moveString) {
        String[] returnValue = null;
        int idx = moveString.indexOf(",");
        if (idx >= 0) {
            returnValue = new String[3];
            returnValue[0] = moveString.substring(0, idx);
            if (moveString.charAt(idx + 1) == '*' || moveString.charAt(idx + 1) == '/') {
                returnValue[1] = moveString.substring(idx + 1, idx + 2);
                returnValue[2] = moveString.substring(idx + 2);
            } else {
                returnValue[1] = "";
                returnValue[2] = moveString.substring(idx + 1);
            }
        }
        return returnValue;
    }
}

