/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.editor.JListModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

final class NaturalAttacksPanel
extends JPanel {
    static final long serialVersionUID = 7072891779087323350L;
    private JButton btnAdd;
    private JButton btnRemove;
    private JCheckBox chbBludgeoning;
    private JCheckBox chbPiercing;
    private JCheckBox chbSlashing;
    private JCheckBox chbWeaponPrimary;
    private JComboBoxEx cmbDamageDie;
    private JComboBoxEx cmbHandsRequired;
    private JComboBoxEx cmbNumDice;
    private JComboBoxEx cmbNumNaturalAttacks;
    private JLabel lblSelected;
    private JList lstSelected;
    private JPanel pnlAddRemove;
    private JPanel pnlAvailable;
    private JPanel pnlSelected;
    private JScrollPane scpSelected;
    private JTextField txtNaturalAttackName;

    NaturalAttacksPanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public List getNaturalWeapons() {
        JListModel lmd = (JListModel)this.lstSelected.getModel();
        ArrayList<Equipment> naturalWeapons = new ArrayList<Equipment>();
        int x = lmd.getSize();
        for (int i = 0; i < x; ++i) {
            int hands;
            Integer anInt;
            Equipment anEquip = new Equipment();
            String aString = (String)lmd.getElementAt(i);
            StringTokenizer natWpn = new StringTokenizer(aString, ",", false);
            anEquip.setName(natWpn.nextToken());
            anEquip.setTypeInfo(natWpn.nextToken());
            String attacksTxt = natWpn.nextToken();
            try {
                anInt = new Integer(attacksTxt);
            }
            catch (NumberFormatException exc) {
                Logging.errorPrint("Natural Weapons Editor: non-numeric value for number of attacks: '" + attacksTxt + "'");
                anInt = new Integer(1);
            }
            if (anInt > 1) {
                String bonusString = "WEAPON|ATTACKS|" + (anInt - 1);
                anEquip.addBonusList(bonusString);
            }
            anEquip.setDamage(natWpn.nextToken());
            String handsTxt = natWpn.nextToken();
            try {
                hands = Integer.parseInt(handsTxt);
            }
            catch (NumberFormatException exc) {
                Logging.errorPrint("Natural Weapons Editor: non-numeric value for number of hands: '" + handsTxt + "'");
                hands = 0;
            }
            anEquip.setHands(hands);
            anEquip.setAttacksProgress(false);
            naturalWeapons.add(anEquip);
        }
        return naturalWeapons;
    }

    void setSelectedList(PlayerCharacter aPC, List argSelected) {
        int x = argSelected.size();
        for (int i = 0; i < x; ++i) {
            boolean weaponPrimary = false;
            String naturalAttacksTxt = "";
            String naturalWeaponName = ((Equipment)argSelected.get(i)).getSimpleName();
            naturalAttacksTxt = naturalAttacksTxt + naturalWeaponName + ",";
            String naturalWeaponModifiedName = ((Equipment)argSelected.get(i)).modifiedName();
            if (naturalWeaponModifiedName.indexOf("Primary") >= 0) {
                weaponPrimary = true;
            }
            String naturalWeaponType = ((Equipment)argSelected.get(i)).getType();
            StringTokenizer wpnType = new StringTokenizer(naturalWeaponType, ".", true);
            naturalWeaponType = "";
            while (wpnType.hasMoreTokens()) {
                String thisToken = wpnType.nextToken();
                naturalWeaponType = naturalWeaponType + thisToken.substring(0, 1).toUpperCase() + thisToken.substring(1).toLowerCase();
            }
            naturalAttacksTxt = naturalAttacksTxt + naturalWeaponType + ",";
            int numAttacks = 1 + (int)((Equipment)argSelected.get(i)).bonusTo(aPC, "WEAPON", "ATTACKS", true);
            naturalAttacksTxt = naturalAttacksTxt + numAttacks + ",";
            String damage = ((Equipment)argSelected.get(i)).getDamage(aPC);
            naturalAttacksTxt = naturalAttacksTxt + damage + ",";
            int numHands = ((Equipment)argSelected.get(i)).getHands(aPC);
            naturalAttacksTxt = naturalAttacksTxt + numHands;
            this.addToSelectedLst(naturalAttacksTxt, weaponPrimary);
        }
    }

    private static boolean isDoubleClick(MouseEvent evt, JList lst, JButton btn) {
        if (lst.getMinSelectionIndex() >= 0) {
            switch (evt.getClickCount()) {
                case 1: {
                    btn.setEnabled(true);
                    break;
                }
                case 2: {
                    if (!btn.isEnabled()) break;
                    return true;
                }
            }
        }
        return false;
    }

    private void addToSelectedLst(String naturalWeapon, boolean isPrimary) {
        JListModel lmd = (JListModel)this.lstSelected.getModel();
        int addPosition = 0;
        int x = lmd.getSize();
        for (int i = 0; i < x; ++i) {
            Object obj = lmd.getElementAt(i);
            if (!((String)obj).startsWith(naturalWeapon.substring(0, naturalWeapon.indexOf(",")))) continue;
            lmd.removeElement(obj);
            addPosition = i;
            break;
        }
        if (isPrimary) {
            lmd.addElement(0, naturalWeapon);
        } else if (addPosition != 0) {
            lmd.addElement(addPosition, naturalWeapon);
        } else {
            lmd.addElement(naturalWeapon);
        }
    }

    private void btnAddActionPerformed() {
        String naturalAttacksString = this.txtNaturalAttackName.getText();
        if (naturalAttacksString.length() == 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_demNatWeaponNoName"), "PCGen", MessageType.ERROR);
            return;
        }
        naturalAttacksString = naturalAttacksString + ",Weapon.Natural.Melee";
        boolean boolTypeEntered = false;
        if (this.chbPiercing.isSelected()) {
            naturalAttacksString = naturalAttacksString + ".Piercing";
            boolTypeEntered = true;
        }
        if (this.chbSlashing.isSelected()) {
            naturalAttacksString = naturalAttacksString + ".Slashing";
            boolTypeEntered = true;
        }
        if (this.chbBludgeoning.isSelected()) {
            naturalAttacksString = naturalAttacksString + ".Bludgeoning";
            boolTypeEntered = true;
        }
        if (!boolTypeEntered) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_demNatWeaponNoType"), "PCGen", MessageType.ERROR);
            return;
        }
        naturalAttacksString = naturalAttacksString + "," + this.cmbNumNaturalAttacks.getSelectedItem();
        naturalAttacksString = naturalAttacksString + "," + (String)this.cmbNumDice.getSelectedItem() + this.cmbDamageDie.getSelectedItem();
        naturalAttacksString = naturalAttacksString + "," + this.cmbHandsRequired.getSelectedItem();
        this.addToSelectedLst(naturalAttacksString, this.chbWeaponPrimary.isSelected());
    }

    private void btnRemoveActionPerformed() {
        this.btnRemove.setEnabled(false);
        JListModel lms = (JListModel)this.lstSelected.getModel();
        Object[] x = this.lstSelected.getSelectedValues();
        for (int i = 0; i < x.length; ++i) {
            lms.removeElement(x[i]);
        }
    }

    private void initComponentContents() {
    }

    private void initComponents() {
        try {
            this.btnAdd = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
            this.btnRemove = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        }
        catch (Exception exc) {
            this.btnAdd = new JButton(">");
            this.btnRemove = new JButton("<");
        }
        this.lblSelected = new JLabel(PropertyFactory.getString("in_selected"));
        this.lstSelected = new JList(new JListModel(new ArrayList(), false));
        this.pnlAvailable = new JPanel();
        this.pnlAddRemove = new JPanel();
        this.pnlSelected = new JPanel();
        this.scpSelected = new JScrollPane();
        this.txtNaturalAttackName = new JTextField();
        this.txtNaturalAttackName.setMaximumSize(new Dimension(100, 21));
        this.txtNaturalAttackName.setPreferredSize(new Dimension(100, 21));
        this.cmbNumNaturalAttacks = new JComboBoxEx(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"});
        this.cmbNumNaturalAttacks.setMaximumSize(new Dimension(21, 21));
        this.cmbNumNaturalAttacks.setPreferredSize(new Dimension(21, 21));
        this.cmbNumDice = new JComboBoxEx(new String[]{"1", "2", "3", "4"});
        this.cmbNumDice.setMaximumSize(new Dimension(21, 21));
        this.cmbNumDice.setPreferredSize(new Dimension(21, 21));
        this.cmbDamageDie = new JComboBoxEx(new String[]{"d1", "d2", "d3", "d4", "d6", "d8", "d10"});
        this.cmbDamageDie.setMaximumSize(new Dimension(65, 21));
        this.cmbDamageDie.setPreferredSize(new Dimension(65, 21));
        this.cmbDamageDie.setMinimumSize(new Dimension(65, 21));
        this.cmbHandsRequired = new JComboBoxEx(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"});
        this.cmbHandsRequired.setMaximumSize(new Dimension(21, 21));
        this.cmbHandsRequired.setPreferredSize(new Dimension(21, 21));
        this.chbPiercing = new JCheckBox();
        this.chbBludgeoning = new JCheckBox();
        this.chbSlashing = new JCheckBox();
        this.chbWeaponPrimary = new JCheckBox();
        Border etched = null;
        TitledBorder title1 = BorderFactory.createTitledBorder(etched, PropertyFactory.getString("in_demTag"));
        title1.setTitleJustification(1);
        this.pnlAvailable.setBorder(title1);
        this.pnlAvailable.setLayout(new GridBagLayout());
        JLabel lblTemp = new JLabel(PropertyFactory.getString("in_demNatWeaponName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)lblTemp, gridBagConstraints);
        JPanel aPanel = new JPanel();
        aPanel.add(this.txtNaturalAttackName);
        aPanel.setLayout(new FlowLayout(0, 0, 0));
        this.txtNaturalAttackName.setPreferredSize(new Dimension(100, 21));
        this.txtNaturalAttackName.setMinimumSize(new Dimension(100, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)aPanel, gridBagConstraints);
        lblTemp = new JLabel(PropertyFactory.getString("in_demWeaponPrimary"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)lblTemp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)this.chbWeaponPrimary, gridBagConstraints);
        lblTemp = new JLabel(PropertyFactory.getString("in_demWeaponBludgeoning"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)lblTemp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)this.chbBludgeoning, gridBagConstraints);
        lblTemp = new JLabel(PropertyFactory.getString("in_demWeaponPiercing"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)lblTemp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)this.chbPiercing, gridBagConstraints);
        lblTemp = new JLabel(PropertyFactory.getString("in_demWeaponSlashing"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)lblTemp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)this.chbSlashing, gridBagConstraints);
        lblTemp = new JLabel(PropertyFactory.getString("in_demNatWeaponNumAttacks"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)lblTemp, gridBagConstraints);
        aPanel = new JPanel();
        aPanel.add(this.cmbNumNaturalAttacks);
        aPanel.setLayout(new FlowLayout(0, 0, 0));
        this.cmbNumNaturalAttacks.setPreferredSize(new Dimension(35, 21));
        this.cmbNumNaturalAttacks.setMinimumSize(new Dimension(35, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)aPanel, gridBagConstraints);
        lblTemp = new JLabel(PropertyFactory.getString("in_demNatWeaponNumHands"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)lblTemp, gridBagConstraints);
        aPanel = new JPanel();
        aPanel.add(this.cmbHandsRequired);
        aPanel.setLayout(new FlowLayout(0, 0, 0));
        this.cmbHandsRequired.setPreferredSize(new Dimension(35, 21));
        this.cmbHandsRequired.setMinimumSize(new Dimension(35, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)aPanel, gridBagConstraints);
        lblTemp = new JLabel(PropertyFactory.getString("in_demWeaponDamage"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)lblTemp, gridBagConstraints);
        aPanel = new JPanel();
        aPanel.add(this.cmbNumDice);
        aPanel.add(this.cmbDamageDie);
        aPanel.setLayout(new FlowLayout(0, 0, 0));
        this.cmbNumDice.setPreferredSize(new Dimension(35, 21));
        this.cmbNumDice.setMinimumSize(new Dimension(35, 21));
        this.cmbDamageDie.setPreferredSize(new Dimension(45, 21));
        this.cmbDamageDie.setMinimumSize(new Dimension(45, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        this.pnlAvailable.add((Component)aPanel, gridBagConstraints);
        this.pnlAddRemove.setLayout(new GridBagLayout());
        this.btnAdd.setEnabled(true);
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NaturalAttacksPanel.this.btnAddActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAddRemove.add((Component)this.btnAdd, gridBagConstraints);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NaturalAttacksPanel.this.btnRemoveActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlAddRemove.add((Component)this.btnRemove, gridBagConstraints);
        this.pnlSelected.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        this.pnlSelected.add((Component)this.lblSelected, gridBagConstraints);
        this.lstSelected.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                NaturalAttacksPanel.this.lstSelectedMouseClicked(evt);
            }
        });
        this.scpSelected.setPreferredSize(new Dimension(90, 20));
        this.scpSelected.setViewportView(this.lstSelected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        this.pnlSelected.add((Component)this.scpSelected, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAvailable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAddRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlSelected, gridBagConstraints);
    }

    private void lstSelectedMouseClicked(MouseEvent evt) {
        if (evt.getSource().equals(this.lstSelected)) {
            String aString = (String)this.lstSelected.getSelectedValue();
            StringTokenizer natWpn = new StringTokenizer(aString, ",", false);
            this.txtNaturalAttackName.setText(natWpn.nextToken());
            if (this.lstSelected.getSelectedIndex() == 0) {
                this.chbWeaponPrimary.setSelected(true);
            } else {
                this.chbWeaponPrimary.setSelected(false);
            }
            String weaponTypeTxt = natWpn.nextToken();
            if (weaponTypeTxt.indexOf("Slashing") != -1) {
                this.chbSlashing.setSelected(true);
            } else {
                this.chbSlashing.setSelected(false);
            }
            if (weaponTypeTxt.indexOf("Piercing") != -1) {
                this.chbPiercing.setSelected(true);
            } else {
                this.chbPiercing.setSelected(false);
            }
            if (weaponTypeTxt.indexOf("Bludgeoning") != -1) {
                this.chbBludgeoning.setSelected(true);
            } else {
                this.chbBludgeoning.setSelected(false);
            }
            String numAttacks = natWpn.nextToken().trim();
            this.cmbNumNaturalAttacks.setSelectedItem(numAttacks);
            String damageDice = natWpn.nextToken();
            this.cmbNumDice.setSelectedItem(damageDice.substring(0, 1));
            this.cmbDamageDie.setSelectedItem(damageDice.substring(1));
            String handsReq = natWpn.nextToken().trim();
            this.cmbHandsRequired.setSelectedItem(handsReq);
            if (NaturalAttacksPanel.isDoubleClick(evt, this.lstSelected, this.btnRemove)) {
                this.btnRemoveActionPerformed();
            }
        }
    }
}

