/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.TypePanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class RaceBasePanel
extends BasePanel {
    private static final String[] sizeTitles = new String[]{"Fine", "Diminutive", "Tiny", "Small", "Medium", "Large", "Huge", "Gargantuan", "Colossal"};
    private static final String[] sizeAbbrev = new String[]{"F", "D", "T", "S", "M", "L", "H", "G", "C"};
    private static final String[] hitDiceSizeValues = new String[]{"1", "2", "4", "6", "8", "10", "12", "14", "16", "18", "20"};
    private static final String[] crValues = new String[]{"1/10", "1/8", "1/6", "1/4", "1/3", "1/2", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
    private JComboBoxEx cmbBonusFeats;
    private JComboBoxEx cmbBonusSkillPoints;
    private JComboBoxEx cmbCR;
    private JComboBoxEx cmbHands;
    private JComboBoxEx cmbHitDiceNumber;
    private JComboBoxEx cmbHitDiceSize;
    private JComboBoxEx cmbLegs;
    private JComboBoxEx cmbMonsterClass;
    private JComboBoxEx cmbMonsterLevel;
    private JComboBoxEx cmbReach;
    private JComboBoxEx cmbSize;
    private JComboBoxEx cmbSkillMult;
    private JPanel pnlTemplateMisc;
    private JTextField txtDisplayName;
    private JTextField txtHitDiceAdvancement;
    private JTextField txtLevelAdj;
    private TypePanel pnlTemplateTypes;

    public RaceBasePanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void setBonusFeats(int bonusFeats) {
        if (bonusFeats >= 0 && bonusFeats < this.cmbBonusFeats.getItemCount()) {
            this.cmbBonusFeats.setSelectedIndex(bonusFeats);
        }
    }

    public int getBonusFeats() {
        return this.cmbBonusFeats.getSelectedIndex();
    }

    public void setBonusSkillPoints(int bonusSkillPoints) {
        if (bonusSkillPoints >= 0 && bonusSkillPoints < this.cmbBonusSkillPoints.getItemCount()) {
            this.cmbBonusSkillPoints.setSelectedIndex(bonusSkillPoints);
        }
    }

    public int getBonusSkillPoints() {
        return this.cmbBonusSkillPoints.getSelectedIndex();
    }

    public void setCR(int argCR) {
        String txtCR = argCR < 0 ? "1/" + Integer.toString(-argCR) : Integer.toString(argCR);
        this.cmbCR.setSelectedItem(txtCR);
    }

    public int getCR() {
        String txtCR = null;
        try {
            txtCR = this.cmbCR.getSelectedItem().toString();
            if (txtCR == null) {
                return 0;
            }
            if (txtCR.startsWith("1/")) {
                return Integer.parseInt(txtCR.substring(2));
            }
            return Integer.parseInt(txtCR);
        }
        catch (NumberFormatException e) {
            Logging.errorPrint("Couldn't figure out what CR " + txtCR + " means.");
            return 0;
        }
    }

    public void setDisplayName(String dislayName) {
        this.txtDisplayName.setText(dislayName);
    }

    public String getDisplayName() {
        return this.txtDisplayName.getText();
    }

    public void setHands(int aNumber) {
        if (aNumber >= 0 && aNumber < this.cmbHands.getItemCount()) {
            this.cmbHands.setSelectedIndex(aNumber);
        }
    }

    public int getHands() {
        return this.cmbHands.getSelectedIndex();
    }

    public void setHitDiceAdvancement(Race thisRace) {
        if (thisRace == null || thisRace.getNumberOfHitDiceAdvancements() == 0) {
            this.txtHitDiceAdvancement.setText("");
        } else {
            StringBuffer adv = new StringBuffer();
            for (int index = 0; index < thisRace.getNumberOfHitDiceAdvancements(); ++index) {
                if (index > 0) {
                    adv.append(',');
                }
                if (thisRace.getHitDiceAdvancement(index) == -1 && thisRace.isAdvancementUnlimited()) {
                    adv.append('*');
                    continue;
                }
                adv.append(String.valueOf(thisRace.getHitDiceAdvancement(index)));
            }
            this.txtHitDiceAdvancement.setText(adv.toString());
        }
    }

    public int[] getHitDiceAdvancement() {
        if (this.txtHitDiceAdvancement.getText() == null || this.txtHitDiceAdvancement.getText().trim().length() == 0) {
            return new int[0];
        }
        StringTokenizer advancement = new StringTokenizer(this.txtHitDiceAdvancement.getText(), ",");
        int[] hitDiceAdvancement = new int[advancement.countTokens()];
        for (int x = 0; x < hitDiceAdvancement.length; ++x) {
            String temp = advancement.nextToken();
            hitDiceAdvancement[x] = temp.length() > 0 && temp.charAt(0) == '*' ? -1 : Integer.parseInt(temp);
        }
        return hitDiceAdvancement;
    }

    public boolean getHitDiceAdvancementUnlimited() {
        if (this.txtHitDiceAdvancement.getText() != null && this.txtHitDiceAdvancement.getText().trim().length() > 0) {
            StringTokenizer advancement = new StringTokenizer(this.txtHitDiceAdvancement.getText(), ",");
            int[] hitDiceAdvancement = new int[advancement.countTokens()];
            for (int x = 0; x < hitDiceAdvancement.length; ++x) {
                String temp = advancement.nextToken();
                if (temp.length() <= 0 || temp.charAt(0) != '*') continue;
                return true;
            }
        }
        return false;
    }

    public void setHitDiceNumber(int aNumber) {
        if (aNumber >= 0 && aNumber < this.cmbMonsterLevel.getItemCount()) {
            this.cmbHitDiceNumber.setSelectedItem(String.valueOf(aNumber));
        }
    }

    public int getHitDiceNumber() {
        return Integer.parseInt((String)this.cmbHitDiceNumber.getSelectedItem());
    }

    public void setHitDiceSize(int aNumber) {
        if (aNumber >= 0 && aNumber < this.cmbMonsterLevel.getItemCount()) {
            this.cmbHitDiceSize.setSelectedItem(String.valueOf(aNumber));
        }
    }

    public int getHitDiceSize() {
        return Integer.parseInt((String)this.cmbHitDiceSize.getSelectedItem());
    }

    public void setLegs(int aNumber) {
        if (aNumber >= 0 && aNumber < this.cmbLegs.getItemCount()) {
            this.cmbLegs.setSelectedIndex(aNumber);
        }
    }

    public int getLegs() {
        return this.cmbLegs.getSelectedIndex();
    }

    public void setLevelAdjustment(String levelAdj) {
        this.txtLevelAdj.setText(levelAdj);
    }

    public String getLevelAdjustment() {
        return this.txtLevelAdj.getText();
    }

    public void setMonsterClass(String aString) {
        if (aString == null || aString.length() == 0) {
            this.cmbMonsterClass.setSelectedItem("(None)");
        } else {
            this.cmbMonsterClass.setSelectedItem(aString);
        }
    }

    public String getMonsterClass() {
        return (String)this.cmbMonsterClass.getSelectedItem();
    }

    public void setMonsterClassList(List classList) {
        this.cmbMonsterClass.setModel(new DefaultComboBoxModel<Object>(classList.toArray()));
    }

    public void setMonsterLevel(int aNumber) {
        if (aNumber >= 0 && aNumber < this.cmbMonsterLevel.getItemCount()) {
            this.cmbMonsterLevel.setSelectedIndex(aNumber);
        }
    }

    public int getMonsterLevel() {
        return this.cmbMonsterLevel.getSelectedIndex();
    }

    public void setRaceSize(String aString) {
        this.cmbSize.setSelectedIndex(0);
        for (int index = 0; index < sizeAbbrev.length; ++index) {
            if (!sizeAbbrev[index].equals(aString)) continue;
            this.cmbSize.setSelectedIndex(index);
            break;
        }
    }

    public String getRaceSize() {
        int index = this.cmbSize.getSelectedIndex();
        if (index >= 0 && index < sizeAbbrev.length) {
            return sizeAbbrev[index];
        }
        return "";
    }

    public void setReach(int aNumber) {
        this.cmbReach.setSelectedItem(String.valueOf(aNumber));
    }

    public int getReach() {
        return Integer.parseInt((String)this.cmbReach.getSelectedItem());
    }

    public void setSkillMultiplier(int aNumber) {
        if (aNumber >= 0 && aNumber < this.cmbSkillMult.getItemCount()) {
            this.cmbSkillMult.setSelectedIndex(aNumber);
        }
    }

    public int getSkillMultiplier() {
        return this.cmbSkillMult.getSelectedIndex();
    }

    public void setTypesAvailableList(List aList, boolean sort) {
        this.pnlTemplateTypes.setAvailableList(aList, sort);
    }

    public void setTypesSelectedList(List aList, boolean sort) {
        this.pnlTemplateTypes.setSelectedList(aList, sort);
    }

    public Object[] getTypesSelectedList() {
        return this.pnlTemplateTypes.getSelectedList();
    }

    public void updateData(PObject thisPObject) {
        super.updateData(thisPObject);
        Race thisRace = (Race)thisPObject;
        thisRace.setBonusInitialFeats(this.getBonusFeats());
        thisRace.setBonusSkillsPerLevel(this.getBonusSkillPoints());
        thisRace.setCR(this.getCR());
        thisRace.setDisplayName(this.getDisplayName());
        thisRace.setHands(this.getHands());
        thisRace.setHitDiceAdvancement(this.getHitDiceAdvancement());
        thisRace.setAdvancementUnlimited(this.getHitDiceAdvancementUnlimited());
        thisRace.setLegs(this.getLegs());
        thisRace.setLevelAdjustment(this.getLevelAdjustment());
        thisRace.setMonsterClass(this.getMonsterClass());
        thisRace.setMonsterClassLevels(this.getMonsterLevel());
        thisRace.setSize(this.getRaceSize());
        thisRace.setReach(this.getReach());
        thisRace.setInitialSkillMultiplier(this.getSkillMultiplier());
        thisRace.setHitDice(this.getHitDiceNumber());
        thisRace.setHitDiceSize(this.getHitDiceSize());
        Object[] sel = this.getTypesSelectedList();
        thisPObject.setTypeInfo(".CLEAR");
        for (int i = 0; i < sel.length; ++i) {
            thisPObject.setTypeInfo(sel[i].toString());
        }
    }

    public void updateView(PlayerCharacter aPC, PObject thisPObject) {
        String aString;
        Race thisRace = (Race)thisPObject;
        ArrayList<String> availableList = new ArrayList<String>();
        ArrayList<String> selectedList = new ArrayList<String>();
        Iterator<Object> e = Globals.getRaceMap().values().iterator();
        while (e.hasNext()) {
            Race aRace = (Race)e.next();
            int i = aRace.getMyTypeCount();
            while (i > 0) {
                if ((aString = aRace.getMyType(--i)).equals("CUSTOM") || availableList.contains(aString)) continue;
                availableList.add(aString);
            }
        }
        int i = thisRace.getMyTypeCount();
        while (i > 0) {
            if ((aString = thisRace.getMyType(--i)).equals("CUSTOM")) continue;
            selectedList.add(aString);
            availableList.remove(aString);
        }
        this.setTypesAvailableList(availableList, true);
        this.setTypesSelectedList(selectedList, true);
        availableList.clear();
        availableList.add("(None)");
        e = Globals.getClassList().iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            if (!aClass.isMonster()) continue;
            availableList.add(aClass.getName());
        }
        this.setMonsterClassList(availableList);
        this.setBonusFeats(thisRace.getBonusInitialFeats());
        this.setBonusSkillPoints(thisRace.getBonusSkillsPerLevel());
        this.setCR(thisRace.getCR());
        this.setDisplayName(thisRace.getDisplayName());
        this.setHands(thisRace.getHands());
        this.setHitDiceAdvancement(thisRace);
        this.setLegs(thisRace.getLegs());
        this.setLevelAdjustment(thisRace.getLevelAdjustmentFormula());
        this.setMonsterClass(thisRace.getMonsterClass(aPC, false));
        this.setMonsterLevel(thisRace.getMonsterClassLevels(aPC, false));
        this.setRaceSize(thisRace.getSize());
        this.setReach(thisRace.getReach());
        this.setSkillMultiplier(thisRace.getInitialSkillMultiplier());
        this.setHitDiceNumber(thisRace.hitDice(aPC, false));
        this.setHitDiceSize(thisRace.getHitDiceSize(aPC, false));
    }

    private static GridBagConstraints buildConstraints(int gridx, int gridy) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        return gridBagConstraints;
    }

    private void initComponentContents() {
        int i;
        this.cmbSize.setModel(new DefaultComboBoxModel<String>(sizeTitles));
        String[] values = new String[20];
        for (i = 0; i < values.length; ++i) {
            values[i] = String.valueOf(i);
        }
        this.cmbBonusSkillPoints.setModel(new DefaultComboBoxModel<String>(values));
        this.cmbBonusFeats.setModel(new DefaultComboBoxModel<String>(values));
        this.cmbLegs.setModel(new DefaultComboBoxModel<String>(values));
        this.cmbHands.setModel(new DefaultComboBoxModel<String>(values));
        this.cmbSkillMult.setModel(new DefaultComboBoxModel<String>(values));
        values = new String[10];
        for (i = 0; i < values.length; ++i) {
            values[i] = String.valueOf(i * 5);
        }
        this.cmbReach.setModel(new DefaultComboBoxModel<String>(values));
        values = new String[40];
        for (i = 0; i < values.length; ++i) {
            values[i] = String.valueOf(i);
        }
        this.cmbMonsterLevel.setModel(new DefaultComboBoxModel<String>(values));
        this.cmbHitDiceNumber.setModel(new DefaultComboBoxModel<String>(values));
        this.cmbHitDiceSize.setModel(new DefaultComboBoxModel<String>(hitDiceSizeValues));
        this.cmbCR.setModel(new DefaultComboBoxModel<String>(crValues));
    }

    private void initComponents() {
        this.cmbBonusSkillPoints = new JComboBoxEx();
        this.cmbBonusFeats = new JComboBoxEx();
        this.cmbCR = new JComboBoxEx();
        this.txtDisplayName = new JTextField();
        this.cmbHands = new JComboBoxEx();
        this.txtHitDiceAdvancement = new JTextField();
        this.cmbHitDiceNumber = new JComboBoxEx();
        this.cmbHitDiceSize = new JComboBoxEx();
        this.cmbLegs = new JComboBoxEx();
        this.txtLevelAdj = new JTextField();
        this.cmbMonsterClass = new JComboBoxEx();
        this.cmbMonsterLevel = new JComboBoxEx();
        this.cmbReach = new JComboBoxEx();
        this.cmbSize = new JComboBoxEx();
        this.cmbSkillMult = new JComboBoxEx();
        this.pnlTemplateMisc = new JPanel();
        this.pnlTemplateTypes = new TypePanel(PropertyFactory.getString("in_demEnterNewType"));
        this.setLayout(new GridBagLayout());
        this.pnlTemplateMisc.setLayout(new GridBagLayout());
        JLabel tempLabel = new JLabel("Display Name");
        GridBagConstraints gridBagConstraints = RaceBasePanel.buildConstraints(0, 0);
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 0);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.txtDisplayName, gridBagConstraints);
        tempLabel = new JLabel("Hands");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 1);
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 1);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbHands, gridBagConstraints);
        tempLabel = new JLabel("Legs");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 1);
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 1);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbLegs, gridBagConstraints);
        tempLabel = new JLabel("Reach");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 2);
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 2);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbReach, gridBagConstraints);
        tempLabel = new JLabel("Skill Multiplier");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 2);
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 2);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbSkillMult, gridBagConstraints);
        tempLabel = new JLabel("Bonus Skill Pts / Level");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 3);
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 3);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbBonusSkillPoints, gridBagConstraints);
        tempLabel = new JLabel("Bonus Starting Feats");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 3);
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 3);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbBonusFeats, gridBagConstraints);
        tempLabel = new JLabel("CR");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 4);
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        this.cmbCR.setEditable(true);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 4);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbCR, gridBagConstraints);
        tempLabel = new JLabel("Level Adjustment");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 4);
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 4);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.txtLevelAdj, gridBagConstraints);
        tempLabel = new JLabel("Size");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 5);
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbSize, gridBagConstraints);
        tempLabel = new JLabel("Hit Dice Advancement");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 5);
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.txtHitDiceAdvancement, gridBagConstraints);
        tempLabel = new JLabel("Monster Class");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 6);
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 6);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbMonsterClass, gridBagConstraints);
        tempLabel = new JLabel("Monster Level");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 6);
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 6);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbMonsterLevel, gridBagConstraints);
        tempLabel = new JLabel("Number of Hit Dice");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 7);
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 7);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbHitDiceNumber, gridBagConstraints);
        tempLabel = new JLabel("Hit Dice Size");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 7);
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 7);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbHitDiceSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlTemplateMisc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlTemplateTypes, gridBagConstraints);
    }
}

