/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pcgen.core.Globals;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.TypePanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.PropertyFactory;

final class SkillBasePanel
extends BasePanel {
    private static final String[] acheckValues = new String[]{"No", "Yes", "Non-proficiency", "Weight"};
    private JCheckBox chkExclusive;
    private JCheckBox chkUntrained;
    private JComboBoxEx cmbArmorCheck;
    private JComboBoxEx cmbKeyStat;
    private JLabel lblArmorCheck;
    private JLabel lblKeyStat;
    private JPanel pnlSkillMisc;
    private TypePanel pnlSkillType;

    public SkillBasePanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void setArmorCheck(int aCheck) {
        if (aCheck >= 0 && aCheck < acheckValues.length) {
            this.cmbArmorCheck.setSelectedItem(acheckValues[aCheck]);
        }
    }

    public int getArmorCheck() {
        return this.cmbArmorCheck.getSelectedIndex();
    }

    public void setIsExclusive(boolean isExclusive) {
        this.chkExclusive.setSelected(isExclusive);
    }

    public boolean getIsExclusive() {
        return this.chkExclusive.isSelected();
    }

    public void setIsUntrained(boolean isUntrained) {
        this.chkUntrained.setSelected(isUntrained);
    }

    public boolean getIsUntrained() {
        return this.chkUntrained.isSelected();
    }

    public void setKeyStat(String aString) {
        if (aString.length() == 0) {
            this.cmbKeyStat.setSelectedItem("None");
        } else {
            for (int i = SettingsHandler.getGame().getUnmodifiableStatList().size() - 1; i >= 0; --i) {
                PCStat aStat = (PCStat)SettingsHandler.getGame().getUnmodifiableStatList().get(i);
                if (!aStat.getAbb().equals(aString)) continue;
                this.cmbKeyStat.setSelectedItem(aStat.getName());
                break;
            }
        }
    }

    public String getKeyStat() {
        int idx = this.cmbKeyStat.getSelectedIndex() - 1;
        if (idx < 0) {
            return "";
        }
        return ((PCStat)SettingsHandler.getGame().getUnmodifiableStatList().get(idx)).getAbb();
    }

    public void setTypesAvailableList(List aList, boolean sort) {
        this.pnlSkillType.setAvailableList(aList, sort);
    }

    public void setTypesSelectedList(List aList, boolean sort) {
        this.pnlSkillType.setSelectedList(aList, sort);
    }

    public Object[] getTypesSelectedList() {
        return this.pnlSkillType.getSelectedList();
    }

    public void updateData(PObject thisPObject) {
        Skill thisSkill = (Skill)thisPObject;
        Object[] sel = this.getTypesSelectedList();
        thisPObject.setTypeInfo(".CLEAR");
        for (int i = 0; i < sel.length; ++i) {
            thisSkill.setTypeInfo(sel[i].toString());
        }
        thisSkill.setUntrained(this.getIsUntrained() ? "Y" : "N");
        thisSkill.setIsExclusive(this.getIsExclusive());
        thisSkill.setKeyStat(this.getKeyStat());
        thisSkill.setACheck(this.getArmorCheck());
    }

    public void updateView(PObject thisPObject) {
        String aString;
        Skill thisSkill = (Skill)thisPObject;
        ArrayList<String> availableList = new ArrayList<String>();
        ArrayList<String> selectedList = new ArrayList<String>();
        Iterator e = Globals.getSkillList().iterator();
        while (e.hasNext()) {
            Skill aSkill = (Skill)e.next();
            int i = aSkill.getMyTypeCount();
            while (i > 0) {
                if ((aString = aSkill.getMyType(--i)).equals("CUSTOM") || availableList.contains(aString)) continue;
                availableList.add(aString);
            }
        }
        int i = thisSkill.getMyTypeCount();
        while (i > 0) {
            if ((aString = thisSkill.getMyType(--i)).equals("CUSTOM")) continue;
            selectedList.add(aString);
            availableList.remove(aString);
        }
        this.setTypesAvailableList(availableList, true);
        this.setTypesSelectedList(selectedList, true);
        this.setKeyStat(thisSkill.getKeyStat());
        this.setArmorCheck(thisSkill.getACheck());
        this.setIsExclusive(thisSkill.isExclusive());
        this.setIsUntrained(thisSkill.isUntrained());
    }

    private void initComponentContents() {
        ArrayList<String> availableList = new ArrayList<String>(SettingsHandler.getGame().getUnmodifiableStatList().size() + 1);
        availableList.add("None");
        Iterator e = SettingsHandler.getGame().getUnmodifiableStatList().iterator();
        while (e.hasNext()) {
            availableList.add(((PCStat)e.next()).getName());
        }
        this.cmbKeyStat.setModel(new DefaultComboBoxModel<Object>(availableList.toArray()));
        this.cmbArmorCheck.setModel(new DefaultComboBoxModel<String>(acheckValues));
    }

    private void initComponents() {
        this.pnlSkillMisc = new JPanel();
        this.lblKeyStat = new JLabel();
        this.cmbKeyStat = new JComboBoxEx();
        this.lblArmorCheck = new JLabel();
        this.cmbArmorCheck = new JComboBoxEx();
        this.chkUntrained = new JCheckBox();
        this.chkExclusive = new JCheckBox();
        this.pnlSkillType = new TypePanel(PropertyFactory.getString("in_demEnterNewType"));
        this.setLayout(new GridBagLayout());
        this.pnlSkillMisc.setLayout(new GridBagLayout());
        this.lblKeyStat.setText("Key Stat");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlSkillMisc.add((Component)this.lblKeyStat, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlSkillMisc.add((Component)this.cmbKeyStat, gridBagConstraints);
        this.lblArmorCheck.setText("Armor Check");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        this.pnlSkillMisc.add((Component)this.lblArmorCheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlSkillMisc.add((Component)this.cmbArmorCheck, gridBagConstraints);
        this.chkUntrained.setText("Use Untrained");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlSkillMisc.add((Component)this.chkUntrained, gridBagConstraints);
        this.chkExclusive.setText("Exclusive");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlSkillMisc.add((Component)this.chkExclusive, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlSkillMisc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlSkillType, gridBagConstraints);
    }
}

