/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import pcgen.core.Campaign;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.WholeNumberField;

class SourceBasePanel
extends BasePanel {
    static final long serialVersionUID = -8057486950329356072L;
    private Campaign theCampaign = null;
    private JCheckBox isD20;
    private JCheckBox isLicensed;
    private JCheckBox isOGL;
    private JCheckBox showInMenu;
    private JComboBoxEx bookType;
    private JScrollPane scrollPane;
    private JTableEx sourceTable;
    private JTextField destination;
    private JTextField game;
    private JTextField genre;
    private JTextField infoText;
    private JTextField pubNameLong;
    private JTextField pubNameShort;
    private JTextField pubNameWeb;
    private JTextField setting;
    private SourceTableModel sourceModel;
    private WholeNumberField rank;
    static /* synthetic */ Class class$java$lang$String;

    public SourceBasePanel() {
        this.initComponents();
        this.intComponentContents();
    }

    public void updateData(PObject thisPObject) {
        this.theCampaign.setRank(new Integer(this.rank.getText().trim()));
        this.theCampaign.setGameMode(this.game.getText().trim());
        this.theCampaign.setPubNameLong(this.pubNameLong.getText().trim());
        this.theCampaign.setPubNameShort(this.pubNameShort.getText().trim());
        this.theCampaign.setPubNameWeb(this.pubNameWeb.getText().trim());
        this.theCampaign.setIsOGL(this.isOGL.getSelectedObjects() != null);
        this.theCampaign.setIsD20(this.isD20.getSelectedObjects() != null);
        this.theCampaign.setShowInMenu(this.showInMenu.getSelectedObjects() != null);
        this.theCampaign.setIsLicensed(this.isLicensed.getSelectedObjects() != null);
        this.theCampaign.setInfoText(this.infoText.getText().trim());
        this.theCampaign.setBookType(this.bookType.getSelectedItem().toString());
        this.theCampaign.setDestination(this.destination.getText().trim());
        this.theCampaign.addLicense(".CLEAR");
        this.theCampaign.addSection15Info(".CLEAR");
        this.theCampaign.setSetting(this.setting.getText().trim());
        this.theCampaign.setGenre(this.genre.getText().trim());
        Properties options = new Properties();
        for (int i = 0; i < this.sourceModel.getOptionList().size(); ++i) {
            options.setProperty(this.sourceModel.getOptionList().get(i).toString(), this.sourceModel.getOptionValues().get(i).toString());
        }
        this.theCampaign.setOptions(options);
        Iterator i = this.sourceModel.getLicenseList().iterator();
        while (i.hasNext()) {
            this.theCampaign.addLicense((String)i.next());
        }
        i = this.sourceModel.getCopyrightList().iterator();
        while (i.hasNext()) {
            this.theCampaign.addSection15Info((String)i.next());
        }
    }

    public void updateView(PObject thisPObject) {
        if (!(thisPObject instanceof Campaign)) {
            return;
        }
        this.theCampaign = (Campaign)thisPObject;
        this.sourceModel.setLists(this.theCampaign.getOptionsList(), this.theCampaign.getLicenseAsList(), this.theCampaign.getSection15AsList());
        this.rank.setText(this.theCampaign.getRank().toString());
        this.game.setText(this.theCampaign.getGameModeString());
        this.pubNameLong.setText(this.theCampaign.getPubNameLong());
        this.pubNameShort.setText(this.theCampaign.getPubNameShort());
        this.pubNameWeb.setText(this.theCampaign.getPubNameWeb());
        this.isOGL.setSelected(this.theCampaign.isOGL());
        this.isD20.setSelected(this.theCampaign.isD20());
        this.isLicensed.setSelected(this.theCampaign.isLicensed());
        this.showInMenu.setSelected(this.theCampaign.canShowInMenu());
        this.infoText.setText(this.theCampaign.getInfoText());
        this.bookType.setSelectedItem(this.theCampaign.getBookType());
        this.setting.setText(this.theCampaign.getSetting());
        this.genre.setText(this.theCampaign.getGenre());
        String a = this.theCampaign.getDestination();
        if (a.equals("") && this.theCampaign.getSourceFile() != null) {
            a = this.theCampaign.getSourceFile();
            if (a.startsWith("file:")) {
                a = a.substring(6);
            }
            a = a.replace('\\', File.separator.charAt(0));
            a = a.replace('/', File.separator.charAt(0));
            String b = SettingsHandler.getPccFilesLocation().toString();
            b = b.replace('\\', File.separator.charAt(0));
            if (a.startsWith(b = b.replace('/', File.separator.charAt(0)))) {
                a = a.substring(b.length() + 1);
            }
            this.destination.setText(a);
        } else {
            this.destination.setText(this.theCampaign.getDestination());
        }
    }

    private void addCopyright() {
        this.sourceModel.addCopyright();
    }

    private void addLicense() {
        this.sourceModel.addLicense();
    }

    private void addOption() {
        this.sourceModel.addOption();
    }

    private GridBagConstraints buildConstraints(GridBagConstraints gridBagConstraints, int gridx, int gridy, boolean useInsets) {
        gridBagConstraints.gridx = gridx;
        gridBagConstraints.gridy = gridy;
        if (useInsets) {
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        }
        return gridBagConstraints;
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.sourceTable = new JTableEx();
        this.sourceModel = new SourceTableModel();
        this.game = new JTextField();
        this.infoText = new JTextField();
        this.pubNameWeb = new JTextField();
        this.pubNameShort = new JTextField();
        this.pubNameLong = new JTextField();
        this.setting = new JTextField();
        this.destination = new JTextField();
        this.genre = new JTextField();
        this.isOGL = new JCheckBox();
        this.isD20 = new JCheckBox();
        this.showInMenu = new JCheckBox();
        this.isLicensed = new JCheckBox();
        this.rank = new WholeNumberField(5, 3);
        this.bookType = new JComboBoxEx();
        this.bookType.setEditable(true);
        this.bookType.addItem("Campaign Setting");
        this.bookType.addItem("Core Rulebook ");
        this.bookType.addItem("Magazine");
        this.bookType.addItem("Module");
        this.bookType.addItem("Sourcebook");
        this.bookType.addItem("Supplement");
        this.bookType.addItem("Web Enhancement");
        this.bookType.setSelectedIndex(0);
        this.setLayout(new BorderLayout());
        JLabel tempLabel = new JLabel("Game Mode:");
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.fill = 2;
        gb.anchor = 17;
        gb = this.buildConstraints(gb, 0, 0, true);
        gb.weightx = 0.1;
        aPanel.add((Component)tempLabel, gb);
        gb = this.buildConstraints(gb, 1, 0, true);
        gb.weightx = 0.4;
        aPanel.add((Component)this.game, gb);
        gb = this.buildConstraints(gb, 2, 0, true);
        gb.weightx = 0.1;
        tempLabel = new JLabel("Info Text:");
        aPanel.add((Component)tempLabel, gb);
        gb = this.buildConstraints(gb, 3, 0, true);
        gb.weightx = 0.4;
        aPanel.add((Component)this.infoText, gb);
        gb.weightx = 0.0;
        tempLabel = new JLabel("Pub Name Short:");
        gb = this.buildConstraints(gb, 0, 1, true);
        aPanel.add((Component)tempLabel, gb);
        gb = this.buildConstraints(gb, 1, 1, true);
        aPanel.add((Component)this.pubNameShort, gb);
        JPanel bPanel = new JPanel();
        tempLabel = new JLabel("OGL:");
        bPanel.add(tempLabel);
        bPanel.add(this.isOGL);
        tempLabel = new JLabel("D20:");
        bPanel.add(tempLabel);
        bPanel.add(this.isD20);
        gb = this.buildConstraints(gb, 2, 1, true);
        aPanel.add((Component)bPanel, gb);
        bPanel = new JPanel();
        bPanel.setLayout(new BorderLayout());
        tempLabel = new JLabel("Setting:");
        bPanel.add((Component)tempLabel, "West");
        bPanel.add((Component)this.setting, "Center");
        gb = this.buildConstraints(gb, 3, 1, true);
        aPanel.add((Component)bPanel, gb);
        tempLabel = new JLabel("Pub Name Long:");
        gb = this.buildConstraints(gb, 0, 2, true);
        aPanel.add((Component)tempLabel, gb);
        gb = this.buildConstraints(gb, 1, 2, true);
        aPanel.add((Component)this.pubNameLong, gb);
        tempLabel = new JLabel("In Menu:");
        gb = this.buildConstraints(gb, 2, 2, true);
        bPanel = new JPanel();
        bPanel.add(tempLabel);
        bPanel.add(this.showInMenu);
        tempLabel = new JLabel("Licensed:");
        bPanel.add(tempLabel);
        bPanel.add(this.isLicensed);
        aPanel.add((Component)bPanel, gb);
        bPanel = new JPanel();
        bPanel.setLayout(new BorderLayout());
        tempLabel = new JLabel("Genre:");
        bPanel.add((Component)tempLabel, "West");
        bPanel.add((Component)this.genre, "Center");
        gb = this.buildConstraints(gb, 3, 2, true);
        aPanel.add((Component)bPanel, gb);
        tempLabel = new JLabel("Pub Name Web:");
        gb = this.buildConstraints(gb, 0, 3, true);
        aPanel.add((Component)tempLabel, gb);
        gb = this.buildConstraints(gb, 1, 3, true);
        aPanel.add((Component)this.pubNameWeb, gb);
        bPanel = new JPanel();
        tempLabel = new JLabel("Rank:");
        bPanel.add(tempLabel);
        bPanel.add(this.rank);
        gb = this.buildConstraints(gb, 2, 3, true);
        aPanel.add((Component)bPanel, gb);
        tempLabel = new JLabel("Book Type");
        gb = this.buildConstraints(gb, 3, 3, true);
        bPanel = new JPanel();
        bPanel.add(tempLabel);
        bPanel.add(this.bookType);
        aPanel.add((Component)bPanel, gb);
        tempLabel = new JLabel("Destination of File:");
        gb = this.buildConstraints(gb, 0, 4, true);
        aPanel.add((Component)tempLabel, gb);
        gb = this.buildConstraints(gb, 1, 4, true);
        gb.gridwidth = 2;
        aPanel.add((Component)this.destination, gb);
        JButton bButton = new JButton("Browse...");
        bButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String loc = "";
                String d = null;
                if (SourceBasePanel.this.theCampaign != null) {
                    d = SourceBasePanel.this.theCampaign.getDestination();
                }
                if (d == null || d.equals("")) {
                    d = SettingsHandler.getPccFilesLocation().toString();
                }
                JFileChooser fc = new JFileChooser();
                fc.setCurrentDirectory(new File(d));
                int returnVal = fc.showOpenDialog(SourceBasePanel.this);
                if (returnVal == 0) {
                    loc = fc.getSelectedFile().toString();
                    if (loc.startsWith(SettingsHandler.getPccFilesLocation().toString())) {
                        loc = loc.substring(SettingsHandler.getPccFilesLocation().toString().length() + 1);
                    } else if (loc.startsWith(SourceBasePanel.this.theCampaign.getSourceFile())) {
                        loc = loc.substring(SourceBasePanel.this.theCampaign.getSourceFile().length() + 1);
                    }
                }
                SourceBasePanel.this.destination.setText(loc);
            }
        });
        gb = this.buildConstraints(gb, 3, 4, true);
        gb.gridwidth = 1;
        aPanel.add((Component)bButton, gb);
        this.add((Component)aPanel, "North");
        this.sourceTable.setModel(this.sourceModel);
        this.sourceTable.setSelectionMode(0);
        this.sourceTable.setDoubleBuffered(false);
        this.scrollPane.setViewportView(this.sourceTable);
        this.add((Component)this.scrollPane, "Center");
        aPanel = new JPanel();
        JButton aButton = new JButton("OPTION");
        aButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SourceBasePanel.this.addOption();
                SourceBasePanel.this.sourceTable.updateUI();
            }
        });
        aPanel.add(aButton);
        aButton = new JButton("COPYRIGHT");
        aPanel.add(aButton);
        aButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SourceBasePanel.this.addCopyright();
                SourceBasePanel.this.sourceTable.updateUI();
            }
        });
        aButton = new JButton("LICENSE");
        aButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SourceBasePanel.this.addLicense();
                SourceBasePanel.this.sourceTable.updateUI();
            }
        });
        aPanel.add(aButton);
        aButton = new JButton("REMOVE");
        aButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SourceBasePanel.this.removeLine();
                SourceBasePanel.this.sourceTable.updateUI();
            }
        });
        aPanel.add(aButton);
        this.add((Component)aPanel, "South");
    }

    private void intComponentContents() {
    }

    private void removeLine() {
        this.sourceModel.removeLine(this.sourceTable.getSelectedRow());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class SourceTableModel
    extends AbstractTableModel {
        List copyrightList = null;
        List licenseList = null;
        List optionList = null;
        List optionValues = null;

        SourceTableModel() {
        }

        public boolean isCellEditable(int rowIndex, int colIndex) {
            return rowIndex < this.optionList.size() || colIndex == 1;
        }

        public Class getColumnClass(int columnIndex) {
            return class$java$lang$String == null ? (class$java$lang$String = SourceBasePanel.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Label";
                }
                case 1: {
                    return "Value";
                }
            }
            return "Out Of Bounds";
        }

        public List getCopyrightList() {
            return this.copyrightList;
        }

        public List getLicenseList() {
            return this.licenseList;
        }

        public void setLists(List optList, List licList, List copyList) {
            this.optionList = optList == null ? new ArrayList() : optList;
            this.optionValues = new ArrayList();
            if (this.optionList != null) {
                Iterator i = this.optionList.iterator();
                while (i.hasNext()) {
                    String aString = (String)i.next();
                    String val = SourceBasePanel.this.theCampaign.getOptions().getProperty(aString);
                    this.optionValues.add(val);
                }
            }
            this.licenseList = licList == null ? new ArrayList() : licList;
            this.copyrightList = copyList == null ? new ArrayList() : copyList;
        }

        public List getOptionList() {
            return this.optionList;
        }

        public List getOptionValues() {
            return this.optionValues;
        }

        public int getRowCount() {
            if (SourceBasePanel.this.theCampaign == null) {
                return 0;
            }
            return this.optionList.size() + this.licenseList.size() + this.copyrightList.size();
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (rowIndex < this.optionList.size()) {
                String vString = (String)aValue;
                if (columnIndex == 0 && vString.startsWith("OPTION:")) {
                    vString = vString.substring(7);
                }
                if (columnIndex == 0) {
                    this.optionList.set(rowIndex, vString);
                } else if (columnIndex == 1) {
                    this.optionValues.set(rowIndex, vString);
                }
                return;
            }
            if ((rowIndex -= this.optionList.size()) < this.copyrightList.size()) {
                this.copyrightList.set(rowIndex, aValue);
                return;
            }
            if ((rowIndex -= this.copyrightList.size()) < this.licenseList.size()) {
                this.licenseList.set(rowIndex, aValue);
                return;
            }
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < this.optionList.size()) {
                String propertyKey = this.optionList.get(rowIndex).toString();
                if (columnIndex == 0) {
                    return "OPTION:" + propertyKey;
                }
                return this.optionValues.get(rowIndex).toString();
            }
            if ((rowIndex -= this.optionList.size()) < this.copyrightList.size()) {
                if (columnIndex == 0) {
                    return "COPYRIGHT:";
                }
                return this.copyrightList.get(rowIndex).toString();
            }
            if ((rowIndex -= this.copyrightList.size()) < this.licenseList.size()) {
                if (columnIndex == 0) {
                    return "LICENSE:";
                }
                return this.licenseList.get(rowIndex).toString();
            }
            return "";
        }

        public void addCopyright() {
            this.copyrightList.add("");
        }

        public void addLicense() {
            this.licenseList.add("");
        }

        public void addOption() {
            this.optionList.add("");
            this.optionValues.add("");
        }

        public void removeLine(int row) {
            if (row < 0) {
                return;
            }
            if (row < this.optionList.size()) {
                this.optionList.remove(row);
                this.optionValues.remove(row);
                return;
            }
            if ((row -= this.optionList.size()) < this.copyrightList.size()) {
                this.copyrightList.remove(row);
                return;
            }
            if ((row -= this.copyrightList.size()) < this.licenseList.size()) {
                this.licenseList.remove(row);
            }
        }
    }
}

