/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import pcgen.core.Campaign;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JTableEx;
import pcgen.util.Logging;

final class SourceFilesPanel
extends JPanel {
    static final long serialVersionUID = 2833296242093657468L;
    private Campaign theCampaign = null;
    private JComboBoxEx fileType;
    private JScrollPane scrollPane;
    private JTableEx fileTable;
    private SourceFileModel fileModel;
    static /* synthetic */ Class class$java$lang$String;

    public SourceFilesPanel() {
        this.initComponents();
        this.intComponentContents();
    }

    public void updateData(PObject thisPObject) {
        List fList = this.fileModel.getFileList();
        List lList = this.fileModel.getLocationList();
        Iterator j = lList.iterator();
        this.theCampaign.addLine(".CLEAR");
        Iterator i = fList.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            String val = (String)j.next();
            if (name.equals("COMMENT")) {
                this.theCampaign.addLine("#" + val);
                continue;
            }
            this.theCampaign.addLine(name + ":" + val);
        }
    }

    public void updateView(PObject thisPObject) {
        if (!(thisPObject instanceof Campaign)) {
            return;
        }
        this.theCampaign = (Campaign)thisPObject;
        List aList = this.theCampaign.getLines();
        Iterator i = aList.iterator();
        while (i.hasNext()) {
            String a = (String)i.next();
            if (a.startsWith("#")) {
                this.fileModel.addFileAndLocation("COMMENT", a.substring(1));
                continue;
            }
            String b = a.substring(0, a.indexOf(":"));
            this.fileModel.addFileAndLocation(b, a.substring(b.length() + 1));
        }
        this.fileTable.updateUI();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.fileTable = new JTableEx();
        this.fileModel = new SourceFileModel();
        this.fileType = new JComboBoxEx();
        this.fileType.addItem("CLASS");
        this.fileType.addItem("COMPANIONMOD");
        this.fileType.addItem("COMMENT");
        this.fileType.addItem("DEITY");
        this.fileType.addItem("DOMAIN");
        this.fileType.addItem("EQUIPMENT");
        this.fileType.addItem("EQUIPMOD");
        this.fileType.addItem("FEAT");
        this.fileType.addItem("KIT");
        this.fileType.addItem("RACE");
        this.fileType.addItem("REGION");
        this.fileType.addItem("SKILL");
        this.fileType.addItem("SPELL");
        this.fileType.addItem("TEMPLATE");
        this.fileType.addItem("WEAPONPROF");
        this.fileType.setSelectedIndex(0);
        JPanel aPanel = new JPanel();
        aPanel.add(this.fileType);
        JButton aButton = new JButton("Add");
        aButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String loc = "";
                String d = null;
                if (SourceFilesPanel.this.theCampaign != null) {
                    d = SourceFilesPanel.this.theCampaign.getDestination();
                }
                if ((d == null || d.equals("")) && (d = SourceFilesPanel.this.theCampaign.getSourceFile()).startsWith("file:/")) {
                    d = d.substring(6);
                }
                if (d == null || d.equals("")) {
                    d = SettingsHandler.getPccFilesLocation().toString();
                }
                if (!SourceFilesPanel.this.fileType.getSelectedItem().toString().equals("COMMENT")) {
                    JFileChooser fc = new JFileChooser();
                    fc.setCurrentDirectory(new File(d));
                    int returnVal = fc.showOpenDialog(SourceFilesPanel.this);
                    if (returnVal == 0) {
                        loc = fc.getSelectedFile().toString();
                        if (loc.startsWith(SettingsHandler.getPccFilesLocation().toString())) {
                            loc = loc.substring(SettingsHandler.getPccFilesLocation().toString().length() + 1);
                        } else if (loc.startsWith(SourceFilesPanel.this.theCampaign.getSourceFile())) {
                            loc = loc.substring(SourceFilesPanel.this.theCampaign.getSourceFile().length() + 1);
                        }
                    }
                }
                SourceFilesPanel.this.fileModel.addFileAndLocation(SourceFilesPanel.this.fileType.getSelectedItem().toString(), loc);
                SourceFilesPanel.this.fileTable.updateUI();
            }
        });
        aPanel.add(aButton);
        aButton = new JButton("Remove");
        aButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int row = SourceFilesPanel.this.fileTable.getSelectedRow();
                SourceFilesPanel.this.fileModel.removeItemsAtIndex(row);
                SourceFilesPanel.this.fileTable.updateUI();
            }
        });
        aPanel.add(aButton);
        this.add((Component)aPanel, "South");
        this.fileTable.setModel(this.fileModel);
        this.fileTable.setSelectionMode(0);
        this.fileTable.setDoubleBuffered(false);
        this.scrollPane.setViewportView(this.fileTable);
        this.add((Component)this.scrollPane, "Center");
    }

    private void intComponentContents() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class SourceFileModel
    extends AbstractTableModel {
        List fileList = new ArrayList();
        List locationList = new ArrayList();

        SourceFileModel() {
        }

        public boolean isCellEditable(int rowIndex, int colIndex) {
            return colIndex == 1;
        }

        public Class getColumnClass(int columnIndex) {
            return class$java$lang$String == null ? (class$java$lang$String = SourceFilesPanel.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return 2;
        }

        public List getFileList() {
            return this.fileList;
        }

        public List getLocationList() {
            return this.locationList;
        }

        public int getRowCount() {
            return this.fileList.size();
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1 && rowIndex < this.locationList.size()) {
                String vString = (String)aValue;
                this.locationList.set(rowIndex, vString);
            }
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            String rc = null;
            switch (columnIndex) {
                case 0: {
                    if (rowIndex < this.fileList.size()) {
                        rc = this.fileList.get(rowIndex).toString();
                        break;
                    }
                    rc = "";
                    break;
                }
                case 1: {
                    if (rowIndex < this.locationList.size()) {
                        rc = this.locationList.get(rowIndex).toString();
                        break;
                    }
                    rc = "";
                    break;
                }
                default: {
                    Logging.errorPrint("Unhandled column " + columnIndex + " at SourceFilesPanel.getValueAt");
                }
            }
            return rc;
        }

        public void addFileAndLocation(String filetype, String filelocation) {
            int row = SourceFilesPanel.this.fileTable.getSelectedRow();
            if (this.fileList.size() == 0) {
                row = 0;
            } else if (row < 0) {
                row = this.fileList.size() - 1;
            }
            this.fileList.add(row, filetype);
            this.locationList.add(row, filelocation);
        }

        public void removeItemsAtIndex(int loc) {
            if (loc >= 0 && loc < this.fileList.size()) {
                this.fileList.remove(loc);
                this.locationList.remove(loc);
            }
        }
    }
}

