/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.SystemCollections;
import pcgen.core.spell.Spell;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.DescriptionPanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.WholeNumberField;
import pcgen.util.DecimalNumberField;
import pcgen.util.PropertyFactory;

public class SpellBasePanel
extends BasePanel {
    private DecimalNumberField txtCost;
    private DescriptionPanel pnlDescription;
    private JCheckBox chkPotionAllowed;
    private JCheckBox chkRingAllowed;
    private JCheckBox chkScrollAllowed;
    private JCheckBox chkWandAllowed;
    private JComboBoxEx cmbArea;
    private JComboBoxEx cmbCastingTime;
    private JComboBoxEx cmbComponents;
    private JComboBoxEx cmbDuration;
    private JComboBoxEx cmbRange;
    private JComboBoxEx cmbSavingThrow;
    private JComboBoxEx cmbSchool;
    private JComboBoxEx cmbSpellRes;
    private JComboBoxEx cmbStat;
    private JComboBoxEx cmbSubschool;
    private JComboBoxEx cmbTarget;
    private JLabel lblArea;
    private JLabel lblCastingTime;
    private JLabel lblComponents;
    private JLabel lblCost;
    private JLabel lblDuration;
    private JLabel lblItems;
    private JLabel lblPotionAllowed;
    private JLabel lblRange;
    private JLabel lblRingAllowed;
    private JLabel lblSavingThrow;
    private JLabel lblSchool;
    private JLabel lblScrollAllowed;
    private JLabel lblSpellRes;
    private JLabel lblStat;
    private JLabel lblSubschool;
    private JLabel lblTarget;
    private JLabel lblWandAllowed;
    private JLabel lblXpCost;
    private JList lstItems;
    private JPanel pnlMagicTypes;
    private JScrollPane scpItems;
    private WholeNumberField txtXpCost;

    public SpellBasePanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void updateData(PObject thisPObject) {
        Spell s = (Spell)thisPObject;
        s.setDescription(this.pnlDescription.getText());
        s.setDescIsPI(this.pnlDescription.getDescIsPI());
        s.setComponentList(".CLEAR");
        String aString = (String)this.cmbComponents.getSelectedItem();
        if (aString != null) {
            s.setComponentList(aString);
        }
        s.setCastingTime(".CLEAR");
        aString = (String)this.cmbCastingTime.getSelectedItem();
        if (aString != null) {
            s.setCastingTime(aString);
        }
        s.setRange(".CLEAR");
        aString = (String)this.cmbRange.getSelectedItem();
        if (aString != null) {
            s.setRange(aString);
        }
        aString = (String)this.cmbTarget.getSelectedItem();
        s.setTarget(aString);
        s.setDuration(".CLEAR");
        aString = (String)this.cmbDuration.getSelectedItem();
        if (aString != null) {
            s.setDuration(aString);
        }
        s.setSaveInfo(".CLEAR");
        aString = (String)this.cmbSavingThrow.getSelectedItem();
        if (aString != null) {
            s.setSaveInfo(aString);
        }
        s.setSpellResistance(".CLEAR");
        aString = (String)this.cmbSpellRes.getSelectedItem();
        if (aString != null) {
            s.setSpellResistance(aString);
        }
        s.addSchool(".CLEAR");
        aString = (String)this.cmbSchool.getSelectedItem();
        if (aString != null) {
            s.addSchool(aString);
        }
        s.addSubschool(".CLEAR");
        aString = (String)this.cmbSubschool.getSelectedItem();
        if (aString != null && !aString.equals("(None)")) {
            s.addSubschool(aString);
        }
        s.setCost(Double.toString(this.txtCost.getValue()));
        s.setXPCost(Integer.toString(this.txtXpCost.getValue()));
        s.setStat((String)this.cmbStat.getSelectedItem());
        StringBuffer sb = new StringBuffer();
        if (this.chkPotionAllowed.isSelected()) {
            sb.append("potion");
        }
        if (!this.chkRingAllowed.isSelected()) {
            sb.append("[ring]");
        }
        if (!this.chkScrollAllowed.isSelected()) {
            sb.append("[scroll]");
        }
        if (!this.chkWandAllowed.isSelected()) {
            sb.append("[wand]");
        }
        s.setCreatableItem(sb.toString());
    }

    public void updateView(PObject thisPObject) {
        Spell thisSpell = (Spell)thisPObject;
        this.pnlDescription.setText(thisSpell.getDescription());
        this.pnlDescription.setDescIsPI(thisSpell.getDescIsPI());
        this.cmbComponents.setSelectedItem(thisSpell.getComponentList());
        this.cmbCastingTime.setSelectedItem(thisSpell.getCastingTime());
        this.cmbRange.setSelectedItem(thisSpell.getRange());
        this.cmbTarget.setSelectedItem(thisSpell.getTarget());
        this.cmbDuration.setSelectedItem(thisSpell.getDuration());
        this.cmbSavingThrow.setSelectedItem(thisSpell.getSaveInfo());
        this.cmbSpellRes.setSelectedItem(thisSpell.getSpellResistance());
        this.cmbSchool.setSelectedItem(thisSpell.getSchool());
        this.cmbSubschool.setSelectedItem(thisSpell.getSubschool());
        if (this.cmbSubschool.getSelectedIndex() < 0) {
            this.cmbSubschool.setSelectedIndex(0);
        }
        this.cmbStat.setSelectedItem(thisSpell.getStat());
        this.txtCost.setValue(thisSpell.getCost().doubleValue());
        this.txtXpCost.setValue(thisSpell.getXPCost());
        String items = thisSpell.getCreatableItem().toLowerCase();
        if (SpellBasePanel.canCreateItem("potion", items)) {
            this.chkPotionAllowed.setSelected(true);
        }
        if (SpellBasePanel.canCreateItem("ring", items)) {
            this.chkRingAllowed.setSelected(true);
        }
        if (SpellBasePanel.canCreateItem("scroll", items)) {
            this.chkScrollAllowed.setSelected(true);
        }
        if (SpellBasePanel.canCreateItem("wand", items)) {
            this.chkWandAllowed.setSelected(true);
        }
    }

    private static boolean canCreateItem(String itemType, String items) {
        boolean canCreate = true;
        if (itemType.equals("potion")) {
            canCreate = false;
        }
        if (items.indexOf("[" + itemType + "]") >= 0) {
            canCreate = false;
        } else if (items.indexOf(itemType) >= 0) {
            canCreate = true;
        }
        return canCreate;
    }

    private void initComponentContents() {
        this.cmbCastingTime.setModel(new DefaultComboBoxModel<Object>(Globals.getCastingTimesSet().toArray()));
        this.cmbRange.setModel(new DefaultComboBoxModel<Object>(Globals.getRangesSet().toArray()));
        this.cmbSpellRes.setModel(new DefaultComboBoxModel<Object>(Globals.getSrSet().toArray()));
        this.cmbSchool.setModel(new DefaultComboBoxModel<Object>(SystemCollections.getUnmodifiableSchoolsList().toArray()));
        this.cmbSavingThrow.setModel(new DefaultComboBoxModel<Object>(Globals.getSaveInfoSet().toArray()));
        this.cmbTarget.setModel(new DefaultComboBoxModel<Object>(Globals.getTargetSet().toArray()));
        this.cmbComponents.setModel(new DefaultComboBoxModel<Object>(Globals.getComponentSet().toArray()));
        this.cmbDuration.setModel(new DefaultComboBoxModel<Object>(Globals.getDurationSet().toArray()));
        this.cmbStat.setModel(new DefaultComboBoxModel<Object>(Globals.getStatSet().toArray()));
        ArrayList<String> subschools = new ArrayList<String>(10);
        subschools.add("(None)");
        subschools.addAll(Globals.getSubschools());
        this.cmbSubschool.setModel(new DefaultComboBoxModel<Object>(subschools.toArray()));
    }

    private void initComponents() {
        this.pnlDescription = new DescriptionPanel();
        this.lblComponents = new JLabel();
        this.cmbComponents = new JComboBoxEx();
        this.lblCastingTime = new JLabel();
        this.cmbCastingTime = new JComboBoxEx();
        this.lblRange = new JLabel();
        this.cmbRange = new JComboBoxEx();
        this.lblTarget = new JLabel();
        this.cmbTarget = new JComboBoxEx();
        this.lblArea = new JLabel();
        this.cmbArea = new JComboBoxEx();
        this.lblDuration = new JLabel();
        this.cmbDuration = new JComboBoxEx();
        this.lblSavingThrow = new JLabel();
        this.cmbSavingThrow = new JComboBoxEx();
        this.lblSpellRes = new JLabel();
        this.cmbSpellRes = new JComboBoxEx();
        this.lblCost = new JLabel();
        this.txtCost = new DecimalNumberField(0.0, 6);
        this.lblSchool = new JLabel();
        this.cmbSchool = new JComboBoxEx();
        this.lblSubschool = new JLabel();
        this.cmbSubschool = new JComboBoxEx();
        this.lblStat = new JLabel();
        this.cmbStat = new JComboBoxEx();
        this.lblItems = new JLabel();
        this.scpItems = new JScrollPane();
        this.lstItems = new JList();
        this.lblXpCost = new JLabel();
        this.txtXpCost = new WholeNumberField(0, 6);
        this.pnlMagicTypes = new JPanel();
        this.lblPotionAllowed = new JLabel();
        this.chkPotionAllowed = new JCheckBox();
        this.chkRingAllowed = new JCheckBox();
        this.lblRingAllowed = new JLabel();
        this.lblScrollAllowed = new JLabel();
        this.chkScrollAllowed = new JCheckBox();
        this.lblWandAllowed = new JLabel();
        this.chkWandAllowed = new JCheckBox();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 8;
        gbc.gridheight = 2;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 4, 2, 2);
        gbc.weightx = 1.0;
        gbc.weighty = 0.3;
        this.add((Component)this.pnlDescription, gbc);
        this.lblComponents.setText(PropertyFactory.getString("in_demComponents"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        this.add((Component)this.lblComponents, gbc);
        this.lblCastingTime.setText(PropertyFactory.getString("in_demCastingTime"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        this.add((Component)this.lblCastingTime, gbc);
        this.cmbCastingTime.setEditable(true);
        this.cmbCastingTime.setPreferredSize(new Dimension(120, 25));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        gbc.weightx = 0.25;
        this.add((Component)this.cmbCastingTime, gbc);
        this.lblRange.setText(PropertyFactory.getString("in_demRange"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        this.add((Component)this.lblRange, gbc);
        this.cmbRange.setEditable(true);
        this.cmbRange.setPreferredSize(new Dimension(120, 25));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        this.add((Component)this.cmbRange, gbc);
        this.lblTarget.setText(PropertyFactory.getString("in_demTargetArea"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        this.add((Component)this.lblTarget, gbc);
        this.cmbTarget.setEditable(true);
        this.cmbTarget.setPreferredSize(new Dimension(120, 25));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        this.add((Component)this.cmbTarget, gbc);
        this.lblDuration.setText(PropertyFactory.getString("in_demDuration"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        this.add((Component)this.lblDuration, gbc);
        this.cmbDuration.setEditable(true);
        this.cmbDuration.setPreferredSize(new Dimension(120, 25));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        this.add((Component)this.cmbDuration, gbc);
        this.lblSavingThrow.setText(PropertyFactory.getString("in_demSavingThrow"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        this.add((Component)this.lblSavingThrow, gbc);
        this.cmbSavingThrow.setEditable(true);
        this.cmbSavingThrow.setPreferredSize(new Dimension(120, 25));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        this.add((Component)this.cmbSavingThrow, gbc);
        this.lblSpellRes.setText(PropertyFactory.getString("in_demSpellResistance"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        this.add((Component)this.lblSpellRes, gbc);
        this.cmbSpellRes.setEditable(true);
        this.cmbSpellRes.setPreferredSize(new Dimension(120, 25));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 8;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        this.add((Component)this.cmbSpellRes, gbc);
        this.lblCost.setText(PropertyFactory.getString("in_demComponentCost"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        this.add((Component)this.lblCost, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 9;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        this.add((Component)this.txtCost, gbc);
        this.lblSchool.setText(PropertyFactory.getString("in_demSchool"));
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 2;
        gbc.insets = new Insets(2, 10, 2, 2);
        gbc.anchor = 13;
        this.add((Component)this.lblSchool, gbc);
        this.cmbSchool.setEditable(true);
        this.cmbSchool.setPreferredSize(new Dimension(120, 25));
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        this.add((Component)this.cmbSchool, gbc);
        this.lblSubschool.setText(PropertyFactory.getString("in_demSubschool"));
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 3;
        gbc.insets = new Insets(2, 10, 2, 2);
        gbc.anchor = 13;
        this.add((Component)this.lblSubschool, gbc);
        this.cmbSubschool.setEditable(true);
        this.cmbSubschool.setPreferredSize(new Dimension(120, 25));
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        gbc.weightx = 0.25;
        this.add((Component)this.cmbSubschool, gbc);
        this.lblStat.setText(PropertyFactory.getString("in_demStat"));
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 4;
        gbc.insets = new Insets(2, 10, 2, 2);
        gbc.anchor = 13;
        this.add((Component)this.lblStat, gbc);
        this.cmbStat.setEditable(true);
        this.cmbStat.setPreferredSize(new Dimension(120, 25));
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        gbc.weightx = 0.25;
        this.add((Component)this.cmbStat, gbc);
        this.lblXpCost.setText(PropertyFactory.getString("in_demXPCost"));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 9;
        gbc.insets = new Insets(2, 10, 2, 2);
        gbc.anchor = 13;
        this.add((Component)this.lblXpCost, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 9;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        this.add((Component)this.txtXpCost, gbc);
        this.cmbComponents.setEditable(true);
        this.cmbComponents.setPreferredSize(new Dimension(120, 25));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        this.add((Component)this.cmbComponents, gbc);
        this.pnlMagicTypes.setLayout(new GridBagLayout());
        this.pnlMagicTypes.setBorder(new TitledBorder(PropertyFactory.getString("in_demAllowedMagicItemType")));
        this.lblPotionAllowed.setLabelFor(this.chkPotionAllowed);
        this.lblPotionAllowed.setText(PropertyFactory.getString("in_demPotion"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(2, 0, 2, 2);
        gbc.anchor = 13;
        this.pnlMagicTypes.add((Component)this.lblPotionAllowed, gbc);
        this.chkPotionAllowed.setHorizontalTextPosition(10);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 0);
        gbc.anchor = 17;
        gbc.weightx = 0.5;
        this.pnlMagicTypes.add((Component)this.chkPotionAllowed, gbc);
        this.lblScrollAllowed.setLabelFor(this.chkScrollAllowed);
        this.lblScrollAllowed.setText(PropertyFactory.getString("in_demScroll"));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(2, 0, 2, 2);
        gbc.anchor = 13;
        this.pnlMagicTypes.add((Component)this.lblScrollAllowed, gbc);
        this.chkScrollAllowed.setHorizontalTextPosition(10);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 0);
        gbc.anchor = 17;
        gbc.weightx = 0.5;
        this.pnlMagicTypes.add((Component)this.chkScrollAllowed, gbc);
        this.lblWandAllowed.setLabelFor(this.chkWandAllowed);
        this.lblWandAllowed.setText(PropertyFactory.getString("in_demWand"));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(2, 0, 2, 2);
        gbc.anchor = 13;
        this.pnlMagicTypes.add((Component)this.lblWandAllowed, gbc);
        this.chkWandAllowed.setHorizontalTextPosition(10);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 0);
        gbc.anchor = 17;
        gbc.weightx = 0.5;
        this.pnlMagicTypes.add((Component)this.chkWandAllowed, gbc);
        this.lblRingAllowed.setLabelFor(this.chkRingAllowed);
        this.lblRingAllowed.setText(PropertyFactory.getString("in_demRing"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(2, 0, 2, 2);
        gbc.anchor = 13;
        this.pnlMagicTypes.add((Component)this.lblRingAllowed, gbc);
        this.chkRingAllowed.setHorizontalTextPosition(10);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 0);
        gbc.anchor = 17;
        gbc.weightx = 0.5;
        this.pnlMagicTypes.add((Component)this.chkRingAllowed, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 5;
        gbc.gridwidth = 3;
        gbc.gridheight = 5;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 10, 2, 2);
        gbc.anchor = 18;
        this.add((Component)this.pnlMagicTypes, gbc);
    }
}

