/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.spell.Spell;
import pcgen.gui.editor.EditUtil;
import pcgen.gui.editor.JListModel;
import pcgen.gui.editor.PObjectUpdater;
import pcgen.gui.editor.TypePanel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.util.PropertyFactory;

public class SpellBasePanel2
extends JPanel
implements PObjectUpdater {
    static final long serialVersionUID = -4883465552783045888L;
    private JButton btnAddVariant;
    private JButton btnRemoveVariant;
    private JList lstVariants;
    private JPanel pnlVariants;
    private JScrollPane scpVariants;
    private JTextField txtVariant;
    private TypePanel pnlType;

    public SpellBasePanel2() {
        this.initComponents();
    }

    public void updateData(PObject thisPObject) {
        Spell s = (Spell)thisPObject;
        Object[] sel = this.pnlType.getSelectedList();
        s.setTypeInfo(".CLEAR");
        s.setTypeInfo(EditUtil.delimitArray(sel, '.'));
        sel = ((JListModel)this.lstVariants.getModel()).getElements();
        s.clearVariants();
        for (int i = 0; i < sel.length; ++i) {
            s.addVariant(sel[i].toString());
        }
    }

    public void updateView(PObject thisPObject) {
        List variants = ((Spell)thisPObject).getVariants();
        if (variants.size() != 0) {
            ((JListModel)this.lstVariants.getModel()).setData(variants);
        }
        ArrayList availableList = new ArrayList();
        ArrayList<String> selectedList = new ArrayList<String>();
        Iterator e = Globals.getSpellMap().values().iterator();
        while (e.hasNext()) {
            Object obj = e.next();
            if (obj instanceof List) {
                for (int i = 0; i < ((ArrayList)obj).size(); ++i) {
                    EditUtil.addPObjectTypes((Spell)((List)obj).get(i), availableList);
                }
                continue;
            }
            EditUtil.addPObjectTypes((Spell)obj, availableList);
        }
        int i = thisPObject.getMyTypeCount();
        while (i > 0) {
            String aString;
            if ((aString = thisPObject.getMyType(--i)).equals("CUSTOM")) continue;
            selectedList.add(aString);
            availableList.remove(aString);
        }
        this.pnlType.setAvailableList(availableList, true);
        this.pnlType.setSelectedList(selectedList, true);
    }

    private void btnAddVariantActionPerformed() {
        this.btnAddVariant.setEnabled(false);
        JListModel lmd = (JListModel)this.lstVariants.getModel();
        lmd.addElement(this.txtVariant.getText());
        this.txtVariant.setText("");
    }

    private void btnRemoveVariantActionPerformed() {
        this.btnRemoveVariant.setEnabled(false);
        JListModel lms = (JListModel)this.lstVariants.getModel();
        Object[] x = this.lstVariants.getSelectedValues();
        for (int i = 0; i < x.length; ++i) {
            this.txtVariant.setText(x[i].toString());
            lms.removeElement(x[i]);
        }
        this.txtVariantKeyReleased();
    }

    private void initComponents() {
        this.pnlType = new TypePanel(PropertyFactory.getString("in_demEnterNewType"));
        this.pnlVariants = new JPanel();
        this.scpVariants = new JScrollPane();
        this.lstVariants = new JList(new JListModel(new ArrayList(), true));
        this.txtVariant = new JTextField();
        try {
            this.btnAddVariant = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
            this.btnRemoveVariant = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        }
        catch (Exception exc) {
            this.btnAddVariant = new JButton(">");
            this.btnRemoveVariant = new JButton("<");
        }
        this.btnRemoveVariant.setEnabled(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 5;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.pnlType, gbc);
        this.pnlVariants.setLayout(new GridBagLayout());
        this.lstVariants.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SpellBasePanel2.this.lstVariantsMouseClicked(evt);
            }
        });
        this.pnlVariants.setBorder(new TitledBorder(PropertyFactory.getString("in_demVariants")));
        this.scpVariants.setViewportView(this.lstVariants);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.gridheight = 4;
        gbc.fill = 1;
        gbc.weightx = 0.4;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.pnlVariants.add((Component)this.scpVariants, gbc);
        this.btnAddVariant.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpellBasePanel2.this.btnAddVariantActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.pnlVariants.add((Component)this.btnAddVariant, gbc);
        this.btnRemoveVariant.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpellBasePanel2.this.btnRemoveVariantActionPerformed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.pnlVariants.add((Component)this.btnRemoveVariant, gbc);
        this.txtVariant.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                super.keyReleased(evt);
                SpellBasePanel2.this.txtVariantKeyReleased();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 0.2;
        this.pnlVariants.add((Component)this.txtVariant, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.gridwidth = 5;
        gbc.gridheight = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.pnlVariants, gbc);
    }

    private void lstVariantsMouseClicked(MouseEvent evt) {
        if (EditUtil.isDoubleClick(evt, this.lstVariants, this.btnRemoveVariant)) {
            this.btnRemoveVariantActionPerformed();
        }
    }

    private void txtVariantKeyReleased() {
        this.btnAddVariant.setEnabled(this.txtVariant.getText().trim().length() != 0);
    }
}

