/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pcgen.core.Globals;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.TypePanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.PropertyFactory;

public class TemplateBasePanel
extends BasePanel {
    private static final String[] genderLockValues = new String[]{"None", "Male", "Female", "Neuter"};
    private static final String[] visibleValues = new String[]{"No", "Yes", "Export", "Display"};
    private static final String[] sizeTitles = new String[]{"(no change)", "Fine", "Diminutive", "Tiny", "Small", "Medium", "Large", "Huge", "Gargantuan", "Colossal"};
    private static final String[] sizeAbbrev = new String[]{"", "F", "D", "T", "S", "M", "L", "H", "G", "C"};
    private JCheckBox chkRemovable;
    private JComboBoxEx cmbBonusFeats;
    private JComboBoxEx cmbBonusSkillPoints;
    private JComboBoxEx cmbGenderLock;
    private JComboBoxEx cmbNonProficiencyPenalty;
    private JComboBoxEx cmbSize;
    private JComboBoxEx cmbVisible;
    private JPanel pnlTemplateMisc;
    private JTextField txtCR;
    private JTextField txtLevelAdj;
    private JTextField txtSubRace;
    private JTextField txtSubRegion;
    private TypePanel pnlTemplateTypes;

    public TemplateBasePanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void setBonusFeats(int bonusFeats) {
        if (bonusFeats >= 0 && bonusFeats < this.cmbBonusFeats.getItemCount()) {
            this.cmbBonusFeats.setSelectedIndex(bonusFeats);
        }
    }

    public int getBonusFeats() {
        return this.cmbBonusFeats.getSelectedIndex();
    }

    public void setBonusSkillPoints(int bonusSkillPoints) {
        if (bonusSkillPoints >= 0 && bonusSkillPoints < this.cmbBonusSkillPoints.getItemCount()) {
            this.cmbBonusSkillPoints.setSelectedIndex(bonusSkillPoints);
        }
    }

    public int getBonusSkillPoints() {
        return this.cmbBonusSkillPoints.getSelectedIndex();
    }

    public void setCR(int argCR) {
        this.txtCR.setText(String.valueOf(argCR));
    }

    public int getCR() {
        return Integer.parseInt(this.txtCR.getText());
    }

    public void setGenderLock(String aString) {
        if (aString.length() == 0) {
            this.cmbGenderLock.setSelectedItem("None");
        } else {
            for (int i = genderLockValues.length - 1; i >= 0; --i) {
                if (!genderLockValues[i].equals(aString)) continue;
                this.cmbGenderLock.setSelectedItem(genderLockValues[i]);
                break;
            }
        }
    }

    public String getGenderLock() {
        return (String)this.cmbGenderLock.getSelectedItem();
    }

    public void setIsRemovable(boolean isRemovable) {
        this.chkRemovable.setSelected(isRemovable);
    }

    public boolean getIsRemovable() {
        return this.chkRemovable.isSelected();
    }

    public void setLevelAdjustment(String levelAdj) {
        this.txtLevelAdj.setText(levelAdj);
    }

    public String getLevelAdjustment() {
        return this.txtLevelAdj.getText();
    }

    public void setNonProficiencyPenalty(int nonProficiencyPenalty) {
        if (nonProficiencyPenalty <= 0 && nonProficiencyPenalty * -1 < this.cmbNonProficiencyPenalty.getItemCount()) {
            this.cmbNonProficiencyPenalty.setSelectedIndex(nonProficiencyPenalty * -1);
        }
    }

    public int getNonProficiencyPenalty() {
        return this.cmbNonProficiencyPenalty.getSelectedIndex() * -1;
    }

    public void setSubRace(String aString) {
        if ("None".equals(aString) || aString == null || "".equals(aString)) {
            this.txtSubRace.setText("");
        } else {
            this.txtSubRace.setText(aString);
        }
    }

    public String getSubRace() {
        if (this.txtSubRace.getText() == null || this.txtSubRace.getText().trim().length() == 0) {
            return "None";
        }
        return this.txtSubRace.getText();
    }

    public void setSubRegion(String aString) {
        if ("None".equals(aString) || aString == null || "".equals(aString)) {
            this.txtSubRegion.setText("");
        } else {
            this.txtSubRegion.setText(aString);
        }
    }

    public String getSubRegion() {
        if (this.txtSubRegion.getText() == null || this.txtSubRegion.getText().trim().length() == 0) {
            return "None";
        }
        return this.txtSubRegion.getText();
    }

    public void setTemplateSize(String aString) {
        this.cmbSize.setSelectedIndex(0);
        for (int index = 0; index < sizeAbbrev.length; ++index) {
            if (!sizeAbbrev[index].equals(aString)) continue;
            this.cmbSize.setSelectedIndex(index);
            break;
        }
    }

    public String getTemplateSize() {
        int index = this.cmbSize.getSelectedIndex();
        if (index >= 0 && index < sizeAbbrev.length) {
            return sizeAbbrev[index];
        }
        return "";
    }

    public void setTypesAvailableList(List aList, boolean sort) {
        this.pnlTemplateTypes.setAvailableList(aList, sort);
    }

    public void setTypesSelectedList(List aList, boolean sort) {
        this.pnlTemplateTypes.setSelectedList(aList, sort);
    }

    public Object[] getTypesSelectedList() {
        return this.pnlTemplateTypes.getSelectedList();
    }

    public void setVisible(int aNumber) {
        if (aNumber >= 0 && aNumber <= 3) {
            this.cmbVisible.setSelectedIndex(aNumber);
        }
    }

    public int getVisible() {
        return this.cmbVisible.getSelectedIndex();
    }

    public void updateData(PObject thisPObject) {
        PCTemplate thisPCTemplate = (PCTemplate)thisPObject;
        thisPCTemplate.setRemovable(this.getIsRemovable());
        thisPCTemplate.setGenderLock(this.getGenderLock());
        thisPCTemplate.setVisible(this.getVisible());
        thisPCTemplate.setSubRegion(this.getSubRegion());
        thisPCTemplate.setSubRace(this.getSubRace());
        thisPCTemplate.setBonusSkillsPerLevel(this.getBonusSkillPoints());
        thisPCTemplate.setBonusInitialFeats(this.getBonusFeats());
        thisPCTemplate.setCR(this.getCR());
        thisPCTemplate.setLevelAdjustment(this.getLevelAdjustment());
        thisPCTemplate.setNonProficiencyPenalty(this.getNonProficiencyPenalty());
        thisPCTemplate.setTemplateSize(this.getTemplateSize());
        Object[] sel = this.getTypesSelectedList();
        thisPObject.setTypeInfo(".CLEAR");
        for (int i = 0; i < sel.length; ++i) {
            thisPCTemplate.setTypeInfo(sel[i].toString());
        }
    }

    public void updateView(PObject thisPObject) {
        String aString;
        PCTemplate thisPCTemplate = (PCTemplate)thisPObject;
        ArrayList<String> availableList = new ArrayList<String>();
        ArrayList<String> selectedList = new ArrayList<String>();
        Iterator e = Globals.getTemplateList().iterator();
        while (e.hasNext()) {
            PCTemplate aTemplate = (PCTemplate)e.next();
            int i = aTemplate.getMyTypeCount();
            while (i > 0) {
                if ((aString = aTemplate.getMyType(--i)).equals("CUSTOM") || availableList.contains(aString)) continue;
                availableList.add(aString);
            }
        }
        int i = thisPCTemplate.getMyTypeCount();
        while (i > 0) {
            if ((aString = thisPCTemplate.getMyType(--i)).equals("CUSTOM")) continue;
            selectedList.add(aString);
            availableList.remove(aString);
        }
        this.setTypesAvailableList(availableList, true);
        this.setTypesSelectedList(selectedList, true);
        this.setIsRemovable(thisPCTemplate.isRemovable());
        this.setGenderLock(thisPCTemplate.getGenderLock());
        this.setVisible(thisPCTemplate.isVisible());
        this.setSubRegion(thisPCTemplate.getSubRegion());
        this.setSubRace(thisPCTemplate.getSubRace());
        this.setBonusSkillPoints(thisPCTemplate.getBonusSkillsPerLevel());
        this.setNonProficiencyPenalty(thisPCTemplate.getNonProficiencyPenalty());
        this.setBonusFeats(thisPCTemplate.getBonusInitialFeats());
        this.setCR(thisPCTemplate.getCR(-1, -1));
        this.setLevelAdjustment(thisPCTemplate.getLevelAdjustmentFormula());
        this.setTemplateSize(thisPCTemplate.getTemplateSize());
    }

    private void initComponentContents() {
        int i;
        this.cmbGenderLock.setModel(new DefaultComboBoxModel<String>(genderLockValues));
        this.cmbVisible.setModel(new DefaultComboBoxModel<String>(visibleValues));
        String[] values = new String[20];
        for (i = 0; i < values.length; ++i) {
            values[i] = String.valueOf(i);
        }
        this.cmbBonusSkillPoints.setModel(new DefaultComboBoxModel<String>(values));
        this.cmbBonusFeats.setModel(new DefaultComboBoxModel<String>(values));
        values = new String[10];
        for (i = 0; i < values.length; ++i) {
            values[i] = String.valueOf(-1 * i);
        }
        this.cmbNonProficiencyPenalty.setModel(new DefaultComboBoxModel<String>(values));
        this.cmbSize.setModel(new DefaultComboBoxModel<String>(sizeTitles));
    }

    private void initComponents() {
        this.pnlTemplateMisc = new JPanel();
        this.chkRemovable = new JCheckBox();
        this.cmbGenderLock = new JComboBoxEx();
        this.cmbBonusSkillPoints = new JComboBoxEx();
        this.cmbBonusFeats = new JComboBoxEx();
        this.cmbNonProficiencyPenalty = new JComboBoxEx();
        this.cmbVisible = new JComboBoxEx();
        this.txtCR = new JTextField();
        this.txtLevelAdj = new JTextField();
        this.cmbSize = new JComboBoxEx();
        this.txtSubRegion = new JTextField();
        this.txtSubRace = new JTextField();
        this.pnlTemplateTypes = new TypePanel(PropertyFactory.getString("in_demEnterNewType"));
        this.setLayout(new GridBagLayout());
        this.pnlTemplateMisc.setLayout(new GridBagLayout());
        JLabel tempLabel = new JLabel("Visible");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbVisible, gridBagConstraints);
        tempLabel = new JLabel("Removable");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.chkRemovable, gridBagConstraints);
        tempLabel = new JLabel("Gender Locked");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbGenderLock, gridBagConstraints);
        tempLabel = new JLabel("Wpn Non Prof Penalty");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbNonProficiencyPenalty, gridBagConstraints);
        tempLabel = new JLabel("Bonus Skill Pts / Level");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbBonusSkillPoints, gridBagConstraints);
        tempLabel = new JLabel("Bonus Starting Feats");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbBonusFeats, gridBagConstraints);
        tempLabel = new JLabel("CR");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.txtCR, gridBagConstraints);
        tempLabel = new JLabel("Level Adjustment");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.txtLevelAdj, gridBagConstraints);
        tempLabel = new JLabel("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbSize, gridBagConstraints);
        tempLabel = new JLabel("Sub Race");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.txtSubRace, gridBagConstraints);
        tempLabel = new JLabel("Sub Region");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)tempLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.txtSubRegion, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlTemplateMisc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlTemplateTypes, gridBagConstraints);
    }
}

