/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.editor.EditUtil;
import pcgen.gui.editor.JListModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.PropertyFactory;

final class VisionPanel
extends JPanel {
    static final long serialVersionUID = 7340632645513314167L;
    private JButton btnAdd;
    private JButton btnRemove;
    private JComboBoxEx cmbVisionType;
    private JLabel lblSelected;
    private JList lstSelected;
    private JPanel pnlAddRemove;
    private JPanel pnlAvailable;
    private JPanel pnlSelected;
    private JScrollPane scpSelected;
    private JTextField txtVisionDistance;

    VisionPanel() {
        this.initComponents();
        this.initComponentContents();
    }

    void setSelectedList(List argSelected) {
        int x = argSelected.size();
        for (int i = 0; i < x; ++i) {
            this.addToSelectedLst((String)argSelected.get(i));
        }
    }

    Object[] getSelectedList() {
        return ((JListModel)this.lstSelected.getModel()).getElements();
    }

    Map getVision() {
        HashMap<String, String> vision = new HashMap<String, String>();
        Object[] selected = this.getSelectedList();
        for (int index = 0; index < selected.length; ++index) {
            String moveString = (String)selected[index];
            int idx = moveString.indexOf(",");
            vision.put(moveString.substring(0, idx), moveString.substring(idx + 1));
        }
        return vision;
    }

    private void addToSelectedLst(String visionValue) {
        JListModel lmd = (JListModel)this.lstSelected.getModel();
        int x = lmd.getSize();
        for (int i = 0; i < x; ++i) {
            Object obj = lmd.getElementAt(i);
            if (!((String)obj).startsWith(visionValue.substring(0, visionValue.indexOf(",")))) continue;
            lmd.removeElement(obj);
            --x;
        }
        lmd.addElement(visionValue);
    }

    private void btnAddActionPerformed() {
        String visionType = (String)this.cmbVisionType.getSelectedItem();
        if (visionType == null || visionType.length() == 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_demVisionInfoMissing"), "PCGen", MessageType.ERROR);
            return;
        }
        String newEntry = (String)this.cmbVisionType.getSelectedItem() + ",";
        newEntry = this.txtVisionDistance.getText().trim().length() == 0 ? newEntry + "0" : newEntry + this.txtVisionDistance.getText().trim();
        this.addToSelectedLst(newEntry);
    }

    private void btnRemoveActionPerformed() {
        this.btnRemove.setEnabled(false);
        JListModel lms = (JListModel)this.lstSelected.getModel();
        Object[] x = this.lstSelected.getSelectedValues();
        for (int i = 0; i < x.length; ++i) {
            lms.removeElement(x[i]);
        }
    }

    private void initComponentContents() {
    }

    private void initComponents() {
        this.cmbVisionType = new JComboBoxEx(new String[]{"Normal", "Low-light", "Keen Low-light", "Darkvision", "Blindsight", "Keen Scent", "Tremorsense"});
        this.cmbVisionType.setEditable(true);
        this.txtVisionDistance = new JTextField();
        try {
            this.btnAdd = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
            this.btnRemove = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        }
        catch (Exception exc) {
            this.btnAdd = new JButton(">");
            this.btnRemove = new JButton("<");
        }
        this.lblSelected = new JLabel(PropertyFactory.getString("in_selected"));
        this.lstSelected = new JList(new JListModel(new ArrayList(), true));
        this.pnlAvailable = new JPanel();
        this.pnlAddRemove = new JPanel();
        this.pnlSelected = new JPanel();
        this.scpSelected = new JScrollPane();
        Border etched = null;
        TitledBorder title1 = BorderFactory.createTitledBorder(etched, PropertyFactory.getString("in_demTag"));
        title1.setTitleJustification(1);
        this.pnlAvailable.setBorder(title1);
        this.pnlAvailable.setLayout(new GridBagLayout());
        JLabel lblTemp = new JLabel(PropertyFactory.getString("in_demVisionType"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)lblTemp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAvailable.add((Component)this.cmbVisionType, gridBagConstraints);
        lblTemp = new JLabel(PropertyFactory.getString("in_demDistance"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)lblTemp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAvailable.add((Component)this.txtVisionDistance, gridBagConstraints);
        this.pnlAddRemove.setLayout(new GridBagLayout());
        this.btnAdd.setEnabled(true);
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VisionPanel.this.btnAddActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAddRemove.add((Component)this.btnAdd, gridBagConstraints);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VisionPanel.this.btnRemoveActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAddRemove.add((Component)this.btnRemove, gridBagConstraints);
        this.pnlSelected.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        this.pnlSelected.add((Component)this.lblSelected, gridBagConstraints);
        this.lstSelected.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                VisionPanel.this.lstSelectedMouseClicked(evt);
            }
        });
        this.scpSelected.setPreferredSize(new Dimension(90, 20));
        this.scpSelected.setViewportView(this.lstSelected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.pnlSelected.add((Component)this.scpSelected, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAvailable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAddRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlSelected, gridBagConstraints);
    }

    private void lstSelectedMouseClicked(MouseEvent evt) {
        if (evt.getSource().equals(this.lstSelected)) {
            String aString = (String)this.lstSelected.getSelectedValue();
            StringTokenizer visionString = new StringTokenizer(aString, ",", false);
            this.cmbVisionType.setSelectedItem(visionString.nextToken());
            this.txtVisionDistance.setText(visionString.nextToken());
            if (EditUtil.isDoubleClick(evt, this.lstSelected, this.btnRemove)) {
                this.btnRemoveActionPerformed();
            }
        }
    }
}

