/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.gui.filter.PObjectFilter;

public abstract class AbstractPObjectFilter
implements PObjectFilter {
    private String category;
    private String description;
    private String name;

    protected AbstractPObjectFilter() {
        this("", "", "");
    }

    protected AbstractPObjectFilter(String argName) {
        this("", argName, "");
    }

    protected AbstractPObjectFilter(String argCategory, String argName) {
        this(argCategory, argName, "");
    }

    private AbstractPObjectFilter(String argCategory, String argName, String argDescription) {
        this.setCategory(argCategory);
        this.setName(argName);
        this.setDescription(argDescription);
    }

    public String getCategory() {
        return this.category;
    }

    public void setDescription(String d) {
        this.description = AbstractPObjectFilter.normalize(d);
    }

    public String getDescription(PlayerCharacter aPC) {
        return this.description;
    }

    public String getName(PlayerCharacter aPC) {
        return this.name;
    }

    public final boolean equals(Object object) {
        if (object instanceof PObjectFilter) {
            return this.equals((PObjectFilter)object);
        }
        return super.equals(object);
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public abstract boolean accept(PlayerCharacter var1, PObject var2);

    public String toString() {
        return this.category.length() > 0 ? this.getCategory() + " :  " + this.getName(Globals.getCurrentPC()) : this.getName(Globals.getCurrentPC());
    }

    final void setCategory(String c) {
        this.category = AbstractPObjectFilter.normalize(c);
    }

    void setName(String n) {
        this.name = AbstractPObjectFilter.normalize(n);
    }

    private final boolean equals(PObjectFilter filter) {
        return filter.toString().equals(this.toString());
    }

    private static String normalize(String s) {
        int sLen = s.length();
        StringBuffer work = new StringBuffer(sLen);
        work.append(s);
        for (int i = 0; i < sLen; ++i) {
            char current = work.charAt(i);
            if (current == '|') {
                work.setCharAt(i, '-');
                continue;
            }
            if (current == '[') {
                work.setCharAt(i, '(');
                continue;
            }
            if (current != ']') continue;
            work.setCharAt(i, ')');
        }
        return work.toString();
    }
}

