/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.gui.filter.CustomFilter;
import pcgen.gui.filter.FilterConstants;
import pcgen.gui.filter.PObjectFilter;
import pcgen.util.PropertyFactory;

final class CompoundFilter
extends AbstractPObjectFilter
implements CustomFilter,
FilterConstants {
    private PObjectFilter filter1;
    private PObjectFilter filter2;
    private String connect;

    CompoundFilter(PObjectFilter argFilter1, PObjectFilter argFilter2, String argConnect) {
        this.connect = argConnect.trim().toUpperCase();
        this.filter1 = argFilter1;
        this.filter2 = argFilter2;
        this.setCategory(PropertyFactory.getString("in_custom"));
        this.setName("(" + this.filter1.getName(Globals.getCurrentPC()) + " " + this.connect.toLowerCase() + " " + this.filter2.getName(Globals.getCurrentPC()) + ")");
    }

    public boolean accept(PlayerCharacter aPC, PObject pObject) {
        if ("AND".equals(this.connect)) {
            return this.filter1.accept(aPC, pObject) && this.filter2.accept(aPC, pObject);
        }
        if ("OR".equals(this.connect)) {
            return this.filter1.accept(aPC, pObject) || this.filter2.accept(aPC, pObject);
        }
        return false;
    }

    public String toString() {
        return "((" + this.filter1.toString() + ") " + this.connect.toLowerCase() + " (" + this.filter2.toString() + "))";
    }
}

