/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.core.Deity;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.gui.filter.AlignmentFilter;
import pcgen.util.PropertyFactory;

final class DeityAlignmentFilter
extends AlignmentFilter {
    private int alignment;

    DeityAlignmentFilter(int alignment) {
        this(alignment, "default");
    }

    DeityAlignmentFilter(int alignment, String mode) {
        super(PropertyFactory.getString("in_alignLabel"), SettingsHandler.getGame().getLongAlignmentAtIndex(alignment));
        this.alignment = alignment;
        this.mode = mode;
    }

    public String getCategory() {
        if ("default".equals(this.mode)) {
            return super.getCategory();
        }
        return super.getCategory() + " (" + this.mode + ')';
    }

    public boolean accept(PlayerCharacter aPC, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Deity) {
            String deityAlign = ((Deity)pObject).getAlignment();
            return deityAlign.equals(SettingsHandler.getGame().getShortAlignmentAtIndex(this.alignment)) || deityAlign.equals(SettingsHandler.getGame().getLongAlignmentAtIndex(this.alignment));
        }
        if (pObject instanceof PCClass) {
            return this.passesAlignmentPrereqs(pObject);
        }
        if (pObject instanceof PCTemplate) {
            return this.passesAlignmentPrereqs(pObject);
        }
        if (pObject instanceof Race) {
            return this.passesAlignmentPrereqs(pObject);
        }
        return true;
    }

    private boolean passesAlignmentPrereqs(PObject pObject) {
        return this.passesAlignmentPrereqs(pObject, this.alignment);
    }
}

