/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.gui.filter.Filterable;
import pcgen.gui.filter.PObjectFilter;

public abstract class FilterAdapterPanel
extends JPanel
implements Filterable {
    private List availableFilters = new ArrayList(0);
    private List removedFilters = new ArrayList(0);
    private List selectedFilters = new ArrayList(0);
    private String kitFilter = "";
    private int filterMode = 0;

    public final List getAvailableFilters() {
        return this.availableFilters;
    }

    public final void setFilterMode(int mode) {
        this.filterMode = mode;
    }

    public final int getFilterMode() {
        return this.filterMode;
    }

    public final List getRemovedFilters() {
        return this.removedFilters;
    }

    public final List getSelectedFilters() {
        return this.selectedFilters;
    }

    public final void registerFilter(PObjectFilter filter) {
        if (filter != null) {
            this.availableFilters.add(filter);
        }
    }

    public boolean isMatchAnyEnabled() {
        return false;
    }

    public boolean isNegateEnabled() {
        return false;
    }

    public int getSelectionMode() {
        return -1;
    }

    public abstract void initializeFilters();

    public abstract void refreshFiltering();

    public final void setKitFilter(String argKitFilter) {
        this.kitFilter = argKitFilter;
    }

    public final String getKitFilter() {
        return this.kitFilter;
    }

    protected final boolean accept(PlayerCharacter aPC, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        int mode = this.getFilterMode();
        Iterator it = this.getSelectedFilters().iterator();
        while (it.hasNext()) {
            PObjectFilter filter = (PObjectFilter)it.next();
            if (mode == 0 && !filter.accept(aPC, pObject)) {
                return false;
            }
            if (mode == 1 && !filter.accept(aPC, pObject)) {
                return true;
            }
            if (mode == 2 && filter.accept(aPC, pObject)) {
                return true;
            }
            if (mode != 3 || !filter.accept(aPC, pObject)) continue;
            return false;
        }
        if (mode == 0 || mode == 3) {
            return true;
        }
        if (mode == 2 || mode == 1) {
            return this.getSelectedFilters().size() == 0;
        }
        return true;
    }
}

