/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterDialogFactory;
import pcgen.gui.filter.FilterList;
import pcgen.gui.filter.Filterable;
import pcgen.gui.filter.GBLPanel;
import pcgen.gui.filter.SortedListModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.util.PropertyFactory;

final class FilterCustomDialog
extends JDialog
implements ActionListener {
    static final long serialVersionUID = -6836959436921618384L;
    private FilterList availableList;
    private FilterList removedList;
    private Filterable filterable;
    private JButton addButton;
    private JButton applyButton;
    private JButton cancelButton;
    private JButton removeButton;
    private SortedListModel availableModel;
    private SortedListModel removedModel;
    private int maxSelected;

    FilterCustomDialog() {
        super((Frame)Globals.getRootFrame(), PropertyFactory.getString("in_filterCustom"));
        this.init();
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.addButton)) {
            int[] indices = this.availableList.getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                this.removedModel.addElement(this.availableModel.get(indices[i] - i));
                this.availableModel.removeElementAt(indices[i] - i);
            }
            if (this.removedModel.size() == this.maxSelected) {
                this.addButton.setEnabled(false);
            }
        } else if (src.equals(this.removeButton)) {
            int[] indices = this.removedList.getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                this.availableModel.addElement(this.removedModel.get(indices[i] - i));
                this.removedModel.removeElementAt(indices[i] - i);
            }
            if (this.removedModel.size() < this.maxSelected) {
                this.addButton.setEnabled(true);
            }
        } else if (src.equals(this.applyButton)) {
            if (this.filterable != null) {
                this.storeFilters(this.filterable.getAvailableFilters(), this.filterable.getRemovedFilters());
                FilterDialogFactory.setFilters(this.filterable.getAvailableFilters(), this.filterable.getSelectedFilters());
                SettingsHandler.storeFilterSettings(this.filterable);
                PCGen_Frame1.restoreFilterSettings(this.filterable.getName());
                this.filterable = null;
            }
            this.setVisible(false);
        } else if (src.equals(this.cancelButton)) {
            this.filterable = null;
            this.setVisible(false);
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this.settings(PCGen_Frame1.getCurrentFilterable());
        }
        super.setVisible(b);
    }

    private void setFilters(List availableFilters, List removedFilters) {
        Iterator it;
        this.availableModel.clear();
        this.removedModel.clear();
        if (availableFilters != null) {
            it = availableFilters.iterator();
            while (it.hasNext()) {
                this.availableModel.addElement(it.next());
            }
        }
        if (removedFilters != null) {
            it = removedFilters.iterator();
            while (it.hasNext()) {
                this.removedModel.addElement(it.next());
            }
        }
    }

    private void _init() {
        GBLPanel leftPanel = new GBLPanel();
        GBLPanel middlePanel = new GBLPanel();
        GBLPanel rightPanel = new GBLPanel();
        ListMouseHandler lml = new ListMouseHandler();
        leftPanel.gbc.anchor = 18;
        leftPanel.gbc.weighty = 0.0;
        leftPanel.add(new JLabel(PropertyFactory.getString("in_availFils")), 0, 0, 1, 1);
        Dimension scrollPaneDimension = new Dimension(200, 295);
        this.availableModel = new SortedListModel();
        this.availableList = new FilterList((ListModel)this.availableModel);
        this.availableList.setSelectionMode(0);
        this.availableList.addMouseListener(lml);
        JScrollPane availableScroll = new JScrollPane(this.availableList);
        availableScroll.setMinimumSize(scrollPaneDimension);
        availableScroll.setPreferredSize(scrollPaneDimension);
        JPanel leftListPanel = new JPanel(new GridLayout(1, 1));
        leftListPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        leftListPanel.add(availableScroll);
        leftPanel.gbc.weightx = 10.0;
        leftPanel.gbc.weighty = 10.0;
        leftPanel.gbc.fill = 1;
        leftPanel.gbc.anchor = 10;
        leftPanel.add(leftListPanel, 1, 0, 1, 1);
        middlePanel.gbc.weightx = 0.0;
        middlePanel.gbc.weighty = 0.0;
        middlePanel.gbc.anchor = 18;
        middlePanel.add(new JLabel("   "), 0, 0, 1, 1);
        this.addButton = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
        this.addButton.addActionListener(this);
        this.removeButton = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        this.removeButton.addActionListener(this);
        JPanel addButtonPanel = new JPanel(new GridLayout(1, 1));
        addButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        addButtonPanel.add(this.addButton);
        JPanel removeButtonPanel = new JPanel(new GridLayout(1, 1));
        removeButtonPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        removeButtonPanel.add(this.removeButton);
        JPanel middleButtonPanel = new JPanel(new GridLayout(2, 1));
        middleButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        middleButtonPanel.add(addButtonPanel);
        middleButtonPanel.add(removeButtonPanel);
        middlePanel.gbc.weighty = 10.0;
        middlePanel.gbc.anchor = 11;
        middlePanel.add(middleButtonPanel, 1, 0, 1, 1);
        rightPanel.gbc.weighty = 0.0;
        rightPanel.gbc.anchor = 18;
        rightPanel.add(new JLabel(PropertyFactory.getString("in_removeFils")), 0, 0, 1, 1);
        this.removedModel = new SortedListModel();
        this.removedList = new FilterList((ListModel)this.removedModel);
        this.removedList.setSelectionMode(0);
        this.removedList.addMouseListener(lml);
        JScrollPane removedScroll = new JScrollPane(this.removedList);
        removedScroll.setMinimumSize(scrollPaneDimension);
        removedScroll.setPreferredSize(scrollPaneDimension);
        JPanel rightListPanel = new JPanel(new GridLayout(1, 1));
        rightListPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        rightListPanel.add(removedScroll);
        rightPanel.gbc.weightx = 10.0;
        rightPanel.gbc.weighty = 10.0;
        rightPanel.gbc.fill = 1;
        rightPanel.gbc.anchor = 10;
        rightPanel.add(rightListPanel, 1, 0, 1, 1);
        Dimension buttonDimension = new Dimension(95, 27);
        this.applyButton = new JButton(PropertyFactory.getString("in_apply"));
        this.applyButton.setPreferredSize(buttonDimension);
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton(PropertyFactory.getString("in_cancel"));
        this.cancelButton.setPreferredSize(buttonDimension);
        this.cancelButton.addActionListener(this);
        JPanel applyButtonPanel = new JPanel(new GridLayout(1, 1));
        applyButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 5));
        applyButtonPanel.add(this.applyButton);
        JPanel cancelButtonPanel = new JPanel(new GridLayout(1, 1));
        cancelButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 2));
        cancelButtonPanel.add(this.cancelButton);
        GBLPanel rightButtonPanel = new GBLPanel();
        rightButtonPanel.gbc.weightx = 0.0;
        rightButtonPanel.gbc.weighty = 0.0;
        rightButtonPanel.gbc.fill = 0;
        rightButtonPanel.gbc.anchor = 13;
        rightButtonPanel.add(applyButtonPanel, 0, 0, 1, 1);
        rightButtonPanel.add(cancelButtonPanel, 0, 1, 1, 1);
        GBLPanel mainPanel = new GBLPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.gbc.fill = 1;
        mainPanel.gbc.anchor = 11;
        mainPanel.gbc.weighty = 10.0;
        mainPanel.add(leftPanel, 0, 0, 1, 1);
        mainPanel.gbc.weightx = 0.0;
        mainPanel.add(middlePanel, 0, 1, 1, 1);
        mainPanel.gbc.weightx = 10.0;
        mainPanel.add(rightPanel, 0, 2, 1, 1);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPanel.add((Component)mainPanel, "Center");
        contentPanel.add((Component)rightButtonPanel, "South");
        this.setContentPane(contentPanel);
    }

    private void activateDisplayOnlyMode() {
        this.availableModel.clear();
        this.removedModel.clear();
        this.availableList.setEnabled(false);
        this.removedList.setEnabled(false);
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.applyButton.setEnabled(false);
    }

    private void activateMultiMultiMode() {
        this.availableList.setSelectionMode(2);
        this.removedList.setSelectionMode(2);
        this.maxSelected = Integer.MAX_VALUE;
    }

    private void init() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 4, screenSize.height / 4);
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this._init();
        this.pack();
        this.setResizable(false);
        this.activateMultiMultiMode();
    }

    private void settings(Filterable f) {
        if (f == null) {
            this.activateDisplayOnlyMode();
        } else {
            this.filterable = f;
            if (f.getSelectionMode() < 0) {
                this.activateDisplayOnlyMode();
                return;
            }
            this.availableList.setEnabled(true);
            this.removedList.setEnabled(true);
            this.setFilters(f.getAvailableFilters(), f.getRemovedFilters());
            this.addButton.setEnabled(true);
            this.removeButton.setEnabled(true);
            this.applyButton.setEnabled(true);
        }
    }

    private void storeFilters(List availableFilters, List removedFilters) {
        Enumeration filters;
        if (availableFilters != null) {
            availableFilters.clear();
            filters = this.availableModel.elements();
            while (filters.hasMoreElements()) {
                availableFilters.add(filters.nextElement());
            }
        }
        if (removedFilters != null) {
            removedFilters.clear();
            filters = this.removedModel.elements();
            while (filters.hasMoreElements()) {
                removedFilters.add(filters.nextElement());
            }
        }
    }

    private class ListMouseHandler
    extends MouseAdapter {
        private ListMouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            Object src = e.getSource();
            if (e.getClickCount() == 2) {
                if (src.equals(FilterCustomDialog.this.availableList) && FilterCustomDialog.this.removedModel.size() < FilterCustomDialog.this.maxSelected) {
                    int index = FilterCustomDialog.this.availableList.getSelectedIndex();
                    if (index > -1) {
                        FilterCustomDialog.this.removedModel.addElement(FilterCustomDialog.this.availableModel.get(index));
                        FilterCustomDialog.this.availableModel.removeElementAt(index);
                    }
                    if (FilterCustomDialog.this.removedModel.size() == FilterCustomDialog.this.maxSelected) {
                        FilterCustomDialog.this.addButton.setEnabled(false);
                    }
                } else if (src.equals(FilterCustomDialog.this.removedList)) {
                    int index = FilterCustomDialog.this.removedList.getSelectedIndex();
                    if (index > -1) {
                        FilterCustomDialog.this.availableModel.addElement(FilterCustomDialog.this.removedModel.get(index));
                        FilterCustomDialog.this.removedModel.removeElementAt(index);
                    }
                    if (FilterCustomDialog.this.removedModel.size() < FilterCustomDialog.this.maxSelected) {
                        FilterCustomDialog.this.addButton.setEnabled(true);
                    }
                }
            }
        }
    }
}

