/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.util.Iterator;
import java.util.List;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.PToolBar;
import pcgen.gui.filter.FilterCustomDialog;
import pcgen.gui.filter.FilterEditorDialog;
import pcgen.gui.filter.FilterSelectDialog;
import pcgen.gui.filter.Filterable;
import pcgen.util.PropertyFactory;

public final class FilterDialogFactory {
    private static final String in_selectFilter = PropertyFactory.getString("in_selectFilter");
    private static final String in_curSelFil = PropertyFactory.getString("in_curSelFil");
    private static final String in_curNoSelFil = PropertyFactory.getString("in_curNoSelFil");
    private static final String in_curActTab = PropertyFactory.getString("in_curActTab");
    private static final String in_matchAllOf = PropertyFactory.getString("in_matchAllOf");
    private static final String in_matchNotAllOf = PropertyFactory.getString("in_matchNotAllOf");
    private static final String in_matchAnyOf = PropertyFactory.getString("in_matchAnyOf");
    private static final String in_matchNotAnyOf = PropertyFactory.getString("in_matchNotAnyOf");
    private static FilterSelectDialog filterSelectDialog = null;
    private static FilterCustomDialog filterCustomDialog = null;
    private static FilterEditorDialog filterEditorDialog = null;

    public static String getSelectedFiltersToolTipText() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append("<font face=\"Dialog\" size=\"2\">");
        buffer.append(in_selectFilter);
        Filterable f = PCGen_Frame1.getCurrentFilterable();
        if (f != null) {
            if (f.getSelectedFilters().size() > 0) {
                buffer.append("<br>").append(in_curSelFil);
                int mode = f.getFilterMode();
                if (mode == 0) {
                    buffer.append("<br>").append(in_matchAllOf);
                } else if (mode == 1) {
                    buffer.append("<br>").append(in_matchNotAllOf);
                } else if (mode == 2) {
                    buffer.append("<br>").append(in_matchAnyOf);
                } else if (mode == 3) {
                    buffer.append("<br>").append(in_matchNotAnyOf);
                }
                buffer.append("<ul>");
                Iterator it = f.getSelectedFilters().iterator();
                while (it.hasNext()) {
                    buffer.append("<li>");
                    buffer.append(it.next().toString());
                    buffer.append("</li>");
                }
                buffer.append("</ul>");
            } else {
                buffer.append("<br>").append(in_curNoSelFil);
            }
        } else {
            buffer.append("<br>").append(in_curActTab);
        }
        buffer.append("</font>");
        buffer.append("</html>");
        return buffer.toString();
    }

    public static void clearSelectedFiltersForSelectedFilterable() {
        Filterable f = PCGen_Frame1.getCurrentFilterable();
        if (f != null) {
            f.getAvailableFilters().addAll(f.getSelectedFilters());
            f.getSelectedFilters().clear();
            PToolBar.getCurrentInstance().setFilterInactive();
            f.refreshFiltering();
            FilterSelectDialog fsd = FilterDialogFactory.getCurrentSelectDialogInstance();
            if (fsd.isShowing()) {
                fsd.clearSelectedFilters();
            }
        }
    }

    public static void showHideFilterCustomDialog() {
        if (filterCustomDialog == null) {
            filterCustomDialog = new FilterCustomDialog();
        }
        if (!filterCustomDialog.isShowing()) {
            filterCustomDialog.setVisible(true);
        } else {
            filterCustomDialog.setVisible(false);
        }
    }

    public static void showHideFilterEditorDialog() {
        if (filterEditorDialog == null) {
            filterEditorDialog = new FilterEditorDialog();
        }
        if (!filterEditorDialog.isShowing()) {
            filterEditorDialog.setVisible(true);
        } else {
            filterEditorDialog.setVisible(false);
        }
    }

    public static void showHideFilterSelectDialog() {
        if (filterSelectDialog == null) {
            filterSelectDialog = new FilterSelectDialog();
        }
        if (!filterSelectDialog.isShowing()) {
            filterSelectDialog.setVisible(true);
        } else {
            filterSelectDialog.setVisible(false);
        }
    }

    static void setFilters(List availableFilters, List selectedFilters) {
        FilterDialogFactory.getCurrentSelectDialogInstance().setFilters(availableFilters, selectedFilters);
    }

    private static FilterSelectDialog getCurrentSelectDialogInstance() {
        if (filterSelectDialog == null) {
            filterSelectDialog = new FilterSelectDialog();
        }
        return filterSelectDialog;
    }
}

