/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import pcgen.core.Constants;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.CustomFilter;
import pcgen.gui.filter.FilterDialogFactory;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.filter.FilterList;
import pcgen.gui.filter.FilterNameDialog;
import pcgen.gui.filter.FilterParseException;
import pcgen.gui.filter.FilterParser;
import pcgen.gui.filter.Filterable;
import pcgen.gui.filter.GBLPanel;
import pcgen.gui.filter.NamedFilter;
import pcgen.gui.filter.PObjectFilter;
import pcgen.gui.filter.SortedListModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

final class FilterEditorDialog
extends JDialog
implements ActionListener {
    static final long serialVersionUID = 6455344467032929848L;
    private static final String HELP_MESSAGE = PropertyFactory.getString("in_filterHelpMessage");
    private FilterList customList;
    private FilterList standardList;
    private final FilterNameDialog filterNameDialog = new FilterNameDialog();
    private Filterable filterable;
    private JButton addCustomButton;
    private JButton addStandardButton;
    private JButton applyButton;
    private JButton cancelButton;
    private JButton clearButton;
    private JButton createButton;
    private JButton deleteButton;
    private JTextArea editorArea;
    private List customFilters = new ArrayList();
    private Map customFiltersOrigin = new HashMap();
    private SortedListModel customModel;
    private SortedListModel standardModel;

    public FilterEditorDialog() {
        super((Frame)Globals.getRootFrame(), PropertyFactory.getString("in_filterCustom"));
        this.init();
    }

    public void actionPerformed(ActionEvent e) {
        block12: {
            Object src;
            block16: {
                PObjectFilter filter;
                block15: {
                    block14: {
                        block13: {
                            block11: {
                                src = e.getSource();
                                if (!src.equals(this.addStandardButton)) break block11;
                                int[] indices = this.standardList.getSelectedIndices();
                                for (int i = 0; i < indices.length; ++i) {
                                    PObjectFilter filter2 = (PObjectFilter)this.standardModel.get(indices[i]);
                                    StringBuffer buf = new StringBuffer();
                                    buf.append(Constants.s_LINE_SEP).append("[").append(filter2.getCategory()).append(" :  ");
                                    buf.append(filter2.getName(Globals.getCurrentPC())).append("]");
                                    this.editorArea.append(buf.toString());
                                }
                                break block12;
                            }
                            if (!src.equals(this.addCustomButton)) break block13;
                            int[] indices = this.customList.getSelectedIndices();
                            for (int i = 0; i < indices.length; ++i) {
                                PObjectFilter filter3 = (PObjectFilter)this.customModel.get(indices[i]);
                                StringBuffer buf = new StringBuffer();
                                buf.append(Constants.s_LINE_SEP).append("[").append(filter3.getCategory()).append(" :  ");
                                buf.append(filter3.getName(Globals.getCurrentPC())).append("]");
                                this.editorArea.append(buf.toString());
                            }
                            break block12;
                        }
                        if (!src.equals(this.applyButton)) break block14;
                        if (this.filterable != null) {
                            this.storeFilters(this.filterable.getAvailableFilters(), this.filterable.getSelectedFilters(), this.filterable.getRemovedFilters());
                            FilterDialogFactory.setFilters(this.filterable.getAvailableFilters(), this.filterable.getSelectedFilters());
                            SettingsHandler.storeFilterSettings(this.filterable);
                            PCGen_Frame1.restoreFilterSettings(this.filterable.getName());
                            this.filterable = null;
                        }
                        this.setVisible(false);
                        break block12;
                    }
                    if (!src.equals(this.cancelButton)) break block15;
                    if (this.filterable != null) {
                        this.unStoreFilters(this.filterable.getAvailableFilters(), this.filterable.getSelectedFilters(), this.filterable.getRemovedFilters());
                    }
                    this.filterable = null;
                    this.setVisible(false);
                    break block12;
                }
                if (!src.equals(this.createButton)) break block16;
                try {
                    filter = new FilterParser(new List[]{this.filterable.getAvailableFilters(), this.filterable.getSelectedFilters(), this.filterable.getRemovedFilters(), this.customFilters}).parse(this.editorArea.getText());
                }
                catch (FilterParseException ex) {
                    filter = null;
                    Logging.errorPrint("Error in FilterDialogFactory::actionPerformed", ex);
                    ShowMessageDelegate.showMessageDialog(ex.getMessage(), PropertyFactory.getString("in_error"), MessageType.ERROR);
                }
                if (filter == null) break block12;
                this.filterNameDialog.setIllegalNames(this.createIllegalNamesList());
                this.filterNameDialog.setVisible(true);
                if ((this.filterNameDialog.getName() + this.filterNameDialog.getDescription()).length() > 0) {
                    filter = FilterFactory.createNamedFilter(filter, this.filterNameDialog.getName(), this.filterNameDialog.getDescription());
                }
                this.customModel.addElement(filter);
                this.customFilters.add(filter);
                break block12;
            }
            if (src.equals(this.clearButton)) {
                this.editorArea.setText("");
            } else if (src.equals(this.deleteButton)) {
                int[] indices = this.customList.getSelectedIndices();
                for (int i = 0; i < indices.length; ++i) {
                    this.customModel.removeElementAt(indices[i] - i);
                }
            }
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this.editorArea.setText(HELP_MESSAGE);
            this.settings(PCGen_Frame1.getCurrentFilterable());
        }
        super.setVisible(b);
    }

    private void setFilters(List availableFilters, List selectedFilters, List removedFilters) {
        Object filter;
        this.standardModel.clear();
        this.customModel.clear();
        this.customFilters.clear();
        this.customFiltersOrigin.clear();
        Iterator it = availableFilters.iterator();
        while (it.hasNext()) {
            filter = it.next();
            if (filter instanceof CustomFilter) {
                this.customFiltersOrigin.put(filter.getClass().getName(), "available");
                this.customFilters.add(filter);
                this.customModel.addElement(filter);
                it.remove();
                continue;
            }
            this.standardModel.addElement(filter);
        }
        it = selectedFilters.iterator();
        while (it.hasNext()) {
            filter = it.next();
            if (filter instanceof CustomFilter) {
                this.customFiltersOrigin.put(filter.getClass().getName(), "selected");
                this.customFilters.add(filter);
                this.customModel.addElement(filter);
                it.remove();
                continue;
            }
            this.standardModel.addElement(filter);
        }
        it = removedFilters.iterator();
        while (it.hasNext()) {
            filter = it.next();
            if (filter instanceof CustomFilter) {
                this.customFiltersOrigin.put(filter.getClass().getName(), "removed");
                this.customFilters.add(filter);
                this.customModel.addElement(filter);
                it.remove();
                continue;
            }
            this.standardModel.addElement(filter);
        }
    }

    private void _init() {
        GBLPanel leftPanel = new GBLPanel();
        GBLPanel middlePanel = new GBLPanel();
        GBLPanel rightPanel = new GBLPanel();
        ListMouseHandler lml = new ListMouseHandler();
        Dimension buttonDimension = new Dimension(95, 27);
        this.applyButton = new JButton(PropertyFactory.getString("in_apply"));
        this.applyButton.setPreferredSize(buttonDimension);
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton(PropertyFactory.getString("in_cancel"));
        this.cancelButton.setPreferredSize(buttonDimension);
        this.cancelButton.addActionListener(this);
        JPanel applyButtonPanel = new JPanel(new GridLayout(1, 1));
        applyButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 5));
        applyButtonPanel.add(this.applyButton);
        JPanel cancelButtonPanel = new JPanel(new GridLayout(1, 1));
        cancelButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 2));
        cancelButtonPanel.add(this.cancelButton);
        GBLPanel rightButtonPanel = new GBLPanel();
        rightButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        rightButtonPanel.gbc.weightx = 0.0;
        rightButtonPanel.gbc.weighty = 0.0;
        rightButtonPanel.gbc.fill = 0;
        rightButtonPanel.add(applyButtonPanel, 0, 0, 1, 1);
        rightButtonPanel.add(cancelButtonPanel, 0, 1, 1, 1);
        this.createButton = new JButton(PropertyFactory.getString("in_create"));
        this.createButton.setPreferredSize(buttonDimension);
        this.createButton.addActionListener(this);
        this.clearButton = new JButton(PropertyFactory.getString("in_clear"));
        this.clearButton.setPreferredSize(buttonDimension);
        this.clearButton.addActionListener(this);
        JPanel createButtonPanel = new JPanel(new GridLayout(1, 1));
        createButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 5));
        createButtonPanel.add(this.createButton);
        JPanel clearButtonPanel = new JPanel(new GridLayout(1, 1));
        clearButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 2));
        clearButtonPanel.add(this.clearButton);
        GBLPanel leftButtonPanel = new GBLPanel();
        leftButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        leftButtonPanel.gbc.weightx = 0.0;
        leftButtonPanel.gbc.weighty = 0.0;
        leftButtonPanel.gbc.fill = 0;
        leftButtonPanel.add(createButtonPanel, 0, 0, 1, 1);
        leftButtonPanel.add(clearButtonPanel, 0, 1, 1, 1);
        this.deleteButton = new JButton(PropertyFactory.getString("in_delete"));
        this.deleteButton.setPreferredSize(buttonDimension);
        this.deleteButton.addActionListener(this);
        JPanel deleteButtonPanel = new JPanel(new GridLayout(1, 1));
        deleteButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        deleteButtonPanel.add(this.deleteButton);
        leftPanel.gbc.anchor = 18;
        leftPanel.gbc.weighty = 0.0;
        leftPanel.add(new JLabel(PropertyFactory.getString("in_standardFils") + ": "), 0, 0, 1, 1);
        Dimension scrollPaneDimension = new Dimension(200, 295);
        this.standardModel = new SortedListModel();
        this.standardList = new FilterList((ListModel)this.standardModel);
        this.standardList.setSelectionMode(0);
        this.standardList.addMouseListener(lml);
        JScrollPane standardScroll = new JScrollPane(this.standardList);
        standardScroll.setMinimumSize(scrollPaneDimension);
        standardScroll.setPreferredSize(scrollPaneDimension);
        JPanel leftListPanel = new JPanel(new GridLayout(1, 1));
        leftListPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        leftListPanel.add(standardScroll);
        this.addStandardButton = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
        this.addStandardButton.addActionListener(this);
        JPanel addStandardButtonPanel = new JPanel(new GridLayout(1, 1));
        addStandardButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        addStandardButtonPanel.add(this.addStandardButton);
        leftPanel.gbc.weightx = 0.0;
        leftPanel.gbc.weighty = 10.0;
        leftPanel.gbc.fill = 1;
        leftPanel.gbc.anchor = 10;
        leftPanel.add(leftListPanel, 1, 0, 1, 1);
        leftPanel.gbc.weighty = 0.0;
        leftPanel.gbc.fill = 0;
        leftPanel.gbc.anchor = 11;
        leftPanel.add(addStandardButtonPanel, 1, 1, 1, 1);
        middlePanel.gbc.weightx = 0.0;
        middlePanel.gbc.weighty = 0.0;
        middlePanel.gbc.fill = 0;
        middlePanel.gbc.anchor = 18;
        middlePanel.add(new JLabel(PropertyFactory.getString("in_editor") + ": "), 0, 0, 1, 1);
        Dimension editorDimension = new Dimension(scrollPaneDimension.width * 2, scrollPaneDimension.height);
        this.editorArea = new JTextArea();
        JScrollPane editorScroll = new JScrollPane(this.editorArea);
        editorScroll.setMinimumSize(editorDimension);
        editorScroll.setPreferredSize(editorDimension);
        JPanel editorPanel = new JPanel(new GridLayout(1, 1));
        editorPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        editorPanel.add(editorScroll);
        middlePanel.gbc.weightx = 10.0;
        middlePanel.gbc.weighty = 10.0;
        middlePanel.gbc.fill = 1;
        middlePanel.gbc.anchor = 11;
        middlePanel.add(editorPanel, 1, 0, 1, 1);
        middlePanel.gbc.weighty = 0.0;
        middlePanel.gbc.fill = 2;
        middlePanel.gbc.anchor = 11;
        middlePanel.add(leftButtonPanel, 2, 0, 1, 1);
        rightPanel.gbc.weighty = 0.0;
        rightPanel.gbc.anchor = 18;
        rightPanel.add(new JLabel(PropertyFactory.getString("in_customFils") + ": "), 0, 1, 1, 1);
        this.customModel = new SortedListModel();
        this.customList = new FilterList((ListModel)this.customModel);
        this.customList.setSelectionMode(0);
        this.customList.addMouseListener(lml);
        JScrollPane customScroll = new JScrollPane(this.customList);
        customScroll.setMinimumSize(scrollPaneDimension);
        customScroll.setPreferredSize(scrollPaneDimension);
        JPanel rightListPanel = new JPanel(new GridLayout(1, 1));
        rightListPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        rightListPanel.add(customScroll);
        this.addCustomButton = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        this.addCustomButton.addActionListener(this);
        JPanel addCustomButtonPanel = new JPanel(new GridLayout(1, 1));
        addCustomButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        addCustomButtonPanel.add(this.addCustomButton);
        rightPanel.gbc.weightx = 0.0;
        rightPanel.gbc.weighty = 0.0;
        rightPanel.gbc.fill = 0;
        rightPanel.gbc.anchor = 11;
        rightPanel.add(addCustomButtonPanel, 1, 0, 1, 1);
        rightPanel.gbc.weighty = 10.0;
        rightPanel.gbc.fill = 1;
        rightPanel.gbc.anchor = 10;
        rightPanel.add(rightListPanel, 1, 1, 1, 1);
        rightPanel.gbc.weighty = 0.0;
        rightPanel.gbc.fill = 0;
        rightPanel.gbc.anchor = 13;
        rightPanel.add(deleteButtonPanel, 2, 1, 1, 1);
        GBLPanel mainPanel = new GBLPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        mainPanel.gbc.fill = 1;
        mainPanel.gbc.anchor = 11;
        mainPanel.gbc.weighty = 10.0;
        mainPanel.gbc.weightx = 0.0;
        mainPanel.add(leftPanel, 0, 0, 1, 1);
        mainPanel.gbc.weightx = 10.0;
        mainPanel.add(middlePanel, 0, 1, 1, 1);
        mainPanel.gbc.weightx = 0.0;
        mainPanel.add(rightPanel, 0, 2, 1, 1);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPanel.add((Component)mainPanel, "Center");
        contentPanel.add((Component)rightButtonPanel, "South");
        this.setContentPane(contentPanel);
    }

    private void activateDisplayOnlyMode() {
        this.standardModel.clear();
        this.customModel.clear();
        this.standardList.setEnabled(false);
        this.customList.setEnabled(false);
        this.addStandardButton.setEnabled(false);
        this.addCustomButton.setEnabled(false);
        this.applyButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.createButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
    }

    private void activateMultiMultiMode() {
        this.standardList.setSelectionMode(2);
        this.customList.setSelectionMode(2);
    }

    private List createIllegalNamesList() {
        ArrayList<String> illegalNames = new ArrayList<String>();
        Iterator it = this.customFilters.iterator();
        while (it.hasNext()) {
            PObjectFilter filter = (PObjectFilter)it.next();
            if (!(filter instanceof NamedFilter)) continue;
            illegalNames.add(filter.getName(Globals.getCurrentPC()));
        }
        return illegalNames;
    }

    private void init() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 24, screenSize.height / 4);
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this._init();
        this.pack();
        this.activateMultiMultiMode();
    }

    private void settings(Filterable f) {
        if (f == null) {
            this.activateDisplayOnlyMode();
        } else {
            this.filterable = f;
            if (f.getSelectionMode() < 0) {
                this.activateDisplayOnlyMode();
                return;
            }
            this.standardList.setEnabled(true);
            this.customList.setEnabled(true);
            this.setFilters(this.filterable.getAvailableFilters(), this.filterable.getSelectedFilters(), this.filterable.getRemovedFilters());
            this.addStandardButton.setEnabled(true);
            this.addCustomButton.setEnabled(true);
            this.applyButton.setEnabled(true);
            this.clearButton.setEnabled(true);
            this.createButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        }
    }

    private void storeFilters(List availableFilters, List selectedFilters, List removedFilters) {
        Enumeration filters = this.customModel.elements();
        while (filters.hasMoreElements()) {
            Object filter = filters.nextElement();
            String origin = (String)this.customFiltersOrigin.get(filter.getClass().getName());
            if (origin == null || "available".equals(origin)) {
                availableFilters.add(filter);
                continue;
            }
            if ("selected".equals(origin)) {
                selectedFilters.add(filter);
                continue;
            }
            if (!"removed".equals(origin)) continue;
            removedFilters.add(filter);
        }
    }

    private void unStoreFilters(List availableFilters, List selectedFilters, List removedFilters) {
        Iterator it = this.customFilters.iterator();
        while (it.hasNext()) {
            Object filter = it.next();
            String origin = (String)this.customFiltersOrigin.get(filter.getClass().getName());
            if (origin == null) continue;
            if ("available".equals(origin)) {
                availableFilters.add(filter);
                continue;
            }
            if ("selected".equals(origin)) {
                selectedFilters.add(filter);
                continue;
            }
            if (!"removed".equals(origin)) continue;
            removedFilters.add(filter);
        }
    }

    private class ListMouseHandler
    extends MouseAdapter {
        private ListMouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            Object src = e.getSource();
            if (e.getClickCount() == 2) {
                int index;
                if (src.equals(FilterEditorDialog.this.standardList)) {
                    int index2 = FilterEditorDialog.this.standardList.getSelectedIndex();
                    if (index2 > -1) {
                        PObjectFilter filter = (PObjectFilter)FilterEditorDialog.this.standardModel.get(index2);
                        FilterEditorDialog.this.editorArea.append(Constants.s_LINE_SEP);
                        FilterEditorDialog.this.editorArea.append("[" + filter.getCategory() + " :  " + filter.getName(Globals.getCurrentPC()) + "]");
                    }
                } else if (src.equals(FilterEditorDialog.this.customList) && (index = FilterEditorDialog.this.customList.getSelectedIndex()) > -1) {
                    PObjectFilter filter = (PObjectFilter)FilterEditorDialog.this.customModel.get(index);
                    FilterEditorDialog.this.editorArea.append(Constants.s_LINE_SEP);
                    FilterEditorDialog.this.editorArea.append("[" + filter.getCategory() + " :  " + filter.getName(Globals.getCurrentPC()) + "]");
                }
            }
        }
    }
}

