/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Campaign;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.gui.filter.AffordableFilter;
import pcgen.gui.filter.AutomaticFeatFilter;
import pcgen.gui.filter.CastingTimeFilter;
import pcgen.gui.filter.ComponentFilter;
import pcgen.gui.filter.CompoundFilter;
import pcgen.gui.filter.DeityAlignmentFilter;
import pcgen.gui.filter.DescriptorFilter;
import pcgen.gui.filter.DomainFilter;
import pcgen.gui.filter.EffectTypeFilter;
import pcgen.gui.filter.FavoredClassFilter;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterConstants;
import pcgen.gui.filter.FilterParseException;
import pcgen.gui.filter.FilterParser;
import pcgen.gui.filter.Filterable;
import pcgen.gui.filter.GenreFilter;
import pcgen.gui.filter.InverseFilter;
import pcgen.gui.filter.NamedFilter;
import pcgen.gui.filter.NonMagicFilter;
import pcgen.gui.filter.NormalFeatFilter;
import pcgen.gui.filter.PCAlignmentFilter;
import pcgen.gui.filter.PCClassFilter;
import pcgen.gui.filter.PCSizeFilter;
import pcgen.gui.filter.PCTemplateFilter;
import pcgen.gui.filter.PObjectFilter;
import pcgen.gui.filter.PantheonFilter;
import pcgen.gui.filter.QualifyFilter;
import pcgen.gui.filter.RaceFilter;
import pcgen.gui.filter.RangeFilter;
import pcgen.gui.filter.RankFilter;
import pcgen.gui.filter.RankModifierFilter;
import pcgen.gui.filter.SchoolFilter;
import pcgen.gui.filter.SettingFilter;
import pcgen.gui.filter.SizeFilter;
import pcgen.gui.filter.SourceFilter;
import pcgen.gui.filter.SpellResistanceFilter;
import pcgen.gui.filter.SpellTypeFilter;
import pcgen.gui.filter.StatFilter;
import pcgen.gui.filter.SubschoolFilter;
import pcgen.gui.filter.TypeFilter;
import pcgen.gui.filter.UntrainedSkillFilter;
import pcgen.gui.filter.VirtualFeatFilter;
import pcgen.gui.filter.WeaponFilter;
import pcgen.persistence.PersistenceManager;
import pcgen.util.Logging;

public final class FilterFactory
implements FilterConstants {
    private static List campaignFilters = new ArrayList();
    private static List classFilters = new ArrayList();
    private static List deityFilters = new ArrayList();
    private static List equipmentFilters = new ArrayList();
    private static List featFilters = new ArrayList();
    private static List prereqAlignmentFilters = new ArrayList();
    private static List raceFilters = new ArrayList();
    private static List sizeFilters = new ArrayList();
    private static List skillFilters = new ArrayList();
    private static List sourceFilters = new ArrayList();
    private static List spellFilters = new ArrayList();
    private static Map filterSettings = new HashMap();

    public static void clearFilterCache() {
        campaignFilters.clear();
        classFilters.clear();
        deityFilters.clear();
        equipmentFilters.clear();
        featFilters.clear();
        prereqAlignmentFilters.clear();
        raceFilters.clear();
        skillFilters.clear();
        sourceFilters.clear();
        spellFilters.clear();
    }

    public static PObjectFilter createPCClassFilter() {
        return new PCClassFilter();
    }

    public static String filterListToString(List filterList) {
        StringBuffer buffer = new StringBuffer();
        Iterator it = filterList.iterator();
        while (it.hasNext()) {
            Object filter = it.next();
            buffer.append("[").append(filter.getClass().getName());
            buffer.append("|").append(filter.toString()).append("]");
        }
        return buffer.toString();
    }

    public static void registerAllClassFilters(FilterAdapterPanel fap) {
        if (classFilters.size() == 0) {
            classFilters.add(FilterFactory.createQualifyFilter());
            Iterator iter = Globals.getPCClassTypeList().iterator();
            while (iter.hasNext()) {
                String subType;
                classFilters.add(FilterFactory.createTypeFilter(subType, (subType = (String)iter.next()).length() > 3));
            }
            classFilters.add(FilterFactory.createSpellTypeFilter("Arcane"));
            classFilters.add(FilterFactory.createSpellTypeFilter("Divine"));
            classFilters.add(FilterFactory.createSpellTypeFilter("Psionic"));
        }
        Iterator it = classFilters.iterator();
        while (it.hasNext()) {
            fap.registerFilter((PObjectFilter)it.next());
        }
    }

    public static void registerAllDeityFilters(FilterAdapterPanel fap) {
        Iterator it;
        if (deityFilters.size() == 0) {
            deityFilters.add(FilterFactory.createQualifyFilter());
            deityFilters.add(FilterFactory.createPCAlignmentFilter());
            for (int i = 0; i < 9; ++i) {
                deityFilters.add(FilterFactory.createAlignmentFilter(i));
            }
            it = Globals.getDomainList().iterator();
            while (it.hasNext()) {
                deityFilters.add(FilterFactory.createDomainFilter((Domain)it.next()));
            }
            deityFilters.add(FilterFactory.createPantheonFilter(PantheonFilter.ALL, 0));
            Iterator it2 = Globals.getPantheons().iterator();
            while (it2.hasNext()) {
                String tmp = (String)it2.next();
                if (!"DROW".equals(tmp.toUpperCase())) {
                    deityFilters.add(FilterFactory.createPantheonFilter(tmp, tmp.indexOf(" (") > -1 ? 0 : 1));
                    continue;
                }
                deityFilters.add(FilterFactory.createPantheonFilter("Drow", 0));
            }
        }
        it = deityFilters.iterator();
        while (it.hasNext()) {
            fap.registerFilter((PObjectFilter)it.next());
        }
    }

    public static void registerAllEquipmentFilters(FilterAdapterPanel fap) {
        Iterator it;
        if (equipmentFilters.size() == 0) {
            equipmentFilters.add(FilterFactory.createQualifyFilter());
            equipmentFilters.add(FilterFactory.createNonMagicFilter());
            equipmentFilters.add(FilterFactory.createAffordableFilter());
            it = Equipment.getEquipmentTypes().iterator();
            while (it.hasNext()) {
                equipmentFilters.add(FilterFactory.createTypeFilter((String)it.next()));
            }
            it = Globals.getWeaponTypesIterator();
            while (it.hasNext()) {
                equipmentFilters.add(FilterFactory.createWeaponFilter((String)it.next()));
            }
            equipmentFilters.add(FilterFactory.createPCSizeFilter());
        }
        it = equipmentFilters.iterator();
        while (it.hasNext()) {
            fap.registerFilter((PObjectFilter)it.next());
        }
    }

    public static void registerAllFeatFilters(FilterAdapterPanel fap) {
        if (featFilters.size() == 0) {
            featFilters.add(FilterFactory.createQualifyFilter());
            featFilters.add(FilterFactory.createAutomaticFeatFilter());
            featFilters.add(FilterFactory.createNormalFeatFilter());
            featFilters.add(FilterFactory.createVirtualFeatFilter());
        }
        Iterator it = featFilters.iterator();
        while (it.hasNext()) {
            fap.registerFilter((PObjectFilter)it.next());
        }
    }

    public static void registerAllPrereqAlignmentFilters(FilterAdapterPanel fap) {
        if (prereqAlignmentFilters.size() == 0) {
            for (int i = 0; i < 9; ++i) {
                prereqAlignmentFilters.add(FilterFactory.createAlignmentFilter(i, "allowed"));
                prereqAlignmentFilters.add(FilterFactory.createAlignmentFilter(i, "required"));
            }
            prereqAlignmentFilters.add(FilterFactory.createPCAlignmentFilter("allowed"));
            prereqAlignmentFilters.add(FilterFactory.createPCAlignmentFilter("required"));
        }
        Iterator it = prereqAlignmentFilters.iterator();
        while (it.hasNext()) {
            fap.registerFilter((PObjectFilter)it.next());
        }
    }

    public static void registerAllRaceFilters(FilterAdapterPanel fap) {
        Iterator it;
        if (raceFilters.size() == 0) {
            Globals.getRaceTypes().add("Humanoid");
            it = Globals.getRaceTypes().iterator();
            while (it.hasNext()) {
                raceFilters.add(FilterFactory.createTypeFilter((String)it.next()));
            }
            raceFilters.add(FilterFactory.createQualifyFilter());
            PObjectFilter filter = FilterFactory.createCompoundFilter(new TypeFilter("Base"), new TypeFilter("PC"), "AND");
            Iterator it2 = Globals.getClassList().iterator();
            while (it2.hasNext()) {
                PCClass aPCClass = (PCClass)it2.next();
                if (!aPCClass.isVisible() || !filter.accept(Globals.getCurrentPC(), aPCClass)) continue;
                raceFilters.add(FilterFactory.createFavoredClassFilter(aPCClass.getName()));
            }
            raceFilters.add(FilterFactory.createPCTemplateFilter());
            raceFilters.add(FilterFactory.createRaceFilter());
        }
        it = raceFilters.iterator();
        while (it.hasNext()) {
            fap.registerFilter((PObjectFilter)it.next());
        }
    }

    public static void registerAllSizeFilters(FilterAdapterPanel fap) {
        if (sizeFilters.size() == 0) {
            for (int i = 0; i < SystemCollections.getSizeAdjustmentListSize(); ++i) {
                sizeFilters.add(FilterFactory.createSizeFilter(i));
            }
        }
        Iterator it = sizeFilters.iterator();
        while (it.hasNext()) {
            fap.registerFilter((PObjectFilter)it.next());
        }
    }

    public static void registerAllSkillFilters(FilterAdapterPanel fap) {
        if (skillFilters.size() == 0) {
            skillFilters.add(FilterFactory.createUntrainedSkillFilter());
            skillFilters.add(FilterFactory.createRankFilter(0.0));
            skillFilters.add(FilterFactory.createRankModifierFilter(0.0));
            for (int i = 0; i < SettingsHandler.getGame().s_ATTRIBSHORT.length; ++i) {
                skillFilters.add(FilterFactory.createStatFilter(SettingsHandler.getGame().s_ATTRIBSHORT[i]));
            }
        }
        Iterator it = skillFilters.iterator();
        while (it.hasNext()) {
            fap.registerFilter((PObjectFilter)it.next());
        }
    }

    public static void registerAllSourceFilters(FilterAdapterPanel fap) {
        if (sourceFilters.size() == 0) {
            Iterator it = PersistenceManager.getInstance().getSources().iterator();
            while (it.hasNext()) {
                String source = (String)it.next();
                sourceFilters.add(FilterFactory.createSourceFilter(source));
            }
        }
        ArrayList<PObjectFilter> aList = new ArrayList<PObjectFilter>();
        ArrayList<PObjectFilter> bList = new ArrayList<PObjectFilter>();
        Iterator it = Globals.getCampaignList().iterator();
        while (it.hasNext()) {
            Campaign c = (Campaign)it.next();
            if (!c.getSetting().equals("")) {
                aList.add(FilterFactory.createSettingFilter(c.getSetting()));
            }
            if (c.getGenre().equals("")) continue;
            bList.add(FilterFactory.createGenreFilter(c.getGenre()));
        }
        sourceFilters.addAll(aList);
        sourceFilters.addAll(bList);
        it = sourceFilters.iterator();
        while (it.hasNext()) {
            fap.registerFilter((PObjectFilter)it.next());
        }
    }

    public static void registerAllSpellFilters(FilterAdapterPanel fap) {
        Iterator it;
        if (spellFilters.size() == 0) {
            spellFilters.add(FilterFactory.createComponentFilter("V"));
            spellFilters.add(FilterFactory.createComponentFilter("S"));
            spellFilters.add(FilterFactory.createComponentFilter("M"));
            spellFilters.add(FilterFactory.createComponentFilter("DF"));
            spellFilters.add(FilterFactory.createComponentFilter("F"));
            spellFilters.add(FilterFactory.createComponentFilter("XP"));
            it = Globals.getCastingTimesSet().iterator();
            while (it.hasNext()) {
                spellFilters.add(FilterFactory.createCastingTimeFilter((String)it.next()));
            }
            it = Globals.getDescriptorSet().iterator();
            while (it.hasNext()) {
                spellFilters.add(FilterFactory.createDescriptorFilter((String)it.next()));
            }
            it = Globals.getTargetSet().iterator();
            while (it.hasNext()) {
                spellFilters.add(FilterFactory.createEffectTypeFilter((String)it.next()));
            }
            it = Globals.getRangesSet().iterator();
            while (it.hasNext()) {
                spellFilters.add(FilterFactory.createRangeFilter((String)it.next()));
            }
            it = SystemCollections.getUnmodifiableSchoolsList().iterator();
            while (it.hasNext()) {
                spellFilters.add(FilterFactory.createSchoolFilter((String)it.next()));
            }
            it = Globals.getSrSet().iterator();
            while (it.hasNext()) {
                spellFilters.add(FilterFactory.createSpellResistanceFilter((String)it.next()));
            }
            it = Globals.getSubschools().iterator();
            while (it.hasNext()) {
                spellFilters.add(FilterFactory.createSubschoolFilter((String)it.next()));
            }
        }
        it = spellFilters.iterator();
        while (it.hasNext()) {
            fap.registerFilter((PObjectFilter)it.next());
        }
    }

    public static boolean restoreFilterSettings(Filterable filterable) {
        filterable.getAvailableFilters().clear();
        filterable.getSelectedFilters().clear();
        filterable.getRemovedFilters().clear();
        filterable.initializeFilters();
        String name = filterable.getName();
        if (name == null) {
            return false;
        }
        try {
            filterable.setFilterMode(Integer.parseInt(SettingsHandler.retrieveFilterSettings(name + ".mode")));
        }
        catch (NumberFormatException ex) {
            filterable.setFilterMode(0);
        }
        filterSettings.clear();
        List customAvailable = FilterFactory.preprocessFilterList("available", SettingsHandler.retrieveFilterSettings(name + ".available"));
        List customSelected = FilterFactory.preprocessFilterList("selected", SettingsHandler.retrieveFilterSettings(name + ".selected"));
        List customRemoved = FilterFactory.preprocessFilterList("removed", SettingsHandler.retrieveFilterSettings(name + ".removed"));
        Iterator it = filterable.getAvailableFilters().iterator();
        while (it.hasNext()) {
            Object filter = it.next();
            String listType = (String)filterSettings.get(filter.toString());
            if (listType == null || "available".equals(listType)) continue;
            if ("selected".equals(listType)) {
                it.remove();
                filterable.getSelectedFilters().add(filter);
                continue;
            }
            if (!"removed".equals(listType)) continue;
            it.remove();
            filterable.getRemovedFilters().add(filter);
        }
        FilterParser fp = new FilterParser(new List[]{filterable.getAvailableFilters(), filterable.getSelectedFilters(), filterable.getRemovedFilters()});
        FilterFactory.parseCustomFilterList(fp, filterable.getAvailableFilters(), customAvailable);
        FilterFactory.parseCustomFilterList(fp, filterable.getSelectedFilters(), customSelected);
        FilterFactory.parseCustomFilterList(fp, filterable.getRemovedFilters(), customRemoved);
        filterable.refreshFiltering();
        return filterable.getAvailableFilters().size() + filterable.getSelectedFilters().size() > 0;
    }

    static PObjectFilter createCompoundFilter(PObjectFilter filter1, PObjectFilter filter2, String connect) {
        return new CompoundFilter(filter1, filter2, connect);
    }

    static PObjectFilter createInverseFilter(PObjectFilter filter) {
        return new InverseFilter(filter);
    }

    static PObjectFilter createNamedFilter(PObjectFilter filter, String name, String description) {
        return new NamedFilter(filter, name, description);
    }

    private static PObjectFilter createAffordableFilter() {
        return new AffordableFilter();
    }

    private static PObjectFilter createAlignmentFilter(int alignment) {
        return new DeityAlignmentFilter(alignment);
    }

    private static PObjectFilter createAlignmentFilter(int alignment, String mode) {
        return new DeityAlignmentFilter(alignment, mode);
    }

    private static PObjectFilter createAutomaticFeatFilter() {
        return new AutomaticFeatFilter();
    }

    private static PObjectFilter createCastingTimeFilter(String castingTime) {
        return new CastingTimeFilter(castingTime);
    }

    private static PObjectFilter createComponentFilter(String component) {
        return new ComponentFilter(component);
    }

    private static PObjectFilter createDescriptorFilter(String descriptor) {
        return new DescriptorFilter(descriptor);
    }

    private static PObjectFilter createDomainFilter(Domain domain) {
        return new DomainFilter(domain);
    }

    private static PObjectFilter createEffectTypeFilter(String effect) {
        return new EffectTypeFilter(effect);
    }

    private static PObjectFilter createFavoredClassFilter(String className) {
        return new FavoredClassFilter(className);
    }

    private static PObjectFilter createGenreFilter(String genre) {
        return new GenreFilter(genre);
    }

    private static PObjectFilter createNonMagicFilter() {
        return new NonMagicFilter();
    }

    private static PObjectFilter createNormalFeatFilter() {
        return new NormalFeatFilter();
    }

    private static PObjectFilter createPCAlignmentFilter() {
        return new PCAlignmentFilter();
    }

    private static PObjectFilter createPCAlignmentFilter(String mode) {
        return new PCAlignmentFilter(mode);
    }

    private static PObjectFilter createPCSizeFilter() {
        return new PCSizeFilter();
    }

    private static PObjectFilter createPCTemplateFilter() {
        return new PCTemplateFilter();
    }

    private static PObjectFilter createPantheonFilter(String race, int detailLevel) {
        return new PantheonFilter(race, detailLevel);
    }

    private static PObjectFilter createQualifyFilter() {
        return new QualifyFilter();
    }

    private static PObjectFilter createRaceFilter() {
        return new RaceFilter();
    }

    private static PObjectFilter createRangeFilter(String range) {
        return new RangeFilter(range);
    }

    private static PObjectFilter createRankFilter(double min) {
        return new RankFilter(min);
    }

    private static PObjectFilter createRankModifierFilter(double min) {
        return new RankModifierFilter(min);
    }

    private static PObjectFilter createSchoolFilter(String school) {
        return new SchoolFilter(school);
    }

    private static PObjectFilter createSettingFilter(String setting) {
        return new SettingFilter(setting);
    }

    private static PObjectFilter createSizeFilter(int size) {
        return new SizeFilter(size);
    }

    private static PObjectFilter createSourceFilter(String source) {
        return new SourceFilter(source, 1);
    }

    private static PObjectFilter createSpellResistanceFilter(String sr) {
        return new SpellResistanceFilter(sr);
    }

    private static PObjectFilter createSpellTypeFilter(String type) {
        return new SpellTypeFilter(type);
    }

    private static PObjectFilter createStatFilter(String stat) {
        return new StatFilter(stat);
    }

    private static PObjectFilter createSubschoolFilter(String school) {
        return new SubschoolFilter(school);
    }

    private static PObjectFilter createTypeFilter(String type) {
        return new TypeFilter(type);
    }

    private static PObjectFilter createTypeFilter(String type, boolean capitalize) {
        return new TypeFilter(type, capitalize);
    }

    private static PObjectFilter createUntrainedSkillFilter() {
        return new UntrainedSkillFilter();
    }

    private static PObjectFilter createVirtualFeatFilter() {
        return new VirtualFeatFilter();
    }

    private static PObjectFilter createWeaponFilter(String type) {
        return new WeaponFilter(type);
    }

    private static void parseCustomFilterList(FilterParser parser, List filterList, List filterDefinitions) {
        Iterator it = filterDefinitions.iterator();
        while (it.hasNext()) {
            String[] filterData = (String[])it.next();
            StringBuffer filterDefinition = new StringBuffer();
            StringTokenizer tokens = new StringTokenizer(filterData[0], "()", true);
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (FilterParser.isLegalToken(token.trim())) {
                    filterDefinition.append(token);
                    continue;
                }
                filterDefinition.append("[");
                filterDefinition.append(token);
                filterDefinition.append("]");
            }
            try {
                PObjectFilter filter = parser.parse(filterDefinition.toString());
                if ((filterData[1] + filterData[2]).length() > 0) {
                    filter = FilterFactory.createNamedFilter(filter, filterData[1], filterData[2]);
                }
                filterList.add(filter);
            }
            catch (FilterParseException ex) {
                Logging.errorPrint("Error in FilterFactory::parseCustomFilterList", ex);
            }
        }
    }

    private static List preprocessFilterList(String list, String filterString) {
        ArrayList<String[]> customFilters = new ArrayList<String[]>();
        if (filterString.length() == 0) {
            return customFilters;
        }
        StringTokenizer filterTokens = new StringTokenizer(filterString, "[]");
        while (filterTokens.hasMoreTokens()) {
            String filterDesc;
            StringTokenizer tokens = new StringTokenizer(filterTokens.nextToken(), "|");
            String className = tokens.nextToken();
            String classDef = tokens.nextToken();
            String filterName = tokens.hasMoreTokens() ? tokens.nextToken() : "";
            String string = filterDesc = tokens.hasMoreTokens() ? tokens.nextToken() : "";
            if (className.endsWith("CompoundFilter") || className.endsWith("InverseFilter") || className.endsWith("NamedFilter")) {
                customFilters.add(new String[]{classDef, filterName, filterDesc});
                continue;
            }
            filterSettings.put(classDef, list);
        }
        return customFilters;
    }
}

