/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import pcgen.core.Globals;
import pcgen.gui.filter.PObjectFilter;

final class FilterList
extends JList {
    static final long serialVersionUID = 6872311299112043236L;
    private static final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);

    FilterList(ListModel model) {
        super(model);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new FilterListCellRenderer());
    }

    public String getToolTipText(MouseEvent e) {
        int index = this.locationToIndex(e.getPoint());
        if (index > -1) {
            PObjectFilter filter = (PObjectFilter)this.getModel().getElementAt(index);
            return filter.getDescription(Globals.getCurrentPC()).length() > 0 ? filter.getDescription(Globals.getCurrentPC()) : filter.getName(Globals.getCurrentPC());
        }
        return this.getToolTipText();
    }

    private static class FilterListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private FilterListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            PObjectFilter filter = (PObjectFilter)value;
            this.setText(filter.getCategory() + " :  " + filter.getName(Globals.getCurrentPC()));
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : NO_FOCUS_BORDER);
            return this;
        }
    }
}

