/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pcgen.core.Globals;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.filter.GBLPanel;
import pcgen.util.PropertyFactory;

final class FilterNameDialog
extends JDialog
implements ActionListener {
    private JButton applyButton;
    private JTextArea descriptionArea;
    private JTextField nameField;
    private final List illegalNamesList = new ArrayList();

    public FilterNameDialog() {
        super((Frame)Globals.getRootFrame(), PropertyFactory.getString("in_filterCustom"));
        this.init();
    }

    public String getDescription() {
        return this.descriptionArea.getText().trim();
    }

    public void setIllegalNames(List newIllegalNamesList) {
        this.illegalNamesList.clear();
        this.illegalNamesList.addAll(newIllegalNamesList);
    }

    public String getName() {
        return this.nameField.getText().trim();
    }

    public void actionPerformed(ActionEvent e) {
        String name = this.nameField.getText();
        if (this.isLegalName(name)) {
            this.setVisible(false);
        } else if (this.illegalNamesList.contains(name.trim())) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_filterEr2P1") + " '" + name + "'!", PropertyFactory.getString("in_filterErWarn"), MessageType.ERROR);
        } else {
            int index = FilterNameDialog.indexOfIllegalChar(name);
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_filterEr3P1") + " '" + name.charAt(index) + "' " + PropertyFactory.getString("in_filterEr3P2"), PropertyFactory.getString("in_filterErWarn"), MessageType.ERROR);
            this.nameField.requestFocus();
            this.nameField.setCaretPosition(index);
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this.nameField.setText("");
            this.descriptionArea.setText("");
        }
        super.setVisible(b);
    }

    private boolean isLegalName(String s) {
        return !this.illegalNamesList.contains(s.trim()) && FilterNameDialog.indexOfIllegalChar(s.trim()) == -1;
    }

    private void _init() {
        this.nameField = new JTextField();
        JPanel nameFieldPanel = new JPanel(new GridLayout(1, 1));
        nameFieldPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        nameFieldPanel.add(this.nameField);
        this.descriptionArea = new JTextArea();
        JScrollPane descriptionScroll = new JScrollPane(this.descriptionArea);
        descriptionScroll.setMinimumSize(new Dimension(300, 300));
        descriptionScroll.setPreferredSize(new Dimension(300, 300));
        JPanel descriptionAreaPanel = new JPanel(new GridLayout(1, 1));
        descriptionAreaPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        descriptionAreaPanel.add(descriptionScroll);
        this.applyButton = new JButton(PropertyFactory.getString("in_apply"));
        this.applyButton.setMinimumSize(new Dimension(95, 27));
        this.applyButton.setPreferredSize(new Dimension(95, 27));
        this.applyButton.addActionListener(this);
        JPanel applyButtonPanel = new JPanel(new GridLayout(1, 1));
        applyButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        applyButtonPanel.add(this.applyButton);
        GBLPanel mainPanel = new GBLPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        mainPanel.gbc.anchor = 11;
        mainPanel.gbc.weightx = 10.0;
        mainPanel.gbc.weighty = 0.0;
        mainPanel.gbc.fill = 2;
        mainPanel.add(new JLabel(PropertyFactory.getString("in_nameLabel") + ":"), 0, 0, 1, 1);
        mainPanel.add(nameFieldPanel, 1, 0, 1, 1);
        mainPanel.add(new JLabel(PropertyFactory.getString("in_descrip") + ":"), 2, 0, 1, 1);
        mainPanel.gbc.weighty = 10.0;
        mainPanel.gbc.fill = 1;
        mainPanel.add(descriptionAreaPanel, 3, 0, 1, 1);
        mainPanel.gbc.weightx = 0.0;
        mainPanel.gbc.weighty = 0.0;
        mainPanel.gbc.fill = 0;
        mainPanel.gbc.anchor = 13;
        mainPanel.add(applyButtonPanel, 4, 0, 1, 1);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPanel.add((Component)mainPanel, "Center");
        this.setContentPane(contentPanel);
    }

    private static int indexOfIllegalChar(String s) {
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isJavaIdentifierStart(chars[i]) || Character.isWhitespace(chars[i]) || chars[i] == '(' || chars[i] == ')') continue;
            return i;
        }
        return -1;
    }

    private void init() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 4, screenSize.height / 4);
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this._init();
        this.pack();
        this.setResizable(false);
    }
}

