/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Constants;
import pcgen.core.Globals;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.filter.FilterParseException;
import pcgen.gui.filter.PObjectFilter;
import pcgen.util.PropertyFactory;

final class FilterParser {
    private static final String TOKEN_AND = "AND";
    private static final String TOKEN_NOT = "NOT";
    private static final String TOKEN_OR = "OR";
    private static final String TOKEN_STARTGROUP = "(";
    private static final String TOKEN_ENDGROUP = ")";
    private static final char CHAR_TOKEN_STARTGROUP = '(';
    private static final char CHAR_TOKEN_ENDGROUP = ')';
    private static final char TOKEN_STARTFILTER = '[';
    private static final String TOKEN_ENDFILTER = "]";
    private List[] filterList;

    FilterParser(List[] filterList) {
        this.filterList = filterList;
    }

    public PObjectFilter parse(String filterDefinition) throws FilterParseException {
        List tokenList = FilterParser.createTokenList(FilterParser.normalize(filterDefinition));
        FilterParser.checkTokens(tokenList);
        return this.parseTokenList(this.enforceStrongAssociationForNOT(tokenList));
    }

    static boolean isLegalToken(String token) {
        String s = token.toUpperCase();
        return s.equals(TOKEN_STARTGROUP) || s.equals(TOKEN_ENDGROUP) || s.equals(TOKEN_AND) || s.equals(TOKEN_NOT) || s.equals(TOKEN_OR) || s.length() > 0 && s.charAt(0) == '[' && s.endsWith(TOKEN_ENDFILTER) && s.length() > 2;
    }

    private static int isLegalTokenSequence(String token1, String token2) {
        String s1 = token1.toUpperCase();
        String s2 = token2.toUpperCase();
        if (s1.endsWith(TOKEN_STARTGROUP) && s2.length() > 0 && s2.charAt(0) == ')') {
            return -1;
        }
        if (s1.endsWith(TOKEN_ENDGROUP) && (s2.equals(TOKEN_NOT) || s2.length() > 0 && s2.charAt(0) == '(' || s2.length() > 0 && s2.charAt(0) == '[')) {
            return -2;
        }
        if (s1.endsWith(TOKEN_ENDFILTER) && (s2.equals(TOKEN_NOT) || s2.length() > 0 && s2.charAt(0) == '(' || s2.length() > 0 && s2.charAt(0) == '[')) {
            return -2;
        }
        if (!(!s1.equals(TOKEN_AND) || s2.equals(TOKEN_NOT) || s2.length() > 0 && s2.charAt(0) == '(' || s2.length() > 0 && s2.charAt(0) == '[')) {
            return -3;
        }
        if (!(!s1.equals(TOKEN_NOT) || s2.length() > 0 && s2.charAt(0) == '(' || s2.length() > 0 && s2.charAt(0) == '[')) {
            return -3;
        }
        if (!(!s1.equals(TOKEN_OR) || s2.equals(TOKEN_NOT) || s2.length() > 0 && s2.charAt(0) == '(' || s2.length() > 0 && s2.charAt(0) == '[')) {
            return -3;
        }
        if (!(!"".equals(s1) || s2.equals(TOKEN_NOT) || s2.length() > 0 && s2.charAt(0) == '(' || s2.length() > 0 && s2.charAt(0) == '[')) {
            return -4;
        }
        if ("".equals(s2) && !s1.endsWith(TOKEN_ENDGROUP) && !s1.endsWith(TOKEN_ENDFILTER)) {
            return -5;
        }
        return 0;
    }

    private static void checkTokens(List tokenList) throws FilterParseException {
        String lastToken = "";
        Iterator it = tokenList.iterator();
        while (it.hasNext()) {
            String token = (String)it.next();
            if (!FilterParser.isLegalToken(token)) {
                throw new FilterParseException(PropertyFactory.getString("in_malformed") + " " + token + ".");
            }
            int sequenceError = FilterParser.isLegalTokenSequence(lastToken, token);
            if (sequenceError == -1) {
                throw new FilterParseException(PropertyFactory.getString("in_emptyState"));
            }
            if (sequenceError == -2) {
                throw new FilterParseException(PropertyFactory.getString("in_missOper"));
            }
            if (sequenceError == -3) {
                throw new FilterParseException(PropertyFactory.getString("in_illegSeq") + " '" + lastToken + " " + token + "'.");
            }
            if (sequenceError == -4) {
                throw new FilterParseException(PropertyFactory.getString("in_illegTok") + " '" + token + "'.");
            }
            lastToken = token;
        }
        if (FilterParser.isLegalTokenSequence(lastToken, "") != 0) {
            throw new FilterParseException(PropertyFactory.getString("in_illegLastTok") + " '" + lastToken + "'.");
        }
    }

    private static List createTokenList(String parseString) throws FilterParseException {
        int braceCount = 0;
        int bracketCount = 0;
        ArrayList<String> list = new ArrayList<String>();
        boolean filterName = false;
        StringBuffer name = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(parseString, " []()", true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.equals(TOKEN_STARTGROUP)) {
                ++braceCount;
            } else if (token.equals(TOKEN_ENDGROUP)) {
                --braceCount;
            } else if (token.equals(new Character('[').toString())) {
                name.delete(0, name.length());
                name.append(token);
                token = "";
                filterName = true;
                ++bracketCount;
            } else if (token.equals(TOKEN_ENDFILTER)) {
                name.append(token);
                token = name.toString();
                filterName = false;
                --bracketCount;
            } else if (!filterName) {
                token = token.toUpperCase();
            }
            if (!filterName) {
                if ((token = token.trim()).length() <= 0) continue;
                list.add(token);
                continue;
            }
            name.append(token);
        }
        if (braceCount > 0) {
            throw new FilterParseException(PropertyFactory.getString("in_missing") + " '" + TOKEN_ENDGROUP + "'.");
        }
        if (braceCount < 0) {
            throw new FilterParseException(PropertyFactory.getString("in_missing") + " '" + TOKEN_STARTGROUP + "'.");
        }
        if (bracketCount > 0) {
            throw new FilterParseException(PropertyFactory.getString("in_missing") + " '" + TOKEN_ENDFILTER + "'.");
        }
        if (bracketCount < 0) {
            throw new FilterParseException(PropertyFactory.getString("in_missing") + " '" + '[' + "'.");
        }
        return list;
    }

    private List enforceStrongAssociationForNOT(List tokenList) {
        ArrayList newTokenList = new ArrayList();
        int index = tokenList.indexOf(TOKEN_NOT);
        if (index == -1) {
            return tokenList;
        }
        newTokenList.addAll(tokenList.subList(0, index));
        newTokenList.add(TOKEN_STARTGROUP);
        newTokenList.add(TOKEN_NOT);
        ArrayList restList = new ArrayList(tokenList.subList(index + 1, tokenList.size()));
        String firstRestToken = (String)restList.get(0);
        if (firstRestToken.equals(TOKEN_STARTGROUP)) {
            int i = 0;
            int braceCount = 1;
            restList.remove(i);
            Iterator it = restList.iterator();
            while (it.hasNext()) {
                String token = (String)it.next();
                if (token.equals(TOKEN_STARTGROUP)) {
                    ++braceCount;
                } else if (token.equals(TOKEN_ENDGROUP)) {
                    --braceCount;
                }
                if (braceCount == 0) break;
                ++i;
            }
            restList.remove(i);
            if (i == restList.size()) {
                newTokenList.add(TOKEN_STARTGROUP);
                newTokenList.addAll(this.enforceStrongAssociationForNOT(restList));
                newTokenList.add(TOKEN_ENDGROUP);
                newTokenList.add(TOKEN_ENDGROUP);
            } else {
                newTokenList.add(TOKEN_STARTGROUP);
                newTokenList.addAll(this.enforceStrongAssociationForNOT(restList.subList(0, i)));
                newTokenList.add(TOKEN_ENDGROUP);
                newTokenList.add(TOKEN_ENDGROUP);
                newTokenList.addAll(this.enforceStrongAssociationForNOT(restList.subList(i, restList.size())));
            }
        } else if (firstRestToken.length() > 0 && firstRestToken.charAt(0) == '[') {
            restList.remove(0);
            newTokenList.add(firstRestToken);
            newTokenList.add(TOKEN_ENDGROUP);
            newTokenList.addAll(this.enforceStrongAssociationForNOT(restList));
        }
        return newTokenList;
    }

    private static String normalize(String s) {
        StringBuffer buffer = new StringBuffer();
        String tokenizeOnThis = "\t" + Constants.s_LINE_SEP + "\f";
        StringTokenizer tokens = new StringTokenizer(s, tokenizeOnThis);
        while (tokens.hasMoreTokens()) {
            buffer.append(tokens.nextToken()).append(" ");
        }
        return buffer.toString().trim();
    }

    /*
     * WARNING - void declaration
     */
    private PObjectFilter parseTokenList(List tokenList) throws FilterParseException {
        void var2_9;
        PObjectFilter filter;
        String firstToken = (String)tokenList.get(0);
        if (firstToken.equals(TOKEN_STARTGROUP)) {
            int i = 0;
            int braceCount = 1;
            tokenList.remove(i);
            Iterator it = tokenList.iterator();
            while (it.hasNext()) {
                String token = (String)it.next();
                if (token.equals(TOKEN_STARTGROUP)) {
                    ++braceCount;
                } else if (token.equals(TOKEN_ENDGROUP)) {
                    --braceCount;
                }
                if (braceCount == 0) break;
                ++i;
            }
            tokenList.remove(i);
            if (i == tokenList.size()) {
                filter = this.parseTokenList(tokenList);
            } else {
                ArrayList tokenList1 = new ArrayList(tokenList.subList(0, i));
                ArrayList tokenList2 = new ArrayList(tokenList.subList(i + 1, tokenList.size()));
                filter = FilterFactory.createCompoundFilter(this.parseTokenList(tokenList1), this.parseTokenList(tokenList2), (String)tokenList.get(i));
            }
        } else if (firstToken.equals(TOKEN_NOT)) {
            tokenList.remove(0);
            filter = FilterFactory.createInverseFilter(this.parseTokenList(tokenList));
        } else if (firstToken.length() > 0 && firstToken.charAt(0) == '[') {
            String filterName = (String)tokenList.remove(0);
            if (tokenList.size() > 0) {
                String operand = (String)tokenList.remove(0);
                filter = FilterFactory.createCompoundFilter(this.retrieveFilter(filterName), this.parseTokenList(tokenList), operand);
            } else {
                filter = this.retrieveFilter(filterName);
            }
        } else {
            throw new FilterParseException(PropertyFactory.getString("in_malformed") + firstToken + ".");
        }
        return var2_9;
    }

    private PObjectFilter retrieveFilter(String filterName) throws FilterParseException {
        for (int i = 0; i < this.filterList.length; ++i) {
            Iterator it = this.filterList[i].iterator();
            while (it.hasNext()) {
                PObjectFilter filter = (PObjectFilter)it.next();
                if (!filterName.equals('[' + filter.getCategory() + " :  " + filter.getName(Globals.getCurrentPC()) + TOKEN_ENDFILTER)) continue;
                return filter;
            }
        }
        throw new FilterParseException(PropertyFactory.getString("in_notFindFil") + " " + filterName + ".");
    }
}

